/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import java.io.File;
import java.util.Objects;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelType;
import model3.DataType;
import util.DepthUnits;

public class PanelChromalogProperties
extends PanelProperties {
    float columnWidth = 40.0f;
    File dir;
    DepthUnits units = DepthUnits.M;
    private static final String[] propNames = new String[]{"Column width", "Directory of files", "File units"};
    public static final int PROP_COLWIDTH = 0;
    public static final int PROP_FILE = 1;
    public static final int PROP_UNITS = 2;
    private static final String[] TOOLTIP_TEXT = new String[propNames.length];

    PanelChromalogProperties(String prefs) {
        super(PanelType.CHROMALOG);
        if (prefs == null) {
            return;
        }
        String[] s = prefs.trim().split("\\|");
        for (int i = 0; i < s.length; ++i) {
            try {
                switch (i) {
                    case 0: {
                        this.columnWidth = Float.parseFloat(s[i]);
                        break;
                    }
                    case 1: {
                        this.dir = new File(s[i]);
                        break;
                    }
                    case 2: {
                        this.units = DepthUnits.getUnits((char)s[i].charAt(0));
                    }
                }
                continue;
            }
            catch (NumberFormatException nfe) {
                System.out.println("Number format exception in PanelChromalogProperties init: " + nfe.getMessage() + " " + i + " " + prefs);
                break;
            }
        }
    }

    @Override
    public String getPropertiesString() {
        return this.getPrefs();
    }

    @Override
    public String getToolTipText(int nProp) {
        if (nProp >= TOOLTIP_TEXT.length) {
            return null;
        }
        return TOOLTIP_TEXT[nProp];
    }

    @Override
    public String getPrefs() {
        Object string = new String();
        String[] props = new String[]{"" + this.columnWidth, this.dir != null ? this.dir.getAbsolutePath() : "", this.units.getAbr()};
        for (String prop : props) {
            string = (String)string + prop + "|";
        }
        return string;
    }

    @Override
    public int getnProps() {
        return propNames.length;
    }

    @Override
    public String getPropertyName(int nProp) {
        if (nProp < propNames.length) {
            return propNames[nProp];
        }
        return null;
    }

    @Override
    public Object getProperty(int nProp) {
        switch (nProp) {
            case 0: {
                return (int)this.columnWidth;
            }
            case 1: {
                return this.dir;
            }
            case 2: {
                return this.units;
            }
        }
        assert (false);
        return null;
    }

    private boolean setColWidth(float colWidth) {
        if (Math.abs((int)this.columnWidth - (int)colWidth) >= 1 && (int)colWidth > 4 && (int)colWidth < 250) {
            this.columnWidth = (int)colWidth;
            return true;
        }
        return false;
    }

    @Override
    public boolean setProperty(int nProp, Object prop) {
        if (this.getProperty(nProp) == null ^ prop == null || this.getProperty(nProp) != null && !this.getProperty(nProp).equals(prop)) {
            switch (nProp) {
                case 0: {
                    if (prop instanceof String) {
                        this.setColWidth(Float.parseFloat((String)prop));
                        break;
                    }
                    this.setColWidth(((Float)prop).floatValue());
                    break;
                }
                case 1: {
                    File file = (File)prop;
                    if (!file.exists()) {
                        System.out.println("file does not exist");
                        return false;
                    }
                    if (!file.isDirectory()) {
                        System.out.println("file is not a directory");
                        return false;
                    }
                    this.dir = (File)prop;
                    break;
                }
                case 2: {
                    this.units = (DepthUnits)prop;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public Class<?> getPropertyClass(int nProp) {
        switch (nProp) {
            case 0: {
                return Integer.class;
            }
            case 1: {
                return File.class;
            }
            case 2: {
                return DepthUnits.class;
            }
        }
        assert (false);
        return null;
    }

    public PanelChromalogProperties() {
        super(PanelType.CHROMALOG);
    }

    public static PanelChromalogProperties createCopy(PanelChromalogProperties rhs) {
        PanelChromalogProperties p = new PanelChromalogProperties();
        p.copy(rhs);
        return p;
    }

    @Override
    public PanelProperties copy() {
        return PanelChromalogProperties.createCopy(this);
    }

    @Override
    public void copy(PanelProperties pp) {
        if (!(pp instanceof PanelChromalogProperties)) {
            throw new IllegalArgumentException("PanelChromalogProperties cannot copy " + String.valueOf(pp));
        }
        if (pp.getPanelType() != this.getPanelType()) {
            throw new IllegalArgumentException("Panel type mismatch in PanelChromalogProperties copy: " + String.valueOf(this.getPanelType()) + " : " + String.valueOf(pp.getPanelType()));
        }
        PanelChromalogProperties rhs = (PanelChromalogProperties)pp;
        this.columnWidth = rhs.columnWidth;
        this.dir = rhs.dir;
        this.units = rhs.units;
    }

    @Override
    public boolean isSimilarTo(PanelProperties comp) {
        if (!(comp instanceof PanelChromalogProperties)) {
            return false;
        }
        if (this.equals(comp)) {
            return true;
        }
        PanelChromalogProperties rhs = (PanelChromalogProperties)comp;
        block3: for (int i = 0; i < this.getnProps(); ++i) {
            switch (i) {
                case 0: {
                    if (!(Math.abs(this.columnWidth - rhs.columnWidth) > 3.0f)) continue block3;
                    return false;
                }
                default: {
                    Object iProp1 = this.getProperty(i);
                    Object iProp2 = rhs.getProperty(i);
                    if (Objects.equals(iProp1, iProp2)) continue block3;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public DataType getDataType() {
        return null;
    }

    public int hashCode() {
        int hash = 5;
        hash = 19 * hash + Float.floatToIntBits(this.columnWidth);
        hash = 19 * hash + Objects.hashCode(this.dir.getAbsolutePath());
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PanelChromalogProperties other = (PanelChromalogProperties)obj;
        if (Float.floatToIntBits(this.columnWidth) != Float.floatToIntBits(other.columnWidth)) {
            return false;
        }
        if (!Objects.equals(this.dir, other.dir)) {
            return false;
        }
        return this.units == other.units;
    }

    static {
        PanelChromalogProperties.TOOLTIP_TEXT[0] = "Column width";
        PanelChromalogProperties.TOOLTIP_TEXT[1] = "Directory/folder containing the chromalog source file(s). File is of type .txt and name must match the well code.";
        PanelChromalogProperties.TOOLTIP_TEXT[2] = "ft/m units of source file";
    }
}

