/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import com.stratadata.model3.event.EventType;
import java.awt.Color;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import jsbchart.block.BlockProperties;
import jsbchart.block.CorrelationPoint;
import jsbchart.block.SchemeBlock;
import jsbchart.core.Chart;
import jsbchart.core.ChartProperties;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.correlation.CorrelationType;
import jsbchart.data.ScaleConverter;
import jsbchart.graphics.SBGraphics;
import jsbchart.panel.PanelEventsBase;
import jsbchart.panel.PanelEventsProperties;
import jsbchart.panel.PanelType;
import jsbchart.util.ChartObject;
import model3.CompositeStandard;
import model3.CompositeStandardEvent;
import model3.SBdb;
import model3.Sample;
import model3.Well;
import model3.WellEvent;
import model3.WellInterp;
import org.apache.commons.lang3.StringUtils;
import util.SB;
import util.SBException;

public class PanelCompositeStandard
extends PanelEventsBase {
    private final SchemeBlock block;
    private CompositeStandard cmpStd;

    public PanelCompositeStandard(CompositeStandard c, SBdb sbdb, SchemeBlock block, String props) throws SQLException, SBException {
        super(null, null);
        this.cmpStd = c;
        this.block = block;
        this.p = new PanelEventsProperties(props, sbdb, c, PanelType.CMPSTD);
        if (this.cmpStd != null) {
            this.cmpStd.loadEvents();
        }
    }

    public PanelCompositeStandard(PanelTemplate template, PanelOcc occ, SchemeBlock block) {
        super(template, occ != null ? occ : new PanelOcc(template.getID()));
        this.block = block;
        this.p = (PanelEventsProperties)template.getProperties();
    }

    public CompositeStandard getStd() {
        return this.p.getCmpStd();
    }

    @Override
    public Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        Iterator it;
        if (this.movedPositions == null) {
            return null;
        }
        float BRACKET = 2.5f / zoom;
        boolean list2 = this.separate && x > this.getWidth(bp) / 2.0f;
        int i = 0;
        Iterator iterator = it = list2 ? this.chartObjects2.iterator() : this.chartObjects.iterator();
        while (it.hasNext()) {
            float symbolSize;
            ChartObject chartObject = (ChartObject)it.next();
            float yPos = list2 ? this.movedPositions2[i] : this.movedPositions[i];
            float f = symbolSize = list2 ? this.symbolSizes2[i] : this.symbolSizes[i];
            if (y > yPos - BRACKET && y < yPos + symbolSize) {
                List list = (List)chartObject.getO();
                if (list.size() == 1) {
                    return list.get(0);
                }
                float rowHeight = symbolSize / (float)list.size();
                for (int j = 0; j < list.size(); ++j) {
                    if (!(y > yPos + (float)j * rowHeight) || !(y < yPos + ((float)j + 1.0f * rowHeight))) continue;
                    return list.get(j);
                }
                return list.get(list.size() - 1);
            }
            ++i;
        }
        return null;
    }

    public String toString() {
        if (this.p == null) {
            return "Composite Standard";
        }
        return "Composite Standard" + (String)(this.p.getCmpStd() != null ? " - " + this.p.getCmpStd().getName() : "");
    }

    @Override
    public String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        Object event = this.getObject(x, y, cp, bp, zoom);
        if (event != null) {
            return ((CompositeStandardEvent)event).toString(true, true, true, false, false);
        }
        return null;
    }

    @Override
    public synchronized float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode, EnumMap<CorrelationType, HashSet<CorrelationPoint>> cLines) {
        if (this.p.showCommentsColumn) {
            g.setColor(Color.BLACK);
            g.drawLine(x + this.p.columnWidth, y + this.getPanelHeaderHeight(cp, mode), x + this.p.columnWidth, y + this.getPanelHeaderHeight(cp, mode) + bp.getHeight());
        }
        float fontSize = cp.getFontSize(this.p.fontSize);
        g.setFont(cp.font, 0, fontSize);
        g.setStroke(0.1f);
        try {
            this.setData(cp, bp, null, g);
            LinkedList compositeList = new LinkedList();
            compositeList.addAll(this.chartObjects);
            if (this.chartObjects2 != null) {
                compositeList.addAll(this.chartObjects2);
            }
            Iterator it = compositeList.iterator();
            int i1 = 0;
            int i2 = 0;
            while (it.hasNext()) {
                ChartObject chartObject = (ChartObject)it.next();
                List events = (List)chartObject.getO();
                EventType type = ((CompositeStandardEvent)events.get(0)).getType();
                this.drawEvents(g, cp, mode, x, y, this.separate && type == EventType.BASE ? i2 : i1, chartObject, bp.getUnits(), cLines.get(CorrelationType.EVENT));
                if (this.separate && type == EventType.BASE) {
                    ++i2;
                    continue;
                }
                ++i1;
            }
        }
        catch (Exception e) {
            this.handleException(g, x, y, cp, bp, e);
        }
        g.setColor(Color.BLACK);
        return x + this.p.panelWidth();
    }

    @Override
    protected String getCaption() {
        if (this.getPanelOcc() != null && this.getPanelOcc().getCaption() != null) {
            return this.getPanelOcc().getCaption();
        }
        if (this.p.getCmpStd() != null) {
            return this.p.getCmpStd().getName();
        }
        return "<No Composite Standard>";
    }

    @Override
    public float drawHorz(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp) {
        if (this.p.getCmpStd() == null) {
            return 0.0f;
        }
        g.setColor(cp.foreground);
        g.setStroke(0.1f);
        if (this.p.showCommentsColumn) {
            g.drawLine(x, y + this.p.commentsColumnWidth, x + PanelCompositeStandard.getXPos(bp.getAgeLeftToRight() ? bp.getMax() : bp.getMin(), bp), y + this.p.commentsColumnWidth);
        }
        float fontSize = cp.getFontSize(this.p.fontSize);
        float ageIndent = 4.0f;
        float eventIndent = 5.25f * fontSize;
        g.setColor(cp.foreground);
        g.setFont(cp.font, 0, fontSize);
        float yBase = y + this.p.panelWidth();
        Iterator<CompositeStandardEvent> it = this.getEvents(bp.getAgeLeftToRight()).iterator();
        LinkedList<Float> positions = new LinkedList<Float>();
        while (it.hasNext()) {
            CompositeStandardEvent event = it.next();
            float age = (float)this.p.getCmpStd().getAge(event.getCSU());
            if (!(age >= bp.getMin()) || !(age <= bp.getMax())) continue;
            float xPos = PanelCompositeStandard.getXPos(age, bp) + x;
            g.drawLine(xPos, yBase, xPos, yBase - 1.0f);
            float offset = this.getEvTypeOffset(event.getType(), fontSize);
            positions.add(Float.valueOf(xPos + offset));
        }
        float[] movedPositionsStd = new float[positions.size()];
        if (!positions.isEmpty()) {
            float lPosition;
            float hPosition;
            for (int i = 0; i < positions.size(); ++i) {
                movedPositionsStd[i] = ((Float)positions.get(i)).floatValue();
            }
            if (bp.getAgeLeftToRight()) {
                hPosition = PanelCompositeStandard.getXPos(bp.getMin(), bp) + x;
                lPosition = PanelCompositeStandard.getXPos(bp.getMax(), bp) + x;
            } else {
                hPosition = PanelCompositeStandard.getXPos(bp.getMax(), bp) + x;
                lPosition = PanelCompositeStandard.getXPos(bp.getMin(), bp) + x;
            }
            PanelCompositeStandard.moveSamplePositions(movedPositionsStd.length, movedPositionsStd, fontSize, hPosition, lPosition);
        }
        it = this.getEvents(bp.getAgeLeftToRight()).iterator();
        int i = 0;
        Color colour = cp.foreground;
        while (it.hasNext()) {
            String eventName;
            CompositeStandardEvent event = it.next();
            float age = (float)this.p.getCmpStd().getAge(event.getCSU());
            if (!(age >= bp.getMin()) || !(age <= bp.getMax())) continue;
            float xPos = PanelCompositeStandard.getXPos(age, bp) + x;
            g.setColor(this.getEventColor(event, cp));
            float movedPosition = movedPositionsStd[i] - this.getEvTypeOffset(event.getType(), fontSize);
            g.drawLine(xPos, yBase - 1.0f, movedPosition, yBase - 2.0f);
            float[] xP = new float[3];
            float[] yP = new float[3];
            xP[0] = movedPosition;
            yP[1] = yP[2] = yBase - 2.0f - 1.0f;
            yP[0] = yBase - 2.0f;
            if (event.getEvType() == 'L') {
                xP[1] = movedPosition + (bp.getAgeLeftToRight() ? -0.6f : 0.6f);
                xP[2] = movedPosition;
            } else if (event.getEvType() == 'F') {
                xP[1] = movedPosition + (bp.getAgeLeftToRight() ? 0.6f : -0.6f);
                xP[2] = movedPosition;
            } else {
                xP[1] = movedPosition - 0.6f;
                xP[2] = movedPosition + 0.6f;
            }
            g.fillPolygon(xP, yP, 3, colour);
            String string = eventName = this.p.showType ? event.toStringName() : event.getName();
            if (this.p.showDepths) {
                g.drawStringVertical("" + SB.round((double)age, (int)2), movedPositionsStd[i], yBase - ageIndent, yBase - y - ageIndent, false, false, true);
            }
            g.drawStringVertical(eventName, movedPositionsStd[i], yBase - eventIndent, this.p.columnWidth - eventIndent, false, false, true);
            if (this.p.showCommentsColumn && StringUtils.isNotBlank((CharSequence)event.getComments())) {
                g.drawStringVertical(event.getComments(), movedPositionsStd[i], yBase - this.p.columnWidth - 2.0f, this.p.commentsColumnWidth - 2.0f, false, false, true);
            }
            ++i;
        }
        return yBase - y;
    }

    @Override
    public int addSamples(LinkedList<Sample> samples, ChartProperties cp) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getRowString(LinkedList<Sample> samples, int index, ChartProperties cp) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    List<ChartObject> getChartObjects(ChartProperties cp) {
        LinkedList<ChartObject> eventList = new LinkedList<ChartObject>();
        ScaleConverter scaleConverter = this.block.getScaleConverter(this.block.getWell());
        for (CompositeStandardEvent event : this.getEvents(true)) {
            float[] positions;
            double age = this.p.getCmpStd().getAge(event.getCSU());
            if (!scaleConverter.isWithinPlottableRange(age, BlockProperties.ScaleType.AGE)) continue;
            for (float yPos : positions = this.block.scaleToAll(age, BlockProperties.ScaleType.AGE, scaleConverter)) {
                ChartObject<CompositeStandardEvent> co = new ChartObject<CompositeStandardEvent>(event, yPos);
                co.setPlotName("" + age * cp.ageFormat.getMultiplyer());
                eventList.add(co);
            }
        }
        return eventList;
    }

    @Override
    void addEvents(ChartProperties cp, List<ChartObject> compositeList) throws SQLException {
        LinkedList<ChartObject> compositeList2 = new LinkedList<ChartObject>();
        Iterator<ChartObject> itt = compositeList.iterator();
        LinkedList<ChartObject<Object>> list = null;
        class ChartObjectCompounder {
            ChartObjectCompounder(PanelCompositeStandard this$0) {
                Objects.requireNonNull(this$0);
            }

            ChartObject createChartObject(LinkedList<ChartObject> list) {
                LinkedList<CompositeStandardEvent> events = new LinkedList<CompositeStandardEvent>();
                for (ChartObject coEvent : list) {
                    events.add((CompositeStandardEvent)coEvent.getO());
                }
                Collections.sort(events);
                ChartObject listObject = new ChartObject(events, list.getLast().getyPos());
                listObject.setPlotName(list.getLast().getPlotName());
                return listObject;
            }
        }
        ChartObjectCompounder compounder = new ChartObjectCompounder(this);
        while (itt.hasNext()) {
            ChartObject chartObject = itt.next();
            CompositeStandardEvent event = (CompositeStandardEvent)chartObject.getO();
            if (list == null) {
                list = new LinkedList<ChartObject>();
                list.add(chartObject);
                continue;
            }
            CompositeStandardEvent lastEvent = (CompositeStandardEvent)((ChartObject)list.getLast()).getO();
            float lastYpos = ((ChartObject)list.getLast()).getyPos();
            if (event.getType() == lastEvent.getType() && (double)Math.abs(chartObject.getyPos() - lastYpos) < 0.1) {
                list.add(chartObject);
                continue;
            }
            compositeList2.add(compounder.createChartObject(list));
            list = new LinkedList();
            list.add(chartObject);
        }
        if (list != null && !list.isEmpty()) {
            compositeList2.add(compounder.createChartObject((LinkedList<ChartObject>)list));
        }
        for (ChartObject co : compositeList2) {
            if (this.separate) {
                EventType type = ((CompositeStandardEvent)((List)co.getO()).get(0)).getType();
                if (type == EventType.BASE) {
                    this.chartObjects2.add(co);
                    continue;
                }
                this.chartObjects.add(co);
                continue;
            }
            this.chartObjects.add(co);
        }
    }

    @Override
    float gethPosition(ChartProperties cp, BlockProperties bp) throws SBException {
        return this.block.scale(bp.getMin(), bp.getScaleType()) + cp.getFontSize(this.p.fontSize) / 2.0f;
    }

    private List<CompositeStandardEvent> getEvents(boolean ageLeftToRight) {
        if (this.p.getCmpStd() == null) {
            return new ArrayList<CompositeStandardEvent>();
        }
        List events = this.p.getCmpStd().getEventsByCSU(ageLeftToRight, true);
        Iterator it = events.iterator();
        while (it.hasNext()) {
            CompositeStandardEvent event = (CompositeStandardEvent)it.next();
            if (!this.p.plotEventDisc(event.getDisc())) {
                it.remove();
                continue;
            }
            if (!this.p.plotEventCategory(event.getEvent().getCatMnem())) {
                it.remove();
                continue;
            }
            if (!this.p.plotEventType(event.getEvType())) {
                it.remove();
                continue;
            }
            if (event.getConfidence().getDBint() > this.p.maxUnconfidence) {
                it.remove();
                continue;
            }
            if (event.getConfidence().getDBint() >= this.p.minUnconfidence) continue;
            it.remove();
        }
        if (!this.p.filter() || this.block.getWell() == null) {
            return events;
        }
        it = events.iterator();
        try {
            LinkedList<WellInterp> interps = new LinkedList<WellInterp>();
            if (this.block.getWells() != null) {
                for (Well well : this.block.getWells()) {
                    interps.add(well.getInterp(this.block.getInterpID()));
                }
            }
            block4: while (it.hasNext()) {
                CompositeStandardEvent e = (CompositeStandardEvent)it.next();
                for (WellInterp interp : interps) {
                    for (WellEvent w : interp.getEvents()) {
                        if (w.getSbEvent().getEvID() != e.getEvID() || w.getTypeObj() != e.getType()) continue;
                        continue block4;
                    }
                }
                it.remove();
            }
        }
        catch (SBException sbe) {
            sbe.printStackTrace();
        }
        return events;
    }

    public CompositeStandard getCmpStd() {
        return this.p.getCmpStd();
    }

    @Override
    public SchemeBlock getBlock() {
        return this.block;
    }
}

