/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.well.WellGeoSort;
import java.awt.Color;
import java.awt.geom.GeneralPath;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import jsbchart.block.BlockProperties;
import jsbchart.block.ChartBlock;
import jsbchart.block.CorrelationPoint;
import jsbchart.block.WellBlock;
import jsbchart.core.Chart;
import jsbchart.core.ChartProperties;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.correlation.CorrelationType;
import jsbchart.data.ScaleConverter;
import jsbchart.graphics.SBGraphics;
import jsbchart.panel.PanelEnvProperties;
import jsbchart.panel.PanelIntcoms;
import jsbchart.panel.PanelIntcomsProperties;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.SBPanel;
import model3.EnvScheme;
import model3.IGDInterval;
import model3.IGDIntervalEnv;
import model3.IPSBathy;
import model3.Intcom;
import model3.InterpHdr;
import model3.SBdb;
import model3.Sample;
import model3.Smpdtl;
import model3.Well;
import model3.WellInterp;
import model3.WellManager;
import model3.WsWell;
import util.SBException;

public class PanelEnv
extends SBPanel
implements Observer {
    private final WellBlock block;
    private PanelEnvProperties p;
    private LinkedList<DrawEnv> drawEnvs;
    private LinkedList<DrawEnvAnalysis> drawEnvAnalys;
    private IPSBathy ipsBathy;
    private boolean[] classes = null;
    private String[] titles;
    private Color[] colours;
    private static float SMALL_HEIGHT = 1.5f;
    private static final String[] templTitles = new String[]{"Class 1", "Class 2", "Class 3", "Class 4"};
    private static final Color[] templColours = new Color[]{new Color(255, 242, 89), new Color(254, 191, 16), new Color(235, 137, 33), new Color(204, 51, 51)};

    PanelEnv(PanelTemplate template, WellBlock block, PanelOcc occ) throws SBException, SQLException {
        super(template, occ != null ? occ : new PanelOcc(template.getID()));
        this.block = block;
        this.p = (PanelEnvProperties)template.getProperties();
        this.init();
    }

    private void init() throws SBException, SQLException {
        if (this.block.getWell() != null) {
            this.block.getWell().loadInterps();
            WellInterp interp = this.block.getWell().getInterp(this.getInterpID(this.block));
            this.block.getWell().loadInterp(interp);
            interp.addWeakObserver((Observer)this);
        }
    }

    @Override
    public void drawBackground(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) {
        try {
            if (this.p.drawIntervals) {
                this.drawIntervals(g, x, y + this.getPanelHeaderHeight(cp, mode), cp, bp, mode);
            }
        }
        catch (Exception e) {
            this.handleException(g, x, y, cp, bp, e);
            e.printStackTrace();
        }
    }

    @Override
    public float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode, EnumMap<CorrelationType, HashSet<CorrelationPoint>> cLines) {
        int schID;
        boolean firstOrOnly;
        if (this.titles == null) {
            return x;
        }
        ScaleConverter sc = this.block.getScaleConverter();
        boolean bl = firstOrOnly = bp == this.block.getProp() || sc.isTopDepth(bp.getMin());
        if (cp.key != null && cp.keyIsVisible() && cp.key.envSchemes && (schID = this.getSchemeID()) > 0) {
            try {
                cp.getKeyData().putEnvScheme(this.getDb().getEnvScheme(schID));
            }
            catch (SQLException sql) {
                sql.printStackTrace();
            }
        }
        if (!g.isVisible(x, firstOrOnly ? 0.0f : this.block.scaleMeasuredDepth(bp.getNormal() ? (double)bp.getMin() : (double)bp.getMax(), sc) + y + this.getPanelHeaderHeight(cp, mode), (float)this.titles.length * this.p.columnWidth, bp.getHeight() + (firstOrOnly ? this.getPanelHeaderHeight(cp, mode) : 0.0f))) {
            return x + this.getWidth(bp);
        }
        try {
            this.drawSeaBed(g, cp, bp, this.block, sc, x, y + this.getPanelHeaderHeight(cp, mode));
            g.setColor(cp.foreground);
            float xpos = x;
            g.setStroke(0.1f);
            g.setFont(cp.font, 0, cp.getFontSizePanel());
            float ytop = y + this.block.getPanelHeaderHeight(cp, mode);
            if (!firstOrOnly) {
                ytop += this.block.scaleMeasuredDepth(bp.getNormal() ? (double)bp.getMin() : (double)bp.getMax(), sc);
            }
            float pad = cp.getFontSizePanel() / 2.0f;
            if (!this.p.stackColumns) {
                for (String title : this.titles) {
                    g.drawLine(xpos, ytop - (firstOrOnly ? pad : 0.0f), xpos, ytop + bp.getHeight());
                    if (mode != Chart.Mode.NO_HEADER && firstOrOnly) {
                        g.drawStringVertical(title, xpos + this.p.columnWidth / 2.0f, ytop - pad * 2.0f, cp.panelSubHeaderHeight - pad * 2.0f, true, false, true);
                    }
                    xpos += this.p.columnWidth;
                }
                if (this.p.drawAnalyses && this.drawEnvAnalys != null) {
                    this.drawAnalyses(g, x, y, cp, bp, mode);
                }
                if (this.p.drawIPSBathy) {
                    this.drawIPSBathy(g, x, y, cp, bp, mode);
                }
            } else if (mode != Chart.Mode.NO_HEADER && firstOrOnly) {
                g.drawStringVertical(this.getSchemeName().isEmpty() ? this.getCaption() : this.getSchemeName(), x + this.p.columnWidth / 2.0f, ytop - pad * 2.0f, cp.panelSubHeaderHeight - pad * 2.0f, true, false, true);
                xpos += this.p.columnWidth;
            }
            if (this.p.commentsCol.show() && this.hasComments()) {
                g.setColor(cp.foreground);
                g.setStroke(0.2f);
                if (mode != Chart.Mode.NO_HEADER && firstOrOnly) {
                    g.drawStringVertical("Comments", xpos + this.p.commentsCol.width() / 2.0f, y + this.block.getPanelHeaderHeight(cp, mode) - cp.getFontSizeHeader(), cp.panelSubHeaderHeight - cp.getFontSizeHeader(), true, false, true);
                    this.drawColumnDivider(g, xpos, y, ytop, firstOrOnly, cp, bp, mode);
                } else {
                    g.drawLine(xpos, ytop, xpos, ytop + bp.getHeight());
                }
                this.drawComments(g, xpos, y + this.getPanelHeaderHeight(cp, mode), bp, cp);
            }
        }
        catch (Exception e) {
            this.handleException(g, x, y, cp, bp, e);
            e.printStackTrace();
        }
        return x + this.getWidth(bp);
    }

    static float drawHorz(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, List<Well> wells, EnvScheme scheme, int interpID, WellGeoSort sortOrder) {
        g.setFont(cp.font, 0, cp.getFontSizePanel());
        g.setStroke(0.1f);
        LinkedList<String> wellNames = new LinkedList<String>();
        float ypos = y;
        WellManager.sortWells(wells, (WellGeoSort)sortOrder);
        for (Well well : wells) {
            try {
                float wellWidth = PanelEnv.drawHorzWell(g, x, ypos, cp, bp, well, scheme, interpID, bp.calcHeight());
                if (wellWidth > 0.0f) {
                    wellNames.add(well.getWellName());
                }
                ypos += wellWidth;
            }
            catch (Exception sbe) {
                sbe.printStackTrace();
            }
        }
        if (!wellNames.isEmpty()) {
            float maxWidth = 0.0f;
            for (String s : wellNames) {
                float sWidth = g.stringWidth(s);
                if (!(sWidth > maxWidth)) continue;
                maxWidth = sWidth;
            }
            maxWidth += 2.0f;
            ypos = y;
            g.setColor(cp.foreground);
            for (String s : wellNames) {
                g.fillRect(x, ypos, maxWidth, 10.0f, cp.background);
                g.drawString(s, x + 1.0f, ypos + 5.0f + g.stringHeightSB() / 2.0f, maxWidth - 2.0f, 1, true);
                ypos += 10.0f;
            }
        }
        g.setStroke(0.4f);
        g.drawRect(x, y, bp.getHeight(), ypos - y);
        return ypos - y;
    }

    private static float drawHorzWell(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Well well, EnvScheme scheme, int interpID, float height) throws SBException, SQLException {
        float colWidth = 10.0f;
        WellInterp interp = well.getInterp(interpID);
        if (interp != null && interp.getLOC() != null) {
            well.loadInterp(interp);
            if (interp.getEnvs() != null && !interp.getEnvs().isEmpty() && interp.getEnvScheme() == scheme) {
                for (IGDIntervalEnv env : interp.getEnvs()) {
                    float x2;
                    double topDepth = well.getDepth(env.getTopSample(), cp.correctDepths, cp.correctCuttings);
                    double baseDepth = well.getDepth(env.getBaseSample(), cp.correctDepths, cp.correctCuttings);
                    double topAge = interp.getLOC().getAge(topDepth, false);
                    double baseAge = interp.getLOC().getAge(baseDepth, false);
                    if (!(baseAge > (double)bp.getMin()) || !(topAge < (double)bp.getMax())) continue;
                    float x1 = PanelEnv.getXPos((float)topAge, bp);
                    if (x1 > (x2 = PanelEnv.getXPos((float)baseAge, bp))) {
                        float temp = x1;
                        x1 = x2;
                        x2 = temp;
                    }
                    if (x1 < 0.0f) {
                        x1 = 0.0f;
                    }
                    if (x2 > bp.getHeight()) {
                        x2 = bp.getHeight();
                    }
                    g.setColor(scheme.getColour(bp.getAgeLeftToRight() ? env.getUp() : env.getLp()));
                    g.fillRect(x + x1, y, (x2 - x1) / 2.0f, colWidth / 2.0f, g.getColor());
                    g.setColor(scheme.getColour(bp.getAgeLeftToRight() ? env.getLp() : env.getUp()));
                    g.fillRect(x + x1 + (x2 - x1) / 2.0f, y, (x2 - x1) / 2.0f, colWidth / 2.0f, g.getColor());
                    g.setColor(scheme.getColour(bp.getAgeLeftToRight() ? env.getUd() : env.getLd()));
                    g.fillRect(x + x1, y + colWidth / 2.0f, (x2 - x1) / 2.0f, colWidth / 2.0f, g.getColor());
                    g.setColor(scheme.getColour(bp.getAgeLeftToRight() ? env.getLd() : env.getUd()));
                    g.fillRect(x + x1 + (x2 - x1) / 2.0f, y + colWidth / 2.0f, (x2 - x1) / 2.0f, colWidth / 2.0f, g.getColor());
                }
                g.setColor(cp.foreground);
                g.drawRect(x, y, height, colWidth);
                return colWidth;
            }
        }
        return 0.0f;
    }

    private void drawComments(SBGraphics g, float x, float topY, BlockProperties bp, ChartProperties cp) {
        Iterator it;
        if (this.block.getWell() == null) {
            LinkedList<Intcom.Builder> list = new LinkedList<Intcom.Builder>();
            Intcom.Builder builder = new Intcom.Builder(this.getDb(), 5, this.block.getTemplateSamples().get(0).getDepth());
            builder.baseDepth(this.block.getTemplateSamples().get(3).getDepth());
            builder.comments("You can enter comments for " + IGDInterval.getIGDName((int)5) + " in the Samples & Interpretations module.");
            list.add(builder);
            it = list.iterator();
        } else {
            it = this.block.getInterp().getIntcoms(5).iterator();
        }
        PanelIntcomsProperties ip = new PanelIntcomsProperties(null);
        ip.fontSize = ChartProperties.FontSize.SMALL;
        ip.shrinkText = false;
        ip.showDepths = true;
        ip.panelWidth = this.p.commentsCol.width();
        PanelIntcoms.drawCommentColumn(it, g, this.block, cp, bp, ip, x, topY);
    }

    @Override
    protected String getCaption() {
        Object string = "Palaeo\\environments";
        if (!this.getSchemeName().isEmpty()) {
            string = (String)string + " : " + this.getSchemeName();
        }
        return string;
    }

    String getSchemeName() {
        Object string = "";
        if (this.p.scheme != null) {
            string = this.p.scheme.toString();
        } else if (this.block.getWell() != null && this.drawEnvs != null && !this.drawEnvs.isEmpty()) {
            try {
                string = (String)string + String.valueOf(this.getDb().getEnvScheme(this.drawEnvs.getFirst().env.getSchID()));
            }
            catch (SQLException sql) {
                sql.printStackTrace();
            }
        }
        return string;
    }

    @Override
    protected String getSubCaption() {
        InterpHdr hdr = this.block.getVersion(this.getInterpID(this.block));
        if (hdr != null && hdr.getInterpID() > 0) {
            return hdr.toString();
        }
        return null;
    }

    private boolean hasComments() {
        if (this.block.getWell() == null) {
            return true;
        }
        return !this.block.getInterp().getIntcoms(5).isEmpty();
    }

    private int usedClassIndex(int classNo) throws SBException {
        int nUsed = 0;
        for (int i = 0; i < this.classes.length; ++i) {
            if (this.classes[i]) {
                ++nUsed;
            }
            if (i != classNo) continue;
            return nUsed;
        }
        throw new SBException("classNo " + classNo + " not found");
    }

    private void drawIPSBathy(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) {
        if (this.ipsBathy == null || this.ipsBathy.get().isEmpty()) {
            return;
        }
        if (this.classes == null || this.classes.length < 9) {
            return;
        }
        ScaleConverter scaleConverter = this.block.getScaleConverter();
        float xLastBath = 0.0f;
        float yLastBath = 0.0f;
        float SYMBOL_SIZE = 1.0f;
        for (IPSBathy.IPSBathyDepth bathy : this.ipsBathy.get()) {
            if (bp != this.block.getProp() && (bathy.getDepth() <= (double)bp.getMin() || bathy.getDepth() >= (double)bp.getMax())) continue;
            if (bathy.getBath() > (double)0.0029f && scaleConverter.isWithinPlottableRange(bathy.getDepth())) {
                float xBno;
                float yBath = y + this.block.scaleMeasuredDepth((float)bathy.getDepth(), scaleConverter) + this.getPanelHeaderHeight(cp, mode);
                float xBavg = x + (float)bathy.getBavg() * this.p.columnWidth + this.p.columnWidth / 2.0f;
                float xBath = x + (float)bathy.getBath() * this.p.columnWidth + this.p.columnWidth / 2.0f;
                float xPlot = x + (float)bathy.getBlw() * this.p.columnWidth + this.p.columnWidth / 2.0f;
                g.setColor(Color.green);
                g.drawLine(xBavg, yBath, xBath, yBath);
                if (xLastBath > 0.0029f) {
                    g.setColor(Color.cyan);
                    g.setStroke(0.3f);
                    g.drawLine(xLastBath, yLastBath, xBath, yBath);
                }
                g.setColor(Color.green);
                g.fillEllipse(xBavg - 0.5f, yBath - 0.5f, 1.0f, 1.0f, Color.green);
                g.setColor(Color.cyan);
                g.fillEllipse(xBath - 0.5f, yBath - 0.5f, 1.0f, 1.0f, Color.cyan);
                g.setColor(Color.black);
                g.fillEllipse(xPlot - 0.5f, yBath - 0.5f, 1.0f, 1.0f, Color.black);
                xLastBath = xBath;
                yLastBath = yBath;
                if (bathy.getBno() >= 8) {
                    g.setColor(Color.green);
                    xBno = x + this.getWidth(bp);
                } else {
                    g.setColor(Color.red);
                    xBno = (float)((double)(x + this.getWidth(bp)) - (double)this.p.columnWidth * (8.0 - (double)bathy.getBno()) / 8.0);
                }
                g.fillRect(xBno - this.p.columnWidth / 8.0f, yBath - 0.3f, 0.6f, 0.6f);
                continue;
            }
            xLastBath = 0.0f;
            yLastBath = 0.0f;
        }
    }

    private void drawAnalyses(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) {
        if (this.drawEnvAnalys == null || this.drawEnvAnalys.isEmpty()) {
            return;
        }
        g.setStroke(this.p.analyWidth);
        g.setColor(this.p.analyColour);
        for (DrawEnvAnalysis analy : this.drawEnvAnalys) {
            if (bp != this.block.getProp() && (analy.depth < (double)bp.getMin() || analy.depth > (double)bp.getMax())) continue;
            float startPoint = x;
            int nUsed = 0;
            for (int i = 0; i < this.classes.length; ++i) {
                if (i == analy.start) {
                    startPoint += (float)nUsed * this.p.columnWidth;
                    break;
                }
                if (!this.classes[i]) continue;
                ++nUsed;
            }
            float span = 0.0f;
            for (int i = analy.start; i <= analy.end; ++i) {
                if (!this.classes[i]) continue;
                span += 1.0f;
            }
            g.drawLine(startPoint, analy.ypos + y + this.getPanelHeaderHeight(cp, mode), startPoint + span * this.p.columnWidth, analy.ypos + y + this.getPanelHeaderHeight(cp, mode));
        }
    }

    private void drawIntervals(SBGraphics g, float x, float ypos, ChartProperties cp, BlockProperties bp, Chart.Mode mode) throws SBException, SQLException {
        if (this.drawEnvs == null) {
            return;
        }
        if (!this.p.stackColumns) {
            LinkedList<GeneralPath> paths = new LinkedList<GeneralPath>();
            GeneralPath clip = new GeneralPath();
            for (DrawEnv env : this.drawEnvs) {
                if (bp != this.block.getProp() && (env.baseDepth <= (double)bp.getMin() || env.topDepth >= (double)bp.getMax())) continue;
                float upx = x + env.xpos[0];
                float udx = x + env.xpos[1];
                float ldx = x + env.xpos[2];
                float lpx = x + env.xpos[3];
                float uy = ypos + env.yposTop;
                float ly = ypos + env.yposBase;
                GeneralPath path = SBGraphics.createGeneralPath(upx, uy);
                SBGraphics.appendLine(path, udx, uy);
                SBGraphics.appendLine(path, ldx, ly);
                SBGraphics.appendLine(path, lpx, ly);
                path.closePath();
                paths.add(path);
                clip.append(path, false);
            }
            g.setClip(clip);
            float ytop = bp == this.block.getProp() ? ypos : ypos + this.block.scaleMeasuredDepth(bp.getNormal() ? (double)bp.getMin() : (double)bp.getMax(), this.block.getScaleConverter());
            float xPos = x;
            for (int i = 0; i < this.titles.length; ++i) {
                g.setColor(this.colours[i]);
                g.fillRect(xPos, ytop, this.p.columnWidth, bp.getHeight());
                xPos += this.p.columnWidth;
            }
            g.setClip(null);
            g.setColor(cp.foreground);
            g.setStroke(0.2f);
            for (GeneralPath gp : paths) {
                g.drawShape(gp);
            }
            for (DrawEnv env : this.drawEnvs) {
                if (env.env == null || !this.p.drawQualifiers || env.env.getQual() <= 0) continue;
                float y = ypos + env.yposTop;
                float h = ypos + env.yposBase - y;
                float w = this.p.columnWidth / 3.0f;
                int classNo = (this.p.drawAllClasses ? env.env.getQual() : this.usedClassIndex(env.env.getQual() - 1)) - 1;
                float xpos = x + (float)classNo * this.p.columnWidth + this.p.columnWidth / 2.0f - w / 2.0f;
                if (this.colours[classNo] == null) {
                    System.out.println("Colour null in env qualifier in panelEnv.drawIntervals");
                    continue;
                }
                g.fillRect(xpos, y, w, h, this.colours[classNo]);
            }
        } else {
            int col = 0;
            g.setColor(cp.foreground);
            g.setStroke(0.2f);
            for (DrawEnv env : this.drawEnvs) {
                Color fillColour;
                if (env.env != null) {
                    assert (env.env.getUp() - 1 >= 0);
                    fillColour = this.colours[env.env.getUp() - 1];
                } else {
                    fillColour = templColours[col++];
                    if (col >= templColours.length) {
                        col = 0;
                    }
                }
                float uy = ypos + env.yposTop;
                float ly = ypos + env.yposBase;
                g.fillRect(x, uy, this.p.columnWidth, ly - uy, fillColour);
            }
        }
    }

    @Override
    public void setData(ChartProperties cp, double[][] sections) throws SBException, SQLException {
        EnvScheme scheme;
        this.drawEnvs = new LinkedList();
        if (this.block.getWell() == null) {
            this.setTemplateData();
            return;
        }
        if (!this.block.getWell().hasInterpLoaded(this.getInterpID())) {
            return;
        }
        Integer schemeID = this.p.scheme != null ? Integer.valueOf(this.p.scheme.getID()) : null;
        ScaleConverter scaleConverter = this.block.getScaleConverter();
        for (IGDIntervalEnv env : this.block.getWell().getInterp(this.getInterpID()).getEnvs()) {
            double baseSampleDepth;
            if (this.p.scheme != null && env.getSchID() != this.p.scheme.getID() || schemeID != null && env.getSchID() != schemeID.intValue()) continue;
            double topSampleDepth = this.block.getWell().getDepth(env.getTopSample(), cp.correctDepths, cp.correctCuttings);
            if (scaleConverter.isWithinPlottableRange(topSampleDepth, baseSampleDepth = this.block.getWell().getDepth(env.getBaseSample(), cp.correctDepths, cp.correctCuttings))) {
                float ly;
                float uy = this.block.scaleMeasuredDepth(topSampleDepth, scaleConverter);
                if (Math.abs(uy - (ly = this.block.scaleMeasuredDepth(baseSampleDepth, scaleConverter))) < SMALL_HEIGHT) {
                    if (scaleConverter.isWithinPlottableRange(topSampleDepth)) {
                        uy -= SMALL_HEIGHT / 2.0f;
                    }
                    if (scaleConverter.isWithinPlottableRange(baseSampleDepth)) {
                        ly += SMALL_HEIGHT / 2.0f;
                    }
                }
                this.drawEnvs.add(new DrawEnv(env, topSampleDepth, baseSampleDepth, uy, ly));
            }
            schemeID = env.getSchID();
        }
        this.drawEnvAnalys = null;
        if (this.p.drawAnalyses) {
            this.drawEnvAnalys = new LinkedList();
            for (Sample sample : this.block.getWell().getSamples()) {
                Integer min = null;
                Integer max = null;
                for (Smpdtl smpdtl : sample.getSmpdtls()) {
                    if (!this.p.useAnalyst(smpdtl.getHeader().getAnalyst()) || schemeID != null && smpdtl.getHeader().getEnvSchID() != schemeID.intValue() || smpdtl.getProximal() <= 0 || smpdtl.getDistal() <= 0) continue;
                    if (min == null || min > smpdtl.getProximal()) {
                        min = smpdtl.getProximal();
                    }
                    if (max == null || max < smpdtl.getDistal()) {
                        max = smpdtl.getDistal();
                    }
                    schemeID = smpdtl.getHeader().getEnvSchID();
                }
                if (min == null || max == null) continue;
                double depth = this.block.getWell().getDepth(sample, cp.correctDepths, cp.correctCuttings);
                float ypos = this.block.scaleMeasuredDepth(depth, scaleConverter);
                this.drawEnvAnalys.add(new DrawEnvAnalysis(depth, ypos, min - 1, max - 1));
            }
            if (this.drawEnvAnalys.isEmpty()) {
                this.drawEnvAnalys = null;
            }
        }
        EnvScheme envScheme = scheme = schemeID == null ? null : this.getDb().getEnvScheme(schemeID.intValue());
        if (scheme == null) {
            assert (this.drawEnvs.isEmpty());
            this.titles = new String[]{"No scheme"};
            this.colours = new Color[]{Color.GRAY};
            this.classes = null;
            return;
        }
        this.classes = new boolean[scheme.getNClasses()];
        boolean includeAllClasses = this.p.drawAllClasses;
        if (!this.p.drawAllClasses) {
            for (IGDIntervalEnv env : this.block.getWell().getInterp(this.getInterpID()).getEnvs()) {
                if (env.getSchID() != schemeID.intValue()) continue;
                this.classes[env.getUp() - 1] = true;
                this.classes[env.getLp() - 1] = true;
                this.classes[env.getUd() - 1] = true;
                this.classes[env.getLd() - 1] = true;
                if (!this.p.drawQualifiers || env.getQual() <= 0) continue;
                this.classes[env.getQual() - 1] = true;
            }
            if (this.drawEnvAnalys != null) {
                for (DrawEnvAnalysis da : this.drawEnvAnalys) {
                    this.classes[da.start] = true;
                    this.classes[da.end] = true;
                }
            }
        }
        if (this.areAllClassesHidden()) {
            includeAllClasses = true;
        }
        if (includeAllClasses) {
            for (int i = 0; i < this.classes.length; ++i) {
                this.classes[i] = true;
            }
        }
        LinkedList<String> titlesList = new LinkedList<String>();
        LinkedList<Color> coloursList = new LinkedList<Color>();
        for (int i = 0; i < this.classes.length; ++i) {
            if (!this.classes[i]) continue;
            titlesList.add(scheme.getTerm(i + 1));
            coloursList.add(scheme.getColour(i + 1));
        }
        this.titles = titlesList.toArray(new String[titlesList.size()]);
        this.colours = coloursList.toArray(new Color[coloursList.size()]);
        for (DrawEnv env : this.drawEnvs) {
            if (!this.p.stackColumns) {
                env.xpos[0] = (float)(this.p.drawAllClasses ? env.env.getUp() : this.usedClassIndex(env.env.getUp() - 1)) * this.p.columnWidth - this.p.columnWidth;
                env.xpos[1] = (float)(this.p.drawAllClasses ? env.env.getUd() : this.usedClassIndex(env.env.getUd() - 1)) * this.p.columnWidth;
                env.xpos[2] = (float)(this.p.drawAllClasses ? env.env.getLd() : this.usedClassIndex(env.env.getLd() - 1)) * this.p.columnWidth;
                env.xpos[3] = (float)(this.p.drawAllClasses ? env.env.getLp() : this.usedClassIndex(env.env.getLp() - 1)) * this.p.columnWidth - this.p.columnWidth;
                continue;
            }
            env.xpos[0] = 0.0f;
            env.xpos[1] = this.p.columnWidth;
            env.xpos[2] = this.p.columnWidth;
            env.xpos[3] = 0.0f;
        }
        if (sections != null) {
            LinkedList<DrawEnv> modList = new LinkedList<DrawEnv>();
            boolean YPOS = false;
            boolean DDEPTH = true;
            for (int j = 1; j < sections.length; ++j) {
                if (Math.abs(sections[j - 1][1] - sections[j][1]) < 0.001) continue;
                for (DrawEnv dEnv : this.drawEnvs) {
                    if (dEnv.baseDepth < sections[j - 1][1] || dEnv.topDepth > sections[j][1]) continue;
                    if (dEnv.topDepth >= sections[j - 1][1] && dEnv.baseDepth <= sections[j][1]) {
                        if (Math.abs(dEnv.topDepth - sections[j - 1][1]) < 0.01) {
                            dEnv.yposTop = (float)sections[j - 1][0];
                        }
                        if (Math.abs(dEnv.baseDepth - sections[j][1]) < 0.01) {
                            dEnv.yposBase = (float)sections[j][0];
                        }
                        modList.add(dEnv);
                        continue;
                    }
                    if (dEnv.topDepth < sections[j - 1][1] && dEnv.baseDepth > sections[j][1]) {
                        modList.add(new DrawEnv(dEnv, sections[j - 1][1], sections[j][1], (float)sections[j - 1][0], (float)sections[j][0]));
                        continue;
                    }
                    if (dEnv.baseDepth > sections[j][1]) {
                        modList.add(new DrawEnv(dEnv, dEnv.topDepth, sections[j][1], dEnv.yposTop, (float)sections[j][0]));
                        continue;
                    }
                    modList.add(new DrawEnv(dEnv, sections[j - 1][1], dEnv.baseDepth, (float)sections[j - 1][0], dEnv.yposBase));
                }
            }
            this.drawEnvs = modList;
        }
        if (this.p.drawIPSBathy) {
            this.ipsBathy = this.block.getWell().getIPSBathy();
        }
    }

    private boolean areAllClassesHidden() {
        boolean allHidden = true;
        for (int i = 0; i < this.classes.length; ++i) {
            if (!this.classes[i]) continue;
            allHidden = false;
            break;
        }
        return allHidden;
    }

    private void setTemplateData() {
        this.classes = new boolean[]{true, true, true, this.p.drawAllClasses};
        LinkedList<String> titlesList = new LinkedList<String>();
        LinkedList<Color> coloursList = new LinkedList<Color>();
        for (int i = 0; i < this.classes.length; ++i) {
            if (!this.classes[i]) continue;
            titlesList.add(templTitles[i]);
            coloursList.add(templColours[i]);
        }
        this.titles = titlesList.toArray(new String[titlesList.size()]);
        this.colours = coloursList.toArray(new Color[coloursList.size()]);
        ScaleConverter sc = this.block.getScaleConverter();
        LinkedList<Sample> templateSamples = this.block.getTemplateSamples();
        this.drawEnvs.add(new DrawEnv((IGDIntervalEnv)null, templateSamples.get(0).getDepth(), templateSamples.get(2).getDepth(), this.block.scaleMeasuredDepth((float)templateSamples.get(0).getDepth(), sc), this.block.scaleMeasuredDepth((float)templateSamples.get(2).getDepth(), sc)));
        this.drawEnvs.add(new DrawEnv((IGDIntervalEnv)null, templateSamples.get(2).getDepth(), templateSamples.get(3).getDepth(), this.block.scaleMeasuredDepth((float)templateSamples.get(2).getDepth(), sc), this.block.scaleMeasuredDepth((float)templateSamples.get(3).getDepth(), sc)));
        int[] zone1 = new int[]{1, 2, 2, 1};
        int[] zone2 = new int[]{1, 2, 3, 2};
        int[][] zones = new int[][]{zone1, zone2};
        for (int i = 0; i < zones.length; ++i) {
            DrawEnv env = this.drawEnvs.get(i);
            if (!this.p.stackColumns) {
                env.xpos[0] = (float)zones[i][0] * this.p.columnWidth - this.p.columnWidth;
                env.xpos[1] = (float)zones[i][1] * this.p.columnWidth;
                env.xpos[2] = (float)zones[i][2] * this.p.columnWidth;
                env.xpos[3] = (float)zones[i][3] * this.p.columnWidth - this.p.columnWidth;
                continue;
            }
            env.xpos[0] = 0.0f;
            env.xpos[1] = this.p.columnWidth;
            env.xpos[2] = this.p.columnWidth;
            env.xpos[3] = 0.0f;
        }
        if (this.p.drawAnalyses) {
            this.drawEnvAnalys = new LinkedList();
            this.drawEnvAnalys.add(new DrawEnvAnalysis(templateSamples.get(1).getDepth(), this.block.scaleMeasuredDepth((float)templateSamples.get(1).getDepth(), sc), 0, 1));
        } else {
            this.drawEnvAnalys = null;
        }
    }

    @Override
    public float getWidth(BlockProperties bp) {
        float width = 0.0f;
        if (this.p.commentsCol.show() && this.hasComments()) {
            width += this.p.commentsCol.width();
        }
        if (this.p.stackColumns) {
            return width + this.p.columnWidth;
        }
        if (this.titles == null) {
            return width + this.p.columnWidth;
        }
        return width + this.p.columnWidth * (float)this.titles.length;
    }

    @Override
    public Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        if (this.drawEnvs.isEmpty() || this.block.getWell() == null) {
            return null;
        }
        float depth = this.block.getDepth(y, bp);
        float BRACKET = 2.5f / zoom;
        for (DrawEnv env : this.drawEnvs) {
            float basepos;
            float toppos = bp.getNormal() ? env.yposTop : env.yposBase;
            float f = basepos = bp.getNormal() ? env.yposBase : env.yposTop;
            if (!(y > toppos - BRACKET) || !(y < basepos + BRACKET) || bp != this.block.getProp() && ((double)depth > env.baseDepth || (double)depth < env.topDepth)) continue;
            if (env.topDepth - (double)BRACKET < (double)depth && env.topDepth + (double)BRACKET > (double)depth) {
                return "Bnd: " + String.valueOf(env.env.getTopSample());
            }
            if (env.baseDepth - (double)BRACKET < (double)depth && env.baseDepth + (double)BRACKET > (double)depth) {
                return "Bnd: " + String.valueOf(env.env.getBaseSample());
            }
            return env.env;
        }
        return null;
    }

    @Override
    public String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        Object o = this.getObject(x, y, cp, bp, zoom);
        if (o != null) {
            return o.toString();
        }
        return null;
    }

    public String toString() {
        Object string = "Palaeoenvironments";
        String interpString = this.getInterpString();
        string = (String)string + (String)(interpString != null ? " : " + interpString : "");
        return string;
    }

    String getInterpString() {
        String interpString = null;
        try {
            interpString = this.block.getWell() != null ? String.valueOf(this.block.getWell().getInterp(this.getInterpID(this.block))) : String.valueOf(this.getDb().getInterp(this.getInterpID()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return interpString;
    }

    public Sample getBoundarySample(float y, float zoom) {
        float depth = this.block.getDepth(y);
        float depthBracket = this.block.getDepth(y + 2.5f / zoom) - depth;
        for (DrawEnv env : this.drawEnvs) {
            if (Math.abs(env.topDepth - (double)depth) < (double)depthBracket) {
                return env.env.getTopSample();
            }
            if (!(Math.abs(env.baseDepth - (double)depth) < (double)depthBracket)) continue;
            return env.env.getBaseSample();
        }
        return null;
    }

    public Sample getSample(float x, float y, float zoom, ChartProperties cp) {
        float depth = this.block.getDepth(y);
        try {
            return this.block.getWell().getSampleNearest((double)depth, 2.5f / zoom, cp.correctDepths, cp.correctCuttings);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public PanelEnvProperties getProperties() {
        return this.p;
    }

    private int getSchemeID() {
        if (this.drawEnvs != null && !this.drawEnvs.isEmpty()) {
            return this.drawEnvs.getFirst().env.getSchID();
        }
        return 0;
    }

    public int getInterpID() {
        return this.getInterpID(this.block);
    }

    @Override
    public ChartBlock getBlock() {
        return this.block;
    }

    @Override
    public boolean hasData(BlockProperties bp) {
        return this.drawEnvs == null || !this.drawEnvs.isEmpty() || this.drawEnvAnalys != null;
    }

    @Override
    public void setProperties(PanelProperties pp) {
        if (!(pp instanceof PanelEnvProperties)) {
            throw new IllegalArgumentException("Wrong properties type for PanelEnv: " + String.valueOf(pp));
        }
        this.p = (PanelEnvProperties)pp;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof WellInterp) {
            if (((WellInterp)o).getHeader().getInterpID() == this.block.getInterpID()) {
                if (arg instanceof IGDIntervalEnv || arg instanceof Integer && (Integer)arg == 5) {
                    this.setDataChanged();
                    this.notifyListeners();
                }
            } else {
                ((WellInterp)o).deleteWeakObserver((Observer)this);
            }
            return;
        }
        super.update(o, arg);
    }

    @Override
    public Float getDataBound(boolean upper) {
        double val;
        if (this.drawEnvs == null && this.drawEnvAnalys == null) {
            return null;
        }
        Double bound = null;
        if (this.drawEnvs != null && !this.drawEnvs.isEmpty()) {
            double d = val = upper ? this.drawEnvs.get((int)0).topDepth : this.drawEnvs.get((int)(this.drawEnvs.size() - 1)).baseDepth;
            if (bound == null || upper && val < bound || !upper && val > bound) {
                bound = val;
            }
        }
        if (this.drawEnvAnalys != null && !this.drawEnvAnalys.isEmpty()) {
            double d = val = upper ? this.drawEnvAnalys.get((int)0).depth : this.drawEnvAnalys.get((int)(this.drawEnvAnalys.size() - 1)).depth;
            if (bound == null || upper && val < bound || !upper && val > bound) {
                bound = val;
            }
        }
        return bound != null ? Float.valueOf(bound.floatValue()) : null;
    }

    @Override
    public void fillWorkspaceWellData(SBdb ws, Set<Integer> dataTypes) throws SQLException, SBException {
        WsWell wsWell = (WsWell)ws.getWell(this.block.getWell().getWellID());
        Integer schemeID = null;
        if (this.drawEnvs != null) {
            ArrayList<IGDIntervalEnv> wsEnvs = new ArrayList<IGDIntervalEnv>();
            for (DrawEnv o : this.drawEnvs) {
                wsEnvs.add(o.env);
                schemeID = o.env.getSchID();
            }
            if (!wsEnvs.isEmpty()) {
                dataTypes.add(15);
                wsWell.getAddInterp(ws.fillInterp(this.getDb().getInterp(this.getInterpID(this.block)))).fillEnvs(wsWell, wsEnvs, true);
            }
        }
        if (this.drawEnvAnalys != null) {
            LinkedList<Smpdtl> toFill = new LinkedList<Smpdtl>();
            for (Sample sample : this.block.getWell().getSamples()) {
                for (Smpdtl smpdtl : sample.getSmpdtls()) {
                    if (!this.p.useAnalyst(smpdtl.getHeader().getAnalyst()) || schemeID != null && smpdtl.getHeader().getEnvSchID() != schemeID.intValue() || smpdtl.getProximal() <= 0 || smpdtl.getDistal() <= 0) continue;
                    schemeID = smpdtl.getHeader().getEnvSchID();
                    toFill.add(smpdtl);
                    dataTypes.add(SBdb.getDType((Discipline)smpdtl.getDiscipline()));
                }
            }
            if (!toFill.isEmpty()) {
                wsWell.fillAnalyses(toFill, false, 0);
            }
        }
    }

    private static class DrawEnv {
        final IGDIntervalEnv env;
        final double topDepth;
        final double baseDepth;
        float yposTop;
        float yposBase;
        final float[] xpos;

        DrawEnv(IGDIntervalEnv env, double topDepth, double baseDepth, float yposTop, float yposBase) {
            this.env = env;
            this.topDepth = topDepth;
            this.baseDepth = baseDepth;
            this.yposTop = yposTop;
            this.yposBase = yposBase;
            this.xpos = new float[4];
        }

        DrawEnv(DrawEnv dEnv, double topDepth, double baseDepth, float yposTop, float yposBase) {
            this.env = dEnv.env;
            this.xpos = Arrays.copyOf(dEnv.xpos, 4);
            this.topDepth = topDepth;
            this.baseDepth = baseDepth;
            this.yposTop = yposTop;
            this.yposBase = yposBase;
        }
    }

    private static class DrawEnvAnalysis {
        final double depth;
        final float ypos;
        final int start;
        final int end;

        DrawEnvAnalysis(double corrDepth, float ypos, int start, int end) {
            this.depth = corrDepth;
            this.ypos = ypos;
            this.start = start;
            this.end = end;
        }
    }
}

