/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.scheme.Confidence;
import com.stratadata.model3.taxon.Category;
import java.awt.Color;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import jsbchart.core.ChartProperties;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelType;
import model3.CompositeStandard;
import model3.SBdb;
import util.ColourUtils;

public class PanelEventsProperties
extends PanelProperties {
    private static final String[] PROP_NAMES = new String[]{"Composite Standard", "Events to include", "Column width", "Comments column", "Comments column width", "Single column", "Show depths", "Show age from composite", "Type", "Disciplines", "Categories", "Use colours", Discipline.MICRO.getAbr(false) + " colour", Discipline.NANNO.getAbr(false) + " colour", Discipline.PALY.getAbr(false) + " colour", Discipline.MACRO.getAbr(false) + " colour", "No discipline colour", "Filter by well events", "Font size", "Minimum confidence", "Maximum confidence", "Confidence colours", "Use abbrs.", "Show names", "Show top events", "Show base events", "Show single events"};
    public static final int PROP_STD = 0;
    public static final int PROP_CMPSTD_EXCL = 1;
    public static final int PROP_WIDTH = 2;
    public static final int PROP_COMMENTS = 3;
    public static final int PROP_COMMENTS_WIDTH = 4;
    public static final int PROP_SINGLE = 5;
    public static final int PROP_DEPTHS = 6;
    public static final int PROP_CMPSTDAGE = 7;
    public static final int PROP_TYPE = 8;
    public static final int PROP_DISC = 9;
    public static final int PROP_CATS = 10;
    public static final int PROP_COLOURS = 11;
    public static final int PROP_COL_M = 12;
    public static final int PROP_COL_N = 13;
    public static final int PROP_COL_P = 14;
    public static final int PROP_COL_A = 15;
    public static final int PROP_COL_NULL = 16;
    public static final int PROP_FILTER = 17;
    public static final int PROP_FONT_SIZE = 18;
    public static final int PROP_MIN_CONF = 19;
    public static final int PROP_MAX_CONF = 20;
    public static final int PROP_CONF = 21;
    public static final int PROP_ABR = 22;
    public static final int PROP_EVENTNAME = 23;
    public static final int PROP_TOPS = 24;
    public static final int PROP_BASES = 25;
    public static final int PROP_SINGLES = 26;
    private static final String[] TOOLTIP_TEXT = new String[PROP_NAMES.length];
    private CompositeStandard std;
    private EventFilter cmpStdExclude = EventFilter.INCLUDE_ONLY_CMPSTDEV;
    float columnWidth = 70.0f;
    boolean singleColumn = false;
    boolean showDepths = true;
    boolean showCmpStdAge = false;
    boolean showType = true;
    boolean abrs = false;
    boolean eventNames = !this.abrs;
    boolean showCommentsColumn = false;
    float commentsColumnWidth = 50.0f;
    ChartProperties.FontSize fontSize = ChartProperties.FontSize.TINY;
    private boolean useColours = false;
    private Color col_M = Color.BLACK;
    private Color col_N = Color.BLUE;
    private Color col_P = Color.RED;
    private Color col_A = Color.GREEN;
    private Color col_null = Color.LIGHT_GRAY;
    private Set<Discipline> discs = null;
    private Set<Category> filter_cat = null;
    private boolean filter;
    boolean confidence;
    boolean showTops = true;
    boolean showBases = true;
    boolean showSingles = true;
    int maxUnconfidence = 100;
    int minUnconfidence = 0;

    private PanelEventsProperties(PanelType type) {
        super(type);
    }

    public static PanelEventsProperties createCopy(PanelEventsProperties rhs) {
        PanelEventsProperties p = new PanelEventsProperties(rhs.getPanelType());
        p.copy(rhs);
        return p;
    }

    @Override
    public PanelProperties copy() {
        return PanelEventsProperties.createCopy(this);
    }

    @Override
    public void copy(PanelProperties pp) {
        if (!(pp instanceof PanelEventsProperties)) {
            throw new IllegalArgumentException("PanelEventsProperties cannot copy " + String.valueOf(pp));
        }
        PanelEventsProperties rhs = (PanelEventsProperties)pp;
        block4: for (int i = 0; i < this.getnProps(); ++i) {
            switch (i) {
                case 9: {
                    this.discs = rhs.discs != null ? new HashSet<Discipline>(rhs.discs) : null;
                    continue block4;
                }
                case 10: {
                    if (rhs.filter_cat == null) {
                        this.filter_cat = null;
                        continue block4;
                    }
                    this.filter_cat = rhs.filter_cat.stream().map(cat -> Category.copy((Category)cat)).collect(Collectors.toCollection(HashSet::new));
                    continue block4;
                }
                default: {
                    this.setProperty(i, rhs.getProperty(i));
                }
            }
        }
    }

    @Override
    public String getPrefs() {
        Object string = new String();
        String[] props = new String[]{"" + this.columnWidth, "" + (this.singleColumn ? 1 : 0), "" + (this.showDepths ? 1 : 0), this.col_A.getRed() + "," + this.col_A.getGreen() + "," + this.col_A.getBlue(), this.col_M.getRed() + "," + this.col_M.getGreen() + "," + this.col_M.getBlue(), this.col_N.getRed() + "," + this.col_N.getGreen() + "," + this.col_N.getBlue(), this.col_P.getRed() + "," + this.col_P.getGreen() + "," + this.col_P.getBlue(), this.col_null.getRed() + "," + this.col_null.getGreen() + "," + this.col_null.getBlue(), "" + (this.useColours ? 1 : 0), "" + (this.showType ? 1 : 0)};
        for (String prop : props) {
            string = (String)string + prop + "|";
        }
        return string;
    }

    @Override
    public String getToolTipText(int nProp) {
        if (nProp >= TOOLTIP_TEXT.length) {
            return null;
        }
        return TOOLTIP_TEXT[nProp];
    }

    public PanelEventsProperties(String props, SBdb sbdb, CompositeStandard std, PanelType panelType) throws SQLException {
        super(panelType);
        this.std = std;
        if (std != null) {
            std.loadEvents();
        }
        if (props == null) {
            return;
        }
        String[] s = props.split("\\|");
        try {
            block32: for (int i = 0; i < s.length; ++i) {
                switch (i) {
                    case 0: {
                        this.columnWidth = Float.parseFloat(s[i]);
                        continue block32;
                    }
                    case 1: {
                        this.singleColumn = Integer.parseInt(s[i]) == 1;
                        continue block32;
                    }
                    case 2: {
                        this.showDepths = Integer.parseInt(s[i]) == 1;
                        continue block32;
                    }
                    case 3: {
                        this.col_A = ColourUtils.getColour((String)s[i]);
                        continue block32;
                    }
                    case 4: {
                        this.col_M = ColourUtils.getColour((String)s[i]);
                        continue block32;
                    }
                    case 5: {
                        this.col_N = ColourUtils.getColour((String)s[i]);
                        continue block32;
                    }
                    case 6: {
                        this.col_P = ColourUtils.getColour((String)s[i]);
                        continue block32;
                    }
                    case 7: {
                        this.col_null = ColourUtils.getColour((String)s[i]);
                        continue block32;
                    }
                    case 8: {
                        this.useColours = Integer.parseInt(s[i]) == 1;
                        continue block32;
                    }
                    case 9: {
                        this.showType = Integer.parseInt(s[i]) == 1;
                        continue block32;
                    }
                    case 10: {
                        if (s[i].isEmpty()) continue block32;
                        String[] t = s[i].split(",");
                        this.discs = new HashSet<Discipline>();
                        for (String t1 : t) {
                            this.discs.add(Discipline.getDisc((String)t1));
                        }
                        continue block32;
                    }
                    case 11: {
                        if (s[i].isEmpty()) continue block32;
                        this.filter = Integer.parseInt(s[i]) == 1;
                        continue block32;
                    }
                    case 12: {
                        if (s[i].isEmpty()) continue block32;
                        try {
                            this.fontSize = ChartProperties.FontSize.valueOf(s[i]);
                        }
                        catch (IllegalArgumentException e) {
                            System.out.println("Exception parsing: " + s[i] + " : " + e.toString());
                        }
                        continue block32;
                    }
                    case 13: {
                        this.confidence = Integer.parseInt(s[i]) == 1;
                        continue block32;
                    }
                    case 14: {
                        this.maxUnconfidence = Integer.parseInt(s[i]);
                        continue block32;
                    }
                    case 15: {
                        this.abrs = Integer.parseInt(s[i]) == 1;
                        this.eventNames = !this.abrs;
                        continue block32;
                    }
                    case 16: {
                        this.minUnconfidence = Integer.parseInt(s[i]);
                        continue block32;
                    }
                    case 17: {
                        this.cmpStdExclude = EventFilter.valueOf(Integer.parseInt(s[i]));
                        continue block32;
                    }
                    case 18: {
                        this.eventNames = Integer.parseInt(s[i]) == 1;
                        continue block32;
                    }
                    case 19: {
                        this.showCmpStdAge = Integer.parseInt(s[i]) == 1;
                        continue block32;
                    }
                    case 20: {
                        if (s[i].isEmpty()) continue block32;
                        String[] catString = s[i].split(",");
                        this.filter_cat = new HashSet<Category>();
                        for (int j = 0; j < catString.length; ++j) {
                            String mnemonic = catString[j];
                            Category cat = sbdb.getCategoryService().findCategory(mnemonic).orElse(null);
                            if (cat == null && !sbdb.isConnected()) {
                                cat = sbdb.getCategoryService().addCategory(mnemonic, Discipline.MICRO, mnemonic, Color.BLACK);
                            }
                            if (cat == null) continue;
                            this.filter_cat.add(cat);
                        }
                        continue block32;
                    }
                    case 21: {
                        this.showTops = Integer.parseInt(s[i]) == 1;
                        continue block32;
                    }
                    case 22: {
                        this.showBases = Integer.parseInt(s[i]) == 1;
                        continue block32;
                    }
                    case 23: {
                        this.showSingles = Integer.parseInt(s[i]) == 1;
                        continue block32;
                    }
                    case 24: {
                        this.showCommentsColumn = Integer.parseInt(s[i]) == 1;
                        continue block32;
                    }
                    case 25: {
                        this.commentsColumnWidth = Float.parseFloat(s[i]);
                    }
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public Color getColor(Discipline discID) {
        if (discID == null) {
            return this.col_null;
        }
        switch (discID) {
            case MICRO: {
                return this.col_M;
            }
            case NANNO: {
                return this.col_N;
            }
            case PALY: {
                return this.col_P;
            }
            case MACRO: {
                return this.col_A;
            }
        }
        assert (false);
        return this.col_null;
    }

    public boolean plotEventDisc(Discipline discID) {
        return this.discs == null || this.discs.contains(discID);
    }

    public boolean plotEventCategory(String mnem) {
        if (this.filter_cat == null || this.filter_cat.isEmpty()) {
            return true;
        }
        if (mnem == null || mnem.isEmpty()) {
            return false;
        }
        return this.filter_cat.stream().map(Category::getMnemonic).anyMatch(m -> mnem.toUpperCase().startsWith((String)m));
    }

    public boolean plotEventType(char eventType) {
        switch (eventType) {
            case 'F': {
                return this.showTops;
            }
            case 'L': {
                return this.showBases;
            }
        }
        return this.showSingles;
    }

    @Override
    public int getnProps() {
        return PROP_NAMES.length;
    }

    @Override
    public boolean showRow(int row) {
        switch (row) {
            case 17: {
                return this.getPanelType() == PanelType.CMPSTD;
            }
            case 7: {
                return this.getPanelType() == PanelType.EVENT;
            }
            case 1: {
                return this.getPanelType() == PanelType.EVENT && this.std != null;
            }
            case 4: {
                return this.showCommentsColumn;
            }
        }
        return true;
    }

    @Override
    public boolean hasShowRowDependencies(int row) {
        switch (row) {
            case 0: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getPropertyName(int nProp) {
        if (nProp == 6) {
            switch (this.getPanelType()) {
                case CMPSTD: {
                    return "Show ages";
                }
            }
        }
        return PROP_NAMES[nProp];
    }

    @Override
    public Object getProperty(int nProp) {
        switch (nProp) {
            case 0: {
                return this.std;
            }
            case 1: {
                return this.cmpStdExclude;
            }
            case 2: {
                return (int)this.columnWidth;
            }
            case 3: {
                return this.showCommentsColumn;
            }
            case 4: {
                return (int)this.commentsColumnWidth;
            }
            case 5: {
                return this.singleColumn;
            }
            case 6: {
                return this.showDepths;
            }
            case 7: {
                return this.showCmpStdAge;
            }
            case 8: {
                return this.showType;
            }
            case 9: {
                return this.discs;
            }
            case 10: {
                return this.filter_cat;
            }
            case 11: {
                return this.useColours;
            }
            case 12: {
                return this.col_M;
            }
            case 13: {
                return this.col_N;
            }
            case 14: {
                return this.col_P;
            }
            case 15: {
                return this.col_A;
            }
            case 16: {
                return this.col_null;
            }
            case 17: {
                return this.filter;
            }
            case 18: {
                return this.fontSize;
            }
            case 21: {
                return this.confidence;
            }
            case 19: {
                return Confidence.getMaxUnconfidence((int)this.maxUnconfidence);
            }
            case 20: {
                return Confidence.getConfidence((int)this.minUnconfidence);
            }
            case 22: {
                return this.abrs;
            }
            case 23: {
                return this.eventNames;
            }
            case 24: {
                return this.showTops;
            }
            case 25: {
                return this.showBases;
            }
            case 26: {
                return this.showSingles;
            }
        }
        assert (false);
        return null;
    }

    @Override
    public Class<?> getPropertyClass(int nProp) {
        switch (nProp) {
            case 0: {
                return CompositeStandard.class;
            }
            case 2: 
            case 4: {
                return Integer.class;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                return Boolean.class;
            }
            case 9: {
                return Discipline[].class;
            }
            case 10: {
                return Category.class;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                return Color.class;
            }
            case 18: {
                return ChartProperties.FontSize.class;
            }
            case 19: 
            case 20: {
                return Confidence.class;
            }
            case 1: {
                return EventFilter.class;
            }
        }
        assert (false);
        return null;
    }

    @Override
    public boolean setProperty(int nProp, Object prop) {
        if (this.getProperty(nProp) == null ^ prop == null || this.getProperty(nProp) != null && !this.getProperty(nProp).equals(prop)) {
            switch (nProp) {
                case 0: {
                    this.std = (CompositeStandard)prop;
                    break;
                }
                case 1: {
                    this.cmpStdExclude = (EventFilter)((Object)prop);
                    break;
                }
                case 2: {
                    this.columnWidth = Integer.parseInt(prop.toString());
                    break;
                }
                case 3: {
                    this.showCommentsColumn = (Boolean)prop;
                    break;
                }
                case 4: {
                    this.commentsColumnWidth = Integer.parseInt(prop.toString());
                    break;
                }
                case 5: {
                    this.singleColumn = (Boolean)prop;
                    break;
                }
                case 6: {
                    this.showDepths = (Boolean)prop;
                    break;
                }
                case 7: {
                    this.showCmpStdAge = (Boolean)prop;
                    break;
                }
                case 8: {
                    this.showType = (Boolean)prop;
                    break;
                }
                case 11: {
                    this.useColours = (Boolean)prop;
                    break;
                }
                case 9: {
                    if (prop instanceof Set) {
                        Set set = (Set)prop;
                        if (set.isEmpty() || set.size() == Discipline.values().length + 1) {
                            this.discs = null;
                            break;
                        }
                        this.discs = new HashSet<Discipline>();
                        for (Object o : set) {
                            if (!(o instanceof Discipline)) {
                                o = null;
                            }
                            this.discs.add((Discipline)o);
                        }
                        break;
                    }
                    this.discs = null;
                    break;
                }
                case 10: {
                    this.filter_cat = prop != null ? (Set)prop : null;
                    break;
                }
                case 12: {
                    this.col_M = (Color)prop;
                    break;
                }
                case 13: {
                    this.col_N = (Color)prop;
                    break;
                }
                case 14: {
                    this.col_P = (Color)prop;
                    break;
                }
                case 15: {
                    this.col_A = (Color)prop;
                    break;
                }
                case 16: {
                    this.col_null = (Color)prop;
                    break;
                }
                case 17: {
                    this.filter = (Boolean)prop;
                    break;
                }
                case 18: {
                    this.fontSize = (ChartProperties.FontSize)((Object)prop);
                    break;
                }
                case 21: {
                    this.confidence = (Boolean)prop;
                    break;
                }
                case 19: {
                    this.maxUnconfidence = ((Confidence)prop).getDBint();
                    break;
                }
                case 20: {
                    this.minUnconfidence = ((Confidence)prop).getDBint();
                    break;
                }
                case 22: {
                    this.abrs = (Boolean)prop;
                    if (this.abrs) break;
                    this.eventNames = true;
                    break;
                }
                case 23: {
                    this.eventNames = (Boolean)prop;
                    if (this.abrs) break;
                    this.eventNames = true;
                    break;
                }
                case 24: {
                    this.showTops = (Boolean)prop;
                    break;
                }
                case 25: {
                    this.showBases = (Boolean)prop;
                    break;
                }
                case 26: {
                    this.showSingles = (Boolean)prop;
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public String getPropertiesString() {
        Object string = this.getPrefs();
        String[] props = new String[16];
        Object discString = "";
        if (this.discs != null) {
            for (Discipline d : this.discs) {
                if (!((String)discString).isEmpty()) {
                    discString = (String)discString + ",";
                }
                if (d != null) {
                    discString = (String)discString + d.getChar();
                    continue;
                }
                discString = (String)discString + "null";
            }
        }
        props[0] = (String)discString;
        props[1] = "" + (this.filter ? 1 : 0);
        props[2] = this.fontSize.name();
        props[3] = "" + (this.confidence ? 1 : 0);
        props[4] = "" + this.maxUnconfidence;
        props[5] = "" + (this.abrs ? 1 : 0);
        props[6] = "" + this.minUnconfidence;
        props[7] = "" + this.cmpStdExclude.getIntProperty();
        props[8] = "" + (this.eventNames ? 1 : 0);
        props[9] = "" + (this.showCmpStdAge ? 1 : 0);
        Object catString = "";
        if (this.filter_cat != null) {
            catString = (String)catString + this.filter_cat.stream().map(Category::getMnemonic).collect(Collectors.joining(","));
        }
        props[10] = catString;
        props[11] = "" + (this.showTops ? 1 : 0);
        props[12] = "" + (this.showBases ? 1 : 0);
        props[13] = "" + (this.showSingles ? 1 : 0);
        props[14] = "" + (this.showCommentsColumn ? 1 : 0);
        props[15] = "" + this.commentsColumnWidth;
        for (String prop : props) {
            string = (String)string + prop + "|";
        }
        return string;
    }

    @Override
    public boolean allowNull(int nProp) {
        switch (nProp) {
            case 0: {
                if (this.getPanelType() == PanelType.EVENT) {
                    return true;
                }
            }
            case 9: {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + (this.std != null ? this.std.hashCode() : 0);
        hash = 29 * hash + Float.floatToIntBits(this.columnWidth);
        hash = 29 * hash + (this.singleColumn ? 1 : 0);
        hash = 29 * hash + (this.showDepths ? 1 : 0);
        hash = 29 * hash + (this.showType ? 1 : 0);
        hash = 29 * hash + (this.useColours ? 1 : 0);
        hash = 29 * hash + (this.col_M != null ? this.col_M.hashCode() : 0);
        hash = 29 * hash + (this.col_N != null ? this.col_N.hashCode() : 0);
        hash = 29 * hash + (this.col_P != null ? this.col_P.hashCode() : 0);
        hash = 29 * hash + (this.col_A != null ? this.col_A.hashCode() : 0);
        hash = 29 * hash + (this.col_null != null ? this.col_null.hashCode() : 0);
        hash = 29 * hash + (this.discs != null ? this.discs.hashCode() : 0);
        hash = 29 * hash + (this.filter ? 1 : 0);
        hash = 29 * hash + (this.confidence ? 1 : 0);
        hash = 29 * hash + (this.abrs ? 1 : 0);
        hash = 29 * hash + this.maxUnconfidence;
        hash = 29 * hash + this.minUnconfidence;
        hash = 29 * hash + this.fontSize.hashCode();
        hash = 29 * hash + this.cmpStdExclude.getIntProperty();
        hash = 29 * hash + (this.eventNames ? 1 : 0);
        hash = 29 * hash + (this.showCmpStdAge ? 1 : 0);
        hash = 29 * hash + (this.filter_cat != null ? this.filter_cat.hashCode() : 0);
        hash = 29 * hash + (this.showTops ? 1 : 0);
        hash = 29 * hash + (this.showBases ? 1 : 0);
        hash = 29 * hash + (this.showSingles ? 1 : 0);
        hash = 29 * hash + (this.showCommentsColumn ? 1 : 0);
        hash = 29 * hash + Float.floatToIntBits(this.commentsColumnWidth);
        return hash;
    }

    @Override
    public boolean isSimilarTo(PanelProperties comp) {
        if (!(comp instanceof PanelEventsProperties)) {
            return false;
        }
        if (this.equals(comp)) {
            return true;
        }
        PanelEventsProperties rhs = (PanelEventsProperties)comp;
        block4: for (int i = 0; i < this.getnProps(); ++i) {
            Object iProp1 = this.getProperty(i);
            Object iProp2 = rhs.getProperty(i);
            switch (i) {
                case 2: {
                    if (!(Math.abs(this.columnWidth - rhs.columnWidth) > 3.0f)) continue block4;
                    return false;
                }
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    continue block4;
                }
                default: {
                    if (Objects.equals(iProp1, iProp2)) continue block4;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean singleColumn() {
        return this.singleColumn;
    }

    public boolean showType() {
        return this.showType;
    }

    public boolean showDepths() {
        return this.showDepths;
    }

    public boolean showCmpStdAge() {
        return this.showCmpStdAge;
    }

    public float panelWidth() {
        return this.columnWidth + (this.showCommentsColumn ? this.commentsColumnWidth : 0.0f);
    }

    public boolean useColours() {
        return this.useColours;
    }

    public boolean filter() {
        return this.filter;
    }

    public boolean showTops() {
        return this.showTops;
    }

    public boolean showBases() {
        return this.showBases;
    }

    public boolean showSingles() {
        return this.showSingles;
    }

    public CompositeStandard getCmpStd() {
        return this.std;
    }

    public EventFilter cmpStdExclude() {
        return this.cmpStdExclude;
    }

    @Override
    public int getCmpStdID() {
        if (this.std != null) {
            return this.std.getStdID();
        }
        return super.getCmpStdID();
    }

    static {
        PanelEventsProperties.TOOLTIP_TEXT[3] = "Check this box to show a separate column containing event comments";
        PanelEventsProperties.TOOLTIP_TEXT[23] = "Check this box to concatenate the abbr. and the event name if abbr. is selected.";
        PanelEventsProperties.TOOLTIP_TEXT[7] = "Show age of event in composite standard. Must have composite std selected";
        PanelEventsProperties.TOOLTIP_TEXT[10] = "Select categories of taxa to include in the panel. If selected, ONLY events linked to taxa can be plotted.";
    }

    public static enum EventFilter {
        INCLUDE_ALL("Include all events", 2),
        INCLUDE_ONLY_CMPSTDEV("Only events in Composite", 0),
        EXCLUDE_CMPSTDEV("Only events NOT in Composite", 1);

        int intProperty;
        String filterText;

        private EventFilter(String filterText, int intProperty) {
            this.filterText = filterText;
            this.intProperty = intProperty;
        }

        public String toString() {
            return this.filterText;
        }

        public static EventFilter valueOf(int intProperty) {
            switch (intProperty) {
                default: {
                    return INCLUDE_ONLY_CMPSTDEV;
                }
                case 1: {
                    return EXCLUDE_CMPSTDEV;
                }
                case 2: 
            }
            return INCLUDE_ALL;
        }

        public int getIntProperty() {
            return this.intProperty;
        }
    }
}

