/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import java.awt.Color;
import java.sql.SQLException;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import javax.swing.undo.AbstractUndoableEdit;
import jsbchart.block.BlockProperties;
import jsbchart.block.ChartBlock;
import jsbchart.block.CorrelationPoint;
import jsbchart.block.WellBlock;
import jsbchart.core.Chart;
import jsbchart.core.ChartProperties;
import jsbchart.core.LithologyPattern;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.correlation.CorrelationType;
import jsbchart.graphics.SBGraphics;
import jsbchart.panel.PanelIntLithProperties;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelType;
import jsbchart.panel.SBPanel;
import model3.GrainSizeDepth;
import model3.GrainSizeList;
import model3.LithBase;
import model3.LithInterval;
import model3.LithQualifier;
import model3.Lithdesc;
import model3.Lithology;
import model3.SBdb;
import model3.Well;
import model3.WsWell;
import util.SB;
import util.SBException;
import util.SbugsCompoundEdit;

public class PanelIntLith
extends SBPanel
implements Observer {
    private final WellBlock block;
    private PanelIntLithProperties p;
    private LinkedList<LithBase> list;
    private GrainSizeList gsl;
    static int nDunham = 6;
    static int nWentworth = 9;
    static float[] wentValue = new float[]{0.0039f, 0.0625f, 0.125f, 0.25f, 0.5f, 1.0f, 2.0f, 4.0f, 64.0f};
    static String[] wentText = new String[]{"Clay", "Silt", "VF snd", "F snd", "M snd.", "C snd.", "VC snd.", "Gran.", "Peb.", "Cobb."};
    static float[] dunhamValue = new float[]{0.025f, 0.2f, 0.8f, 3.2f, 10.0f, 32.0f};
    static String[] dunhamText = new String[]{"Mdstn.", "Wckstn.", "Pckstn.", "Pckstn. (lean)", "Grnstn.", "Ftlstn.", "Rdstn."};
    private static float MM_FILTER_SPAN = 0.8f;
    private static LinkedList<LithBase> TEMPLATE_LITH;
    private static GrainSizeList TEMPLATE_GSL;

    public PanelIntLith(PanelTemplate template, WellBlock block, PanelOcc occ) {
        super(template, occ != null ? occ : new PanelOcc(template.getID()));
        assert (template.getType() == PanelType.INTLITH);
        this.block = block;
        this.p = (PanelIntLithProperties)template.getProperties();
        this.init();
    }

    private void init() {
        if (this.block.getWell() != null) {
            this.block.getWell().addWeakObserver((Observer)this);
        }
    }

    @Override
    public WellBlock getBlock() {
        return this.block;
    }

    private void initLithology() {
        try {
            this.list = new LinkedList();
            if (this.block.getWell() != null) {
                this.list.addAll(this.block.getWell().getLithIntervals());
                this.block.getWell().getGrainSize().load(this.getDb(), this.block.getWell().getWellID());
                this.gsl = new GrainSizeList(this.block.getWell().getGrainSize());
            } else {
                if (TEMPLATE_LITH == null) {
                    TEMPLATE_LITH = new LinkedList<LithBase>();
                    TEMPLATE_GSL = new GrainSizeList();
                    PanelIntLith.initTemplateLithology(this.getDb(), TEMPLATE_LITH, TEMPLATE_GSL);
                }
                this.list = TEMPLATE_LITH;
                this.gsl = TEMPLATE_GSL;
            }
        }
        catch (SQLException | SBException sql) {
            sql.printStackTrace();
        }
    }

    public static LinkedList<LithBase> scaleLithologyIntervals(SBdb db, LinkedList<LithBase> lithList, float chartScale) {
        LinkedList<LithBase> scaledList = new LinkedList<LithBase>();
        LithInterval lastInterval = null;
        HashMap<Lithology, Double> intervalMap = new HashMap<Lithology, Double>();
        for (LithBase base : lithList) {
            if (base instanceof LithInterval) {
                LithInterval interval = (LithInterval)base;
                if (lastInterval != null) {
                    if (lastInterval.getLithology().equals((Object)interval.getLithology()) || interval.getBaseDepth() - interval.getTopDepth() < (double)(chartScale * MM_FILTER_SPAN / 1000.0f)) {
                        lastInterval = new LithInterval(db, lastInterval.getTopDepth(), interval.getBaseDepth(), lastInterval.getLithology());
                        Double intervalOfLith = (Double)intervalMap.get(interval.getLithology());
                        if (intervalOfLith == null) {
                            intervalMap.put(interval.getLithology(), interval.getBaseDepth() - interval.getTopDepth());
                            continue;
                        }
                        intervalOfLith = intervalOfLith + (interval.getBaseDepth() - interval.getTopDepth());
                        intervalMap.replace(interval.getLithology(), intervalOfLith);
                        continue;
                    }
                    if (!intervalMap.isEmpty()) {
                        Lithology popular = null;
                        double largestDepth = 0.0;
                        for (Lithology lith : intervalMap.keySet()) {
                            if (!((Double)intervalMap.get(lith) > largestDepth)) continue;
                            popular = lith;
                            largestDepth = (Double)intervalMap.get(lith);
                        }
                        if (!lastInterval.getLithology().equals(popular)) {
                            lastInterval = new LithInterval(db, lastInterval.getTopDepth(), interval.getBaseDepth(), popular);
                        }
                    }
                    scaledList.add((LithBase)lastInterval);
                    lastInterval = interval;
                    intervalMap.clear();
                    continue;
                }
                lastInterval = interval;
                continue;
            }
            scaledList.add(base);
        }
        if (lastInterval != null) {
            scaledList.add((LithBase)lastInterval);
        }
        return scaledList;
    }

    static void initTemplateLithology(SBdb sbdb, List<LithBase> list, GrainSizeList gsl) throws SBException, SQLException {
        list.add((LithBase)new LithInterval(sbdb, 10.0, 30.0, sbdb.getLithdesc().getLithology(1064)));
        list.add((LithBase)new LithInterval(sbdb, 30.0, 60.0, sbdb.getLithdesc().getLithology(1000)));
        LithQualifier q = new LithQualifier(null);
        q.setTopDepth(20.0);
        q.setLithology(sbdb.getLithdesc().getLithology(3034));
        q.setAlignment('C');
        q.setXpos(30.0f);
        list.add((LithBase)q);
        q = new LithQualifier(null);
        q.setTopDepth(40.0);
        q.setLithology(sbdb.getLithdesc().getLithology(3037));
        q.setAlignment('C');
        q.setXpos(70.0f);
        list.add((LithBase)q);
        q = new LithQualifier(null);
        q.setTopDepth(20.0);
        q.setLithology(sbdb.getLithdesc().getLithology(4010));
        q.setAlignment('L');
        list.add((LithBase)q);
        if (gsl != null) {
            gsl.add(new GrainSizeDepth(10.0, 0.2f));
            gsl.add(new GrainSizeDepth(12.0, 0.25f));
            gsl.add(new GrainSizeDepth(14.0, 0.7f));
            gsl.add(new GrainSizeDepth(16.0, 0.2f));
            gsl.add(new GrainSizeDepth(18.0, 0.1f));
            gsl.add(new GrainSizeDepth(20.0, 0.3f));
            gsl.add(new GrainSizeDepth(22.0, 0.25f));
            gsl.add(new GrainSizeDepth(24.0, 0.5f));
            gsl.add(new GrainSizeDepth(26.0, 0.7f));
            gsl.add(new GrainSizeDepth(28.0, 0.8f));
            gsl.add(new GrainSizeDepth(30.0, 0.7f));
            gsl.add(new GrainSizeDepth(32.0, 0.002f));
            gsl.add(new GrainSizeDepth(34.0, 0.003f));
            gsl.add(new GrainSizeDepth(36.0, 0.0025f));
            gsl.add(new GrainSizeDepth(38.0, 0.002f));
            gsl.add(new GrainSizeDepth(40.0, 0.001f));
            gsl.add(new GrainSizeDepth(42.0, 0.003f));
            gsl.add(new GrainSizeDepth(44.0, 0.0025f));
            gsl.add(new GrainSizeDepth(46.0, 0.001f));
            gsl.add(new GrainSizeDepth(48.0, 0.002f));
            gsl.add(new GrainSizeDepth(50.0, 0.01f));
            gsl.add(new GrainSizeDepth(52.0, 0.002f));
            gsl.add(new GrainSizeDepth(54.0, 0.001f));
            gsl.add(new GrainSizeDepth(56.0, 0.0025f));
            gsl.add(new GrainSizeDepth(58.0, 0.0035f));
            gsl.add(new GrainSizeDepth(60.0, 0.0025f));
        }
    }

    @Override
    public PanelIntLithProperties getProperties() {
        return this.p;
    }

    @Override
    public void setProperties(PanelProperties prop) {
        if (!(prop instanceof PanelIntLithProperties)) {
            throw new IllegalArgumentException("Attempt to set panel interpreted lithology properties to " + String.valueOf(prop));
        }
        this.p = (PanelIntLithProperties)prop;
    }

    @Override
    public void drawBackground(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) {
        float baseDepth;
        float topDepth;
        boolean firstOrOnly;
        boolean bl = firstOrOnly = bp == this.block.getProp() || (double)Math.abs(bp.getMin() - this.block.getTopDepth()) < 0.01;
        if (!g.isVisible(x, (firstOrOnly ? 0.0f : this.block.scaleDepth(bp.getNormal() ? bp.getMin() : bp.getMax())) + y + this.getPanelHeaderHeight(cp, mode), this.getWidth(bp), bp.getHeight())) {
            if (cp.key != null && cp.keyIsVisible()) {
                this.initLithology();
                for (LithBase base : this.list) {
                    cp.getKeyData().putLithology(base);
                }
            }
            return;
        }
        this.drawSeaBed(g, cp, bp, this.block, this.block.getScaleConverter(), x, y + this.getPanelHeaderHeight(cp, mode));
        g.setStroke(0.2f);
        this.initLithology();
        if (this.p.grainSizeColumn.show()) {
            this.drawGrainSizeHeader(g, x, y, cp, mode, this.p.width, this.p.grainSizeColumn.width());
        }
        if (bp == this.block.getProp()) {
            topDepth = this.block.getTopDepth();
            baseDepth = this.block.getBaseDepth();
        } else {
            topDepth = bp.getMin();
            baseDepth = bp.getMax();
        }
        if (this.p.scaleIntervals) {
            this.list = PanelIntLith.scaleLithologyIntervals(this.getDb(), this.list, bp.getScale());
        }
        PanelIntLith.drawLithology(g, x, y, cp, bp, mode, this.list, this.p.width, this.p.grainSizeColumn.width(), this.block, this.p.drawQualifiers, this.p.grainSizeColumn.show() ? this.gsl : null, topDepth, baseDepth, this.block);
    }

    @Override
    public float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode, EnumMap<CorrelationType, HashSet<CorrelationPoint>> cLines) {
        return x + this.getWidth(bp);
    }

    @Override
    protected String getCaption() {
        if (this.getPanelOcc() != null && this.getPanelOcc().getCaption() != null) {
            return this.getPanelOcc().getCaption();
        }
        return "Lithology";
    }

    @Override
    protected String getSubCaption() {
        String lithTitle = null;
        if (this.p.grainSizeColumn.show()) {
            lithTitle = "and Grain Size";
        }
        return lithTitle;
    }

    private void drawGrainSizeHeader(SBGraphics g, float x, float y, ChartProperties cp, Chart.Mode mode, float panelWidth, float gsWidth) {
        float yTop = y + this.getPanelHeaderHeight(cp, mode);
        float yBase = yTop + this.block.scaleDepth(this.block.getBaseDepth());
        float tickHeight = 5.0f;
        g.setFont("Ariel", 0, gsWidth < 36.0f ? cp.getFontSizeSmall() : cp.getFontSize());
        g.setStroke(0.2f);
        g.drawLine(x + panelWidth, yTop, x + panelWidth, yTop - tickHeight);
        g.setColor(cp.foreground);
        g.drawStringVertical(this.p.dunham ? dunhamText[0] : wentText[0], x + panelWidth + g.stringHeightSB() / 2.0f, yTop - tickHeight - 0.5f);
        g.setColor(Color.LIGHT_GRAY);
        g.drawLine(x + panelWidth, yTop, x + panelWidth, yBase);
        for (int i = 0; i < (this.p.dunham ? dunhamValue.length : wentValue.length); ++i) {
            float xpos = x + panelWidth + (float)((Math.log10(this.p.dunham ? (double)dunhamValue[i] : (double)wentValue[i]) + 3.0) * (double)gsWidth / 5.0);
            g.setColor(Color.LIGHT_GRAY);
            g.drawLine(xpos, yTop, xpos, yBase);
            g.setColor(cp.foreground);
            g.drawLine(xpos, yTop, xpos, yTop - tickHeight);
            g.drawStringVertical(this.p.dunham ? dunhamText[i + 1] : wentText[i + 1], xpos + g.stringHeightSB() / 2.0f, yTop - tickHeight - 0.5f);
        }
    }

    static void drawLithology(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode, List<LithBase> lithList, float columnWidth, float gsWidth, WellBlock wellBlock, boolean qualifiers, GrainSizeList gsl, float topDepth, float baseDepth, ChartBlock block) {
        float yTop;
        float colTop = y + PanelIntLith.getPanelHeaderHeight(cp, mode, block);
        for (LithBase base : lithList) {
            if (!(base instanceof LithInterval)) continue;
            LithInterval interval = (LithInterval)base;
            if (interval.getTopDepth() > (double)baseDepth) break;
            yTop = colTop + wellBlock.scaleDepth((float)interval.getTopDepth());
            if (interval.getTopDepth() < (double)topDepth) {
                if (interval.getBaseDepth() < (double)topDepth) continue;
                yTop = colTop + wellBlock.scaleDepth(topDepth);
            }
            float yBase = colTop + wellBlock.scaleDepth((float)interval.getBaseDepth());
            if (interval.getBaseDepth() > (double)baseDepth) {
                yBase = colTop + wellBlock.scaleDepth(baseDepth);
            }
            if (yTop > yBase) {
                float temp = yTop;
                yTop = yBase;
                yBase = temp;
            }
            float[] xPoints = new float[]{x, x + columnWidth, x + columnWidth, x};
            float[] yPoints = new float[]{yTop, yTop, yBase, yBase};
            if (cp.key != null) {
                cp.getKeyData().putLithology(base);
            }
            if (gsl != null) {
                LinkedList<GrainSizeDepth> newDepths = new LinkedList<GrainSizeDepth>();
                for (GrainSizeDepth gsd : gsl) {
                    if (Math.abs(interval.getTopDepth() - gsd.getDepth()) < 0.001 || Math.abs(interval.getBaseDepth() - gsd.getDepth()) < 0.001 || gsd.getDepth() > interval.getTopDepth() && gsd.getDepth() < interval.getBaseDepth()) {
                        newDepths.add(gsd);
                    }
                    if (!(gsd.getDepth() > interval.getBaseDepth())) continue;
                    break;
                }
                if (newDepths.size() > 1) {
                    float[] xPs = new float[newDepths.size() + 2];
                    float[] yPs = new float[newDepths.size() + 2];
                    xPs[0] = xPoints[1];
                    yPs[0] = yPoints[1];
                    for (int i = 1; i < newDepths.size() + 1; ++i) {
                        xPs[i] = x + columnWidth + (float)((Math.log10(((GrainSizeDepth)newDepths.get(i - 1)).getGrainSize()) + 3.0) * (double)gsWidth / 5.0);
                        if (xPs[i] < 0.0f) {
                            xPs[i] = xPs[0];
                        }
                        yPs[i] = y + PanelIntLith.getPanelHeaderHeight(cp, mode, block) + wellBlock.scaleDepth((float)((GrainSizeDepth)newDepths.get(i - 1)).getDepth());
                    }
                    xPs[newDepths.size() + 1] = xPoints[2];
                    yPs[newDepths.size() + 1] = yPoints[2];
                    g.setColor(interval.getLithology().getBackColour());
                    g.fillPolygon(xPs, yPs, xPs.length);
                    LithologyPattern.draw(interval.getLithology(), g, xPoints, yPoints, 4, false, null, false);
                    g.setColor(cp.foreground);
                    g.setStroke(0.1f);
                    g.drawLine(xPoints[0], yPoints[0], xPoints[1], yPoints[1]);
                    g.drawPolyline(xPs, yPs, xPs.length, true);
                    g.drawLine(xPoints[2], yPoints[2], xPoints[3], yPoints[3]);
                    continue;
                }
                LithologyPattern.draw(interval.getLithology(), g, xPoints, yPoints, 4, false, cp.foreground, false);
                continue;
            }
            if (!g.isVisible(xPoints[0], yPoints[0], xPoints[1] - xPoints[0], yPoints[2] - yPoints[1])) continue;
            LithologyPattern.draw(interval.getLithology(), g, xPoints, yPoints, 4, false, cp.foreground, false);
        }
        if (qualifiers) {
            char[] qualifierOrder;
            for (char plotQual : qualifierOrder = new char[]{'S', 'A', 'Q'}) {
                for (LithBase base : lithList) {
                    LithQualifier qual;
                    if (!(base instanceof LithQualifier) || (qual = (LithQualifier)base).getType() != plotQual || qual.getTopDepth() < (double)wellBlock.getTopDepth() || qual.getTopDepth() > (double)wellBlock.getBaseDepth()) continue;
                    if (cp.key != null) {
                        cp.getKeyData().putLithology(base);
                    }
                    yTop = colTop + wellBlock.scaleDepth((float)qual.getTopDepth());
                    float xPos = 0.0f;
                    char type = qual.getType();
                    switch (type) {
                        case 'A': 
                        case 'Q': {
                            xPos = x + qual.getXpos() / 100.0f * columnWidth;
                            if (Math.abs(xPos - x) < qual.getLithology().getWidth()) {
                                xPos = x + qual.getLithology().getWidth() / 2.0f;
                            } else if (x + columnWidth - xPos < qual.getLithology().getWidth()) {
                                xPos = x + columnWidth - qual.getLithology().getWidth() / 2.0f;
                            }
                            LithologyPattern.draw(qual.getLithology(), g, xPos, yTop, false, false, false);
                            break;
                        }
                        case 'S': {
                            int alignment = qual.getAlignment();
                            float width = qual.getXpos();
                            if (width > 100.0f) {
                                width = 100.0f;
                                alignment = 76;
                            }
                            switch (alignment) {
                                case 76: {
                                    xPos = x;
                                    break;
                                }
                                case 82: {
                                    xPos = x + columnWidth - width / 100.0f * columnWidth;
                                    break;
                                }
                                case 67: {
                                    xPos = x + columnWidth / 2.0f - width / 200.0f * columnWidth;
                                    break;
                                }
                            }
                            width = width / 100.0f * columnWidth;
                            LithologyPattern.drawStringer(qual.getLithology(), g, xPos, yTop, width, false, false, false);
                            break;
                        }
                    }
                }
            }
        }
    }

    @Override
    public float getWidth(BlockProperties bp) {
        return this.p.width + this.p.grainSizeColumn.width();
    }

    @Override
    public Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        float depth = this.block.getDepth(y, bp);
        float bracket = this.block.getBracket(1.25f, zoom, depth);
        float width_bracket = 4.0f;
        try {
            LithBase base2;
            Iterator iterator = this.block.getWell().getLithIntervals().iterator();
            while (iterator.hasNext() && !((base2 = (LithBase)iterator.next()).getTopDepth() > (double)(depth + bracket))) {
                LithQualifier qual;
                if (!(base2 instanceof LithQualifier) || !(Math.abs((qual = (LithQualifier)base2).getTopDepth() - (double)depth) < (double)bracket)) continue;
                float xpos = x / this.getWidth(bp) * 100.0f;
                switch (Lithdesc.getLithType((char)qual.getType())) {
                    case ACCESSORY: 
                    case QUALIFIER: {
                        if (!(Math.abs(qual.getXpos() - xpos) < width_bracket)) break;
                        return qual;
                    }
                    case STRINGER: {
                        float lhs = 0.0f;
                        switch (qual.getAlignmentType()) {
                            case LEFT: {
                                lhs = 0.0f;
                                break;
                            }
                            case CENTRE: {
                                lhs = 50.0f - qual.getXpos() / 2.0f;
                                break;
                            }
                            case RIGHT: {
                                lhs = 100.0f - qual.getXpos();
                                break;
                            }
                            default: {
                                assert (false);
                                break;
                            }
                        }
                        if (!(xpos > lhs - width_bracket) || !(xpos < lhs + qual.getXpos() + width_bracket)) break;
                        return qual;
                    }
                }
            }
            for (LithBase base2 : this.block.getWell().getLithIntervals()) {
                LithInterval interval;
                if (!(base2 instanceof LithInterval) || !((double)depth > (interval = (LithInterval)base2).getTopDepth()) || !((double)depth < interval.getBaseDepth())) continue;
                return interval;
            }
        }
        catch (SQLException sql) {
            sql.printStackTrace();
        }
        return null;
    }

    @Override
    public String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        float depth = this.block.getDepth(y, bp);
        if (depth < this.block.getTopDepth() || depth > this.block.getBaseDepth()) {
            return null;
        }
        if (this.block.getWell() == null) {
            return null;
        }
        Object depthString = SB.getDepthString((double)depth, (char)this.block.getProp().getUnits(), (int)1, (char)this.block.getWell().getType());
        Object obj = this.getObject(x, y, cp, bp, zoom);
        if (obj != null) {
            if (obj instanceof LithInterval) {
                LithInterval lith = (LithInterval)obj;
                float bracket = this.block.getBracket(1.25f, zoom, depth);
                if (Math.abs(lith.getTopDepth() - (double)depth) < (double)bracket) {
                    return "Bnd: " + SB.getDepthString((double)lith.getTopDepth(), (char)this.block.getProp().getUnits(), (int)2, (char)this.block.getWell().getType());
                }
                if (Math.abs(lith.getBaseDepth() - (double)depth) < (double)bracket) {
                    return "Bnd: " + SB.getDepthString((double)lith.getBaseDepth(), (char)this.block.getProp().getUnits(), (int)2, (char)this.block.getWell().getType());
                }
                depthString = (String)depthString + " " + lith.toString();
                return depthString;
            }
            if (obj instanceof LithQualifier) {
                depthString = (String)depthString + " " + obj.toString();
                return depthString;
            }
        }
        return depthString;
    }

    public Double getBndDepth(float y, float zoom) {
        float depth = this.block.getDepth(y, null);
        for (LithBase base : this.list) {
            if (!(base instanceof LithInterval)) continue;
            LithInterval lith = (LithInterval)base;
            float bracket = this.block.getBracket(1.25f, zoom, depth);
            if (Math.abs(lith.getTopDepth() - (double)depth) < (double)bracket) {
                return lith.getTopDepth();
            }
            if (!(Math.abs(lith.getBaseDepth() - (double)depth) < (double)bracket)) continue;
            return lith.getBaseDepth();
        }
        return null;
    }

    public double getDepth(float y) {
        float depth = this.block.getDepth(y, null);
        if (depth > this.block.getTopDepth() && depth < this.block.getBaseDepth()) {
            return depth;
        }
        return 0.0;
    }

    public String toString() {
        return "Interpreted Lithology";
    }

    public AbstractUndoableEdit insertQualifier(Lithology qual, float xpos, float ypos) throws SBException, SQLException {
        assert (qual.isQual());
        double depth = this.block.getDepth(ypos, null);
        float x = xpos / this.getWidth(null) * 100.0f;
        LithQualifier.Builder builder = new LithQualifier.Builder(this.getDb(), depth, qual).xPos(x);
        SbugsCompoundEdit edit = this.block.getWell().addLithInterval((LithBase.Builder)builder);
        edit.doEdits();
        return edit;
    }

    public boolean canInsertInterval(float ypos) {
        double depth = this.block.getDepth(ypos, null);
        LithInterval lastInterval = null;
        for (LithBase base : this.list) {
            if (!(base instanceof LithInterval)) continue;
            LithInterval interval = (LithInterval)base;
            if (lastInterval == null) {
                lastInterval = interval;
                continue;
            }
            if (depth > lastInterval.getBaseDepth() && depth < interval.getTopDepth()) {
                return true;
            }
            lastInterval = interval;
        }
        return false;
    }

    public boolean isWithinInterval(float ypos) {
        double depth = this.block.getDepth(ypos, null);
        for (LithBase base : this.list) {
            LithInterval interval;
            if (!(base instanceof LithInterval) || !(depth > (interval = (LithInterval)base).getTopDepth()) || !(depth < interval.getBaseDepth())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof Well) {
            if (o == this.block.getWell()) {
                if (arg instanceof LithBase || arg == LithBase.class) {
                    this.setDataChanged();
                    this.notifyListeners();
                    return;
                }
            } else assert (false);
            return;
        }
        super.update(o, arg);
    }

    @Override
    public boolean hasData(BlockProperties bp) {
        if (this.list == null) {
            this.initLithology();
            if (this.list == null) {
                return true;
            }
        }
        return !this.list.isEmpty();
    }

    @Override
    public Float getDataBound(boolean upper) {
        if (this.list == null || this.list.isEmpty()) {
            return null;
        }
        if (upper) {
            return Float.valueOf((float)this.list.getFirst().getTopDepth());
        }
        Double bound = null;
        for (LithBase lith : this.list) {
            double val;
            double d = val = lith instanceof LithInterval ? ((LithInterval)lith).getBaseDepth() : lith.getTopDepth();
            if (bound != null && !(val > bound)) continue;
            bound = val;
        }
        return bound != null ? Float.valueOf(bound.floatValue()) : null;
    }

    @Override
    public void fillWorkspaceWellData(SBdb ws, Set<Integer> dataTypes) throws SQLException, SBException {
        LithBase li;
        WsWell wsWell = (WsWell)ws.getWell(this.block.getWell().getWellID());
        float topDepth = this.block.getTopDepth();
        float baseDepth = this.block.getBaseDepth();
        LinkedList<LithBase> toFill = new LinkedList<LithBase>();
        Iterator iterator = this.block.getWell().getLithIntervals().iterator();
        while (iterator.hasNext() && !((li = (LithBase)iterator.next()).getTopDepth() > (double)baseDepth)) {
            if (li.getTopDepth() < (double)topDepth && (!(li instanceof LithInterval) || !(((LithInterval)li).getBaseDepth() > (double)topDepth))) continue;
            toFill.add(li);
        }
        if (!toFill.isEmpty()) {
            wsWell.fillLithology(toFill);
            dataTypes.add(21);
        }
    }
}

