/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import com.stratadata.model3.scheme.Boundary;
import com.stratadata.model3.scheme.UnitEWBoundary;
import java.awt.Color;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import jsbchart.block.BlockProperties;
import jsbchart.block.ChartBlock;
import jsbchart.block.CorrelationPoint;
import jsbchart.block.SchemeBlock;
import jsbchart.core.Chart;
import jsbchart.core.ChartProperties;
import jsbchart.core.LithologyPattern;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.correlation.CorrelationType;
import jsbchart.graphics.SBGraphics;
import jsbchart.panel.PanelLithostratSchemeProperties;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.SBPanel;
import jsbchart.panel.panelIGDScheme.PanelIGDScheme;
import jsbchart.panel.panelIGDScheme.PanelIGDSchemeProperties;
import jsbchart.panel.panelIGDScheme.RenderingSummary;
import model3.IGDIntervalZone;
import model3.IGDScheme;
import model3.IGDUnitBase;
import model3.LithostratUnit;
import model3.LithostratUnitClass;
import util.ColourUtils;
import util.SBException;

public class PanelLithostratScheme
extends SBPanel {
    private PanelLithostratSchemeProperties p;
    private final SchemeBlock block;
    private List<RenderingSummary<IGDUnitBase>> drawnLabels = new ArrayList<RenderingSummary<IGDUnitBase>>();
    static final float SHAZAM_HEIGHT = 4.0f;

    protected PanelLithostratScheme(PanelTemplate template, SchemeBlock block, PanelOcc occ) throws SQLException, SBException {
        super(template, occ != null ? occ : new PanelOcc(template.getID()));
        this.block = block;
        this.p = (PanelLithostratSchemeProperties)template.getProperties();
    }

    public PanelLithostratScheme(SchemeBlock block, IGDScheme scheme) throws SQLException, SBException {
        this.block = block;
        this.p = new PanelLithostratSchemeProperties(scheme, null);
    }

    @Override
    public float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode, EnumMap<CorrelationType, HashSet<CorrelationPoint>> cLines) {
        try {
            this.drawUnits(g, x, y, cp, bp, mode);
            switch (mode) {
                case NORMAL: 
                case HEADER_ONLY: {
                    float xpos = x + (this.p.labelWest != null ? this.p.labelWest.getWidth() : 0.0f);
                    float fontSize = cp.getFontSizeHeader();
                    g.setFont(cp.font, 0, fontSize);
                    g.drawString(this.p.W, xpos + fontSize, y + this.getPanelHeaderHeight(cp, mode) - fontSize);
                    g.drawString(this.p.E, xpos + this.p.columnWidth - fontSize - g.stringWidth(this.p.E), y + this.getPanelHeaderHeight(cp, mode) - fontSize);
                }
            }
        }
        catch (SQLException | SBException e) {
            this.handleException(g, x, y, cp, bp, (Exception)e);
        }
        return x + this.p.calcWidth();
    }

    private void drawUnits(SBGraphics g, float xpos, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) throws SBException, SQLException {
        this.drawnLabels = new ArrayList<RenderingSummary<IGDUnitBase>>();
        if (this.p.labelWest != null) {
            this.drawLabel(true, g, xpos, y, bp, cp, mode);
        }
        float x = xpos + (this.p.labelWest != null ? this.p.labelWest.getWidth() : 0.0f);
        if (this.p.columnWidth > 0.0f) {
            List<UnitForeground> foregrounds = this.setData(cp, null, bp);
            g.setColor(cp.foreground);
            for (UnitForeground f : foregrounds) {
                f.draw(g, cp, null, x, y + this.getPanelHeaderHeight(cp, mode));
            }
        }
        if (this.p.labelEast != null) {
            this.drawLabel(false, g, x + this.p.columnWidth, y, bp, cp, mode);
        }
    }

    protected List<UnitForeground> setData(ChartProperties cp, double[][] sections, BlockProperties bp) throws SBException {
        ArrayList bases = new ArrayList(this.p.scheme.getUnitBases());
        Collections.sort(bases, new IGDScheme.UnitHierComparator());
        ArrayList<UnitForeground> foregrounds = new ArrayList<UnitForeground>();
        for (IGDUnitBase base : bases) {
            if (!base.hasAges() || !this.p.plotHier(base.getHier()) || base.getLage() <= (double)bp.getMin() || base.getUage() >= (double)bp.getMax()) continue;
            LithostratUnit unit = (LithostratUnit)base;
            float[] xPoints = new float[4];
            for (int i = 0; i < xPoints.length; ++i) {
                xPoints[i] = unit.getX(i) * this.p.columnWidth;
            }
            float[] yPoints = new float[4];
            for (int i = 0; i < yPoints.length; ++i) {
                double age = unit.getAge(i);
                yPoints[i] = this.block.getProp().scaleAge((float)age, false);
            }
            UnitForeground unitF = new UnitForeground(this, (LithostratUnitClass)unit, xPoints, yPoints);
            if (cp.key != null && cp.keyIsVisible() && this.p.lithology && unit.getLithology() != null) {
                cp.getKeyData().putLithology(unit);
            }
            boolean isChild = false;
            for (UnitForeground f : foregrounds) {
                if (!f.addChild(unitF)) continue;
                isChild = true;
                break;
            }
            if (isChild) continue;
            foregrounds.add(unitF);
        }
        return foregrounds;
    }

    private void drawLabel(boolean west, SBGraphics g, float xpos, float y, BlockProperties bp, ChartProperties cp, Chart.Mode mode) throws SQLException, SBException {
        PanelIGDSchemeProperties label = west ? this.p.labelWest : this.p.labelEast;
        List<RenderingSummary<IGDUnitBase>> labelDrawSummary = PanelIGDScheme.drawUnitsAge(g, xpos, y + this.getPanelHeaderHeight(cp, mode), bp, cp, mode, true, true, true, this.block, label, label.getWidth(), null);
        if (!west) {
            float correction = this.getWidth(bp) - this.p.labelEast.getWidth();
            ArrayList<RenderingSummary<IGDUnitBase>> corrected = new ArrayList<RenderingSummary<IGDUnitBase>>();
            for (RenderingSummary<IGDUnitBase> s : labelDrawSummary) {
                corrected.add(new RenderingSummary<IGDUnitBase>(s.getObject(), s.getDrawnAreaOfChart(), new Point2D.Float(s.getPanelOffset().x - correction, s.getPanelOffset().y)));
            }
            this.drawnLabels.addAll(corrected);
        } else {
            this.drawnLabels.addAll(labelDrawSummary);
        }
        float fontSize = cp.getFontSizeHeader();
        g.setFont(cp.font, 0, fontSize);
        g.setColor(cp.foreground);
        float total = west ? 0.0f : label.getWidth();
        for (int i = 0; i < label.nHier(); ++i) {
            if (!label.plotHier(i)) continue;
            if (!west) {
                total -= label.hierWidth(i);
            }
            g.drawStringVertical(IGDIntervalZone.getHierName((int)this.p.getScheme().getIGDType(), (int)(i + 1)), xpos + total + label.hierWidth(i) / 2.0f + g.stringHeightSB() / 2.0f, y + this.getPanelHeaderHeight(cp, mode) - fontSize);
            if (west) {
                total += label.hierWidth(i);
            }
            g.drawLine(xpos + total, y + PanelLithostratScheme.getPanelCaptionHeight(cp, mode, true), xpos + total, y + this.getPanelHeaderHeight(cp, mode));
        }
    }

    static void drawEWboundary(UnitEWBoundary bnd, SBGraphics g, boolean isEast, float x, float width, float leftX, float ypos1, float rightX, float ypos2) {
        GeneralPath p = SBGraphics.createGeneralPath(leftX, ypos1);
        PanelLithostratScheme.appendEWBoundary(bnd, p, isEast, x, width, leftX, ypos1, rightX, ypos2);
        g.drawShape(p);
    }

    static void appendEWBoundary(UnitEWBoundary bnd, GeneralPath p, boolean isEast, float x, float width, float leftX, float ypos1, float rightX, float ypos2) {
        if (bnd != UnitEWBoundary.NORMAL) {
            if (isEast && (leftX + bnd.getAmplitude() / 2.0f > x + width || rightX + bnd.getAmplitude() / 2.0f > x + width)) {
                bnd = UnitEWBoundary.NORMAL;
            } else if (!isEast && (leftX - bnd.getAmplitude() / 2.0f < x || rightX - bnd.getAmplitude() / 2.0f < x)) {
                bnd = UnitEWBoundary.NORMAL;
            }
        }
        if (bnd == UnitEWBoundary.NORMAL) {
            SBGraphics.appendLine(p, rightX, ypos2);
            return;
        }
        boolean reverse = false;
        if (ypos2 < ypos1) {
            reverse = true;
            float tempy = ypos2;
            float tempx = rightX;
            ypos2 = ypos1;
            ypos1 = tempy;
            rightX = leftX;
            leftX = tempx;
        }
        ArrayList<Point2D.Float> points = new ArrayList<Point2D.Float>();
        float height = ypos2 - ypos1;
        int iterations = Math.abs(Math.round(height / 4.0f));
        float iterationHeight = height / (float)iterations;
        boolean goRight = isEast;
        float yCentre = ypos1 + iterationHeight / 2.0f;
        for (int i = 1; i <= iterations; ++i) {
            float xCentre = leftX + (rightX - leftX) / (float)iterations * (float)i;
            if (i > 1) {
                yCentre += iterationHeight;
            }
            xCentre = goRight ? (xCentre += bnd.getAmplitude() / 2.0f) : (xCentre -= bnd.getAmplitude() / 2.0f);
            goRight = !goRight;
            points.add(new Point2D.Float(xCentre, yCentre));
        }
        points.add(new Point2D.Float(rightX, ypos2));
        if (reverse) {
            Collections.reverse(points);
        }
        for (Point2D.Float pt : points) {
            SBGraphics.appendLine(p, pt.x, pt.y);
        }
    }

    static void drawBoundary(Boundary type, float leftX, float rightX, float ypos1, float ypos2, SBGraphics g, float stroke) {
        float h = 1.75f;
        switch (type) {
            default: {
                g.setStroke(stroke);
                g.drawLine(leftX, ypos1, rightX, ypos2);
                break;
            }
            case PROB: {
                g.setDashStroke(stroke, 2.5f);
                g.drawLine(leftX, ypos1, rightX, ypos2);
                break;
            }
            case POSS: {
                g.setDashStroke(stroke, 1.0f);
                g.drawLine(leftX, ypos1, rightX, ypos2);
                break;
            }
            case UNCF: 
            case QUNCF: {
                g.setStroke(stroke);
                GeneralPath p = SBGraphics.createGeneralPath(leftX, ypos1);
                g.appendUnconf(p, leftX, rightX, ypos1, ypos2, false, true, true, false);
                g.drawShape(p);
            }
        }
        g.setStroke(stroke);
    }

    @Override
    public float getWidth(BlockProperties bp) {
        return this.p.calcWidth();
    }

    @Override
    public Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        try {
            if (this.p.labelEast != null && x > this.getWidth(bp) - this.p.labelEast.getWidth()) {
                return this.findDrawnLabelAtPoint(new Point2D.Float(x, y));
            }
            if (this.p.labelWest != null) {
                if (x < this.p.labelWest.getWidth()) {
                    return this.findDrawnLabelAtPoint(new Point2D.Float(x, y));
                }
                x -= this.p.labelWest.getWidth();
            }
            List<UnitForeground> data = this.setData(cp, null, bp);
            for (UnitForeground unit : data) {
                UnitForeground found = unit.containsPoint(x, y);
                if (found == null) continue;
                return found.unit;
            }
            return null;
        }
        catch (SBException sbe) {
            return sbe.getMessage();
        }
    }

    private IGDUnitBase findDrawnLabelAtPoint(Point2D.Float point) {
        for (RenderingSummary<IGDUnitBase> drawnLabel : this.drawnLabels) {
            if (!drawnLabel.getDrawnAreaOfPanel().contains(point)) continue;
            return drawnLabel.getObject();
        }
        return null;
    }

    @Override
    public String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        Object o = this.getObject(x, y, cp, bp, zoom);
        if (o != null) {
            return o.toString();
        }
        return null;
    }

    @Override
    protected String getCaption() {
        return this.getLithostratCaption();
    }

    protected String getLithostratCaption() {
        if (this.getPanelOcc() != null && this.getPanelOcc().getCaption() != null) {
            return this.getPanelOcc().getCaption();
        }
        return this.p.getScheme().toString();
    }

    @Override
    public PanelLithostratSchemeProperties getProperties() {
        return this.p;
    }

    @Override
    public ChartBlock getBlock() {
        return this.block;
    }

    public IGDScheme getScheme() {
        return this.p.scheme;
    }

    @Override
    public void setProperties(PanelProperties p) {
        if (!(p instanceof PanelLithostratSchemeProperties)) {
            throw new IllegalArgumentException("Wrong type of properties for PanelLithostratScheme");
        }
        this.p = (PanelLithostratSchemeProperties)p;
    }

    protected class UnitForeground {
        final LithostratUnitClass unit;
        protected final float[] xPoints;
        protected final float[] yPoints;
        Polygon polygon;
        protected ArrayList<UnitForeground> children;
        final /* synthetic */ PanelLithostratScheme this$0;

        protected UnitForeground(PanelLithostratScheme this$0, LithostratUnitClass unit, float[] xPoints, float[] yPoints) {
            PanelLithostratScheme panelLithostratScheme = this$0;
            Objects.requireNonNull(panelLithostratScheme);
            this.this$0 = panelLithostratScheme;
            this.polygon = null;
            this.unit = unit;
            this.xPoints = xPoints;
            this.yPoints = yPoints;
            assert (xPoints.length == yPoints.length);
            int[] ageInts = new int[4];
            int[] xInts = new int[4];
            for (int i = 0; i < 4; ++i) {
                ageInts[i] = (int)(unit.getAge(i) * 1000000.0);
                xInts[i] = (int)(unit.getX(i) * 100.0f);
            }
            this.polygon = new Polygon(xInts, ageInts, 4);
        }

        protected boolean addChild(UnitForeground child) {
            double childLEy;
            double childUWy;
            if (child.unit.getHier() <= this.unit.getHier()) {
                return false;
            }
            double childUWx = child.unit.getX(0) * 100.0f;
            if (!(this.polygon.contains(childUWx, childUWy = child.unit.getAge(0) * 1000000.0) || (int)childUWx == this.polygon.xpoints[0] && (int)childUWy == this.polygon.ypoints[0])) {
                return false;
            }
            double childLEx = child.unit.getX(2) * 100.0f;
            if (!(this.polygon.contains(childLEx, childLEy = child.unit.getAge(2) * 1000000.0) || (int)childLEx == this.polygon.xpoints[2] && (int)childLEy == this.polygon.ypoints[2])) {
                return false;
            }
            if (this.children != null) {
                for (UnitForeground f : this.children) {
                    if (!f.addChild(child)) continue;
                    return true;
                }
            }
            if (this.children == null) {
                this.children = new ArrayList();
            }
            this.children.add(child);
            return true;
        }

        protected float[][] draw(SBGraphics g, ChartProperties cp, Area parentArea, float x, float y) {
            float[] ixPoints = new float[4];
            float[] iyPoints = new float[4];
            System.arraycopy(this.xPoints, 0, ixPoints, 0, 4);
            System.arraycopy(this.yPoints, 0, iyPoints, 0, 4);
            int i = 0;
            while (i < 4) {
                int n = i;
                ixPoints[n] = ixPoints[n] + x;
                int n2 = i++;
                iyPoints[n2] = iyPoints[n2] + y;
            }
            float[] ixCache = new float[4];
            float[] iyCache = new float[4];
            System.arraycopy(ixPoints, 0, ixCache, 0, 4);
            System.arraycopy(iyPoints, 0, iyCache, 0, 4);
            if (parentArea != null) {
                float overlap = 1.0f;
                if (this.unit.getUBnd().isUnconformable()) {
                    iyPoints[0] = iyPoints[0] - overlap;
                    ixPoints[0] = ixPoints[0] + overlap * (this.xPoints[0] - this.xPoints[3]) / (this.yPoints[3] - this.yPoints[0]);
                    iyPoints[1] = iyPoints[1] - overlap;
                    ixPoints[1] = ixPoints[1] - overlap * (this.xPoints[2] - this.xPoints[1]) / (this.yPoints[2] - this.yPoints[1]);
                }
                if (this.unit.getLBnd().isUnconformable()) {
                    iyPoints[2] = iyPoints[2] + overlap;
                    iyPoints[3] = iyPoints[3] + overlap;
                }
            }
            GeneralPath path = SBGraphics.createGeneralPath(ixPoints[0], iyPoints[0]);
            path.setWindingRule(1);
            ArrayList<Shape> extraShapes = new ArrayList<Shape>();
            if (this.unit.getUBnd().isUnconformable() && parentArea == null) {
                extraShapes.add(g.appendUnconf(path, ixPoints[0], ixPoints[1], iyPoints[0], iyPoints[1], this.unit.getUBnd() == Boundary.QUNCF, true, true, false));
            } else {
                SBGraphics.appendLine(path, ixPoints[1], iyPoints[1]);
            }
            PanelLithostratScheme.appendEWBoundary(this.unit.getEBnd(), path, true, x, this.this$0.p.columnWidth, ixPoints[1], iyPoints[1], ixPoints[2], iyPoints[2]);
            if (this.unit.getLBnd().isUnconformable() && parentArea == null) {
                extraShapes.add(g.appendUnconf(path, ixPoints[2], ixPoints[3], iyPoints[2], iyPoints[3], this.unit.getLBnd() == Boundary.QUNCF, true, true, false));
            } else {
                SBGraphics.appendLine(path, ixPoints[3], iyPoints[3]);
            }
            PanelLithostratScheme.appendEWBoundary(this.unit.getWBnd(), path, false, x, this.this$0.p.columnWidth, ixPoints[3], iyPoints[3], ixPoints[0], iyPoints[0]);
            Area thisArea = new Area(path);
            if (parentArea != null) {
                thisArea.intersect(parentArea);
            }
            Area bounds = new Area(new Rectangle2D.Float(x * 100.0f, y * 100.0f, this.this$0.p.columnWidth * 100.0f, this.this$0.getBlock().getHeight() * 100.0f));
            bounds.intersect(thisArea);
            Area shape = bounds;
            g.setClip(shape);
            if (this.this$0.p.lithology && this.unit.getLithology() != null) {
                LithologyPattern.draw(this.unit.getLithology(), g, ixPoints, iyPoints, 4, false, null, true, true);
            } else if (this.this$0.p.colours) {
                g.fillShape(shape, this.unit.getColour());
            }
            g.setStroke(0.15f);
            g.setColor(cp.foreground);
            for (Shape extraShape : extraShapes) {
                if (extraShape == null) continue;
                g.drawShape(extraShape);
            }
            PanelLithostratScheme.drawEWboundary(this.unit.getWBnd(), g, false, x, this.this$0.p.columnWidth, ixCache[0], iyCache[0], ixCache[3], iyCache[3]);
            PanelLithostratScheme.drawEWboundary(this.unit.getEBnd(), g, true, x, this.this$0.p.columnWidth, ixCache[1], iyCache[1], ixCache[2], iyCache[2]);
            if (parentArea == null || !this.unit.getUBnd().isUnconformable()) {
                PanelLithostratScheme.drawBoundary(this.unit.getUBnd(), ixCache[0], ixCache[1], iyCache[0], iyCache[1], g, 0.15f);
            }
            if (parentArea == null || !this.unit.getLBnd().isUnconformable()) {
                PanelLithostratScheme.drawBoundary(this.unit.getLBnd(), ixCache[3], ixCache[2], iyCache[3], iyCache[2], g, 0.15f);
            }
            g.clearClip();
            if (this.children != null) {
                for (UnitForeground child : this.children) {
                    if (this.unit.getUBnd().isUnconformable() && this.unit.getLine(true).ptLineDist(child.unit.getX(0), child.unit.getAge(0)) == 0.0 || this.unit.getLBnd().isUnconformable() && this.unit.getLine(false).ptLineDist(child.unit.getX(3), child.unit.getAge(3)) == 0.0) {
                        child.draw(g, cp, null, x, y);
                        continue;
                    }
                    child.draw(g, cp, null, x, y);
                }
            } else if (iyPoints[0] >= y && iyPoints[0] < y + this.this$0.getBlock().getHeight()) {
                g.setFont(cp.font, 0, cp.getFontSizePanel());
                String label = this.this$0.p.useAbrs && this.unit.getAbr() != null && !this.unit.getAbr().isEmpty() ? this.unit.getAbr() : this.unit.getName();
                float labelWidth = g.stringWidth(label);
                float labelHeight = g.stringHeightSB();
                float upperXdiff = Math.abs(this.xPoints[0] - this.xPoints[1]);
                float lowerXdiff = Math.abs(this.xPoints[3] - this.xPoints[2]);
                float labelX = upperXdiff < lowerXdiff ? ixPoints[0] + upperXdiff / 2.0f - labelWidth / 2.0f : ixPoints[3] + lowerXdiff / 2.0f - labelWidth / 2.0f;
                float upperYmax = Math.max(this.yPoints[0], this.yPoints[1]);
                float lowerYmin = Math.min(this.yPoints[3], this.yPoints[2]);
                float labelY = y + upperYmax + Math.abs(lowerYmin - upperYmax) / 2.0f - labelHeight / 2.0f;
                Rectangle rect = g.getRectangle(labelX, labelY, labelWidth, labelHeight);
                Area test = new Area(shape);
                Area rectArea = new Area(rect);
                test.intersect(rectArea);
                if (test.equals(rectArea)) {
                    Color colour = this.unit.getColour();
                    if (this.this$0.p.lithology && this.unit.getLithology() != null) {
                        colour = this.unit.getLithology().getBackColour();
                        g.setColor(colour);
                        g.fillRect(labelX, labelY, labelWidth, labelHeight);
                    }
                    if (ColourUtils.isSimilarColour((Color)colour, (Color)cp.foreground)) {
                        g.setColor(cp.background);
                    } else {
                        g.setColor(cp.foreground);
                    }
                    g.drawString(label, labelX, labelY + labelHeight);
                } else {
                    int key = cp.getKeyData().putText(label);
                    g.drawString("*" + String.valueOf(cp.keyIsVisible() ? Integer.valueOf(key) : ""), ixPoints[0], iyPoints[0] + cp.getFontSizePanel());
                }
            }
            return new float[][]{ixCache, iyCache};
        }

        protected UnitForeground containsPoint(float x, float y) {
            Point p = new Point((int)(x * 100.0f), (int)(y * 100.0f));
            int[] iyPoints = new int[4];
            int[] ixPoints = new int[4];
            for (int i = 0; i < this.xPoints.length; ++i) {
                ixPoints[i] = (int)(this.xPoints[i] * 100.0f);
                iyPoints[i] = (int)(this.yPoints[i] * 100.0f);
            }
            if (new Polygon(ixPoints, iyPoints, 4).contains(p)) {
                if (this.children != null) {
                    for (UnitForeground child : this.children) {
                        UnitForeground childContainer = child.containsPoint(x, y);
                        if (childContainer == null) continue;
                        return childContainer;
                    }
                }
                return this;
            }
            return null;
        }

        public String toString() {
            return this.unit.toString();
        }
    }
}

