/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import java.awt.Color;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Observable;
import java.util.Set;
import jsbchart.block.BlockProperties;
import jsbchart.block.CorrelationPoint;
import jsbchart.block.WellBlock;
import jsbchart.core.Chart;
import jsbchart.core.ChartProperties;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.correlation.CorrelationType;
import jsbchart.graphics.SBGraphics;
import jsbchart.panel.PanelMarkersProperties;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelType;
import jsbchart.panel.SBPanel;
import model3.Markers;
import model3.SBdb;
import model3.SeismicMarker;
import model3.Well;
import model3.WsWell;
import util.SB;
import util.SBException;
import util.exception.StackError;

class PanelMarkers
extends SBPanel {
    private final WellBlock block;
    private PanelMarkersProperties p;

    public PanelMarkers(PanelTemplate template, WellBlock block, PanelOcc occ) {
        super(template, occ != null ? occ : new PanelOcc(template.getID()));
        assert (template.getType() == PanelType.MARKERS);
        this.block = block;
        this.p = (PanelMarkersProperties)template.getProperties();
    }

    @Override
    public float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode, EnumMap<CorrelationType, HashSet<CorrelationPoint>> cLines) {
        float baseDepth;
        float topDepth;
        if (!g.isVisible(x, y, this.getWidth(bp), bp.getHeight() + this.getPanelHeaderHeight(cp, mode))) {
            return x + this.getWidth(bp);
        }
        g.setClip(x, y + this.getPanelHeaderHeight(cp, mode), this.getWidth(this.block.getProp()), this.block.getHeight());
        if (bp == this.block.getProp()) {
            topDepth = this.block.getTopDepth();
            baseDepth = this.block.getBaseDepth();
        } else {
            topDepth = bp.getMin();
            baseDepth = bp.getMax();
        }
        try {
            this.drawSeaBed(g, cp, bp, this.block, this.block.getScaleConverter(), x, y + this.getPanelHeaderHeight(cp, mode));
            Markers markers = this.block.getWell() == null ? PanelMarkers.getTemplateMarkers(this.block) : this.block.getWell().getMarkers();
            g.setStroke(0.6f);
            g.setFont(cp.font, 0, cp.getFontSize());
            for (SeismicMarker m : markers.getList()) {
                if (m.getDepth() < (double)topDepth || m.getDepth() > (double)baseDepth) continue;
                float yPos = this.block.scaleDepth((float)m.getDepth()) + y + this.getPanelHeaderHeight(cp, mode);
                g.setColor(m.getColour());
                g.drawLine(x, yPos, x + this.p.width, yPos);
                g.setColor(cp.foreground);
                g.drawString(m.getName(), x + this.p.width - 1.0f, yPos - 1.0f, this.p.width, 2, true);
                if (!this.p.depths) continue;
                g.setFontSize(cp.getFontSizeSmall());
                String depthString = this.getBoundaryLabel(this.block.getProp(), m.getDepth(), 2, true);
                g.drawString(depthString, x, yPos + g.stringHeight(), this.getWidth(bp), 0, true);
                g.setFontSize(cp.getFontSize());
            }
        }
        catch (Exception ex) {
            this.handleException(g, x, y, cp, bp, ex);
        }
        g.setClip(null);
        return x + this.p.width;
    }

    @Override
    public float getWidth(BlockProperties bp) {
        return this.p.width;
    }

    @Override
    public Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        float b = 4.0f / zoom;
        float depth = this.block.getDepth(y, bp);
        try {
            Markers markers = this.block.getWell() == null ? PanelMarkers.getTemplateMarkers(this.block) : this.block.getWell().getMarkers();
            for (SeismicMarker m : markers.getList()) {
                if (!(m.getDepth() > (double)(depth - b)) || !(m.getDepth() < (double)(depth + b))) continue;
                return m;
            }
        }
        catch (SQLException sqle) {
            StackError.showStackError((String)"SQL Error", (SQLException)sqle);
        }
        catch (SBException sqle) {
            StackError.showStackError((String)"SB Error", (Throwable)sqle);
        }
        return null;
    }

    @Override
    public String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        Object o = this.getObject(x, y, cp, bp, zoom);
        if (o != null && o instanceof SeismicMarker) {
            SeismicMarker m = (SeismicMarker)o;
            return m.toString() + " (" + SB.getDepthString((double)m.getDepth(), (char)this.block.getProp().getUnits(), (int)2) + ")";
        }
        return null;
    }

    public String toString() {
        return "Seismic Markers";
    }

    @Override
    public WellBlock getBlock() {
        return this.block;
    }

    @Override
    public PanelMarkersProperties getProperties() {
        return this.p;
    }

    @Override
    public void setProperties(PanelProperties prop) {
        if (!(prop instanceof PanelMarkersProperties)) {
            throw new IllegalArgumentException("Attempt to set panel markers properties to " + String.valueOf(prop));
        }
        this.p = (PanelMarkersProperties)prop;
    }

    @Override
    protected String getCaption() {
        return "Seismic Markers";
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof Well) {
            if (o == this.block.getWell()) {
                if (arg instanceof Markers || arg == Markers.class || arg instanceof SeismicMarker || arg == SeismicMarker.class) {
                    this.setDataChanged();
                    this.notifyListeners();
                    return;
                }
            } else assert (false);
            return;
        }
        super.update(o, arg);
    }

    @Override
    public boolean hasData(BlockProperties bp) {
        if (this.block.getWell() != null) {
            try {
                return !this.block.getWell().getMarkers().getList().isEmpty();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                return false;
            }
        }
        return true;
    }

    private static Markers getTemplateMarkers(WellBlock block) throws SBException {
        Markers markers = new Markers(null);
        markers.add(new SeismicMarker(30.0, "Blue", Color.BLUE));
        markers.add(new SeismicMarker(60.0, "Red", Color.RED));
        return markers;
    }

    @Override
    public void fillWorkspaceWellData(SBdb ws, Set<Integer> dataTypes) throws SQLException, SBException {
        WsWell wsWell = (WsWell)ws.getWell(this.block.getWell().getWellID());
        float topDepth = this.block.getTopDepth();
        float baseDepth = this.block.getBaseDepth();
        ArrayList<SeismicMarker> toFill = new ArrayList<SeismicMarker>();
        for (SeismicMarker mkr : this.block.getWell().getMarkers().getList()) {
            if (!(mkr.getDepth() >= (double)topDepth) || !(mkr.getDepth() <= (double)baseDepth)) continue;
            toFill.add(mkr);
        }
        if (!toFill.isEmpty()) {
            wsWell.fillMarkers(toFill);
            dataTypes.add(24);
        }
    }
}

