/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import com.stratadata.model3.well.sample.SampleType;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import jsbchart.block.BlockProperties;
import jsbchart.block.ChartBlock;
import jsbchart.block.CorrelationPoint;
import jsbchart.block.WellBlock;
import jsbchart.core.Chart;
import jsbchart.core.ChartProperties;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.correlation.CorrelationType;
import jsbchart.graphics.SBGraphics;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelSamplesProperties;
import jsbchart.panel.PanelType;
import jsbchart.panel.SBPanelHTML;
import jsbchart.util.DrawingUtils;
import model3.SBdb;
import model3.Sample;
import model3.Smpdtl;
import model3.WsWell;
import util.SBException;
import util.exception.StackError;

class PanelSamples
extends SBPanelHTML
implements Observer {
    private final WellBlock block;
    private PanelSamplesProperties p;
    private float sampleWidth = 30.0f;
    private float[] origSamplePosition;
    private float[] samplePosition;
    private String[][] sampleString;
    private Sample[] plotSamples;
    private boolean hasDogLegs = true;
    static final float DOGLEG_LEGTH = 2.0f;

    public PanelSamples(PanelTemplate template, WellBlock block, PanelOcc occ) {
        super(template, occ != null ? occ : new PanelOcc(template.getID()));
        assert (template.getType() == PanelType.SAMPLES);
        this.block = block;
        this.p = (PanelSamplesProperties)template.getProperties();
        this.init();
    }

    private void init() {
        if (this.block.getWell() != null) {
            this.block.getWell().addWeakObserver((Observer)this);
        }
    }

    @Override
    public void terminate() {
        super.terminate();
        if (this.block.getWell() != null) {
            this.block.getWell().deleteWeakObserver((Observer)this);
        }
        this.origSamplePosition = null;
        this.samplePosition = null;
    }

    @Override
    public String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        return null;
    }

    @Override
    public Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        return "Samples";
    }

    public String toString() {
        return "Samples panel";
    }

    @Override
    public WellBlock getBlock() {
        return this.block;
    }

    @Override
    public synchronized float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode, EnumMap<CorrelationType, HashSet<CorrelationPoint>> cLines) {
        if (!g.isVisible(x, (bp == this.block.getProp() ? 0.0f : this.block.scaleDepth(bp.getNormal() ? bp.getMin() : bp.getMax())) + y + this.getPanelHeaderHeight(cp, mode), this.getWidth(bp), bp.getHeight())) {
            return x + this.getWidth(bp);
        }
        this.drawSeaBed(g, cp, bp, this.block, this.block.getScaleConverter(), x, y + this.getPanelHeaderHeight(cp, mode));
        if (this.samplePosition == null) {
            return x + this.getWidth(bp);
        }
        float xpos = x;
        g.setStroke(0.1f);
        g.setFont(cp.font, 0, cp.getFontSizeSmall());
        g.setColor(cp.foreground);
        try {
            float defaultWidth = this.sampleWidth;
            if (this.block.getProp() != bp) {
                Integer begin = null;
                int end = 0;
                for (int i = 0; i < this.samplePosition.length; ++i) {
                    Sample s = this.plotSamples[i];
                    double sampleDepth = this.block.getWell().getDepth(s, cp.correctDepths, cp.correctCuttings);
                    if (!(sampleDepth + (double)0.0029f > (double)bp.getMin()) || !(sampleDepth - (double)0.0029f <= (double)bp.getMax())) continue;
                    if (begin == null) {
                        begin = i;
                    }
                    if (i <= end) continue;
                    end = i;
                }
                if (begin != null && end - begin > 0) {
                    PanelSamples.drawSamples(g, y, xpos, cp, mode, this.p, Arrays.copyOfRange(this.samplePosition, (int)begin, ++end), Arrays.copyOfRange(this.origSamplePosition, (int)begin, end), (String[][])Arrays.copyOfRange(this.sampleString, (int)begin, end), null, this.block, this.hasDogLegs);
                }
            } else {
                PanelSamples.drawSamples(g, y, xpos, cp, mode, this.p, this.samplePosition, this.origSamplePosition, this.sampleString, null, this.block, this.hasDogLegs);
            }
            if (mode != Chart.Mode.NO_HEADER && (bp == this.block.getProp() || (double)Math.abs(this.block.getTopDepth() - bp.getMin()) < 0.01) && (cp.correctDepths || cp.correctCuttings)) {
                boolean b = false;
                for (int i = 0; i < this.samplePosition.length; ++i) {
                    if (!Boolean.valueOf(this.sampleString[i][2]).booleanValue()) continue;
                    b = true;
                    break;
                }
                if (b) {
                    Object s = "Displaying core-corrected depths for ";
                    if (cp.correctDepths) {
                        s = (String)s + "CO";
                    }
                    if (cp.correctCuttings) {
                        if (cp.correctDepths) {
                            s = (String)s + ", ";
                        }
                        s = (String)s + "CU";
                    }
                    g.setFontSize(cp.getFontSizeSmall());
                    g.drawStringVertical((String)s, x + cp.getFontSizeSmall() + 1.0f, y + this.getPanelHeaderHeight(cp, mode) - 1.0f, this.getMaxSubheaderStringHeight(cp), false, false, true);
                }
            }
            if (this.sampleWidth <= 0.0f) {
                this.sampleWidth = defaultWidth;
            }
            xpos += this.sampleWidth;
        }
        catch (Exception se) {
            System.out.println("Warning: null sample depth");
            se.printStackTrace();
        }
        return xpos;
    }

    @Override
    public float getWidth(BlockProperties bp) {
        float width = 0.0f;
        return width += this.sampleWidth;
    }

    @Override
    protected String getCaption() {
        return "Samples";
    }

    static void drawSamples(SBGraphics g, float y, float xpos, ChartProperties cp, Chart.Mode mode, PanelSamplesProperties p, float[] samplePosition, float[] origSamplePosition, String[][] sampleString, Float doubleDogleg, ChartBlock context, boolean hasDogLegs) throws SBException {
        if (p == null) {
            p = new PanelSamplesProperties();
        }
        if (samplePosition.length != sampleString.length) {
            throw new SBException("Data has not been set correctly in PanelSamples");
        }
        g.setFont(cp.font, 0, cp.getFontSizeSmall());
        for (int i = 0; i < samplePosition.length; ++i) {
            float xposi = xpos;
            float ypos = y + PanelSamples.getPanelHeaderHeight(cp, mode, context) + origSamplePosition[i];
            float ypos1 = y + PanelSamples.getPanelHeaderHeight(cp, mode, context) + samplePosition[i];
            if (hasDogLegs) {
                g.drawLine(xposi, ypos, xposi += 2.0f, ypos);
                g.drawLine(xposi, ypos, xposi += 2.0f, ypos1);
            }
            float lineLength = p.drawSymbols() ? 3.0f : 1.5f;
            g.drawLine(xposi, ypos1, xposi + lineLength, ypos1);
            if (Boolean.valueOf(sampleString[i][2]).booleanValue()) {
                g.drawLine(xposi + 0.5f, ypos1 - 0.5f, xposi + 0.5f, ypos1 + 0.5f);
            }
            if (p.drawSymbols()) {
                DrawingUtils.drawSampleSymbol(sampleString[i][1], g, xposi, ypos1);
            }
            xposi += lineLength;
            g.drawString(sampleString[i][0], xposi += 0.5f, ypos1 + g.stringHeightSB() / 2.0f);
            if (doubleDogleg == null) continue;
            if (hasDogLegs) {
                float xposj = xpos + doubleDogleg.floatValue();
                g.drawLine(xposj, ypos, xposj -= 2.0f, ypos);
                g.drawLine(xposj, ypos, xposj -= 2.0f, ypos1);
                g.drawLine(xposi + (g.stringWidth(sampleString[i][0]) + 0.5f), ypos1, xposj, ypos1);
                continue;
            }
            g.drawLine(xposi + (g.stringWidth(sampleString[i][0]) + 0.5f), ypos1, xpos + doubleDogleg.floatValue(), ypos1);
        }
    }

    static String[] getSampleString(Sample sample, ChartProperties cp, WellBlock block, PanelSamplesProperties p) {
        boolean shifted = false;
        Object strg = "";
        if (p.isDrawDepths()) {
            Double correctedTop = null;
            Double correctedBase = null;
            if (cp.correctDepths && block.getWell() != null) {
                try {
                    if (Math.abs(sample.getDepth() - block.getWell().getDepth(sample, true, cp.correctCuttings)) > (double)0.0029f) {
                        correctedTop = sample.getTopDepth() != null ? Double.valueOf(block.getWell().getCorrectedDepth(sample.getTopDepth().doubleValue())) : null;
                        correctedBase = sample.getBaseDepth() != null ? Double.valueOf(block.getWell().getCorrectedDepth(sample.getBaseDepth().doubleValue())) : null;
                        shifted = true;
                    }
                }
                catch (SQLException sql) {
                    StackError.showStackError((String)"SQL Error", (SQLException)sql);
                }
            }
            strg = sample.toString(block.getProp().getUnits(), !p.drawSymbols(), false, !p.drawSymbols(), p.drawRange(), correctedTop, correctedBase).trim();
            if (shifted && p.drawUnshifted()) {
                strg = (String)strg + " (" + sample.toString(block.getProp().getUnits(), false, false, false, p.drawRange(), null, null).trim() + ")";
            }
            if (p.drawSymbols() && sample.getType() == SampleType.LOG) {
                strg = (String)strg + " log";
            }
        }
        if (p.drawLabels() && !sample.getLabel().isEmpty()) {
            strg = (String)strg + " " + sample.getLabel();
        }
        return new String[]{strg, sample.getType().getAbr(), Boolean.toString(shifted)};
    }

    @Override
    public synchronized void setData(ChartProperties cp, double[][] sections) throws SQLException, SBException {
        float width;
        LinkedList<Object> samples;
        if (this.block.getWell() != null) {
            samples = new LinkedList();
            for (Sample sample : this.block.getWell().getSamples(cp.correctDepths, cp.correctCuttings)) {
                if (!(this.block.getWell().getDepth(sample, cp.correctDepths, cp.correctCuttings) + (double)0.0029f >= (double)this.block.getTopDepth()) || !(this.block.getWell().getDepth(sample, cp.correctDepths, cp.correctCuttings) - (double)0.0029f <= (double)this.block.getBaseDepth()) || !this.p.draw(sample.getType())) continue;
                samples.add(sample);
            }
        } else {
            samples = this.getTemplateSamples();
        }
        this.samplePosition = new float[samples.size()];
        this.sampleString = new String[samples.size()][2];
        this.plotSamples = new Sample[samples.size()];
        int i = 0;
        Iterator it = samples.iterator();
        float f = width = this.p.isDrawDepths() ? 17.0f : 8.0f;
        while (it.hasNext()) {
            Sample sample = (Sample)it.next();
            this.samplePosition[i] = this.block.scaleDepth(this.block.getWell() != null ? (float)this.block.getWell().getDepth(sample, cp.correctDepths, cp.correctCuttings) : (float)sample.getDepth());
            this.sampleString[i] = PanelSamples.getSampleString(sample, cp, this.block, this.p);
            this.plotSamples[i] = sample;
            float currentSampleWidth = (this.p.drawSymbols() ? 3.0f : 1.5f) + SBGraphics.stringWidth(this.sampleString[i][0], cp.getFontSizeSmall()) + 4.0f;
            if (currentSampleWidth + 2.0f > width) {
                width = currentSampleWidth + 2.0f;
            }
            ++i;
        }
        this.sampleWidth = width;
        this.origSamplePosition = Arrays.copyOf(this.samplePosition, this.samplePosition.length);
        if (samples.size() < 2 || !this.p.isDrawDepths() && !this.p.drawLabels()) {
            return;
        }
        PanelSamples.moveSamplePositions(cp, sections, this.block, this.samplePosition, this.plotSamples, null, cp.getFontSizeSmall());
        this.hasDogLegs = false;
        for (int j = 0; j < this.samplePosition.length; ++j) {
            if (!((double)Math.abs(this.samplePosition[j] - this.origSamplePosition[j]) > 0.1)) continue;
            this.hasDogLegs = true;
            break;
        }
        if (!this.hasDogLegs) {
            width -= 4.0f;
        }
    }

    private LinkedList<Sample> getTemplateSamples() throws SBException, SQLException {
        LinkedList<Sample> fullList = this.block.getTemplateSamples();
        LinkedList<Sample> tempList = new LinkedList<Sample>();
        for (Sample sample : fullList) {
            if (!this.p.draw(sample.getType())) continue;
            tempList.add(sample);
        }
        return tempList;
    }

    static void moveSamplePositions(ChartProperties cp, double[][] sections, WellBlock block, float[] samplePosition, Sample[] plotSamples, Smpdtl[] plotSmpdtl, float symbolHeight) throws SQLException {
        assert (plotSamples == null || plotSmpdtl == null);
        if (sections != null) {
            boolean ypos = false;
            boolean ddepth = true;
            int pos = 0;
            for (int j = 0; j < sections.length - 1; ++j) {
                int k;
                for (k = pos; k < samplePosition.length; ++k) {
                    Sample s;
                    Sample sample = s = plotSamples == null ? plotSmpdtl[k].getSample() : plotSamples[k];
                    if (block.getWell().getDepth(s, cp.correctDepths, cp.correctCuttings) > sections[j + 1][1]) break;
                }
                if (k - pos > 0) {
                    float[] section = Arrays.copyOfRange(samplePosition, pos, k);
                    float pos1 = (float)sections[j][0];
                    float pos2 = (float)sections[j + 1][0];
                    PanelSamples.moveSamplePositions(k - pos, section, symbolHeight, Math.min(pos1, pos2) + symbolHeight / 1.8f, Math.max(pos1, pos2) - symbolHeight / 1.8f);
                    System.arraycopy(section, 0, samplePosition, pos, k - pos);
                }
                pos = k;
            }
        } else {
            float hSampPosition = symbolHeight / 2.0f;
            float lSampPosition = block.getHeight() - symbolHeight / 2.0f;
            PanelSamples.moveSamplePositions(samplePosition.length, samplePosition, symbolHeight, hSampPosition, lSampPosition);
        }
    }

    @Override
    public PanelSamplesProperties getProperties() {
        return this.p;
    }

    @Override
    public void setProperties(PanelProperties prop) {
        if (!(prop instanceof PanelSamplesProperties)) {
            throw new IllegalArgumentException("Attempt to set panel samples properties to " + String.valueOf(prop));
        }
        this.p = (PanelSamplesProperties)prop;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o == this.block.getWell() && arg instanceof Sample) {
            this.setDataChanged();
            this.notifyListeners();
            return;
        }
        super.update(o, arg);
    }

    @Override
    public int addSamples(LinkedList<Sample> samples, ChartProperties cp) {
        for (Sample sample : this.plotSamples) {
            try {
                Sample.insert(samples, (Sample)sample, (char)this.block.getProp().getUnits());
            }
            catch (SBException sBException) {
                // empty catch block
            }
        }
        return this.plotSamples.length;
    }

    @Override
    public String getRowString(LinkedList<Sample> samples, int index, ChartProperties cp) {
        Object rowString = "<td>";
        Sample sample = samples.get(index);
        for (Sample plotSample : this.plotSamples) {
            if (!plotSample.equals((Object)sample)) continue;
            rowString = (String)rowString + PanelSamples.getSampleString(sample, cp, this.block, this.p)[0];
            break;
        }
        rowString = (String)rowString + "</td>";
        return rowString;
    }

    @Override
    public boolean hasData(BlockProperties bp) {
        return this.plotSamples != null && this.plotSamples.length != 0;
    }

    @Override
    public Float getDataBound(boolean upper) {
        if (this.plotSamples == null || this.plotSamples.length == 0) {
            return null;
        }
        return Float.valueOf(upper ? (float)this.plotSamples[0].getDepth() : (float)this.plotSamples[this.plotSamples.length - 1].getDepth());
    }

    @Override
    public void fillWorkspaceWellData(SBdb ws, Set<Integer> dataTypes) throws SQLException, SBException {
        WsWell wsWell = (WsWell)ws.getWell(this.block.getWell().getWellID());
        for (Sample sample : this.plotSamples) {
            wsWell.fillSample(sample.getSampID());
        }
    }
}

