/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import com.stratadata.model3.image.TaxonImageService;
import com.stratadata.model3.scheme.Confidence;
import com.stratadata.model3.taxon.Category;
import com.stratadata.model3.taxon.Genus;
import com.stratadata.model3.taxon.SynonymService;
import com.stratadata.model3.taxon.Taxon;
import com.stratadata.model3.taxon.TaxonNameService;
import com.stratadata.model3.taxon.TaxonService;
import com.stratadata.model3.well.analysis.Situation;
import com.stratadata.model3.well.analysis.SpeciesType;
import com.stratadata.model3.well.analysis.hdr.AbundanceScheme;
import java.awt.Color;
import java.awt.Image;
import java.awt.font.TextAttribute;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.sql.SQLException;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsbchart.block.BlockProperties;
import jsbchart.block.CorrelationPoint;
import jsbchart.block.SubBlockProperties;
import jsbchart.core.Chart;
import jsbchart.core.ChartProperties;
import jsbchart.graphics.SBGraphics;
import jsbchart.graphics.text.HorizontalAlignment;
import jsbchart.graphics.text.SBFont;
import jsbchart.graphics.text.TextDirection;
import jsbchart.graphics.text.TextLayoutPreferences;
import jsbchart.graphics.text.TextSettings;
import jsbchart.graphics.text.VerticalAlignment;
import jsbchart.panel.PanelTaxonBase;
import jsbchart.panel.PanelTaxonGroup;
import jsbchart.panel.PanelTaxonOcc;
import jsbchart.panel.PanelTaxonProperties;
import jsbchart.panel.PanelTaxonPropertiesBase;
import jsbchart.panel.PanelTaxonType;
import jsbchart.panel.SBPanel;
import jsbchart.panel.SBPanelHTML;
import jsbchart.util.ChartImage;
import jsbchart.util.ChartObject;
import jsbchart.util.ChartObjectCompareDepth;
import jsbchart.util.TickScheme;
import model3.AnalystHeader;
import model3.CompositeStandard;
import model3.CompositeStandardEvent;
import model3.IGDScheme;
import model3.IGDUnit;
import model3.Sample;
import model3.Smpdtl;
import model3.Taxon;
import model3.TaxonOcc;
import model3.TxGroup;
import model3.TxGroupSet;
import model3.Well;
import model3.WellEvent;
import model3.WellInterp;
import org.apache.commons.lang3.StringUtils;
import util.ColourUtils;
import util.NumberUtils;
import util.RectUtils;
import util.SB;
import util.SBException;
import util.SBObservable;
import util.exception.StackError;

public class PanelTaxon
extends PanelTaxonBase
implements TaxonImageService.TaxonImageListener {
    private static final Logger LOGGER = Logger.getLogger(PanelTaxon.class.getName());
    private static final int PA_COUNT = 5;
    private static final float EVENT_TRACK_COLOUR_FACTOR = 0.25f;
    private static final int MAX_TOOLTIP_CURVE_NAMES = 1015;
    private static final float HIST_MIN = 0.35f;
    private static final float HIST_TOTAL_DELTA = 1.0E-4f;
    private int nTracks;
    private int nCurves;
    private float[][][] curveData;
    private boolean[][] curveHasOutsideCount;
    private String[][] curveLabels;
    private Color[] analystColours;
    private boolean[][] markerData;
    private float maxDrawnTitleHeight = 0.0f;
    private final float INNER_CAPTION_PADDING = 1.0f;
    Color[][] colours;
    private List<TaxonTrack> tracks = new ArrayList<TaxonTrack>();
    private LinkedList<ChartImage> images;
    private ChartObject[][] events;
    private final HashMap<Integer, Set<AnalystHeader>> semiQuantSuites = new HashMap();
    static final float CUTOFF_WIDTH = 1.0f;
    List<Integer> specTypes = null;
    private static EnumMap<PanelTaxonProperties.Group, String[]> templateNames = new EnumMap(PanelTaxonProperties.Group.class);
    private static EnumMap<PanelTaxonProperties.Group, float[][]> templateData = new EnumMap(PanelTaxonProperties.Group.class);
    private static Color[] templateColours = new Color[]{new Color(148, 49, 99), new Color(204, 51, 51), new Color(235, 137, 33), new Color(254, 191, 16), new Color(255, 242, 89), new Color(51, 83, 167), new Color(33, 182, 168), new Color(132, 207, 150)};
    private static float[][] diversityTemplateData;

    List<TaxonTrack> getTracks() {
        return this.tracks;
    }

    private void putSemiQuantSuite(AnalystHeader hdr) {
        int abnSchID = hdr.getAbnSchID();
        if (abnSchID < 1) {
            return;
        }
        if (this.semiQuantSuites.get(abnSchID) == null) {
            HashSet<AnalystHeader> set = new HashSet<AnalystHeader>();
            set.add(hdr);
            this.semiQuantSuites.put(abnSchID, set);
        } else {
            this.semiQuantSuites.get(abnSchID).add(hdr);
        }
    }

    private PanelTaxonProperties p() {
        return (PanelTaxonProperties)this.getPanelTaxonOcc().getProperties();
    }

    public PanelTaxonProperties getProperties() {
        return this.p();
    }

    private boolean isOverplot() {
        return this.getPanelTaxonOcc().isOverplot();
    }

    @Override
    PanelTaxonPropertiesBase getPanelTaxonProperties() {
        return this.p();
    }

    @Override
    void terminate() {
        this.curveData = null;
        this.curveLabels = null;
        this.nTracks = 0;
        this.tracks.clear();
    }

    private Color getDefaultColour() {
        if (this.p().inheritFilterColour) {
            if (this.getFilterCat() != null) {
                return this.getFilterCat().getColour();
            }
            if (this.getFilterGroup() != null) {
                return this.getFilterGroup().getColour();
            }
        }
        return this.p().colour;
    }

    @Override
    public void update(Observable o, Object arg) {
        boolean changed = false;
        if (o instanceof TxGroup) {
            TxGroup group = (TxGroup)o;
            if (this.p().group == PanelTaxonProperties.Group.GROUP || this.getFilterGroup() == group || this.p().highlightGroup == group) {
                this.setDataChanged();
            } else {
                group.deleteWeakObserver((Observer)this);
            }
        } else if (o instanceof TxGroupSet) {
            TxGroupSet set = (TxGroupSet)o;
            if (this.getFilterSet() == set) {
                this.setDataChanged();
            } else {
                set.deleteWeakObserver((Observer)this);
            }
        } else if (o instanceof WellInterp) {
            if (arg != null && (arg instanceof WellEvent || arg.getClass() == Integer.class && ((Integer)arg).equals(20)) && this.p().drawEvents) {
                this.setDataChanged();
            }
        } else if (o instanceof CompositeStandard || o instanceof IGDScheme) {
            if (!(o != this.p().cmpStd && o != this.p().hdrScheme || this.p().track_style != PanelTaxonProperties.Track.SINGLE || this.p().group != PanelTaxonProperties.Group.SPEC && this.p().group != PanelTaxonProperties.Group.GROUP)) {
                this.setDataChanged();
            } else {
                ((SBObservable)o).deleteWeakObserver((Observer)this);
            }
        }
        this.notifyListeners();
    }

    private static String getPanelTotalTitle(PanelTaxonProperties p) {
        assert (p.group == PanelTaxonProperties.Group.TOTAL);
        String trackTitle = p.normaliseWeight || p.useSplits ? "Normalised count" : PanelTaxonProperties.Group.TOTAL.getCurveNames()[0];
        return trackTitle;
    }

    @Override
    String getCaption() {
        String caption = super.getCaption();
        if (caption != null && this.p().track_style == PanelTaxonProperties.Track.SINGLE && this.tracks.size() == 1) {
            TaxonTrack track = this.tracks.get(0);
            if (track.attName != null && track.attName.toString().contains(caption)) {
                return null;
            }
            if (this.getFilterCat() != null && caption.equalsIgnoreCase(this.getFilterCat().getMnemonic()) && track.name.contains(this.getFilterCat().getName())) {
                return null;
            }
        }
        return caption;
    }

    PanelTaxon(PanelTaxonGroup parent, PanelTaxonOcc occ) {
        super(parent, occ == null ? new PanelTaxonOcc(PanelTaxonType.TAXON, true, null, null, false) : occ);
    }

    PanelTaxon(PanelTaxonGroup parent, PanelTaxonOcc occ, PanelTaxonOcc.Filter filter) {
        super(parent, occ, filter);
    }

    @Override
    public String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        Object o = this.getObject(x, y, cp, bp, zoom);
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return o.toString();
        }
        if (o instanceof PanelTaxonObject) {
            PanelTaxonObject pto = (PanelTaxonObject)o;
            if (pto.track.getTaxon() != null && pto.smpdtl != null) {
                model3.Taxon t = pto.track.getTaxon();
                Object strg = pto.smpdtl.getOccurString(t);
                if (!((String)strg).isEmpty()) {
                    String taxonString = pto.track.object instanceof model3.Taxon ? pto.track.name : t.toString(this.p().hdr_author);
                    taxonString = taxonString.replaceAll("<", "&LT;").replaceAll(">", "&GT;");
                    strg = "<html><b>" + taxonString + " " + pto.sample.toString(bp.getUnits()) + "  " + pto.smpdtl.getHeader().toString() + " (" + (String)strg + ")</b>";
                }
                if (pto.event != null) {
                    strg = ((String)strg).isEmpty() ? "<html>" : (String)strg + "<br>";
                    strg = (String)strg + pto.event.toString(true, true, false, bp.getUnits(), true, false, false);
                }
                if (!((String)strg).isEmpty()) {
                    return (String)strg + "</html>";
                }
            } else if (pto.track.curveNames != null && pto.track.curveNames.length > 0) {
                if (pto.track.curveNames.length > 1015) {
                    return pto.sample.toString(bp.getUnits());
                }
                int trackIndex = this.tracks.indexOf(pto.track);
                int sampleIndex = -1;
                for (int i = 0; i < this.parent.plotSmpdtl.length; ++i) {
                    if (this.parent.plotSmpdtl[i].getSample() != pto.sample) continue;
                    sampleIndex = i;
                    break;
                }
                String curves = "<html><strong>" + pto.sample.toString(bp.getUnits()) + "</strong><br>";
                boolean trackNameShown = false;
                float[] arr = new float[3];
                for (int curveIndex = 0; curveIndex < pto.track.curveNames.length; ++curveIndex) {
                    int count;
                    String c = pto.track.curveNames[curveIndex];
                    if (sampleIndex >= 0 && (count = (int)this.getSampleCountFromCurveData(sampleIndex, trackIndex, curveIndex)) == 0) continue;
                    if (!trackNameShown && pto.track.curveNames.length > 1) {
                        curves = curves + pto.track.name + "<br>";
                        trackNameShown = true;
                    }
                    boolean strongColour = false;
                    if (!this.p().colourSuites && this.colours[0] != null && this.colours[0].length > 0 && this.colours[0].length > curveIndex) {
                        Color color = pto.track.curveNames.length > 1 ? this.colours[trackIndex][curveIndex] : this.colours[trackIndex][0];
                        if (color == null) {
                            color = this.p().colour;
                        }
                        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), arr);
                        if ((double)arr[1] < 0.6) {
                            curves = curves + "<strong>";
                            strongColour = true;
                        }
                        curves = curves + SBPanelHTML.getHTMLFontColour(color);
                    }
                    curves = pto.track.curveNames.length > 1 ? curves + c + (c.length() > 5 ? "<br>" : " ") : curves + pto.track.name + "<br>";
                    if (!strongColour) continue;
                    curves = curves + "</strong>";
                }
                return curves + "</html>";
            }
            return "<html>" + pto.track.name + "<br>" + pto.sample.toString(bp.getUnits()) + "</html>";
        }
        if (o instanceof TaxonTrack) {
            TaxonTrack t = (TaxonTrack)o;
            Object headerString = "";
            if (t.hasHeaderData()) {
                headerString = " (";
                if (t.minAge != null) {
                    headerString = (String)headerString + SB.floatString((double)t.minAge, (int)2).trim() + "Ma ";
                }
                if (t.unit1 != null) {
                    headerString = (String)headerString + t.unit1;
                }
                if (t.unit2 != null) {
                    headerString = (String)headerString + (t.unit1 != null ? " - " : "") + t.unit2;
                }
                if (t.maxAge != null) {
                    headerString = (String)headerString + (!((String)headerString).isEmpty() ? " " : "") + SB.floatString((double)t.maxAge, (int)2).trim() + "Ma";
                }
                headerString = (String)headerString + ")";
            }
            headerString = t.name + (String)headerString;
            return headerString;
        }
        if (o instanceof Sample) {
            Sample sample = (Sample)o;
            return sample.toString(bp.getUnits());
        }
        if (o instanceof ChartImage) {
            ChartImage ci = (ChartImage)o;
            TaxonOcc occ = (TaxonOcc)ci.getObject();
            Smpdtl dtl = this.parent.getSample(ci.getOrigTop(), zoom, bp, null);
            if (dtl == null) {
                return null;
            }
            if (!dtl.getOccurUnsorted().contains(occ)) {
                dtl = null;
            }
            Object retString = occ.getTaxon().toString(false, false, true);
            if (dtl != null) {
                retString = (String)retString + " " + String.valueOf(dtl.getSample()) + "  " + dtl.getHeader().toString();
            }
            retString = (String)retString + " (" + occ.toAbnString() + ")";
            return "Image: " + (String)retString;
        }
        assert (false);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        float xPos = 0.0f;
        List<TaxonTrack> list = this.tracks;
        synchronized (list) {
            Iterator<TaxonTrack> it = this.tracks.iterator();
            TaxonTrack track = null;
            while (it.hasNext()) {
                TaxonTrack t = it.next();
                if (x > xPos && x <= xPos + t.width) {
                    track = t;
                    break;
                }
                xPos += t.width;
            }
            if (track == null && this.p().showImages && this.images != null) {
                for (ChartImage image : this.images) {
                    if (!(y > image.getMovedTop()) || !(y < image.getMovedTop() + image.getHeight())) continue;
                    return image;
                }
                return null;
            }
            Smpdtl dtl = this.parent.getSample(y, zoom, bp, track);
            if (dtl != null && track != null) {
                PanelTaxonObject pto = new PanelTaxonObject(this, track, dtl.getSample(), dtl);
                if (this.p().drawEvents && this.events != null && this.events[this.tracks.indexOf(track)] != null) {
                    for (ChartObject co : this.events[this.tracks.indexOf(track)]) {
                        try {
                            if (co.getSample() != dtl.getSample()) continue;
                            pto.event = (WellEvent)co.getO();
                        }
                        catch (SBException sbe) {
                            sbe.printStackTrace();
                        }
                    }
                }
                return pto;
            }
            if (track != null) {
                return track;
            }
            return null;
        }
    }

    @Override
    synchronized float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode, int firstSample, int lastSample, Integer iKey, HashSet<CorrelationPoint> eventLines, List<String> overplotStackSubHeaders, float headerKeyHeight) {
        Category cat;
        boolean firstOrOnly;
        boolean bl = firstOrOnly = bp == this.getBlock().getProp() || (double)Math.abs(bp.getMin() - this.getBlock().getTopDepth()) < 0.01;
        if (!g.isVisible(x, firstOrOnly ? y : this.getBlock().scaleDepth(bp.getNormal() ? bp.getMin() : bp.getMax()) + y + this.getBlock().getPanelHeaderHeight(cp, mode), this.getWidth(bp), bp.getHeight() + (bp == this.getBlock().getProp() ? this.getPanelHeaderHeight(cp, mode) : 0.0f)) && !cp.keyIsVisible()) {
            return x + this.getWidth(bp);
        }
        float xpos = x;
        if (this.p().grid && !this.isOverplot()) {
            this.drawGrid(g, xpos, y, cp, bp, mode);
        }
        xpos = x;
        boolean firstOrOnlyBlock = this.getBlock().getProp() == bp || (double)Math.abs(this.getBlock().getTopDepth() - bp.getMin()) < 0.01;
        float lineTop = firstOrOnlyBlock ? y + this.getPanelHeaderHeight(cp, mode) : Math.min(this.getBlock().scaleDepth(bp.getMin()), this.getBlock().scaleDepth(bp.getMax())) + y + this.getPanelHeaderHeight(cp, mode);
        float lineBase = lineTop + bp.getHeight();
        if (cp.key != null && cp.keyIsVisible() && cp.key.abnSchemes && !this.semiQuantSuites.isEmpty()) {
            Color c = null;
            Color[][] colorArray = this.colours;
            int n = colorArray.length;
            block2: for (int i = 0; i < n; ++i) {
                Color[] arr;
                for (Color current : arr = colorArray[i]) {
                    Color c1;
                    Color color = c1 = current == null ? this.p().colour : current;
                    if (c == null) {
                        c = c1;
                        continue;
                    }
                    if (c1.equals(c)) continue;
                    c = null;
                    break block2;
                }
            }
            for (Integer abnSchID : this.semiQuantSuites.keySet()) {
                cp.getKeyData().putAbnScheme(this.getBlock().getDb().getAbundanceSchemeService().findAbundanceScheme(abnSchID.intValue()).orElse(null), c);
            }
        }
        if (cp.key != null && cp.key.categories && (cat = this.getFilterCat()) != null) {
            cp.getKeyData().putCategory(cat);
        }
        g.setStroke(0.1f);
        float fontSize = cp.getFontSize();
        g.setFont(cp.font, 0, fontSize);
        xpos = this.drawTracks(g, cp, fontSize, iKey, firstOrOnlyBlock, mode, y, xpos, firstSample, lastSample, lineTop, lineBase, bp, eventLines, overplotStackSubHeaders, headerKeyHeight);
        Rectangle2D.Float captionArea = this.getCaption() == null || StringUtils.isEmpty((CharSequence)this.parent.convertCaption(this.getCaption(), cp)) || !this.parent.isFirstOrOnlyBlock(bp) || this.parent.getNumPanels() == 1 || this.getWidth(bp) == 0.0f || mode == Chart.Mode.NO_HEADER ? new Rectangle2D.Float(x, y + cp.panelCaptionHeight + headerKeyHeight, 0.0f, 0.0f) : this.drawInnerCaptionInternal(g, x, y + cp.panelCaptionHeight, cp, bp, firstOrOnlyBlock, mode, overplotStackSubHeaders, headerKeyHeight);
        this.drawSubHeaders(firstOrOnlyBlock, mode, bp, captionArea.y + captionArea.height, cp, fontSize, overplotStackSubHeaders, g, x);
        try {
            if (this.p().showImages && this.images != null && !this.images.isEmpty()) {
                this.drawImagesPanel(g, y, xpos, bp, cp, mode);
                xpos += this.p().imageWidth;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return xpos;
    }

    private float drawTracks(SBGraphics g, ChartProperties cp, float fontSize, Integer iKey, boolean firstOrOnlyBlock, Chart.Mode mode, float y, float xpos, int firstSample, int lastSample, float lineTop, float lineBase, BlockProperties bp, HashSet<CorrelationPoint> eventLines, List<String> overplotStackSubHeaders, float headerKeyHeight) {
        g.setFont(cp.font, 0, fontSize);
        int nTrack = 0;
        float keyWidth = 0.0f;
        float catWidth = 0.0f;
        if (this.p().group == PanelTaxonProperties.Group.SPEC || this.p().group == PanelTaxonProperties.Group.GENUS) {
            if (this.parent.alphabeticKey() && iKey != null) {
                keyWidth = g.stringWidth("  " + (iKey.intValue() + this.tracks.size() - 1));
            }
            if (this.p().hdr_cat) {
                for (TaxonTrack track : this.tracks) {
                    catWidth = Math.max(g.stringWidth(track.getToken(0) + "  "), catWidth);
                }
            }
        }
        boolean plotIkey = this.p().group == PanelTaxonProperties.Group.SPEC || this.p().group == PanelTaxonProperties.Group.GENUS;
        Map<AttributedCharacterIterator.Attribute, Object> atts = SBPanel.getAttributes(g);
        int trackNo = 0;
        this.maxDrawnTitleHeight = g.getTextMeasurer().calculateTextHeight("*10", new TextSettings(HorizontalAlignment.Centre, VerticalAlignment.Middle, TextDirection.Vertical, SBFont.buildFontFromGraphics(g, fontSize)));
        if (this.p().hdr_cat) {
            this.maxDrawnTitleHeight += catWidth;
        }
        for (TaxonTrack track : this.tracks) {
            g.setColor(cp.foreground);
            g.setFontSize(cp.getFontSize());
            if (!(this.isOverplot() && this.parent.overplotDataMatches(this) || !firstOrOnlyBlock || mode == Chart.Mode.NO_HEADER)) {
                try {
                    this.drawTrackHeader(g, cp, y, xpos, track, nTrack, atts, (Integer)(plotIkey ? iKey : null), keyWidth, catWidth, bp, overplotStackSubHeaders, headerKeyHeight);
                    if (plotIkey && iKey != null) {
                        String[] stringArray = iKey;
                        iKey = iKey.intValue() + 1;
                    }
                }
                catch (SQLException sql) {
                    System.out.println("Error drawing panel taxon header for track " + track.name);
                    sql.printStackTrace();
                }
            }
            if (this.p().highlightMarkers && this.markerData != null && this.p().track_style == PanelTaxonProperties.Track.SINGLE) {
                this.drawMarkerHighlighting(firstSample, lastSample, y, cp, mode, g, xpos, track, nTrack);
            }
            if (this.p().justify == PanelTaxonProperties.Justify.CENTRE) {
                if (this.p().plot_style != PanelTaxonProperties.Plot.NUMBERS && !this.p().abn_style.setSemiQuant()) {
                    g.drawLine(xpos + track.width / 2.0f, lineTop, xpos + track.width / 2.0f, lineBase);
                } else if (this.p().grid && trackNo > 0 && Math.abs(Math.IEEEremainder(trackNo, 5.0)) < 0.001) {
                    g.setDashStroke(0.1f, 1.7f);
                    g.setColor(Color.LIGHT_GRAY);
                    g.drawLine(xpos, lineTop, xpos, lineBase);
                    g.setColor(cp.foreground);
                    g.setStroke(0.1f);
                }
                ++trackNo;
            } else {
                g.drawLine(xpos + track.width, lineTop, xpos + track.width, lineBase);
            }
            this.drawScaleTicks(g, bp, cp, xpos, y + this.getPanelHeaderHeight(cp, mode) + (firstOrOnlyBlock ? 0.0f : this.getBlock().scaleDepth(bp.getNormal() ? bp.getMin() : bp.getMax())), track.width);
            if (this.p().stratRange && this.p().track_style == PanelTaxonProperties.Track.SINGLE) {
                this.drawStratigraphicRange(g, bp, xpos, y + this.getPanelHeaderHeight(cp, mode), nTrack, track.width, firstSample, lastSample);
            }
            g.setFontSize(cp.getFontSizeTiny());
            if (firstSample != lastSample) {
                switch (this.p().plot_style) {
                    case HIST: {
                        this.drawHistograms(g, cp, y + this.getPanelHeaderHeight(cp, mode), xpos, nTrack, track.width, firstSample, lastSample);
                        break;
                    }
                    case STICKNDOT: 
                    case SAWTOOTH: {
                        this.drawSawtooth(g, cp, y + this.getPanelHeaderHeight(cp, mode), xpos, nTrack, track.width, firstSample, lastSample, true);
                        if (!this.p().sawtoothEnhanced) break;
                    }
                    case CURVE: {
                        this.drawSawtooth(g, cp, y + this.getPanelHeaderHeight(cp, mode), xpos, nTrack, track.width, firstSample, lastSample, false);
                        break;
                    }
                    case NUMBERS: {
                        this.drawLabels(g, cp, xpos, y + this.getPanelHeaderHeight(cp, mode), nTrack, track.width, firstSample, lastSample);
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
            }
            if (this.p().drawEvents && this.events != null && this.p().justify != PanelTaxonProperties.Justify.CENTRE) {
                this.drawEvents(g, xpos, y + this.getPanelHeaderHeight(cp, mode), nTrack, track.width, cp, bp, eventLines);
            }
            if (cp.key != null && cp.keyIsVisible()) {
                switch (this.p().track_style) {
                    case SINGLE: {
                        Category cat;
                        if (cp.key.txGroups && track.object instanceof TxGroup) {
                            cp.getKeyData().putTxGroup((TxGroup)track.object);
                        }
                        if (!cp.key.categories || this.p().group != PanelTaxonProperties.Group.CAT || (cat = (Category)this.getBlock().getDb().getCategoryService().findCategory(track.name).get()) == null) break;
                        cp.getKeyData().putCategory(cat);
                        break;
                    }
                    case MULTI: {
                        Category cat;
                        if (cp.key.txGroups && this.p().group == PanelTaxonProperties.Group.GROUP) {
                            try {
                                cat = this.getTxGroups().iterator();
                                while (cat.hasNext()) {
                                    TxGroup group = cat.next();
                                    cp.getKeyData().putTxGroup(group);
                                }
                            }
                            catch (SQLException sql) {
                                sql.printStackTrace();
                            }
                        }
                        if (!cp.key.categories || this.p().group != PanelTaxonProperties.Group.CAT) break;
                        for (String curveName : track.curveNames) {
                            cp.getKeyData().putCategory((Category)this.getBlock().getDb().getCategoryService().findCategory(curveName).get());
                        }
                        break;
                    }
                }
            }
            xpos += track.width;
            ++nTrack;
        }
        return xpos;
    }

    private void drawSubHeaders(boolean firstOrOnlyBlock, Chart.Mode mode, BlockProperties bp, float yStart, ChartProperties cp, float fontSize, List<String> overplotStackSubHeaders, SBGraphics g, float x) {
        float headerYStart = yStart;
        if (this.isOverplot() && !overplotStackSubHeaders.isEmpty()) {
            headerYStart += fontSize * (float)overplotStackSubHeaders.size();
        }
        if (firstOrOnlyBlock && mode != Chart.Mode.NO_HEADER && this.parent.getnSamples() > 0 && this.p().hdr_key && this.getWidth(bp) > 0.0f) {
            String abnHdr;
            String dataInclusion;
            float hdrtextpos = headerYStart + fontSize;
            g.setFont(cp.font, 0, fontSize);
            g.setColor(cp.foreground);
            if (!this.isOverplot() && (dataInclusion = this.getDataInclusionDescriptor()) != null) {
                this.drawSubHeader(g, x, hdrtextpos, bp, cp, dataInclusion);
                hdrtextpos += fontSize;
                overplotStackSubHeaders.add(dataInclusion);
            }
            if (!((abnHdr = this.getAbnHeader(g)).isEmpty() || this.isOverplot() && overplotStackSubHeaders.contains(abnHdr))) {
                this.drawSubHeader(g, x, hdrtextpos, bp, cp, abnHdr);
                hdrtextpos += fontSize;
                overplotStackSubHeaders.add(abnHdr);
            }
            try {
                if (this.p().subgroup != PanelTaxonProperties.SubGroup.NONE) {
                    this.drawSubGroupHeader(g, x, hdrtextpos, cp, bp);
                    hdrtextpos += fontSize;
                    overplotStackSubHeaders.add(this.toString());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                hdrtextpos += fontSize;
            }
            if (this.p().highlightGroup != null && this.p().group == PanelTaxonProperties.Group.SPEC) {
                g.setColor(this.p().highlightColour);
                String hString = "Highlighted: " + this.p().highlightGroup.toString();
                if (!this.isOverplot() || !overplotStackSubHeaders.contains(hString)) {
                    this.drawSubHeader(g, x, hdrtextpos, bp, cp, hString);
                    g.setColor(cp.foreground);
                    hdrtextpos += fontSize;
                    overplotStackSubHeaders.add(hString);
                }
            }
            Object weightSplitString = "";
            if (this.p().normaliseWeight && !this.p().abn_style.setSemiQuant() && this.p().calc_style != PanelTaxonProperties.Calc.RICHNESS && !this.p().calc_style.isDiversity) {
                weightSplitString = (String)weightSplitString + "Per " + SB.round((double)this.p().normalWeight, (int)0) + "g";
            }
            if (this.p().useSplits && !this.p().abn_style.setSemiQuant()) {
                if (!((String)weightSplitString).isEmpty()) {
                    weightSplitString = (String)weightSplitString + "; ";
                }
                weightSplitString = (String)weightSplitString + "Split factors applied";
            }
            if (!(((String)weightSplitString).isEmpty() || this.isOverplot() && overplotStackSubHeaders.contains(weightSplitString))) {
                this.drawSubHeader(g, x, hdrtextpos, bp, cp, (String)weightSplitString);
                overplotStackSubHeaders.add((String)weightSplitString);
            }
        }
    }

    private float calcSubHeadersHeight(boolean firstOrOnlyBlock, Chart.Mode mode, BlockProperties bp, List<String> overplotStackSubHeaders, SBGraphics g, float fontSize) {
        int count = this.countSubHeaders(firstOrOnlyBlock, mode, bp, overplotStackSubHeaders, g);
        float subHeaderHeight = (float)count * fontSize + 0.5f * fontSize;
        return subHeaderHeight;
    }

    private int countSubHeaders(boolean firstOrOnlyBlock, Chart.Mode mode, BlockProperties bp, List<String> overplotStackSubHeaders, SBGraphics g) {
        int count = 0;
        if (firstOrOnlyBlock && mode != Chart.Mode.NO_HEADER && this.parent.getnSamples() > 0 && this.p().hdr_key && this.getWidth(bp) > 0.0f) {
            String abnHdr;
            String dataInclusion;
            if (!this.isOverplot() && (dataInclusion = this.getDataInclusionDescriptor()) != null) {
                ++count;
            }
            if (!((abnHdr = this.getAbnHeader(g)).isEmpty() || this.isOverplot() && overplotStackSubHeaders.contains(abnHdr))) {
                ++count;
            }
            if (this.p().subgroup != PanelTaxonProperties.SubGroup.NONE) {
                ++count;
            }
            if (this.p().highlightGroup != null && this.p().group == PanelTaxonProperties.Group.SPEC) {
                ++count;
            }
            Object weightSplitString = "";
            if (this.p().normaliseWeight && !this.p().abn_style.setSemiQuant() && this.p().calc_style != PanelTaxonProperties.Calc.RICHNESS && !this.p().calc_style.isDiversity) {
                weightSplitString = (String)weightSplitString + "Per " + SB.round((double)this.p().normalWeight, (int)0) + "g";
            }
            if (this.p().useSplits && !this.p().abn_style.setSemiQuant()) {
                if (!((String)weightSplitString).isEmpty()) {
                    weightSplitString = (String)weightSplitString + "; ";
                }
                weightSplitString = (String)weightSplitString + "Split factors applied";
            }
            if (!(((String)weightSplitString).isEmpty() || this.isOverplot() && overplotStackSubHeaders.contains(weightSplitString))) {
                ++count;
            }
        }
        return count;
    }

    private void drawSubHeader(SBGraphics g, float x, float yPos, BlockProperties bp, ChartProperties cp, String headerText) {
        if (!g.drawString(headerText, x + 1.0f, yPos, this.getWidth(bp), 1, false)) {
            int key = cp.getKeyData().putText(headerText);
            g.drawString("*" + String.valueOf(cp.keyIsVisible() ? Integer.valueOf(key) : ""), x + 1.0f, yPos);
        }
    }

    Rectangle2D.Float drawInnerCaptionInternal(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, boolean firstOrOnlyBlock, Chart.Mode mode, List<String> overplotStackSubHeaders, float headerKeyHeight) {
        String caption = this.getCaption();
        caption = this.parent.convertCaption(caption, cp);
        float fontSize = cp.getFontSizePanel();
        g.setFont(cp.font, 1, fontSize);
        float panelSubHeaderHeight = this.getBlock().getHeaderHeight(cp) - cp.panelCaptionHeight;
        float subHeadersHeight = this.calcSubHeadersHeight(true, Chart.Mode.NORMAL, bp, overplotStackSubHeaders, g, cp.getFontSize());
        float minCaptionHeight = this.getMinInnerCaptionHeight(g, cp);
        float maxCaptionHeight = panelSubHeaderHeight - this.maxDrawnTitleHeight - subHeadersHeight - headerKeyHeight;
        if (maxCaptionHeight < minCaptionHeight) {
            maxCaptionHeight = minCaptionHeight;
        }
        Rectangle2D.Float box = new Rectangle2D.Float(x, y + headerKeyHeight, this.getWidth(bp), minCaptionHeight + 0.01f);
        box = RectUtils.makeSmallerRect((Rectangle2D.Float)box, (float)1.0f);
        TextLayoutPreferences prefs = new TextLayoutPreferences().setHorizontalAlignment(HorizontalAlignment.Centre).setTextDirection(TextDirection.Horizontal).setVerticalAlignment(VerticalAlignment.Top).truncateText().wrapText().setFont(SBFont.buildFontFromGraphics(g, fontSize));
        boolean willFit = g.willStringFitWithinBox(caption, box, prefs);
        float lineHeight = g.getTextMeasurer().calculateHorizontalLineHeight(prefs.getFont());
        if (!willFit) {
            box = new Rectangle2D.Float(x, y + headerKeyHeight, this.getWidth(bp), maxCaptionHeight);
            box = RectUtils.makeSmallerRect((Rectangle2D.Float)box, (float)1.0f);
            if ((double)box.width < (double)lineHeight * 3.5) {
                prefs.setTextDirection(TextDirection.Vertical);
            }
        }
        Rectangle2D.Float drawnArea = g.drawStringWithinBox(caption, box, prefs);
        drawnArea = RectUtils.getRectWithBorder((Rectangle2D.Float)drawnArea, (float)1.0f);
        g.drawLine(x, drawnArea.y + drawnArea.height, x + this.getWidth(bp), drawnArea.y + drawnArea.height);
        return drawnArea;
    }

    private float getMinInnerCaptionHeight(SBGraphics g, ChartProperties cp) {
        SBFont f = SBFont.buildFontFromGraphics(g, cp.getFontSizePanel());
        return g.calculateLineHeight(f) + 2.0f;
    }

    @Override
    boolean drawInnerCaption(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp) {
        return false;
    }

    private void drawMarkerHighlighting(int firstSample, int lastSample, float y, ChartProperties cp, Chart.Mode mode, SBGraphics g, float xpos, TaxonTrack track, int trackNum) {
        for (int i = firstSample; i < lastSample; ++i) {
            if (!this.markerData[i][trackNum]) continue;
            float sampleY = y + this.getPanelHeaderHeight(cp, mode) + this.parent.getSamplePosition(i);
            Color old = g.getColor();
            g.setColor(new Color(255, 255, 100));
            g.fillRect(xpos, sampleY - this.p().hist_height * 0.5f, track.width, this.p().hist_height);
            g.setColor(old);
        }
    }

    private String getAbnHeader(SBGraphics g) {
        Object hdr = "";
        if (this.p().group == PanelTaxonProperties.Group.TOTAL) {
            return hdr;
        }
        if (this.p().abn_style.setSemiQuant()) {
            hdr = (String)hdr + String.valueOf((Object)this.p().abn_style);
            if (!this.semiQuantSuites.isEmpty()) {
                hdr = (String)hdr + " [";
                hdr = this.semiQuantSuites.size() > 1 ? (String)hdr + StringUtils.join(this.semiQuantSuites.entrySet().stream().map(e -> this.getBlock().getDb().getAbundanceSchemeService().findAbundanceScheme(((Integer)e.getKey()).intValue()).map(AbundanceScheme::toString).orElse("") + " (" + StringUtils.join((Iterable)((Iterable)e.getValue()), (String)", ") + ")").toList(), (String)", ") : (String)hdr + String.valueOf(this.semiQuantSuites.entrySet().stream().findFirst().map(e -> this.getBlock().getDb().getAbundanceSchemeService().findAbundanceScheme(((Integer)e.getKey()).intValue()).map(AbundanceScheme::toString).orElse("")));
                hdr = (String)hdr + "]";
            }
        } else {
            switch (this.p().calc_style) {
                case ABS: {
                    float tickInt = this.p().maxWidth / this.p().cutoff;
                    int tickNo = 1;
                    while (tickInt < 1.0f) {
                        tickInt *= 10.0f;
                        tickNo *= 10;
                    }
                    Object[] objectArray = new Object[]{Float.valueOf(this.p().cutoff)};
                    Object[] objectArray2 = new Object[]{Float.valueOf(this.p().maxWidth)};
                    String abnHdrLong = String.valueOf((Object)this.p().abn_style) + " abundance (" + String.format("%.0f", objectArray) + " = " + String.format("%.0f", objectArray2) + "mm, scale tick = " + tickNo + " counts)";
                    if (g.stringWidth(abnHdrLong) > this.getWidth(this.parent.getBlock().getProp())) {
                        Object[] objectArray3 = new Object[]{Float.valueOf(this.p().cutoff)};
                        Object[] objectArray4 = new Object[]{Float.valueOf(this.p().maxWidth)};
                        String abnHdrShort = String.valueOf((Object)this.p().abn_style) + " abundance (" + String.format("%.0f", objectArray3) + " = " + String.format("%.0f", objectArray4) + "mm)";
                        if (g.stringWidth(abnHdrShort) > this.getWidth(this.parent.getBlock().getProp())) {
                            hdr = (String)hdr + abnHdrLong;
                            break;
                        }
                        hdr = (String)hdr + abnHdrShort;
                        break;
                    }
                    hdr = (String)hdr + abnHdrLong;
                    break;
                }
                case RELATIVE: {
                    hdr = (String)hdr + String.valueOf((Object)this.p().abn_style) + " abundance, % panel";
                    break;
                }
                case RELATIVE_OUTER: {
                    hdr = (String)hdr + String.valueOf((Object)this.p().abn_style) + " abundance, % " + this.parent.getDataDescriptor();
                    break;
                }
                case RICHNESS: {
                    hdr = (String)hdr + "species richness";
                    break;
                }
                case SHANNON: {
                    hdr = (String)hdr + "Shannon diversity";
                    break;
                }
                case FISHER: {
                    hdr = (String)hdr + "Fisher's alpha diversity";
                    break;
                }
                case COSINETHETA: {
                    hdr = (String)hdr + "Cosine theta similarity";
                }
            }
        }
        return hdr;
    }

    private String getSubTypeHeader() {
        if (this.p().subTypes != null) {
            try {
                Object specType = "";
                Iterator it = this.p().subTypes.iterator();
                int i = 0;
                while (it.hasNext()) {
                    Integer specTypeID = (Integer)it.next();
                    specType = i == 0 ? (String)specType : (i == this.p().subTypes.size() - 1 ? (String)specType + " and " : (String)specType + ", ");
                    specType = (String)specType + ((SpeciesType)this.parent.getDb().getSpeciesTypeService().getSpeciesType(specTypeID.intValue()).get()).toString();
                    ++i;
                }
                return specType;
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    String getDataInclusionDescriptor() {
        Object hdr = "";
        if (this.p().includeCv != null || this.p().includeQ != null || this.p().includeRw != null || this.p().includeTr != null || this.p().subTypes != null || this.p().exclGroup != null || this.p().includeCn != null) {
            Boolean[] qual = new Boolean[]{this.p().includeRw, this.p().includeQ, this.p().includeCv, this.p().includeTr, this.p().includeCn};
            String[] s = new String[]{"Rw", "?", "Cv", "Tr", "Cn"};
            Object inclusion = "";
            for (int i = 0; i < qual.length; ++i) {
                if (!Objects.equals(qual[i], Boolean.TRUE)) continue;
                inclusion = (String)inclusion + (((String)inclusion).isEmpty() ? "" : ", ") + s[i];
            }
            if (!((String)inclusion).isEmpty()) {
                hdr = (String)hdr + (String)inclusion + " only";
            }
            Object exclusion = "";
            for (int i = 0; i < qual.length; ++i) {
                if (!Objects.equals(qual[i], Boolean.FALSE)) continue;
                exclusion = (String)exclusion + (((String)exclusion).isEmpty() ? "" : ", ") + s[i];
            }
            if (this.p().exclGroup != null) {
                exclusion = (String)exclusion + (((String)exclusion).isEmpty() ? "" : ", ") + "'" + this.p().exclGroup.getName() + "'";
            }
            if (!((String)exclusion).isEmpty()) {
                hdr = (String)hdr + (((String)hdr).isEmpty() ? "" : "; ") + (String)exclusion + " excluded";
            }
            if (this.p().subTypes != null) {
                hdr = (String)hdr + (((String)hdr).isEmpty() ? "" : ", ") + this.getSubTypeHeader();
            }
        }
        if (this.p().thresholdCount > 0) {
            if (!((String)hdr).isEmpty()) {
                hdr = (String)hdr + "; ";
            }
            hdr = (String)hdr + "Min count = " + this.p().thresholdCount;
        }
        if (this.p().onlyIncludeTaxaLinkedToEvents) {
            if (!((String)hdr).isEmpty()) {
                hdr = (String)hdr + "; ";
            }
            hdr = (String)hdr + "Only showing taxon linked to events";
        }
        hdr = !((String)hdr).isEmpty() ? "(" + (String)hdr + ")" : null;
        return hdr;
    }

    private void drawSubGroupHeader(SBGraphics g, float xpos, float ypos, ChartProperties cp, BlockProperties bp) throws SBException, SQLException {
        Color colour;
        Object strg = "Sub-Groups: ";
        String[] subgroups = this.getSubgroups();
        if (subgroups.length == 1 && this.p().subgroup == PanelTaxonProperties.SubGroup.SUBTYPE && subgroups[0] == "<no sub-type>") {
            return;
        }
        Color[] sgColours = new Color[subgroups.length];
        if (!this.p().group.hasColours()) {
            if (this.p().colourSuites) {
                colour = this.parent.getSingleSuiteColour();
                if (colour == null) {
                    colour = cp.foreground;
                }
            } else {
                colour = this.getDefaultColour();
            }
        } else {
            colour = cp.foreground;
        }
        for (int i = 0; i < subgroups.length; ++i) {
            if (i > 0) {
                strg = (String)strg + ", ";
            }
            strg = (String)strg + subgroups[i];
            sgColours[i] = colour;
            colour = ColourUtils.getLighterColour((Color)colour, (float)0.8f);
        }
        AttributedString attString = new AttributedString((String)strg);
        attString.addAttributes(SBPanel.getAttributes(g), 0, attString.getIterator().getEndIndex());
        for (int j = 0; j < subgroups.length; ++j) {
            try {
                int begin = ((String)strg).indexOf(subgroups[j]);
                int end = begin + subgroups[j].length();
                attString.addAttribute(TextAttribute.FOREGROUND, sgColours[j], begin, end);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!g.drawString(attString, xpos + 1.0f, ypos, this.getWidth(bp), false)) {
            int key = cp.getKeyData().putText(attString);
            g.drawString("*" + String.valueOf(cp.keyIsVisible() ? Integer.valueOf(key) : ""), xpos + 1.0f, ypos);
        }
    }

    private float getAgeUnitSize(float availableHeight) {
        if (availableHeight > 68.0f) {
            return availableHeight / 8.0f;
        }
        return 8.5f;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void drawTrackHeader(SBGraphics g, ChartProperties cp, float y, float xpos, TaxonTrack track, int nTrack, Map<AttributedCharacterIterator.Attribute, Object> atts, Integer iKey, float keyWidth, float catWidth, BlockProperties bp, List<String> overplotStackSubHeaders, float headerKeyHeight) throws SQLException {
        float fontSize = cp.getFontSize();
        g.setFontStyle(0);
        g.setFontSize(fontSize);
        boolean leftIndent = true;
        boolean baseIndent = true;
        TextSettings settings = new TextSettings(HorizontalAlignment.Centre, VerticalAlignment.Bottom, TextDirection.Vertical, SBFont.buildFontFromGraphics(g, cp.getFontSize()));
        float trackNameHeight = track.attName != null ? g.getTextMeasurer().calculateTextHeight(track.attName, settings) : g.getTextMeasurer().calculateTextHeight(track.name, settings);
        float titleHeight = trackNameHeight;
        if (this.p().hdr_cat) {
            titleHeight += catWidth;
        }
        if (iKey != null) {
            titleHeight += keyWidth;
        }
        titleHeight += 1.0f;
        float panelSubHeaderHeight = this.getBlock().getHeaderHeight(cp) - cp.panelCaptionHeight;
        float subHeadingsHeight = this.calcSubHeadersHeight(true, Chart.Mode.NORMAL, bp, overplotStackSubHeaders, g, cp.getFontSize());
        float trackTitleTop = y + cp.panelCaptionHeight + headerKeyHeight + subHeadingsHeight;
        float maxTrackTitleHeight = panelSubHeaderHeight - headerKeyHeight - subHeadingsHeight;
        if (this.getCaption() != null) {
            trackTitleTop += this.getMinInnerCaptionHeight(g, cp);
            maxTrackTitleHeight -= this.getMinInnerCaptionHeight(g, cp);
        }
        float maxTrackNameHeight = maxTrackTitleHeight - 1.0f;
        if (this.p().hdr_cat) {
            maxTrackNameHeight -= catWidth;
        }
        if (iKey != null) {
            maxTrackNameHeight -= keyWidth;
        }
        if (titleHeight < maxTrackTitleHeight && titleHeight > this.maxDrawnTitleHeight) {
            this.maxDrawnTitleHeight = titleHeight;
        }
        if (this.p().track_style == PanelTaxonProperties.Track.SINGLE) {
            float ref = y + cp.panelCaptionHeight + (this.parent.alphabeticKey() ? cp.panelSubHeaderHeight / 2.0f : 0.0f) + fontSize + 1.5f;
            float refPlus = 0.0f;
            try {
                if (this.p().hdr_key) {
                    if (this.p().subgroup != PanelTaxonProperties.SubGroup.NONE && this.getSubgroups().length > 1) {
                        refPlus = fontSize + 1.5f;
                        ref += refPlus;
                    }
                    if (this.getDataInclusionDescriptor() != null) {
                        ref += fontSize + 1.5f;
                    }
                }
                if (this.getCaption() != null && this.parent.size() > 1 && !this.parent.alphabeticKey()) {
                    ref += (refPlus += this.parent.getInnerPanelCaptionHeight(cp));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            float ageSpace = 0.0f;
            float ageUnit = this.getAgeUnitSize(cp.panelSubHeaderHeight);
            if (this.parent.alphabeticKey()) {
                ageUnit /= 2.0f;
            }
            ageUnit -= refPlus;
            if (this.p().cmpStd != null) {
                ageSpace += ageUnit * 2.0f;
            }
            if (this.p().hdrScheme != null) {
                ageSpace += ageUnit * 2.0f;
            }
            float textPos = switch (this.p().justify) {
                default -> xpos + fontSize;
                case PanelTaxonProperties.Justify.CENTRE -> xpos + track.width / 2.0f + g.stringHeightSB() / 2.0f;
                case PanelTaxonProperties.Justify.RIGHT -> xpos + track.width - (fontSize - g.stringHeightSB());
            };
            if (this.isOverplot()) {
                switch (this.p().justify) {
                    default: {
                        textPos += (float)this.parent.getOverplotOffset(this) * fontSize;
                        break;
                    }
                    case RIGHT: {
                        textPos -= (float)this.parent.getOverplotOffset(this) * fontSize;
                    }
                }
            }
            if (track.attName != null) {
                boolean highlight;
                track.attName.addAttributes(atts, 0, track.attName.getIterator().getEndIndex());
                float basePos = y + this.parent.getBlock().getHeaderHeight(cp) - 1.0f;
                boolean bl = highlight = this.p().highlightGroup != null && track.object instanceof model3.Taxon && this.p().highlightGroup.isMember(((model3.Taxon)track.object).getSpecID(), this.parent.p.getSynSchID());
                if (highlight) {
                    g.setColor(this.p().highlightColour);
                    track.attName.addAttribute(TextAttribute.FOREGROUND, this.p().highlightColour);
                }
                if (iKey != null) {
                    g.drawStringVertical("" + iKey, textPos, basePos);
                    basePos -= keyWidth;
                }
                boolean trackNameDrawn = false;
                if (this.p().hdr_alphacodes && track.codeName != null && !track.codeName.isEmpty()) {
                    trackNameDrawn = g.drawStringVertical(track.codeName, textPos, basePos - (this.p().hdr_cat ? catWidth : 0.0f), maxTrackNameHeight, false, false, false);
                } else {
                    g.setFontStyle(0);
                    trackNameDrawn = g.drawStringVertical(track.attName, textPos, basePos - (this.p().hdr_cat ? catWidth : 0.0f), maxTrackNameHeight, false);
                    g.setFontStyle(0);
                }
                if (!trackNameDrawn) {
                    if (this.p().hdr_cat) {
                        AttributedString aString = this.toAttString(track.object, true);
                        aString.addAttributes(atts, 0, aString.getIterator().getEndIndex());
                        int key = cp.getKeyData().putText(aString);
                        g.drawStringVertical("*" + String.valueOf(cp.keyIsVisible() ? Integer.valueOf(key) : ""), textPos, basePos);
                    } else {
                        int key = cp.getKeyData().putText(track.attName);
                        g.drawStringVertical("*" + String.valueOf(cp.keyIsVisible() ? Integer.valueOf(key) : ""), textPos, basePos);
                    }
                } else if (this.p().hdr_cat) {
                    g.setFontStyle(0);
                    g.drawStringVertical(track.getToken(0), textPos, basePos, basePos, false, false, true);
                }
                if (highlight) {
                    g.setColor(cp.foreground);
                }
            } else {
                float basePos = y + this.parent.getBlock().getHeaderHeight(cp) - 1.0f;
                if (iKey != null) {
                    g.drawStringVertical("" + iKey, textPos, basePos);
                    basePos -= keyWidth;
                }
                if (!g.drawStringVertical(track.name, textPos, basePos, basePos - ref - (track.hasHeaderData() ? ageSpace : 0.0f), false, false, false)) {
                    int key = cp.getKeyData().putText(track.name);
                    g.drawStringVertical("*" + String.valueOf(cp.keyIsVisible() ? Integer.valueOf(key) : ""), textPos, basePos);
                }
            }
            g.setStroke(0.1f);
            g.setFontStyle(0);
            if (track.maxAge != null) {
                g.drawRect(xpos, ref + ageSpace - ageUnit, track.width, ageUnit);
                g.drawStringVertical(SB.floatString((double)track.maxAge, (int)1).trim(), textPos, ref + ageSpace, ageUnit, false, true, true);
            }
            if (track.minAge != null) {
                g.drawRect(xpos, ref, track.width, ageUnit);
                g.drawStringVertical(SB.floatString((double)track.minAge, (int)1).trim(), textPos, ref + ageUnit, ageUnit, false, true, true);
            }
            if (track.unit2 != null ^ track.unit1 != null) {
                g.fillRect(xpos, ref + (track.unit2 != null && track.minAge == null ? 0.0f : ageUnit), track.width, track.maxAge == null || track.minAge == null ? ageUnit * 3.0f : ageUnit * 2.0f, track.unit2 != null ? track.col2 : track.col1);
                g.drawStringVertical(track.unit2 != null ? track.unit2 : track.unit1, textPos, ref + ageSpace - ageUnit, ageUnit * 2.0f, false, true, true);
                return;
            }
            if (track.unit2 != null) {
                g.setColor(track.col2);
                g.fillRect(xpos, ref + ageUnit * 2.0f, track.width, ageUnit);
                g.setColor(cp.foreground);
                g.drawStringVertical(track.unit2, textPos, ref + ageUnit * 3.0f, ageUnit, false, true, true);
            }
            if (track.unit1 != null) {
                g.setColor(track.col1);
                g.fillRect(xpos, ref + ageUnit, track.width, ageUnit);
                g.setColor(cp.foreground);
                g.drawStringVertical(track.unit1, textPos, ref + ageUnit * 2.0f, ageUnit, false, true, true);
            }
            if (track.unit2 != null && track.unit1 != null) {
                g.drawStringVertical("-", textPos, ref + ageUnit * 2.0f + g.stringWidth("-") / 2.0f, ageUnit, false, false, true);
            }
            if (track.unit2 == null) {
                if (track.unit1 == null) return;
            }
            g.drawRect(xpos, ref + ageUnit, track.width, ageUnit * 2.0f);
            return;
        }
        float boxHeight = g.stringHeightSB();
        float ypos = y + this.parent.getBlock().getHeaderHeight(cp) - 1.0f;
        Color[] fillColours = new Color[track.curveNames.length];
        if (this.p().colourSuites) {
            Color baseColour = this.parent.getSingleSuiteColour();
            if (baseColour == null) {
                baseColour = cp.foreground;
            }
            PanelTaxon.fillColourArray(baseColour, fillColours);
        } else {
            fillColours = this.colours[nTrack];
        }
        boolean hasSpace = true;
        int startKeyNo = 0;
        int endKeyNo = 0;
        int nCurve = track.curveNames.length - 1;
        while (true) {
            boolean drawKey;
            block59: {
                boolean empty;
                block60: {
                    block58: {
                        if (nCurve <= -1) break block58;
                        drawKey = true;
                        if (!this.p().clearEmptyTracks || this.p().group == PanelTaxonProperties.Group.SPEC && this.p().track_style == PanelTaxonProperties.Track.MULTI) break block59;
                        empty = true;
                        break block60;
                    }
                    if (startKeyNo <= 0) return;
                    Object keyString = "*";
                    if (cp.key != null && cp.keyIsVisible()) {
                        keyString = (String)keyString + startKeyNo + (String)(endKeyNo > startKeyNo ? " - " + endKeyNo : "");
                    }
                    g.drawString((String)keyString, xpos + 2.0f, ypos, track.width - 2.0f, 1, true);
                    return;
                }
                for (int nSample = 0; nSample < this.parent.getnSamples(); ++nSample) {
                    if (!(nCurve == 0 && this.curveData[nSample][0][nCurve] > 0.0f) && (nCurve <= 0 || !(this.curveData[nSample][0][nCurve] > this.curveData[nSample][0][nCurve - 1]))) continue;
                    empty = false;
                    break;
                }
                if (empty) {
                    drawKey = false;
                }
            }
            if (drawKey) {
                if (hasSpace) {
                    Color fillColour = fillColours[nCurve] == null ? this.getDefaultColour() : fillColours[nCurve];
                    g.fillRect(xpos + 1.0f, ypos - boxHeight, boxHeight, boxHeight, fillColour);
                    g.drawString(track.curveNames[nCurve], xpos + boxHeight + 2.0f, ypos, track.width - boxHeight - 2.0f, 1, true);
                    ypos = (float)((double)ypos - (double)fontSize * 1.5);
                    if ((double)ypos < (double)(y + cp.panelCaptionHeight + boxHeight) + (double)fontSize * 4.0) {
                        hasSpace = false;
                    }
                } else {
                    endKeyNo = cp.getKeyData().putText(track.curveNames[nCurve]);
                    if (startKeyNo == 0) {
                        startKeyNo = endKeyNo;
                    }
                }
            }
            --nCurve;
        }
    }

    /*
     * Exception decompiling
     */
    private void drawHistograms(SBGraphics g, ChartProperties cp, float y, float xpos, int nTrack, float trackWidth, int firstSample, int lastSample) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.ClassCastException: class org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement cannot be cast to class org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement (org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement and org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement are in unnamed module of loader 'app')
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchExpressionRewriter$LValueSingleUsageCheckingRewriter.rewriteExpression(SwitchExpressionRewriter.java:96)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.LValueExpression.applyExpressionRewriter(LValueExpression.java:84)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredFor.rewriteExpressions(StructuredFor.java:194)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:24)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchExpressionRewriter.rewriteBlockSwitches(SwitchExpressionRewriter.java:140)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchExpressionRewriter.transform(SwitchExpressionRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.switchExpression(Op04StructuredStatement.java:101)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:909)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Color getEventColour(Color c, int nTrack, int nSample) {
        if (this.tracks.get((int)nTrack).object instanceof CompositeStandardEvent && this.p().sortType == PanelTaxonProperties.Sort.SORTAGE && this.events != null) {
            boolean eventIsPicked = false;
            if (this.events[nTrack] != null) {
                CompositeStandardEvent cse = (CompositeStandardEvent)this.tracks.get((int)nTrack).object;
                for (ChartObject co : this.events[nTrack]) {
                    WellEvent wellEvent = (WellEvent)co.getO();
                    if (wellEvent.getEvent() != cse.getEvent() || wellEvent.getTypeObj() != cse.getType()) continue;
                    eventIsPicked = true;
                    if (!(this.parent.plotSmpdtl[nSample].getSample().getDepth() < wellEvent.getSample().getDepth())) break;
                    c = ColourUtils.getLighterColour((Color)c, (float)(switch (wellEvent.getConfidence()) {
                        default -> 0.2f;
                        case Confidence.PROBABLE -> 0.35f;
                        case Confidence.POSSIBLE -> 0.5f;
                    }));
                    break;
                }
            }
            if (!eventIsPicked) {
                return Color.WHITE;
            }
        }
        return c;
    }

    private void drawSawtooth(SBGraphics g, ChartProperties cp, float y, float xpos, int nTrack, float trackWidth, int firstSample, int lastSample, boolean fill) {
        GeneralPath[] gp = null;
        int enhance = 1;
        if (!fill) {
            gp = new GeneralPath[this.nCurves];
            if (this.p().plot_style == PanelTaxonProperties.Plot.SAWTOOTH || this.p().plot_style == PanelTaxonProperties.Plot.STICKNDOT) {
                enhance = this.p().sawtoothEnhancement;
            }
        }
        for (int nSample = firstSample; nSample < lastSample; ++nSample) {
            float[] xp = new float[5];
            float[] yp = new float[5];
            float ypos = y + this.parent.getSamplePosition(nSample);
            if (nSample == 0) {
                if (this.curveData[nSample][nTrack].length <= 0 || !(this.curveData[nSample][nTrack][0] > 0.0f)) continue;
                float width = this.curveData[nSample][nTrack][0] * this.p().horzScale;
                if (width > this.p().maxWidth) {
                    width = this.p().maxWidth;
                }
                if (!fill) continue;
                switch (this.p().justify) {
                    case LEFT: {
                        g.drawLine(xpos, ypos, xpos + width, ypos);
                        break;
                    }
                    case RIGHT: {
                        g.drawLine(xpos + trackWidth, ypos, xpos + trackWidth - width, ypos);
                        break;
                    }
                    case CENTRE: {
                        g.drawLine(xpos + trackWidth / 2.0f - width / 2.0f, ypos, xpos + trackWidth / 2.0f + width / 2.0f, ypos);
                    }
                }
                continue;
            }
            float yposTop = y + this.parent.getSamplePosition(nSample - 1);
            boolean secondPolygon = false;
            float[] total0 = new float[this.nCurves];
            float[] total1 = new float[this.nCurves];
            for (int i = 0; i < this.nCurves; ++i) {
                total0[i] = this.curveData[nSample - 1][nTrack][i] * (float)enhance;
                total1[i] = this.curveData[nSample][nTrack][i] * (float)enhance;
            }
            float yposTop2 = 0.0f;
            float ypos2 = 0.0f;
            if (ypos - yposTop > this.p().sawtoothCutoff) {
                yposTop = ypos - this.p().sawtoothCutoff / 2.0f;
                yposTop2 = y + this.parent.getSamplePosition(nSample - 1);
                ypos2 = yposTop2 + this.p().sawtoothCutoff / 2.0f;
                secondPolygon = true;
            }
            float pxpos = this.p().justify == PanelTaxonProperties.Justify.CENTRE ? xpos + trackWidth / 2.0f : xpos;
            for (int i = this.nCurves - 1; i > -1; --i) {
                GeneralPath segment;
                float[] newypoints;
                float[] newxpoints;
                float thisSampleCount = this.getSampleCountFromCurveData(nSample, nTrack, i);
                float previousSampleCount = this.getSampleCountFromCurveData(nSample - 1, nTrack, i);
                if (thisSampleCount == 0.0f && previousSampleCount == 0.0f) continue;
                Color c = this.colours[nTrack][i];
                if (c == null) {
                    c = this.getDefaultColour();
                }
                c = this.getEventColour(c, nTrack, nSample);
                if (total1[i] > 0.0f || !secondPolygon && total1[i] == 0.0f && total0[i] > 0.0f) {
                    float topWidth = secondPolygon && total0[i] > 0.0f && Math.abs(total1[i] - total0[i]) > 0.0f ? Math.min(total0[i], total1[i]) + Math.abs(total1[i] - total0[i]) / 2.0f : total0[i];
                    this.setPolygonPoints(xp, yp, pxpos, topWidth, yposTop, total1[i], ypos, trackWidth);
                    if (this.p().justify == PanelTaxonProperties.Justify.CENTRE) {
                        newxpoints = new float[8];
                        newypoints = new float[8];
                        this.centrePolygonPoints(xp, yp, newxpoints, newypoints, pxpos);
                        xp = newxpoints;
                        yp = newypoints;
                    }
                    if (fill) {
                        g.fillPolygon(xp, yp, xp.length, c);
                    } else {
                        segment = SBGraphics.createGeneralPath(xp[1], yp[1]);
                        if (Math.abs(xp[2] - xp[1]) > 0.0f || Math.abs(xp[2] - xp[3]) > 0.0f) {
                            SBGraphics.appendLine(segment, xp[2], yp[2]);
                        }
                        SBGraphics.appendLine(segment, xp[3], yp[3]);
                        if (gp[i] == null) {
                            gp[i] = segment;
                        } else {
                            gp[i].append(segment, false);
                        }
                    }
                }
                if (!secondPolygon || !(total0[i] > 0.0f)) continue;
                float topWidth2 = Math.abs(total1[i] - total0[i]) > 0.0f && total1[i] > 0.0f ? Math.min(total0[i], total1[i]) + Math.abs(total1[i] - total0[i]) / 2.0f : total1[i];
                this.setPolygonPoints(xp, yp, pxpos, total0[i], yposTop2, topWidth2, ypos2, trackWidth);
                if (this.p().justify == PanelTaxonProperties.Justify.CENTRE) {
                    newxpoints = new float[8];
                    newypoints = new float[8];
                    this.centrePolygonPoints(xp, yp, newxpoints, newypoints, pxpos);
                    xp = newxpoints;
                    yp = newypoints;
                }
                if (fill) {
                    g.fillPolygon(xp, yp, xp.length, c);
                    continue;
                }
                segment = SBGraphics.createGeneralPath(xp[1], yp[1]);
                if (Math.abs(xp[2] - xp[1]) > 0.0f || Math.abs(xp[2] - xp[3]) > 0.0f) {
                    SBGraphics.appendLine(segment, xp[2], yp[2]);
                }
                SBGraphics.appendLine(segment, xp[3], yp[3]);
                if (gp[i] == null) {
                    gp[i] = segment;
                    continue;
                }
                gp[i].append(segment, false);
            }
        }
        if (gp != null) {
            if (this.p().plot_style == PanelTaxonProperties.Plot.CURVE) {
                g.setStroke(0.3f, 0, 1);
            } else {
                g.setStroke(0.1f, 0, 1);
            }
            for (int i = 0; i < this.nCurves; ++i) {
                GeneralPath path = gp[i];
                if (path == null) continue;
                Color c = this.colours[nTrack][i];
                if (c == null) {
                    this.getDefaultColour();
                }
                g.setColor(c);
                g.drawShape(path);
            }
        }
        if (this.p().plot_style == PanelTaxonProperties.Plot.STICKNDOT) {
            this.drawDotAndStick(g, cp, xpos, y, nTrack, trackWidth, firstSample, lastSample);
        }
        if (this.p().track_style == PanelTaxonProperties.Track.SINGLE) {
            this.drawLabels(g, cp, xpos, y, nTrack, trackWidth, firstSample, lastSample);
        }
    }

    private float getSampleCountFromCurveData(int numSample, int numTrack, int numCurve) {
        if (numCurve == 0) {
            return this.curveData[numSample][numTrack][numCurve];
        }
        return this.curveData[numSample][numTrack][numCurve] - this.curveData[numSample][numTrack][numCurve - 1];
    }

    private void setPolygonPoints(float[] xp, float[] yp, float xpos, float topVal, float yposTop, float baseVal, float yposBase, float trackWidth) {
        float cutoff = trackWidth / this.p().horzScale;
        if (this.p().justify == PanelTaxonProperties.Justify.CENTRE) {
            topVal = topVal > cutoff ? cutoff / 2.0f : topVal / 2.0f;
            baseVal = baseVal > cutoff ? cutoff / 2.0f : baseVal / 2.0f;
        }
        yp[0] = yposTop;
        xp[0] = xpos;
        yp[1] = yposTop;
        xp[1] = topVal > cutoff ? xpos + trackWidth : xpos + topVal * this.p().horzScale;
        if (topVal > cutoff && baseVal > cutoff) {
            xp[2] = xpos + trackWidth;
            yp[2] = yposTop;
            xp[3] = xpos + trackWidth;
            yp[3] = yposBase;
        } else if (topVal > cutoff) {
            xp[2] = xpos + trackWidth;
            yp[2] = yposBase - (yposBase - yposTop) * (trackWidth / (topVal * this.p().horzScale));
            xp[3] = xpos + baseVal * this.p().horzScale;
            yp[3] = yposBase;
        } else if (baseVal > cutoff) {
            xp[2] = xpos + trackWidth;
            yp[2] = yposTop + (yposBase - yposTop) * (trackWidth / (baseVal * this.p().horzScale));
            xp[3] = xpos + trackWidth;
            yp[3] = yposBase;
        } else {
            xp[2] = xpos + topVal * this.p().horzScale;
            yp[2] = yposTop;
            xp[3] = xpos + baseVal * this.p().horzScale;
            yp[3] = yposBase;
        }
        xp[4] = xpos;
        yp[4] = yposBase;
        if (this.p().justify == PanelTaxonProperties.Justify.RIGHT) {
            xp[0] = xp[0] + trackWidth;
            xp[1] = xpos + trackWidth - (xp[1] - xpos);
            xp[2] = xpos + trackWidth - (xp[2] - xpos);
            xp[3] = xpos + trackWidth - (xp[3] - xpos);
            xp[4] = xp[4] + trackWidth;
        }
    }

    private void centrePolygonPoints(float[] xpoints, float[] ypoints, float[] newxpoints, float[] newypoints, float xpos) {
        System.arraycopy(xpoints, 0, newxpoints, 0, 5);
        newxpoints[5] = xpos - (xpoints[3] - xpos);
        newxpoints[6] = xpos - (xpoints[2] - xpos);
        newxpoints[7] = xpos - (xpoints[1] - xpos);
        System.arraycopy(ypoints, 0, newypoints, 0, 5);
        newypoints[5] = ypoints[3];
        newypoints[6] = ypoints[2];
        newypoints[7] = ypoints[1];
    }

    /*
     * Enabled aggressive block sorting
     */
    private void drawLabels(SBGraphics g, ChartProperties cp, float xpos, float y, int nTrack, float trackWidth, int firstSample, int lastSample) {
        int nSamp = firstSample;
        while (nSamp < lastSample) {
            String label = this.curveLabels[nSamp][nTrack];
            if (label != null) {
                Color c;
                float ypos = y + this.parent.getSamplePosition(nSamp);
                if (this.p().histHeightSampleRange) {
                    if (this.parent.getDb().useSampleTops()) {
                        ypos += g.stringHeightSB();
                    }
                } else {
                    ypos += g.stringHeightSB() / 2.0f;
                }
                Color color = c = this.p().colourSuites ? this.colours[nSamp][0] : this.colours[nTrack][0];
                if (c == null) {
                    c = this.getDefaultColour();
                }
                c = this.getEventColour(c, nTrack, nSamp);
                g.setColor(this.p().colourLabels ? c : cp.foreground);
                float data = this.curveData[nSamp][nTrack][this.nCurves - 1];
                float pad = this.p().plot_style == PanelTaxonProperties.Plot.STICKNDOT ? 0.6f : 0.4f;
                float x = switch (this.p().plot_style == PanelTaxonProperties.Plot.NUMBERS ? PanelTaxonProperties.Justify.CENTRE : this.p().justify) {
                    case PanelTaxonProperties.Justify.CENTRE -> {
                        if (data > 0.0f && this.p().plot_style != PanelTaxonProperties.Plot.NUMBERS && (g.stringWidth(label) + pad < data * this.p().horzScale || g.stringWidth(label) + pad > trackWidth / 2.0f - data * this.p().horzScale / 2.0f)) {
                            if (!(g.stringWidth(label) > data * this.p().horzScale * 2.0f)) {
                                g.setColorContrastingBW(c);
                            }
                            yield xpos + trackWidth / 2.0f - g.stringWidth(label) / 2.0f;
                        }
                        if (data == 0.0f || this.p().plot_style == PanelTaxonProperties.Plot.NUMBERS) {
                            yield xpos + trackWidth / 2.0f - g.stringWidth(label) / 2.0f;
                        }
                        yield xpos + trackWidth / 2.0f + data * this.p().horzScale / 2.0f + pad;
                    }
                    default -> {
                        if (data > this.p().cutoff) {
                            if (this.p().plot_style != PanelTaxonProperties.Plot.CURVE) {
                                g.setColorContrastingBW(c);
                            }
                            if (this.p().justify == PanelTaxonProperties.Justify.RIGHT) {
                                if (this.p().plot_style == PanelTaxonProperties.Plot.SAWTOOTH) {
                                    yield xpos + pad;
                                }
                                yield xpos + trackWidth - this.p().cutoff * this.p().horzScale + 1.0f;
                            }
                            if (this.p().plot_style == PanelTaxonProperties.Plot.SAWTOOTH) {
                                yield xpos + trackWidth - g.stringWidth(label) - 1.0f;
                            }
                            yield xpos + this.p().cutoff * this.p().horzScale - g.stringWidth(label) - 1.0f;
                        }
                        if (data > 0.0f && data * this.p().horzScale + pad + g.stringWidth(label) > trackWidth && g.stringWidth(label) + pad < data * this.p().horzScale) {
                            if (this.p().plot_style != PanelTaxonProperties.Plot.CURVE) {
                                g.setColorContrastingBW(c);
                            }
                            if (this.p().justify == PanelTaxonProperties.Justify.RIGHT) {
                                yield xpos + trackWidth - data * this.p().horzScale + pad;
                            }
                            yield xpos + data * this.p().horzScale - g.stringWidth(label) - pad;
                        }
                        yield this.p().justify == PanelTaxonProperties.Justify.RIGHT ? xpos + trackWidth - data * this.p().horzScale - g.stringWidth(label) - pad : xpos + data * this.p().horzScale + pad;
                    }
                };
                int fontStyle = g.getFont().getStyle();
                if (label.equalsIgnoreCase("+")) {
                    this.drawOutsideCount(g, cp, x, ypos);
                } else if (label.contains("+")) {
                    String label1 = label.substring(0, label.indexOf("+"));
                    String label2 = label.length() > label.indexOf("+") ? label.substring(label.indexOf("+") + 1) : "";
                    g.drawString(label1, x, ypos);
                    float w1 = g.stringWidth(label1);
                    g.setFontStyle(1);
                    g.drawString("+", x + w1, ypos);
                    g.setFontStyle(0);
                    float w2 = g.stringWidth(label1 + "+");
                    g.drawString(label2, x + w2, ypos);
                } else {
                    g.drawString(label, x, ypos);
                    g.setFontStyle(fontStyle);
                    g.setColor(cp.foreground);
                }
            }
            ++nSamp;
        }
        return;
    }

    public void drawOutsideCount(SBGraphics g, ChartProperties cp, float x, float y) {
        float length = g.stringWidth("A");
        float lineWidth = 0.25f;
        y -= g.stringHeightSB() / 2.0f;
        g.setStroke(0.25f, 1, 2);
        switch (this.p().justify) {
            case CENTRE: {
                x -= 0.0625f;
                break;
            }
            case LEFT: {
                x += length / 5.0f;
                break;
            }
            case RIGHT: {
                x -= length / 5.0f;
            }
        }
        g.drawLine(x, y, x + length, y);
        g.drawLine(x + length / 2.0f, y - length / 2.0f, x + length / 2.0f, y + length / 2.0f);
        g.setStroke(0.1f);
    }

    /*
     * Exception decompiling
     */
    private void drawDotAndStick(SBGraphics g, ChartProperties cp, float xpos, float y, int nTrack, float trackWidth, int firstSample, int lastSample) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.ClassCastException: class org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement cannot be cast to class org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement (org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement and org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement are in unnamed module of loader 'app')
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchExpressionRewriter$LValueSingleUsageCheckingRewriter.rewriteExpression(SwitchExpressionRewriter.java:96)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.LValueExpression.applyExpressionRewriter(LValueExpression.java:84)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredFor.rewriteExpressions(StructuredFor.java:194)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:24)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchExpressionRewriter.rewriteBlockSwitches(SwitchExpressionRewriter.java:140)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchExpressionRewriter.transform(SwitchExpressionRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.switchExpression(Op04StructuredStatement.java:101)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:909)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void drawEvents(SBGraphics g, float x, float y, int nTrack, float trackWidth, ChartProperties cp, BlockProperties bp, HashSet<CorrelationPoint> cLines) {
        ChartObject[] evs = this.events[nTrack];
        if (evs == null) {
            return;
        }
        g.setColor(cp.foreground);
        float arrowHeight = 0.8f;
        float indent = 1.0f;
        for (ChartObject co : evs) {
            if (bp != this.getBlock().getProp() && (!(co.getCorrDepth() >= (double)bp.getMin()) || !(co.getCorrDepth() <= (double)bp.getMax()))) continue;
            boolean eventIsTrackEvent = true;
            if (this.tracks.get((int)nTrack).object instanceof CompositeStandardEvent) {
                eventIsTrackEvent = false;
                CompositeStandardEvent cse = (CompositeStandardEvent)this.tracks.get((int)nTrack).object;
                WellEvent wellEvent = (WellEvent)co.getO();
                if (wellEvent.getEvent() == cse.getEvent() && wellEvent.getTypeObj() == cse.getType()) {
                    eventIsTrackEvent = true;
                }
            }
            boolean correlating = false;
            if (cLines != null) {
                for (CorrelationPoint corrP : cLines) {
                    if (corrP.line().getObject() != ((WellEvent)co.getO()).getEvent() || corrP.line().getObjectType() != ((WellEvent)co.getO()).getTypeObj()) continue;
                    g.setColor(corrP.line().getColour());
                    correlating = true;
                    break;
                }
            }
            boolean left = this.p().justify == PanelTaxonProperties.Justify.RIGHT;
            float xPos = left ? x + 0.1f : x + trackWidth - 0.1f;
            float[] xP = new float[3];
            float[] yP = new float[3];
            yP[0] = y + co.getyPos();
            WellEvent ev = (WellEvent)co.getO();
            switch (ev.getTypeObj()) {
                case BASE: {
                    yP[1] = yP[0] - 0.8f;
                    yP[2] = yP[0];
                    break;
                }
                case TOP: {
                    yP[1] = yP[0] + 0.8f;
                    yP[2] = yP[0];
                    break;
                }
                case SINGLE: {
                    yP[1] = yP[0] - 0.4f;
                    yP[2] = yP[0] + 0.4f;
                }
            }
            g.drawLine(xPos, yP[0], left ? (xPos = xPos + 1.0f) : (xPos = xPos - 1.0f), yP[0]);
            xP[0] = xP[1] = xPos;
            xP[2] = left ? (xPos = xPos + 2.0f) : (xPos = xPos - 2.0f);
            g.fillPolygon(xP, yP, 3, eventIsTrackEvent ? g.getColor() : ColourUtils.getLighterColour((Color)g.getColor(), (float)0.2f));
            if (!co.getPlotName().isEmpty()) {
                float stringPos = yP[0];
                switch (ev.getTypeObj()) {
                    case TOP: {
                        stringPos += g.stringHeightSB();
                        break;
                    }
                    case SINGLE: {
                        stringPos += g.stringHeightSB() / 2.0f;
                    }
                }
                switch (this.p().justify) {
                    case LEFT: 
                    case CENTRE: {
                        xPos -= g.stringWidth(co.getPlotName()) + 0.2f;
                        break;
                    }
                    case RIGHT: {
                        xPos += 0.2f;
                    }
                }
                g.drawString(co.getPlotName(), xPos, stringPos);
            }
            if (!correlating) continue;
            g.setColor(cp.foreground);
        }
    }

    private void drawStratigraphicRange(SBGraphics g, BlockProperties bp, float xpos, float y, int nTrack, float trackWidth, int firstSample, int lastSample) {
        TaxonTrack track = this.tracks.get(nTrack);
        if (track.nSampleTop == null || track.nSampleBase == null) {
            return;
        }
        if (track.nSampleBase > -1 && track.nSampleBase < firstSample || track.nSampleTop > -1 && track.nSampleTop >= lastSample) {
            return;
        }
        boolean firstOrOnlySubBlock = true;
        if (bp instanceof SubBlockProperties && (double)Math.abs(this.getBlock().getTopDepth() - bp.getMin()) > 0.01) {
            firstOrOnlySubBlock = false;
        }
        float yTop = track.nSampleTop < 0 || track.nSampleTop < firstSample ? y + (firstOrOnlySubBlock ? 0.0f : this.getBlock().scaleDepth(((SubBlockProperties)bp).getNormal() ? bp.getMin() : bp.getMax())) : y + this.parent.getSamplePosition(track.nSampleTop);
        float yBase = track.nSampleBase < 0 || track.nSampleBase >= lastSample ? y + bp.getHeight() + (firstOrOnlySubBlock ? 0.0f : this.getBlock().scaleDepth(((SubBlockProperties)bp).getNormal() ? bp.getMin() : bp.getMax())) : y + this.parent.getSamplePosition(track.nSampleBase);
        g.setStroke(0.1f);
        if ((double)Math.abs(yTop - yBase) > 0.01) {
            float barWidth = 0.35f;
            float arrowWidth = 0.8f;
            float arrowHeight = 2.0f;
            if (this.p().justify == PanelTaxonProperties.Justify.CENTRE) {
                float[] ypos;
                float centre = xpos + trackWidth / 2.0f;
                g.fillRect(centre - 0.175f, yTop, 0.35f, yBase - yTop, Color.WHITE);
                float[] x = new float[]{centre - 0.35f, centre + 0.35f, centre + 0.35f + 0.4f, centre - 0.35f - 0.4f};
                if (track.nSampleTop < 0 && firstOrOnlySubBlock) {
                    ypos = new float[]{y, y, y + 2.0f, y + 2.0f};
                    g.fillPolygon(x, ypos, 4, Color.WHITE);
                }
                if (track.nSampleBase < 0 && (bp == this.getBlock().getProp() || (double)Math.abs(this.getBlock().getBaseDepth() - bp.getMax()) < 0.01)) {
                    ypos = new float[]{yBase, yBase, yBase - 2.0f, yBase - 2.0f};
                    g.fillPolygon(x, ypos, 4, Color.WHITE);
                }
            } else {
                float[] ypos;
                float[] x;
                g.drawRect(xpos, yTop, 0.35f, yBase - yTop);
                if (track.nSampleTop < 0 && firstOrOnlySubBlock) {
                    x = new float[]{xpos, xpos + 0.35f, xpos + 0.35f + 0.8f, xpos};
                    ypos = new float[]{y, y, y + 2.0f, y + 2.0f};
                    g.fillPolygon(x, ypos, 4, Color.WHITE);
                }
                if (track.nSampleBase < 0 && (bp == this.getBlock().getProp() || (double)Math.abs(this.getBlock().getBaseDepth() - bp.getMax()) < 0.01)) {
                    x = new float[]{xpos, xpos + 0.35f + 0.8f, xpos + 0.35f, xpos};
                    ypos = new float[]{yBase - 2.0f, yBase - 2.0f, yBase, yBase};
                    g.fillPolygon(x, ypos, 4, Color.WHITE);
                }
            }
        }
    }

    private void drawScaleTicks(final SBGraphics g, final BlockProperties bp, ChartProperties cp, float xLeft, final float ypos, float trackWidth) {
        float tickInt;
        if (this.p().plot_style == PanelTaxonProperties.Plot.NUMBERS || this.p().abn_style.setSemiQuant()) {
            return;
        }
        if (this.isOverplot()) {
            return;
        }
        for (tickInt = this.p().maxWidth / this.p().cutoff; tickInt < 1.0f; tickInt *= 10.0f) {
        }
        class TickDraw {
            TickDraw() {
                Objects.requireNonNull(this$0);
            }

            void drawTick(int i, float xpos) {
                if (i % 10 == 0) {
                    g.drawLine(xpos, ypos, xpos, ypos + 1.0f);
                    g.drawLine(xpos, ypos + bp.getHeight(), xpos, ypos + bp.getHeight() - 1.0f);
                } else if (i % 5 == 0) {
                    g.drawLine(xpos, ypos, xpos, ypos + 0.75f);
                    g.drawLine(xpos, ypos + bp.getHeight(), xpos, ypos + bp.getHeight() - 0.75f);
                } else {
                    g.drawLine(xpos, ypos, xpos, ypos + 0.5f);
                    g.drawLine(xpos, ypos + bp.getHeight(), xpos, ypos + bp.getHeight() - 0.5f);
                }
            }
        }
        TickDraw tickDraw = new TickDraw();
        int i = 1;
        switch (this.p().justify) {
            default: {
                assert (false);
            }
            case LEFT: {
                float xpos;
                for (xpos = xLeft + tickInt; xpos < xLeft + trackWidth; xpos += tickInt) {
                    tickDraw.drawTick(i, xpos);
                    ++i;
                }
                break;
            }
            case RIGHT: {
                float xpos;
                for (xpos = xLeft + trackWidth - tickInt; xpos > xLeft; xpos -= tickInt) {
                    tickDraw.drawTick(i, xpos);
                    ++i;
                }
                break;
            }
            case CENTRE: {
                float xpos;
                for (xpos = xLeft + tickInt + trackWidth / 2.0f; xpos < xLeft + trackWidth; xpos += tickInt) {
                    tickDraw.drawTick(i, xpos);
                    ++i;
                }
                i = 1;
                for (xpos = xLeft + trackWidth / 2.0f - tickInt; xpos > xLeft; xpos -= tickInt) {
                    tickDraw.drawTick(i, xpos);
                    ++i;
                }
            }
        }
        if (!(this.nTracks != 1 || this.isOverplot() && this.parent.overplotDataMatches(this) || this.p().group != PanelTaxonProperties.Group.TOTAL && this.p().track_style == PanelTaxonProperties.Track.SINGLE)) {
            g.setFontSize(cp.getFontSizeTiny());
            int limit = Math.round(trackWidth / this.p().horzScale);
            String limitString = "" + limit;
            float yPos2 = ypos + g.stringHeightSB() + 0.2f;
            switch (this.p().justify) {
                default: {
                    assert (false);
                }
                case LEFT: 
                case CENTRE: {
                    g.drawString(limitString, xLeft + trackWidth - g.stringWidth(limitString) - 0.2f, yPos2);
                    break;
                }
                case RIGHT: {
                    g.drawString(limitString, xLeft + 0.2f, yPos2);
                }
            }
        }
    }

    @Override
    public float getWidth(BlockProperties bp) {
        float width = 0.0f;
        if (this.p().showImages && this.images != null && !this.images.isEmpty()) {
            width += this.p().imageWidth;
        }
        return width += this.getTracksWidth();
    }

    private float getTracksWidth() {
        float width = 0.0f;
        for (TaxonTrack track : this.tracks) {
            width += track.width;
        }
        return width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void setData(ChartProperties cp, double[][] sections) throws SQLException, SBException {
        PanelTaxonGroup panelTaxonGroup = this.parent;
        synchronized (panelTaxonGroup) {
            if (this.getBlock().getWell() != null) {
                this.getBlock().getWell().loadAnalyses();
            }
            this.p().setScale();
            this.specTypes = null;
            this.semiQuantSuites.clear();
            this.events = null;
            if (this.getBlock().getWell() == null) {
                this.setDataTemplate(cp);
            } else {
                this.initObservation();
                switch (this.p().group) {
                    case CAT: {
                        this.setDataCat(cp);
                        break;
                    }
                    case GENUS: {
                        this.setDataGenus(cp);
                        break;
                    }
                    case GROUP: {
                        this.setDataGroup(cp);
                        break;
                    }
                    case SITU: {
                        this.setDataSituation(cp);
                        break;
                    }
                    case CONF: {
                        this.setDataBoolean(cp);
                        break;
                    }
                    case SPEC: {
                        this.setDataSpecies(cp);
                        break;
                    }
                    case SUBTYPE: {
                        this.setDataSubType(cp);
                        break;
                    }
                    case TOTAL: {
                        this.setDataTotal(cp);
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
            }
            if (this.p().showImages && this.getBlock().getWell() != null) {
                this.setDataImages(cp, sections);
            } else {
                this.images = null;
            }
        }
    }

    private void initObservation() {
        if (this.getFilterGroup() != null) {
            this.getFilterGroup().addWeakObserver((Observer)this);
        }
        if (this.p().highlightGroup != null) {
            this.p().highlightGroup.addWeakObserver((Observer)this);
        }
        if (this.getFilterSet() != null) {
            this.getFilterSet().addWeakObserver((Observer)this);
        }
        if (this.p().track_style == PanelTaxonProperties.Track.SINGLE && (this.p().group == PanelTaxonProperties.Group.SPEC || this.p().group == PanelTaxonProperties.Group.GROUP)) {
            if (this.p().cmpStd != null) {
                this.p().cmpStd.addWeakObserver((Observer)this);
            }
            if (this.p().hdrScheme != null) {
                this.p().hdrScheme.addWeakObserver((Observer)this);
            }
        }
    }

    private void setDataTemplate(ChartProperties cp) throws SBException, SQLException {
        int nSample;
        if (this.getBlock().getWell() != null) {
            return;
        }
        int n = this.getNTemplateTracks(this.p(), this.getPanelTaxonOcc());
        String[] subgroups = this.getSubgroups();
        int m = subgroups.length;
        this.events = null;
        if (!this.isOverplot()) {
            this.tracks.clear();
            if (this.p().track_style == PanelTaxonProperties.Track.MULTI) {
                this.nCurves = n;
                this.nTracks = 1;
                String[] curveNames = new String[n];
                for (int i = 0; i < n; ++i) {
                    String tString = (this.p().group == PanelTaxonProperties.Group.SPEC && this.p().hdr_cat ? "CAT " : "") + this.getTemplateNames(this.p(), this.getPanelTaxonOcc())[i];
                    if (this.p().hdr_author && i == 4) {
                        tString = tString + " (author 2014)";
                    }
                    curveNames[i] = tString;
                }
                TaxonTrack track = new TaxonTrack(this, null, "Species", curveNames, null, null);
                this.tracks.add(track);
            } else {
                this.nCurves = m;
                this.nTracks = n;
                for (int nTaxon = 0; nTaxon < this.getNTemplateTracks(this.p(), this.getPanelTaxonOcc()); ++nTaxon) {
                    this.tracks.add(new TaxonTrack(this, null, (this.p().group == PanelTaxonProperties.Group.SPEC && this.p().hdr_cat ? "CAT " : "") + (this.p().group == PanelTaxonProperties.Group.SPEC && this.p().hdr_alphacodes ? this.getTemplateTaxonAlphacodes(this.p(), this.getPanelTaxonOcc())[nTaxon] : this.getTemplateNames(this.p(), this.getPanelTaxonOcc())[nTaxon]) + (this.p().group == PanelTaxonProperties.Group.SPEC && this.p().hdr_author && nTaxon == 4 ? " (author 2014)" : ""), null, null, null));
                }
            }
        } else {
            this.tracks = this.parent.getOverplotTracks(this);
            this.nTracks = this.tracks.size();
            this.nCurves = m;
        }
        float[][][] sampleData = new float[this.parent.getnSamples()][n][m];
        AbundanceScheme[] abnSchemes = new AbundanceScheme[this.parent.getnSamples()];
        float[] sampleTotal = new float[this.parent.getnSamples()];
        Color[] tcColours = this.getTemplateColours(this.p(), this.getPanelTaxonOcc());
        this.colours = this.p().colourSuites ? new Color[this.parent.getnSamples()][this.nCurves] : new Color[this.nTracks][this.nCurves];
        this.curveData = new float[this.parent.getnSamples()][this.nTracks][this.nCurves];
        this.curveHasOutsideCount = new boolean[this.parent.getnSamples()][this.nCurves];
        this.curveLabels = new String[this.parent.getnSamples()][n];
        if (this.p().group == PanelTaxonProperties.Group.SPEC && this.p().track_style == PanelTaxonProperties.Track.SINGLE) {
            this.markerData = new boolean[this.parent.getnSamples()][this.nTracks];
            this.markerData[(int)Math.floor((double)((double)this.parent.getnSamples() * 0.5))][1] = true;
        }
        float maxValue = this.p().hist_height / this.p().horzScale;
        for (nSample = 0; nSample < this.parent.getnSamples(); ++nSample) {
            for (int i = 0; i < this.getNTemplateTracks(this.p(), this.getPanelTaxonOcc()); ++i) {
                int j;
                for (j = i; j >= 8; j -= 8) {
                }
                switch (this.p().abn_style) {
                    case Q: 
                    case SEMIQ: {
                        float count = PanelTaxon.getTemplateData()[j][nSample];
                        int index = 0;
                        if (count < 2.0f) {
                            index = 1;
                        } else if (count < 5.0f) {
                            index = 2;
                        } else if (count < 10.0f) {
                            index = 3;
                        } else if (count < 25.0f) {
                            index = 4;
                        } else if (count < 50.0f) {
                            index = 5;
                        }
                        sampleData[nSample][i][0] = maxValue / 5.0f * (float)index;
                        break;
                    }
                    case MIX: {
                        sampleData[nSample][i][0] = PanelTaxon.getTemplateData()[j][nSample];
                        break;
                    }
                    case PA: {
                        sampleData[nSample][i][0] = PanelTaxon.getTemplateData()[j][nSample] > 0.0f ? 5.0f : 0.0f;
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                if (this.p().track_style == PanelTaxonProperties.Track.MULTI) {
                    if (this.p().colourSuites) continue;
                    this.colours[0] = tcColours;
                    continue;
                }
                if (this.nTracks <= 0) continue;
                if (!this.p().colourSuites && this.nTracks > 0) {
                    PanelTaxon.fillColourArray(tcColours[i] != null ? tcColours[i] : this.p().colour, this.colours[i]);
                }
                if (!(sampleData[nSample][i][0] > 0.0f)) continue;
                this.tracks.get(i).setDataRange(nSample, null);
            }
            if (!this.p().colourSuites) continue;
            PanelTaxon.fillColourArray(this.analystColours[nSample], this.colours[nSample]);
        }
        if (this.p().calc_style == PanelTaxonProperties.Calc.COSINETHETA) {
            for (nSample = this.parent.getnSamples() - 2; nSample >= 0; --nSample) {
                for (int nTrack = 0; nTrack < this.nTracks; ++nTrack) {
                    this.curveData[nSample][nTrack][0] = (float)Math.random();
                }
            }
        }
        this.copySampleData(sampleData, null, m, cp, sampleTotal, null);
    }

    private void setDataSpecies(ChartProperties cp) throws SQLException, SBException {
        Color[][] tcColours;
        int n;
        String[] subgroups = this.getSubgroups();
        int m = subgroups.length;
        ArrayList<Object> taxa = null;
        if (!this.isOverplot()) {
            if (this.getInterp() != null && this.p().onlyIncludeTaxaLinkedToEvents) {
                HashSet<model3.Taxon> taxaSet = new HashSet<model3.Taxon>();
                for (WellEvent ev : this.getInterp().getEvents()) {
                    model3.Taxon eventTaxon = ev.getEvent().getTaxon();
                    if (eventTaxon == null) continue;
                    taxaSet.add(eventTaxon);
                }
                taxa = new ArrayList(taxaSet);
            } else {
                HashMap taxaMap = new HashMap();
                for (Well well : this.getBlock().getWells()) {
                    well.fillTaxonList(taxaMap, this.parent.getDiscID().getChar(), 0, 0);
                }
                taxa = new ArrayList(taxaMap.values());
            }
            if (this.getBlock().getWells().size() == 1) {
                this.getBlock().getWell().sortTaxonList(taxa, this.parent.getDiscID(), this.p().sortType.getIntegerEquivalent(), this.p().showFlags);
            } else {
                this.sortTaxonList(taxa);
            }
            ListIterator listIt = taxa.listIterator();
            while (listIt.hasNext()) {
                model3.Taxon taxon = (model3.Taxon)listIt.next();
                if (this.getFilterSpec() != null) {
                    if (taxon.getSpecID() == this.getFilterSpec().getSpecID()) continue;
                    listIt.remove();
                    continue;
                }
                if (this.getFilterCat() != null) {
                    if (this.getIncludeSubCats()) {
                        if (taxon.getCatMnem().startsWith(this.getFilterCat().getMnemonic())) continue;
                        listIt.remove();
                        continue;
                    }
                    if (taxon.getCatMnem().equals(this.getFilterCat().getMnemonic())) continue;
                    listIt.remove();
                    continue;
                }
                if (this.getFilterGroup() != null) {
                    if (this.getFilterGroup().isMember(taxon.getSpecID(), this.parent.p.applySynToGroups ? this.parent.p.synschID : 0)) continue;
                    listIt.remove();
                    continue;
                }
                if (this.getFilterSet() != null) {
                    boolean found = false;
                    for (TxGroup group : this.getFilterSet().getGroups()) {
                        if (!group.isMember(taxon.getSpecID(), this.parent.p.applySynToGroups ? this.parent.p.synschID : 0)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    listIt.remove();
                    continue;
                }
                if (this.getFilterCmpStd() == null) continue;
                this.getFilterCmpStd().loadEvents();
                if (this.getFilterCmpStd().hasTaxon(taxon.getSpecID(), this.parent.p.applySynToGroups ? this.parent.p.synschID : 0)) continue;
                listIt.remove();
            }
            n = taxa.size();
            this.tracks.clear();
            this.events = null;
            if (this.p().track_style == PanelTaxonProperties.Track.MULTI) {
                this.nCurves = n;
                this.nTracks = 1;
                tcColours = new Color[this.nTracks][this.nCurves];
                String[] curveNames = new String[n];
                for (int i = 0; i < n; ++i) {
                    model3.Taxon pref;
                    model3.Taxon t = (model3.Taxon)taxa.get(i);
                    Object tString = t.toString(this.p().hdr_author);
                    if (this.parent.p.synschID > 0 && (pref = t.getPreferred(this.parent.p.synschID)) != null) {
                        tString = (String)tString + " (" + pref.toString(this.p().hdr_author) + ")";
                    }
                    curveNames[i] = tString;
                }
                TaxonTrack track = new TaxonTrack(this, null, "Species", curveNames, null, null);
                this.tracks.add(track);
            } else {
                Iterator it;
                this.nCurves = m;
                if (this.p().sortType != PanelTaxonProperties.Sort.SORTAGE) {
                    it = taxa.iterator();
                } else {
                    if (this.getFilterCmpStd() == null) {
                        throw new SBException("Attempt to sort data by Event Age when Inner Panel not restricted to Composite Standard.");
                    }
                    this.getFilterCmpStd().loadEvents();
                    List csEvs = this.getFilterCmpStd().getEvents(true);
                    ListIterator evit = csEvs.listIterator();
                    while (evit.hasNext()) {
                        CompositeStandardEvent cse = (CompositeStandardEvent)evit.next();
                        model3.Taxon et = cse.getEvent().getTaxon();
                        if (et != null && taxa.contains(et)) continue;
                        if (et != null && this.parent.p.applySynToGroups && this.parent.p.synschID > 0) {
                            List juniorSynonyms = this.parent.getDb().getSynonymService().getSynonyms(this.parent.p.synschID, et.getSpecID(), this.parent.getDb().getTaxonService());
                            boolean found = false;
                            block22: for (Taxon t : juniorSynonyms) {
                                for (Object taxon : taxa) {
                                    if (taxon.getSpecID() != t.getSpecID()) continue;
                                    found = true;
                                    continue block22;
                                }
                            }
                            if (found) continue;
                        }
                        evit.remove();
                    }
                    n = csEvs.size();
                    it = csEvs.iterator();
                }
                this.nTracks = n;
                tcColours = new Color[this.nTracks][this.nCurves];
                int i = -1;
                while (it.hasNext()) {
                    Object tName;
                    model3.Taxon taxon;
                    Object o = it.next();
                    AttributedString attString = null;
                    if (o instanceof model3.Taxon) {
                        taxon = (model3.Taxon)o;
                        tName = taxon.toString(this.p().hdr_author);
                        if (this.parent.p.getSynSchID() > 0) {
                            try {
                                model3.Taxon pref = taxon.getPreferred(this.parent.p.synschID);
                                if (pref != null) {
                                    tName = (String)tName + "  (";
                                    tName = (String)tName + pref.toString(this.p().hdr_author, false);
                                    tName = (String)tName + ")";
                                }
                            }
                            catch (SQLException | SBException e) {
                                e.printStackTrace();
                            }
                        }
                        attString = this.toAttString(taxon, false);
                    } else {
                        taxon = ((CompositeStandardEvent)o).getEvent().getTaxon();
                        tName = ((CompositeStandardEvent)o).toStringName();
                    }
                    TaxonTrack track = new TaxonTrack(this, attString, (String)tName, null, o, taxon.getAlphaCode());
                    if (this.p().cmpStd != null) {
                        this.p().cmpStd.loadEvents();
                        if (o instanceof CompositeStandardEvent) {
                            track.minAge = ((CompositeStandardEvent)o).getCSU();
                        } else {
                            CompositeStandard.AgeRange range = this.p().cmpStd.getAgeRange(taxon, true);
                            if (range != null) {
                                track.minAge = range.getMinAge();
                                track.maxAge = range.getMaxAge();
                            }
                        }
                        this.setTrackUnits(track);
                    }
                    this.tracks.add(track);
                    Color colour = this.p().highlightGroup != null && this.p().highlightGroup.isMember(taxon.getSpecID(), this.parent.p.getSynSchID()) ? this.p().highlightColour : this.getDefaultColour();
                    PanelTaxon.fillColourArray(colour, tcColours[++i]);
                    if (!this.p().drawEvents || this.getBlock().getWells().size() != 1 || this.getInterp() == null || this.getInterp().getEvents().isEmpty()) continue;
                    model3.Taxon pref = null;
                    if (this.parent.p.getSynSchID() > 0) {
                        pref = taxon.getPreferred(this.parent.p.synschID);
                    }
                    LinkedList<ChartObject<WellEvent>> trackEvents = new LinkedList<ChartObject<WellEvent>>();
                    for (WellEvent ev : this.getInterp().getEvents()) {
                        double depth;
                        if (ev.getEvent().getSpecID() != taxon.getSpecID() && (pref == null || ev.getEvent().getSpecID() != pref.getSpecID()) || !((depth = this.getBlock().getWell().getDepth(ev.getSample(), cp.correctDepths, cp.correctCuttings)) > (double)this.getBlock().getTopDepth()) || !(depth < (double)this.getBlock().getBaseDepth())) continue;
                        ChartObject<WellEvent> co = new ChartObject<WellEvent>(ev, this.getBlock().scaleDepth((float)depth));
                        String evString = ev.toString(false, false, false);
                        if (evString.contains(taxon.toString(false, false, false))) {
                            evString = evString.replace(taxon.toString(false, false, false), "");
                        }
                        co.setPlotName(evString.trim());
                        co.setCorrDepth(depth);
                        trackEvents.add(co);
                    }
                    if (trackEvents.isEmpty()) continue;
                    Collections.sort(trackEvents, new ChartObjectCompareDepth());
                    if (this.events == null) {
                        this.events = new ChartObject[this.nTracks][];
                    }
                    this.events[i] = trackEvents.toArray(new ChartObject[trackEvents.size()]);
                }
            }
        } else {
            assert (this.p().track_style == PanelTaxonProperties.Track.SINGLE);
            this.tracks = this.parent.getOverplotTracks(this);
            this.nTracks = n = this.tracks.size();
            this.nCurves = m;
            tcColours = new Color[this.nTracks][this.nCurves];
            for (int nTrack = 0; nTrack < this.nTracks; ++nTrack) {
                TaxonTrack track = this.tracks.get(nTrack);
                Color colour = this.p().highlightGroup != null && this.p().highlightGroup.isMember(((model3.Taxon)track.object).getSpecID(), this.parent.p.getSynSchID()) ? this.p().highlightColour : this.getDefaultColour();
                PanelTaxon.fillColourArray(colour, tcColours[nTrack]);
            }
        }
        float[][][] sampleData = new float[this.parent.getnSamples()][n][m];
        int[][] tally = new int[this.parent.getnSamples()][n];
        AbundanceScheme[] abnSchemes = new AbundanceScheme[this.parent.getnSamples()];
        float[] sampleTotal = new float[this.parent.getnSamples()];
        this.curveData = new float[this.parent.getnSamples()][this.nTracks][this.nCurves];
        this.markerData = new boolean[this.parent.getnSamples()][this.nTracks];
        this.curveHasOutsideCount = new boolean[this.parent.getnSamples()][this.nCurves];
        this.curveLabels = new String[this.parent.getnSamples()][n];
        this.colours = this.p().colourSuites ? new Color[this.parent.getnSamples()][this.nCurves] : tcColours;
        Iterator<Sample> sampleIt = this.parent.getSampleIterator(cp);
        int nSample = 0;
        block27: while (sampleIt.hasNext()) {
            Sample sample = sampleIt.next();
            Boolean sampleOutsideRange = this.isOutsideBlockRange(sample);
            for (Smpdtl smpdtl : sample.getSmpdtls()) {
                if (!this.parent.useAnalysis(smpdtl, false)) continue;
                if (sampleOutsideRange == null) {
                    if (nSample > abnSchemes.length - 1) {
                        System.out.println("Quitting sample/analysis setting loop in PanelTaxon.setData due to array size mismatch");
                        continue block27;
                    }
                    if (this.p().colourSuites) {
                        PanelTaxon.fillColourArray(this.analystColours[nSample], this.colours[nSample]);
                    }
                    abnSchemes[nSample] = this.parent.getDb().getAbundanceSchemeService().findAbundanceScheme(smpdtl.getHeader().getAbnSchID()).orElse(null);
                    if (abnSchemes[nSample] != null && this.p().abn_style == PanelTaxonProperties.Abundance.SEMIQ) {
                        this.putSemiQuantSuite(smpdtl.getHeader());
                    }
                }
                for (TaxonOcc fss : smpdtl.getOccurUnsorted()) {
                    if (this.useOcc(fss)) {
                        ArrayList<Integer> matchingTracks = new ArrayList<Integer>();
                        block1 : switch (this.p().track_style) {
                            case SINGLE: {
                                for (int trackNo = 0; trackNo < this.tracks.size(); ++trackNo) {
                                    model3.Taxon t = this.tracks.get(trackNo).getTaxon();
                                    boolean trackMatch = false;
                                    if (fss.getTaxon().getSpecID() == t.getSpecID()) {
                                        trackMatch = true;
                                    }
                                    if (this.parent.p.applySynToGroups && this.parent.p.synschID > 0 && this.p().sortType == PanelTaxonProperties.Sort.SORTAGE) {
                                        List juniorSynonyms = this.parent.getDb().getSynonymService().getSynonyms(this.parent.p.synschID, t.getSpecID(), this.parent.getDb().getTaxonService());
                                        for (Taxon tx : juniorSynonyms) {
                                            if (tx.getSpecID() != fss.getTaxon().getSpecID()) continue;
                                            trackMatch = true;
                                            break;
                                        }
                                    }
                                    if (!trackMatch) continue;
                                    matchingTracks.add(trackNo);
                                    if (this.p().sortType != PanelTaxonProperties.Sort.SORTAGE) break block1;
                                }
                                break;
                            }
                            case MULTI: {
                                int groupIndex = 0;
                                if (taxa != null) {
                                    for (int taxaNum = 0; taxaNum < taxa.size(); ++taxaNum) {
                                        model3.Taxon t = (model3.Taxon)taxa.get(taxaNum);
                                        if (fss.getTaxon().getSpecID() != t.getSpecID()) continue;
                                        groupIndex = taxaNum;
                                    }
                                }
                                matchingTracks.add(groupIndex);
                            }
                        }
                        for (Integer j : matchingTracks) {
                            if (sampleOutsideRange == null) {
                                if (this.p().subgroup != PanelTaxonProperties.SubGroup.CMF) {
                                    float count = 0.0f;
                                    switch (this.p().abn_style) {
                                        case Q: {
                                            count = (float)fss.getDerivedCount(abnSchemes[nSample], this.p().useSplits ? smpdtl.getCoarse() : 0.0f, this.p().useSplits ? smpdtl.getMedium() : 0.0f, this.p().useSplits ? smpdtl.getFine() : 0.0f);
                                            break;
                                        }
                                        case MIX: {
                                            count = (float)fss.getTotalCount(this.p().useSplits ? smpdtl.getCoarse() : 0.0f, this.p().useSplits ? smpdtl.getMedium() : 0.0f, this.p().useSplits ? smpdtl.getFine() : 0.0f);
                                            break;
                                        }
                                        case SEMIQ: {
                                            if (abnSchemes[nSample] == null) {
                                                count = 0.0f;
                                                break;
                                            }
                                            count = fss.isOutsideCount() ? 0.0f : (float)fss.getDerivedCount(abnSchemes[nSample]);
                                            break;
                                        }
                                        case PA: {
                                            count = fss.isOutsideCount() ? 0.0f : 5.0f;
                                            break;
                                        }
                                        default: {
                                            assert (false);
                                            break;
                                        }
                                    }
                                    if (this.p().abn_style != PanelTaxonProperties.Abundance.PA) {
                                        if (this.p().normaliseWeight && (double)smpdtl.getWeight() > 1.0E-4 && !this.p().abn_style.setSemiQuant()) {
                                            count *= this.p().normalWeight / smpdtl.getWeight();
                                        }
                                        float[] fArray = sampleData[nSample][j];
                                        int n2 = m > 1 ? this.getSubgroupInt(fss) : 0;
                                        fArray[n2] = fArray[n2] + count;
                                    } else {
                                        sampleData[nSample][j.intValue()][m > 1 ? this.getSubgroupInt((TaxonOcc)fss) : 0] = count;
                                    }
                                } else {
                                    switch (this.p().abn_style) {
                                        case Q: {
                                            float[] fArray = sampleData[nSample][j];
                                            fArray[0] = fArray[0] + fss.getDerivedCount(abnSchemes[nSample], TaxonOcc.SizeFraction.COARSE, this.p().useSplits ? smpdtl.getCoarse() : 0.0f);
                                            float[] fArray2 = sampleData[nSample][j];
                                            fArray2[1] = fArray2[1] + fss.getDerivedCount(abnSchemes[nSample], TaxonOcc.SizeFraction.MEDIUM, this.p().useSplits ? smpdtl.getMedium() : 0.0f);
                                            float[] fArray3 = sampleData[nSample][j];
                                            fArray3[2] = fArray3[2] + fss.getDerivedCount(abnSchemes[nSample], TaxonOcc.SizeFraction.FINE, this.p().useSplits ? smpdtl.getFine() : 0.0f);
                                            break;
                                        }
                                        case MIX: {
                                            float[] fArray = sampleData[nSample][j];
                                            fArray[0] = fArray[0] + (float)fss.getCoarse() * (this.p().useSplits ? smpdtl.getCoarse() : 1.0f);
                                            float[] fArray4 = sampleData[nSample][j];
                                            fArray4[1] = fArray4[1] + (float)fss.getMedium() * (this.p().useSplits ? smpdtl.getMedium() : 1.0f);
                                            float[] fArray5 = sampleData[nSample][j];
                                            fArray5[2] = fArray5[2] + (float)fss.getFine() * (this.p().useSplits ? smpdtl.getFine() : 1.0f);
                                            break;
                                        }
                                        default: {
                                            throw new SBException("Attempt to use split-factor sub-grouping for " + this.p().abn_style.toString());
                                        }
                                    }
                                }
                                if (!fss.isOutsideCount()) {
                                    int[] nArray = tally[nSample];
                                    int n3 = j;
                                    nArray[n3] = nArray[n3] + 1;
                                }
                                boolean useSubjAbund = this.p().abn_style == PanelTaxonProperties.Abundance.MIX || this.p().abn_style == PanelTaxonProperties.Abundance.SEMIQ && this.p().plot_style == PanelTaxonProperties.Plot.NUMBERS;
                                this.setLabel(fss, nSample, j, !Boolean.TRUE.equals(this.p().includeRw), useSubjAbund, true, abnSchemes[nSample]);
                                if (this.nTracks == 1) {
                                    this.markerData[nSample][0] = this.markerData[nSample][0] || fss.isMarker();
                                } else {
                                    boolean bl = this.markerData[nSample][j.intValue()] = this.markerData[nSample][j] || fss.isMarker();
                                }
                            }
                            if (this.p().track_style != PanelTaxonProperties.Track.SINGLE || this.p().showFlags && (fss.getCaved() || fss.getReworked() || fss.getContamination())) continue;
                            this.tracks.get(j).setDataRange(nSample, sampleOutsideRange);
                        }
                    }
                    if (this.p().calc_style != PanelTaxonProperties.Calc.RELATIVE_OUTER || sampleOutsideRange != null || !this.parentUseOcc(fss)) continue;
                    int n4 = nSample;
                    sampleTotal[n4] = sampleTotal[n4] + this.getDerivedCount(fss, smpdtl, abnSchemes[nSample], 1);
                }
                if (sampleOutsideRange != null) continue;
                ++nSample;
            }
        }
        if (this.p().abn_style.setSemiQuant()) {
            this.setSemiQuant(sampleData, tally, abnSchemes, n);
        }
        this.copySampleData(sampleData, null, m, cp, sampleTotal, null);
    }

    void setAnalystColours(Color[] colours) {
        this.analystColours = colours;
    }

    private void sortTaxonList(List taxa) throws SBException, SQLException {
        int sort = this.p().sortType.getIntegerEquivalent();
        model3.Taxon.sort((List)taxa, (Taxon.SortOrder)Taxon.SortOrder.SORT_GENUS);
        Float[] ypos = new Float[taxa.size()];
        for (int i = 0; i < taxa.size(); ++i) {
            model3.Taxon taxon = (model3.Taxon)taxa.get(i);
            for (Well well : this.getBlock().getWells()) {
                double depth = well.getEndSampleDepth(taxon.getSpecID(), this.parent.getDiscID(), sort, this.p().showFlags);
                float y = this.getBlock().scaleDepth((float)depth, well);
                if (ypos[i] == null) {
                    ypos[i] = Float.valueOf(y);
                    continue;
                }
                if (this.p().sortType.getIntegerEquivalent() == 0) {
                    ypos[i] = Float.valueOf(Math.min(ypos[i].floatValue(), y));
                    continue;
                }
                ypos[i] = Float.valueOf(Math.max(ypos[i].floatValue(), y));
            }
        }
        boolean swap = true;
        block2: while (swap) {
            swap = false;
            for (int i = 1; i < ypos.length; ++i) {
                if (!(sort == 0 && ypos[i].floatValue() < ypos[i - 1].floatValue()) && (sort != 1 || !(ypos[i].floatValue() > ypos[i - 1].floatValue()))) continue;
                swap = true;
                float tempDepth = ypos[i].floatValue();
                ypos[i] = ypos[i - 1];
                ypos[i - 1] = Float.valueOf(tempDepth);
                model3.Taxon tempTaxon = (model3.Taxon)taxa.get(i);
                taxa.remove(i);
                taxa.add(i - 1, tempTaxon);
                continue block2;
            }
        }
    }

    private AttributedString toAttString(Object o, boolean overrideCat) {
        if (o instanceof model3.Taxon) {
            model3.Taxon modelTaxon = (model3.Taxon)o;
            if (this.parent.p.synschID > 0) {
                return TaxonNameService.toSynonymAttributedString((SynonymService)this.parent.getDb().getSynonymService(), (TaxonService)this.parent.getDb().getTaxonService(), (int)this.parent.p.synschID, (int)modelTaxon.getSpecID(), (boolean)this.p().hdr_italics, (boolean)this.parent.p.showJuniorSynonyms, (boolean)this.p().hdr_author, (boolean)overrideCat);
            }
            return modelTaxon.toAttributedString(this.p().hdr_italics, this.p().hdr_author, overrideCat);
        }
        if (o instanceof Genus) {
            return ((Genus)o).toAttributedString(this.p().hdr_italics, overrideCat);
        }
        return null;
    }

    private List<TxGroup> getTxGroups() throws SQLException {
        if (this.getFilterSet() != null) {
            return this.getFilterSet().getGroups();
        }
        if (this.parent.getFilterSet() != null) {
            return this.parent.getFilterSet().getGroups();
        }
        LinkedList<TxGroup> groups = new LinkedList<TxGroup>();
        groups.add(this.getFilterGroup());
        return groups;
    }

    private void setDataGroup(ChartProperties cp) throws SQLException, SBException {
        int i;
        int m;
        if (this.getFilterSet() == null && this.getFilterGroup() == null && this.parent.getFilterSet() == null) {
            throw new SBException("Cannot group by taxon group unless filtered by set or group");
        }
        List<TxGroup> groups = this.getTxGroups();
        int n = groups.size();
        String[] subgroups = this.getSubgroups();
        int n2 = m = subgroups.length > 0 ? subgroups.length : 1;
        if (this.p().track_style == PanelTaxonProperties.Track.MULTI) {
            this.nCurves = n;
            this.nTracks = 1;
        } else {
            this.nCurves = m;
            this.nTracks = n;
        }
        if (this.isOverplot()) {
            this.tracks = this.parent.getOverplotTracks(this);
            this.nTracks = this.tracks.size();
            assert (this.p().track_style == PanelTaxonProperties.Track.SINGLE);
            groups.clear();
            for (TaxonTrack track : this.tracks) {
                groups.add((TxGroup)track.object);
            }
            n = groups.size();
        }
        Color[] tcColours = new Color[n];
        String[] names = new String[n];
        for (i = 0; i < n; ++i) {
            groups.get(i).addWeakObserver((Observer)this);
            tcColours[i] = this.p().inheritFilterColour ? groups.get(i).getColour() : this.p().colour;
            names[i] = groups.get(i).getName();
        }
        if (this.p().colourSuites) {
            this.colours = new Color[this.parent.getnSamples()][this.nCurves];
        } else {
            this.colours = new Color[this.nTracks][this.nCurves];
            if (this.isOverplot()) {
                for (i = 0; i < this.nTracks; ++i) {
                    PanelTaxon.fillColourArray(tcColours[i], this.colours[i]);
                }
            }
        }
        if (!this.isOverplot()) {
            this.tracks.clear();
            for (i = 0; i < this.nTracks; ++i) {
                TaxonTrack newTrack;
                if (this.p().track_style == PanelTaxonProperties.Track.MULTI) {
                    newTrack = new TaxonTrack(this, null, "Groups", names, null, null);
                    if (!this.p().colourSuites) {
                        this.colours[i] = tcColours;
                    }
                } else {
                    newTrack = new TaxonTrack(this, null, names[i], subgroups, groups.get(i), null);
                    if (!this.p().colourSuites) {
                        PanelTaxon.fillColourArray(tcColours[i], this.colours[i]);
                    }
                    if (this.p().cmpStd != null) {
                        this.p().cmpStd.loadEvents();
                        TxGroup group = groups.get(i);
                        Double minAge = null;
                        Double maxAge = null;
                        for (model3.Taxon t : this.parent.getDb().getTxGroupTaxa(group)) {
                            CompositeStandard.AgeRange r = this.p().cmpStd.getAgeRange(t, true);
                            if (r == null) {
                                maxAge = null;
                                minAge = null;
                                break;
                            }
                            if (r.getMinAge() != null) {
                                if (minAge == null || r.getMinAge() < minAge) {
                                    minAge = r.getMinAge();
                                }
                                if (maxAge == null || r.getMinAge() > maxAge) {
                                    maxAge = r.getMinAge();
                                }
                            }
                            if (r.getMaxAge() == null) continue;
                            if (maxAge == null || r.getMaxAge() > maxAge) {
                                maxAge = r.getMaxAge();
                            }
                            if (minAge != null && !(r.getMaxAge() < minAge)) continue;
                            minAge = r.getMaxAge();
                        }
                        if (minAge != null || maxAge != null) {
                            newTrack.minAge = minAge;
                            newTrack.maxAge = maxAge;
                            this.setTrackUnits(newTrack);
                        }
                    }
                }
                this.tracks.add(newTrack);
            }
        }
        this.curveData = new float[this.parent.getnSamples()][this.nTracks][this.nCurves];
        this.curveHasOutsideCount = new boolean[this.parent.getnSamples()][this.nCurves];
        this.curveLabels = new String[this.parent.getnSamples()][this.nTracks];
        this.fillSampleData(cp, groups.toArray(), m, n);
    }

    private void setDataCat(ChartProperties cp) throws SQLException, SBException {
        HashMap<String, Category> catMap = new HashMap<String, Category>();
        for (Smpdtl smpdtl : this.parent.plotSmpdtl) {
            if (!this.parent.useAnalysis(smpdtl, true)) continue;
            for (TaxonOcc occ : smpdtl.getOccurUnsorted()) {
                if (!this.useOcc(occ)) continue;
                Category c = (Category)this.parent.getDb().getCategoryService().findCategory(occ.getTaxon().getCatMnem()).get();
                catMap.put(c.getMnemonic(), c);
            }
        }
        int n = catMap.size();
        List<Category> cats = this.parent.sortFilterCategories(new ArrayList<Category>(catMap.values()));
        Color[] tcColours = new Color[n];
        Object[] names = new String[n];
        for (int i = 0; i < cats.size(); ++i) {
            tcColours[i] = this.p().inheritFilterColour ? cats.get(i).getColour() : this.p().colour;
            names[i] = cats.get(i).getMnemonic();
        }
        int m = this.setTracks(names, null, tcColours, n);
        this.fillSampleData(cp, names, m, n);
    }

    private void setDataGenus(ChartProperties cp) throws SQLException, SBException {
        List<Genus> genera = !this.isOverplot() ? Arrays.stream(this.parent.plotSmpdtl).flatMap(smpdtl -> smpdtl.getOccurUnsorted().stream()).filter(occ -> this.useOccNoException((TaxonOcc)occ)).map(occ -> occ.getTaxon().getGenus().getGenusCopy()).distinct().sorted().toList() : this.parent.getOverplotTracks(this).stream().map(t -> (Genus)t.object).toList();
        int n = genera.size();
        Color[] tcColours = new Color[n];
        AttributedString[] attNames = new AttributedString[n];
        for (int i = 0; i < genera.size(); ++i) {
            tcColours[i] = this.p().inheritFilterColour ? genera.get(i).getColour() : this.p().colour;
            attNames[i] = this.toAttString(genera.get(i), false);
        }
        Object[] arr = genera.toArray();
        int m = this.setTracks(arr, attNames, tcColours, n);
        this.fillSampleData(cp, arr, m, n);
    }

    private void setDataSubType(ChartProperties cp) throws SQLException, SBException {
        LinkedList<String> types = new LinkedList<String>();
        for (Smpdtl smpdtl : this.parent.plotSmpdtl) {
            for (TaxonOcc occ : smpdtl.getOccurUnsorted()) {
                String type;
                if (!this.useOcc(occ) || types.contains(type = occ.getSpecTypeString())) continue;
                types.add(type);
            }
        }
        int n = types.size();
        Collections.sort(types);
        Color[] tcColours = new Color[n];
        Object[] names = new String[n];
        for (int i = 0; i < types.size(); ++i) {
            tcColours[i] = this.getDefaultColour();
            names[i] = (String)types.get(i);
        }
        int m = this.setTracks(names, null, tcColours, n);
        this.fillSampleData(cp, names, m, n);
    }

    private void setDataBoolean(ChartProperties cp) throws SQLException, SBException {
        int n = 2;
        Color[] tcColours = new Color[]{new Color(51, 102, 204), new Color(204, 51, 51)};
        Object[] curveNames = this.p().group.getCurveNames();
        assert (curveNames != null);
        int m = this.setTracks(curveNames, null, tcColours, n);
        this.fillSampleData(cp, curveNames, m, n);
    }

    private void setDataSituation(ChartProperties cp) throws SQLException, SBException {
        int n = 4;
        Color[] tcColours = new Color[]{new Color(51, 204, 100), new Color(51, 102, 204), new Color(204, 51, 51), new Color(50, 50, 50)};
        Object[] curveNames = this.p().group.getCurveNames();
        assert (curveNames != null);
        int m = this.setTracks(curveNames, null, tcColours, n);
        this.fillSampleData(cp, curveNames, m, n);
    }

    private void setDataTotal(ChartProperties cp) throws SQLException, SBException {
        String dataInclustionDescriptor;
        Object trackTitle;
        int n = 1;
        String prefix = null;
        if (this.getPanelTaxonOcc().getFilterObj() != null) {
            if (this.getPanelTaxonOcc().getFilterObj().getFilter() instanceof Integer) {
                if (this.getFilterCat() != null) {
                    prefix = this.getFilterCat().getName();
                } else if (this.getFilterGroup() != null) {
                    prefix = this.getFilterGroup().getName();
                } else assert (false);
            } else {
                prefix = this.getPanelTaxonOcc().getFilterObj().toString(false);
            }
        }
        switch (this.p().calc_style) {
            default: {
                trackTitle = PanelTaxon.getPanelTotalTitle(this.p());
                if (!this.isOverplot()) break;
                trackTitle = (String)trackTitle + ", cutoff = " + (int)this.p().cutoff;
                break;
            }
            case RICHNESS: 
            case SHANNON: 
            case FISHER: 
            case COSINETHETA: {
                trackTitle = this.p().calc_style.toString();
                trackTitle = ((String)trackTitle).substring(0, 1).toUpperCase() + ((String)trackTitle).substring(1);
                break;
            }
            case RELATIVE_OUTER: {
                trackTitle = "% ";
                trackTitle = this.parent.p.filter_set != null ? (String)trackTitle + this.parent.p.filter_set.getName() : (String)trackTitle + this.parent.getDiscID().getAbr(true);
            }
        }
        if (!this.p().hdr_key && (dataInclustionDescriptor = this.getDataInclusionDescriptor()) != null) {
            trackTitle = (String)trackTitle + " " + dataInclustionDescriptor;
        }
        if (prefix != null) {
            trackTitle = prefix + " (" + ((String)trackTitle).toLowerCase() + ")";
        }
        int m = this.setTracks(new String[]{trackTitle}, null, new Color[]{this.getDefaultColour()}, n);
        this.fillSampleData(cp, null, m, n);
        if (this.isOverplot() && !this.parent.overplotDataMatches(this) && !this.tracks.isEmpty()) {
            List<TaxonTrack> overplotTracks = this.parent.getOverplotTracks(this);
            if (overplotTracks.isEmpty()) {
                this.tracks.get((int)0).width = 0.0f;
                LOGGER.log(Level.WARNING, "inner taxon panel '" + this.toString() + "' overplot track non-empty on empty underlying track: ", this);
            } else {
                float maxWidth;
                TaxonTrack parentTrack = overplotTracks.get(0);
                parentTrack.width = maxWidth = Math.max(parentTrack.width, this.tracks.get((int)0).width);
                this.tracks.get((int)0).width = maxWidth;
            }
        }
    }

    private void fillSampleData(ChartProperties cp, Object[] objects, int m, int n) throws SQLException, SBException {
        assert (objects == null || objects.length == n);
        float[][][] sampleData = new float[this.parent.getnSamples()][n][m];
        boolean[][][] sampleDataOutsideCount = new boolean[this.parent.getnSamples()][n][m];
        float[] sampleTotal = this.p().calc_style == PanelTaxonProperties.Calc.RELATIVE_OUTER ? new float[this.parent.getnSamples()] : null;
        HashMap[][] tally = new HashMap[this.parent.getnSamples()][n];
        AbundanceScheme[] abnSchemes = new AbundanceScheme[this.parent.getnSamples()];
        HashSet<model3.Taxon> eventTaxa = null;
        if (this.getInterp() != null && this.p().onlyIncludeTaxaLinkedToEvents) {
            eventTaxa = new HashSet<model3.Taxon>();
            for (WellEvent ev : this.getInterp().getEvents()) {
                model3.Taxon eventTaxon = ev.getEvent().getTaxon();
                eventTaxa.add(eventTaxon);
            }
        }
        Iterator<Sample> sampleIt = this.parent.getSampleIterator(cp);
        int nSample = 0;
        block19: while (sampleIt.hasNext()) {
            Sample sample = sampleIt.next();
            Boolean sampleOutside = this.isOutsideBlockRange(sample);
            for (Smpdtl smpdtl : sample.getSmpdtls()) {
                if (!this.parent.useAnalysis(smpdtl, true)) continue;
                if (sampleOutside == null) {
                    if (this.p().colourSuites) {
                        PanelTaxon.fillColourArray(this.analystColours[nSample], this.colours[nSample]);
                    }
                    if (nSample > abnSchemes.length - 1) {
                        System.out.println("Quitting sample/analysis setting loop in PanelTaxon.fillSampleData due to array size mismatch");
                        continue block19;
                    }
                    abnSchemes[nSample] = this.parent.getDb().getAbundanceSchemeService().findAbundanceScheme(smpdtl.getHeader().getAbnSchID()).orElse(null);
                    if (abnSchemes[nSample] != null && this.p().abn_style == PanelTaxonProperties.Abundance.SEMIQ) {
                        this.putSemiQuantSuite(smpdtl.getHeader());
                    }
                }
                for (TaxonOcc fss : smpdtl.getOccurUnsorted()) {
                    if (eventTaxa != null && !eventTaxa.contains(fss.getTaxon())) continue;
                    if (this.useOcc(fss)) {
                        Integer j = null;
                        LinkedList<Integer> multiCurves = null;
                        block0 : switch (this.p().group) {
                            case GROUP: {
                                for (int i = 0; i < n; ++i) {
                                    if (!((TxGroup)objects[i]).isMember(fss.getTaxon().getSpecID(), this.parent.p.applySynToGroups ? this.parent.p.getSynSchID() : 0)) continue;
                                    if (j != null) {
                                        if (multiCurves == null) {
                                            multiCurves = new LinkedList<Integer>();
                                            multiCurves.add(j);
                                        }
                                        multiCurves.add(i);
                                        continue;
                                    }
                                    j = i;
                                }
                                break;
                            }
                            case GENUS: {
                                for (int i = 0; i < n; ++i) {
                                    if (((Genus)objects[i]).getGenID() != fss.getTaxon().getGenID()) continue;
                                    j = i;
                                    break block0;
                                }
                                break;
                            }
                            case CAT: 
                            case SUBTYPE: {
                                String compString = "";
                                switch (this.p().group) {
                                    case CAT: {
                                        compString = fss.getTaxon().getCatMnem();
                                        break;
                                    }
                                    case SUBTYPE: {
                                        compString = fss.getSpecTypeString();
                                        break;
                                    }
                                    default: {
                                        assert (false);
                                        break;
                                    }
                                }
                                for (int i = 0; i < n; ++i) {
                                    if (!compString.equals(objects[i])) continue;
                                    j = i;
                                    break block0;
                                }
                                break;
                            }
                            case CONF: {
                                j = fss.getQuestionable() ? 1 : 0;
                                break;
                            }
                            case SITU: {
                                switch (fss.getSituation()) {
                                    case INSITU: {
                                        j = 0;
                                        break;
                                    }
                                    case TR: {
                                        j = 1;
                                        break;
                                    }
                                    case RW: {
                                        j = 2;
                                        break;
                                    }
                                    case CV: {
                                        j = 3;
                                        break;
                                    }
                                    case CN: {
                                        j = 4;
                                    }
                                }
                                break;
                            }
                            default: {
                                j = 0;
                            }
                        }
                        if (sampleOutside == null) {
                            if (!this.isOverplot()) assert (j != null);
                            if (j != null) {
                                Integer[] jArr = new Integer[multiCurves != null ? multiCurves.size() : 1];
                                if (multiCurves != null) {
                                    jArr = multiCurves.toArray(new Integer[0]);
                                } else {
                                    jArr[0] = j;
                                }
                                for (Integer j2 : jArr) {
                                    this.countOcc(sampleData, sampleDataOutsideCount, nSample, j2, m, fss, smpdtl, abnSchemes[nSample], tally, jArr.length);
                                    this.setLabel(fss, nSample, j2, this.p().group != PanelTaxonProperties.Group.SITU && !Boolean.TRUE.equals(this.p().includeRw), this.p().group == PanelTaxonProperties.Group.SPEC && this.p().abn_style == PanelTaxonProperties.Abundance.MIX, this.p().group != PanelTaxonProperties.Group.CONF, null);
                                }
                            }
                        }
                        if (!(this.p().track_style != PanelTaxonProperties.Track.SINGLE || j == null || this.tracks.size() <= j || this.p().showFlags && (fss.getCaved() || fss.getReworked() || fss.getContamination()))) {
                            this.tracks.get(j).setDataRange(nSample, sampleOutside);
                        }
                    }
                    if (this.p().calc_style != PanelTaxonProperties.Calc.RELATIVE_OUTER || sampleOutside != null || !this.parentUseOcc(fss)) continue;
                    int n2 = nSample;
                    sampleTotal[n2] = sampleTotal[n2] + this.getDerivedCount(fss, smpdtl, abnSchemes[nSample], 1);
                }
                if (sampleOutside != null) continue;
                ++nSample;
            }
        }
        if (this.p().abn_style.setSemiQuant()) {
            this.setSemiQuant(sampleData, tally, abnSchemes, n);
        }
        this.copySampleData(sampleData, sampleDataOutsideCount, m, cp, sampleTotal, tally);
    }

    private float getDerivedCount(TaxonOcc fss, Smpdtl smpdtl, AbundanceScheme abnScheme, int divisor) {
        double derivedCount = fss.getDerivedCount((AbundanceScheme)(this.p().abn_style != PanelTaxonProperties.Abundance.MIX ? abnScheme : null), this.p().useSplits ? smpdtl.getCoarse() : 0.0f, this.p().useSplits ? smpdtl.getMedium() : 0.0f, this.p().useSplits ? smpdtl.getFine() : 0.0f);
        derivedCount = this.getNormalisedCount(smpdtl, derivedCount);
        if (divisor > 1) {
            derivedCount /= (double)divisor;
        }
        return (float)derivedCount;
    }

    private double getNormalisedCount(Smpdtl smpdtl, double derivedCount) {
        if (this.p().normaliseWeight && smpdtl.getWeight() > 0.0f && this.p().abn_style != PanelTaxonProperties.Abundance.SEMIQ) {
            derivedCount *= (double)(this.p().normalWeight / smpdtl.getWeight());
        }
        return derivedCount;
    }

    private void countOcc(float[][][] sampleData, boolean[][][] sampleDataOutsideCount, int nSample, int j, int m, TaxonOcc fss, Smpdtl smpdtl, AbundanceScheme abnScheme, HashMap[][] tally, int divisor) {
        if (this.p().abn_style == PanelTaxonProperties.Abundance.MIX && fss.getTotalCount() == 0) {
            return;
        }
        if (!fss.isOutsideCount() && (this.p().calc_style.isDiversity || this.p().calc_style == PanelTaxonProperties.Calc.RICHNESS || this.p().abn_style.setSemiQuant())) {
            if (tally[nSample][j] == null) {
                tally[nSample][j] = new HashMap();
            }
            if (tally[nSample][j].get(fss.getTaxon()) == null) {
                tally[nSample][j].put(fss.getTaxon(), Float.valueOf(this.getDerivedCount(fss, smpdtl, abnScheme, divisor)));
            } else {
                float count = ((Float)tally[nSample][j].get(fss.getTaxon())).floatValue();
                tally[nSample][j].put(fss.getTaxon(), Float.valueOf(count += this.getDerivedCount(fss, smpdtl, abnScheme, divisor)));
            }
        }
        switch (this.p().calc_style) {
            case RICHNESS: {
                float[] fArray = sampleData[nSample][j];
                int n = m > 1 ? this.getSubgroupInt(fss) : 0;
                fArray[n] = fArray[n] + 1.0f;
                break;
            }
            case SHANNON: 
            case FISHER: {
                float[] fArray = sampleData[nSample][j];
                fArray[0] = fArray[0] + this.getDerivedCount(fss, smpdtl, abnScheme, divisor);
                break;
            }
            default: {
                if (this.p().subgroup != PanelTaxonProperties.SubGroup.CMF) {
                    float[] fArray = sampleData[nSample][j];
                    int n = m > 1 ? this.getSubgroupInt(fss) : 0;
                    fArray[n] = fArray[n] + this.getDerivedCount(fss, smpdtl, abnScheme, divisor);
                    sampleDataOutsideCount[nSample][j][m > 1 ? this.getSubgroupInt((TaxonOcc)fss) : 0] = fss.isOutsideCount();
                    break;
                }
                AbundanceScheme abnSch = this.p().abn_style != PanelTaxonProperties.Abundance.MIX ? abnScheme : null;
                float[] fArray = sampleData[nSample][j];
                fArray[0] = (float)((double)fArray[0] + this.getNormalisedCount(smpdtl, fss.getDerivedCount(abnSch, TaxonOcc.SizeFraction.COARSE, this.p().useSplits ? smpdtl.getCoarse() : 0.0f)));
                float[] fArray2 = sampleData[nSample][j];
                fArray2[1] = (float)((double)fArray2[1] + this.getNormalisedCount(smpdtl, fss.getDerivedCount(abnSch, TaxonOcc.SizeFraction.MEDIUM, this.p().useSplits ? smpdtl.getMedium() : 0.0f)));
                float[] fArray3 = sampleData[nSample][j];
                fArray3[2] = (float)((double)fArray3[2] + this.getNormalisedCount(smpdtl, fss.getDerivedCount(abnSch, TaxonOcc.SizeFraction.FINE, this.p().useSplits ? smpdtl.getFine() : 0.0f)));
            }
        }
    }

    private int setTracks(Object[] objs, AttributedString[] attNames, Color[] tcColours, int n) throws SBException, SQLException {
        int m;
        assert (objs.length == tcColours.length);
        assert (objs.length == n);
        String[] subgroups = this.getSubgroups();
        int n2 = m = subgroups.length > 0 ? subgroups.length : 1;
        if (this.p().track_style == PanelTaxonProperties.Track.MULTI) {
            this.nCurves = n;
            this.nTracks = 1;
        } else {
            this.nCurves = m;
            this.nTracks = n;
        }
        boolean usingParentTracks = false;
        if (this.isOverplot()) {
            assert (this.p().track_style == PanelTaxonProperties.Track.SINGLE);
            if (this.parent.overplotDataMatches(this)) {
                this.tracks = this.parent.getOverplotTracks(this);
                usingParentTracks = true;
                assert (this.nTracks >= this.tracks.size());
                this.nTracks = this.tracks.size();
                if (this.nTracks > 0 && this.p().group == PanelTaxonProperties.Group.TOTAL) {
                    this.tracks.get((int)0).name = this.tracks.get((int)0).name + ", " + objs[0].toString();
                }
            } else assert (this.nTracks == 1);
        }
        this.colours = this.p().colourSuites ? new Color[this.parent.getnSamples()][this.nCurves] : new Color[this.nTracks][this.nCurves];
        Object[] objects = Arrays.copyOf(objs, n);
        String[] names = new String[objects.length];
        for (int j = 0; j < objects.length; ++j) {
            String string = names[j] = objects[j] instanceof Genus ? ((Genus)objects[j]).toString(true) : objects[j].toString();
            if (usingParentTracks || !(objects[j] instanceof String)) continue;
            objects[j] = null;
        }
        if (usingParentTracks) {
            if (this.nTracks > 1) {
                block1: for (i = 0; i < this.tracks.size(); ++i) {
                    for (int j = 0; j < names.length; ++j) {
                        if (!Objects.equals(this.tracks.get((int)i).name, names[j])) continue;
                        objs[i] = objects[j];
                        if (this.p().colourSuites) continue block1;
                        PanelTaxon.fillColourArray(tcColours[j], this.colours[i]);
                        continue block1;
                    }
                }
            } else if (!this.p().colourSuites && this.nTracks > 0) {
                PanelTaxon.fillColourArray(tcColours[0], this.colours[0]);
            }
        } else {
            this.tracks.clear();
            for (i = 0; i < this.nTracks; ++i) {
                TaxonTrack newTrack;
                if (this.p().track_style == PanelTaxonProperties.Track.MULTI) {
                    newTrack = new TaxonTrack(this, null, this.p().group.getTrackAdj(), names, null, null);
                    if (!this.p().colourSuites) {
                        this.colours[i] = tcColours;
                    }
                } else {
                    newTrack = new TaxonTrack(this, attNames != null ? attNames[i] : null, names[i], subgroups, objects[i], null);
                    if (!this.p().colourSuites) {
                        PanelTaxon.fillColourArray(tcColours[i], this.colours[i]);
                    }
                }
                this.tracks.add(newTrack);
            }
        }
        this.curveData = new float[this.parent.getnSamples()][this.nTracks][this.nCurves];
        this.curveHasOutsideCount = new boolean[this.parent.getnSamples()][this.nCurves];
        this.curveLabels = new String[this.parent.getnSamples()][this.nTracks];
        return m;
    }

    private void setSpecTypes() throws SBException, SQLException {
        if (this.specTypes != null && !this.specTypes.isEmpty()) {
            return;
        }
        this.specTypes = new LinkedList<Integer>();
        for (Smpdtl smpdtl : this.parent.plotSmpdtl) {
            if (!this.parent.useAnalysis(smpdtl, false)) continue;
            for (TaxonOcc occ : smpdtl.getOccurUnsorted()) {
                int type;
                if (!this.useOcc(occ) || this.specTypes.contains(type = occ.getSpecType())) continue;
                this.specTypes.add(type);
            }
        }
        Collections.sort(this.specTypes);
    }

    private static void fillColourArray(Color baseColour, Color[] colourArray) {
        Color colour;
        if (colourArray.length == 0) {
            return;
        }
        int c = 0;
        colourArray[c] = colour = baseColour;
        ++c;
        while (c < colourArray.length) {
            colourArray[c] = colour = ColourUtils.getLighterColour((Color)colour);
            ++c;
        }
    }

    private String[] getSubgroups() throws SBException, SQLException {
        if (this.p().subgroup.getGroupNames() == null) {
            if (this.getBlock().getWell() != null) {
                this.setSpecTypes();
                String[] names = new String[this.specTypes.size()];
                for (int i = 0; i < this.specTypes.size(); ++i) {
                    names[i] = this.parent.getDb().getSpeciesTypeService().getSpeciesType(this.specTypes.get(i).intValue()).map(SpeciesType::description).orElse("");
                }
                return names;
            }
            return new String[]{"Adult", "Juvenile"};
        }
        return this.p().subgroup.getGroupNames();
    }

    private int getSubgroupInt(TaxonOcc fss) {
        switch (this.p().subgroup) {
            case SITU: {
                switch (fss.getSituation()) {
                    case INSITU: {
                        return 0;
                    }
                    case TR: {
                        return 1;
                    }
                    case RW: {
                        return 2;
                    }
                    case CV: {
                        return 3;
                    }
                    case CN: {
                        return 4;
                    }
                }
            }
            case CONF: {
                if (fss.getQuestionable()) {
                    return 1;
                }
                return 0;
            }
            case SUBTYPE: {
                for (int i = 0; i < this.specTypes.size(); ++i) {
                    if (fss.getSpecType() != this.specTypes.get(i).intValue()) continue;
                    return i;
                }
                return 0;
            }
        }
        return 0;
    }

    private void setSemiQuant(float[][][] sampleData, int[][] tally, AbundanceScheme[] abnSchemes, int n) throws SBException {
        switch (this.p().abn_style) {
            case SEMIQ: {
                if (abnSchemes == null || abnSchemes.length != sampleData.length) {
                    throw new IllegalArgumentException("Abundance scheme array invalid in setSemiQuant()");
                }
                float maxValue = this.p().hist_height / this.p().horzScale;
                for (int i = 0; i < this.parent.getnSamples(); ++i) {
                    for (int j = 0; j < n; ++j) {
                        if (!(sampleData[i][j][0] > 0.0f) || tally[i][j] <= 0) continue;
                        int count = (int)sampleData[i][j][0];
                        if (abnSchemes[i] != null) {
                            int index = abnSchemes[i].getIndex(count) + 1;
                            sampleData[i][j][0] = maxValue / (float)abnSchemes[i].getEntryCount() * (float)index;
                            continue;
                        }
                        sampleData[i][j][0] = 0.0f;
                    }
                }
                break;
            }
            case PA: {
                for (int i = 0; i < this.parent.getnSamples(); ++i) {
                    for (int j = 0; j < n; ++j) {
                        if (tally[i][j] <= 0) continue;
                        sampleData[i][j][0] = this.p().hist_height / this.p().horzScale;
                    }
                }
                break;
            }
        }
    }

    private void setSemiQuant(float[][][] sampleData, HashMap[][] mapTally, AbundanceScheme[] abnSchemes, int n) throws SBException {
        int[][] tally = new int[mapTally.length][n];
        for (int i = 0; i < mapTally.length; ++i) {
            HashMap[] hashArr = mapTally[i];
            for (int j = 0; j < hashArr.length; ++j) {
                tally[i][j] = hashArr[j] != null ? hashArr[j].size() : 0;
            }
        }
        this.setSemiQuant(sampleData, tally, abnSchemes, n);
    }

    private void setTrackUnits(TaxonTrack track) throws SQLException, SBException {
        IGDUnit unit2;
        if (this.p().hdrScheme == null) {
            return;
        }
        IGDUnit unit = null;
        if (track.minAge != null && (unit = this.p().hdrScheme.findUnit(track.minAge.doubleValue(), true, false)) != null) {
            track.unit1 = unit.getAbr();
            if (track.unit1 == null || !this.p().schAbrs) {
                track.unit1 = unit.getName();
            }
            track.col1 = unit.getColour();
        }
        if (track.maxAge != null && (unit2 = this.p().hdrScheme.findUnit(track.maxAge.doubleValue(), false, true)) != null && (unit != null && unit2 != unit || unit == null)) {
            track.unit2 = unit2.getAbr();
            if (track.unit2 == null || !this.p().schAbrs) {
                track.unit2 = unit2.getName();
            }
            track.col2 = unit2.getColour();
        }
    }

    private void copySampleData(float[][][] sampleData, boolean[][][] sampleDataOutsideCount, int m, ChartProperties cp, float[] trackTotals, HashMap[][] tally) {
        if (this.p().track_style == PanelTaxonProperties.Track.MULTI) {
            assert (!this.isOverplot());
            float maxWidth = 0.0f;
            for (int i = 0; i < this.parent.getnSamples(); ++i) {
                float w = this.copySampleDataCurves(sampleData[i], sampleDataOutsideCount != null ? sampleDataOutsideCount[i] : null, i, trackTotals != null ? trackTotals[i] : 0.0f);
                if (!(w > maxWidth)) continue;
                maxWidth = w;
            }
            TaxonTrack track = this.tracks.get(0);
            track.width = maxWidth;
        } else {
            sampleData = this.sortTracks(sampleData, tally);
            switch (this.p().calc_style) {
                case COSINETHETA: {
                    this.copySampleDataMatrix(sampleData, tally);
                    break;
                }
                default: {
                    for (int i = 0; i < this.parent.getnSamples(); ++i) {
                        this.copySampleDataTracks(sampleData[i], i, m, trackTotals != null ? trackTotals[i] : 0.0f, tally != null ? tally[i] : null);
                    }
                }
            }
            if (this.events != null) {
                this.setTrackWidthEvents(cp);
            }
        }
        if (this.p().clearEmptyTracks) {
            this.clearEmptyTracks();
        }
    }

    private float copySampleDataCurves(float[][] sampleData, boolean[][] sampleDataOutsideCount, int nSample, float sampleTotal) {
        if (this.nCurves == 0) {
            return 0.0f;
        }
        float maxWidth = this.p().minWidth;
        for (int i = 0; i < this.nCurves; ++i) {
            float j = sampleData[i][0];
            if (sampleDataOutsideCount != null) {
                boolean bl = this.curveHasOutsideCount[nSample][i] = this.curveHasOutsideCount[nSample][i] || sampleDataOutsideCount[i][0];
            }
            if (i > 0) {
                j += this.curveData[nSample][0][i - 1];
            }
            if (i == this.nCurves - 1) {
                if (j < this.p().cutoff) {
                    if (j * this.p().horzScale > maxWidth) {
                        maxWidth = j * this.p().horzScale;
                    }
                } else {
                    maxWidth = this.p().maxWidth;
                }
            }
            this.curveData[nSample][0][i] = j;
        }
        float total = sampleTotal;
        switch (this.p().calc_style) {
            case RELATIVE: {
                total = this.curveData[nSample][0][this.nCurves - 1];
            }
            case RELATIVE_OUTER: {
                maxWidth = this.p().maxWidth;
                for (int i = this.nCurves - 1; i > -1; --i) {
                    if (!(this.curveData[nSample][0][i] > 0.0f)) continue;
                    this.curveData[nSample][0][i] = this.curveData[nSample][0][i] / total * 100.0f;
                }
                break;
            }
        }
        return maxWidth;
    }

    private void copySampleDataTracks(float[][] sampleData, int nSample, int m, float sampleTotalOuter, HashMap[] tally) {
        int k;
        int j;
        float sampletotal = 0.0f;
        if (this.p().calc_style == PanelTaxonProperties.Calc.RELATIVE_OUTER && this.getBlock().getWell() != null) {
            sampletotal = sampleTotalOuter;
        } else {
            for (j = 0; j < this.nTracks; ++j) {
                for (k = 0; k < m; ++k) {
                    sampletotal += sampleData[j][k];
                }
            }
        }
        switch (this.p().calc_style) {
            case RELATIVE: 
            case RELATIVE_OUTER: {
                for (j = 0; j < this.nTracks; ++j) {
                    for (k = 0; k < m; ++k) {
                        float f = sampletotal > 0.0f ? sampleData[j][k] / sampletotal * 100.0f : 0.0f;
                        if (k > 0) {
                            f += this.curveData[nSample][j][k - 1];
                        }
                        this.curveData[nSample][j][k] = f;
                        if (!this.p().showAbundance || k != m - 1) continue;
                        if ((double)f >= 1.0) {
                            this.curveLabels[nSample][j] = (int)SB.round((double)f, (int)0) + (String)(this.curveLabels[nSample][j] != null ? " " + this.curveLabels[nSample][j] : "");
                            continue;
                        }
                        if (!((double)f > 1.0E-4)) continue;
                        this.curveLabels[nSample][j] = ("" + SB.roundToSignificantFigures((double)f, (int)2)).substring(1) + (String)(this.curveLabels[nSample][j] != null ? " " + this.curveLabels[nSample][j] : "");
                    }
                }
                break;
            }
            case SHANNON: {
                for (j = 0; j < this.nTracks; ++j) {
                    float diversity = 0.0f;
                    if (this.getBlock().getWell() == null) {
                        diversity = PanelTaxon.getTemplateDiversityData()[j][nSample];
                    } else {
                        HashMap counts = tally[j];
                        if (counts != null) {
                            double N = sampleData[j][0];
                            Iterator it = counts.values().iterator();
                            double H = 0.0;
                            while (it.hasNext()) {
                                double pi = (double)((Float)it.next()).floatValue() / N;
                                H += pi * Math.log(pi);
                            }
                            diversity = (float)(H *= -1.0);
                        }
                    }
                    this.curveData[nSample][j][0] = diversity;
                    if (!this.p().showAbundance || !(diversity > 0.0f)) continue;
                    this.curveLabels[nSample][j] = SB.round((double)diversity, (int)2) + (String)(this.curveLabels[nSample][j] != null ? " " + this.curveLabels[nSample][j] : "");
                }
                break;
            }
            case FISHER: {
                for (j = 0; j < this.nTracks; ++j) {
                    float diversity = 0.0f;
                    if (this.getBlock().getWell() == null) {
                        diversity = PanelTaxon.getTemplateDiversityData()[j][nSample] * 2.5f;
                    } else {
                        HashMap counts = tally[j];
                        if (counts != null) {
                            double N = sampleData[j][0];
                            double S = counts.size();
                            if (!(N <= 1.0) && S != 0.0 && !(S >= N)) {
                                double alpha = 1.0;
                                double e = 1.0;
                                while (e > 1.0E-5) {
                                    double alpha2 = S / Math.log(1.0 + N / alpha);
                                    e = Math.abs(alpha2 - alpha);
                                    alpha = alpha2;
                                }
                                if (alpha > 0.0 && alpha != Double.NaN) {
                                    diversity = (float)alpha;
                                }
                            }
                        }
                    }
                    this.curveData[nSample][j][0] = diversity;
                    if (!this.p().showAbundance || !(diversity > 0.0f)) continue;
                    this.curveLabels[nSample][j] = SB.round((double)diversity, (int)2) + (String)(this.curveLabels[nSample][j] != null ? " " + this.curveLabels[nSample][j] : "");
                }
                break;
            }
            default: {
                for (j = 0; j < this.nTracks; ++j) {
                    for (k = 0; k < m; ++k) {
                        float f = sampleData[j][k];
                        if (k > 0) {
                            f += this.curveData[nSample][j][k - 1];
                        }
                        this.curveData[nSample][j][k] = f;
                        if (!this.p().showAbundance || this.p().abn_style.setSemiQuant() || k != m - 1 || !(f > 0.0f)) continue;
                        String countLabel = f < 1.0f ? ("" + SB.roundToSignificantFigures((double)f, (int)2)).substring(1) : "" + (int)f;
                        String curveLabel = this.curveLabels[nSample][j];
                        if (curveLabel != null && curveLabel.contains("+") && (curveLabel = curveLabel.replaceAll("[\\+]", "")).trim().isEmpty()) {
                            curveLabel = null;
                        }
                        this.curveLabels[nSample][j] = countLabel + (String)(curveLabel != null ? " " + curveLabel : "");
                    }
                }
            }
        }
        for (j = 0; j < this.nTracks; ++j) {
            float maxWidth;
            int labelWidth;
            TaxonTrack track = this.tracks.get(j);
            int n = labelWidth = this.curveLabels[nSample][j] != null ? this.curveLabels[nSample][j].length() : 0;
            if (this.p().plot_style != PanelTaxonProperties.Plot.NUMBERS) {
                float curvetotal = this.curveData[nSample][j][m - 1];
                if (this.p().justify == PanelTaxonProperties.Justify.CENTRE) {
                    float halfMaxWidth = curvetotal * this.p().horzScale / 2.0f + (float)labelWidth + 1.5f;
                    maxWidth = halfMaxWidth * 2.0f;
                } else {
                    maxWidth = (float)labelWidth + curvetotal * this.p().horzScale + 1.5f;
                }
            } else {
                maxWidth = labelWidth;
            }
            if (maxWidth > this.p().maxWidth) {
                maxWidth = this.p().maxWidth;
            }
            if (track.width < maxWidth) {
                track.width = maxWidth;
            }
            if (this.p().group != PanelTaxonProperties.Group.TOTAL || this.p().plot_style == PanelTaxonProperties.Plot.NUMBERS) continue;
            float limit = track.width / this.p().horzScale;
            float newLimit = limit < 100.0f ? (float)NumberUtils.significantDigitRounder((double)limit, (int)1, (int)1) : (float)NumberUtils.significantDigitRounder((double)limit, (int)2, (int)1);
            track.width = newLimit * this.p().horzScale;
        }
    }

    private void copySampleDataMatrix(float[][][] sampleData, HashMap[][] tally) {
        assert (this.p().calc_style == PanelTaxonProperties.Calc.COSINETHETA);
        if (tally == null) {
            return;
        }
        if (sampleData.length < 2) {
            return;
        }
        for (int nSample = this.parent.getnSamples() - 2; nSample >= 0; --nSample) {
            for (int nTrack = 0; nTrack < this.nTracks; ++nTrack) {
                float maxWidth;
                int labelWidth;
                HashMap iTally = tally[nSample + 1][nTrack];
                HashMap jTally = tally[nSample][nTrack];
                float sumij = 0.0f;
                float sumisq = 0.0f;
                float sumjsq = 0.0f;
                HashSet taxa = new HashSet();
                if (iTally != null) {
                    taxa.addAll(iTally.keySet());
                }
                if (jTally != null) {
                    taxa.addAll(jTally.keySet());
                }
                float cosTheta = 0.0f;
                if (!taxa.isEmpty()) {
                    for (Object o : taxa) {
                        model3.Taxon taxon = (model3.Taxon)o;
                        float xik = 0.0f;
                        float xjk = 0.0f;
                        boolean oneWasUsed = false;
                        if (iTally != null && iTally.get(taxon) != null) {
                            xik = ((Float)iTally.get(taxon)).floatValue();
                            oneWasUsed = true;
                        }
                        if (jTally != null && jTally.get(taxon) != null) {
                            xjk = ((Float)jTally.get(taxon)).floatValue();
                            oneWasUsed = true;
                        }
                        assert (oneWasUsed);
                        sumij += xik * xjk;
                        sumisq = (float)((double)sumisq + Math.pow(xik, 2.0));
                        sumjsq = (float)((double)sumjsq + Math.pow(xjk, 2.0));
                    }
                    cosTheta = (float)((double)sumij / Math.sqrt(sumisq * sumjsq));
                    if (Float.isNaN(cosTheta)) {
                        cosTheta = 0.0f;
                    }
                    if (this.p().showAbundance) {
                        this.curveLabels[nSample][nTrack] = SB.round((double)cosTheta, (int)2) + (String)(this.curveLabels[nSample][nTrack] != null ? " " + this.curveLabels[nSample][nTrack] : "");
                    }
                }
                this.curveData[nSample][nTrack][0] = cosTheta;
                int n = labelWidth = this.curveLabels[nSample][nTrack] != null ? this.curveLabels[nSample][nTrack].length() : 0;
                if (this.p().plot_style != PanelTaxonProperties.Plot.NUMBERS) {
                    float curvetotal = cosTheta;
                    if (this.p().justify == PanelTaxonProperties.Justify.CENTRE) {
                        float halfMaxWidth = curvetotal * this.p().horzScale / 2.0f + (float)labelWidth + 1.5f;
                        maxWidth = halfMaxWidth * 2.0f;
                    } else {
                        maxWidth = (float)labelWidth + curvetotal * this.p().horzScale + 1.5f;
                    }
                } else {
                    maxWidth = labelWidth;
                }
                if (maxWidth > this.p().maxWidth) {
                    maxWidth = this.p().maxWidth;
                }
                TaxonTrack track = this.tracks.get(nTrack);
                if (!(track.width < maxWidth)) continue;
                track.width = maxWidth;
            }
        }
    }

    private void setTrackWidthEvents(ChartProperties cp) {
        for (int i = 0; i < this.nTracks; ++i) {
            TaxonTrack track = this.tracks.get(i);
            if (this.events[i] == null) continue;
            float maxEvWidth = 0.0f;
            for (ChartObject co : this.events[i]) {
                float w;
                if (co.getPlotName().isEmpty() || !((w = SBGraphics.stringWidth(co.getPlotName(), cp.getFontSizeSmall())) > maxEvWidth)) continue;
                maxEvWidth = w;
            }
            track.width += maxEvWidth + 2.3f;
        }
    }

    private void setLabel(TaxonOcc fss, int nSample, int n, boolean useRw, boolean useSubjAbund, boolean useConf, AbundanceScheme abnSch) {
        if (!((!fss.isOutsideCount() || fss.getCaved() || useRw && fss.getReworked()) && this.p().showFlags || n >= this.curveLabels[nSample].length || this.curveLabels[nSample][n] != null && this.curveLabels[nSample][n].contains("+"))) {
            if (this.curveLabels[nSample][n] == null) {
                this.curveLabels[nSample][n] = "";
            } else {
                String[] stringArray = this.curveLabels[nSample];
                int n2 = n;
                stringArray[n2] = stringArray[n2] + " ";
            }
            String[] stringArray = this.curveLabels[nSample];
            int n3 = n;
            stringArray[n3] = stringArray[n3] + "+";
        }
        if (this.p().showFlags) {
            if (this.p().track_style == PanelTaxonProperties.Track.MULTI) {
                n = 0;
            }
            if (useSubjAbund) {
                if (fss.getTotalCount() == 0 && fss.getSubAbund().length() > 0) {
                    this.curveLabels[nSample][n] = fss.getSubAbund();
                } else if (this.p().abn_style == PanelTaxonProperties.Abundance.SEMIQ && abnSch != null) {
                    this.curveLabels[nSample][n] = fss.getSubAbund(abnSch);
                }
            }
            if (!(fss.getSituation() == Situation.INSITU || this.p().subgroup == PanelTaxonProperties.SubGroup.SITU || this.curveLabels[nSample][n] != null && this.curveLabels[nSample][n].contains(fss.getSituation().getAbr()))) {
                if (this.curveLabels[nSample][n] == null) {
                    this.curveLabels[nSample][n] = "";
                } else {
                    String[] stringArray = this.curveLabels[nSample];
                    int n4 = n;
                    stringArray[n4] = stringArray[n4] + " ";
                }
                String[] stringArray = this.curveLabels[nSample];
                int n5 = n;
                stringArray[n5] = stringArray[n5] + fss.getSituation().getAbr();
            }
            if (!(!useConf || fss.getIdentType() != '?' || this.p().subgroup == PanelTaxonProperties.SubGroup.CONF && !fss.isOutsideCount() || this.curveLabels[nSample][n] != null && this.curveLabels[nSample][n].contains("?"))) {
                if (this.curveLabels[nSample][n] == null) {
                    this.curveLabels[nSample][n] = "";
                } else {
                    String[] stringArray = this.curveLabels[nSample];
                    int n6 = n;
                    stringArray[n6] = stringArray[n6] + " ";
                }
                String[] stringArray = this.curveLabels[nSample];
                int n7 = n;
                stringArray[n7] = stringArray[n7] + "?";
            }
        }
        if (!(!this.p().showOccComments || fss.getComment() == null || fss.getComment().isEmpty() || fss.getComment().length() > this.p().occCommentsMaxLength || this.curveLabels[nSample][n] != null && this.curveLabels[nSample][n].contains(fss.getComment()))) {
            if (this.curveLabels[nSample][n] == null) {
                this.curveLabels[nSample][n] = "";
            } else {
                String[] stringArray = this.curveLabels[nSample];
                int n8 = n;
                stringArray[n8] = stringArray[n8] + " ";
            }
            String[] stringArray = this.curveLabels[nSample];
            int n9 = n;
            stringArray[n9] = stringArray[n9] + " " + fss.getComment();
        }
    }

    private void clearEmptyTracks() {
        LinkedList<Integer> empties = new LinkedList<Integer>();
        for (int nTrack = 0; nTrack < this.nTracks; ++nTrack) {
            boolean empty = true;
            block1: for (int nSample = 0; nSample < this.parent.getnSamples(); ++nSample) {
                for (int nCurve = 0; nCurve < this.nCurves; ++nCurve) {
                    if (!(this.curveData[nSample][nTrack][nCurve] > 0.0f)) continue;
                    empty = false;
                    break block1;
                }
            }
            if (!empty) continue;
            empties.add(nTrack);
        }
        if (empties.isEmpty()) {
            return;
        }
        LinkedList<Integer> reallyEmpty = new LinkedList<Integer>();
        for (Integer empty : empties) {
            boolean hasLabel = false;
            for (int nSample = 0; nSample < this.parent.getnSamples(); ++nSample) {
                if (this.curveLabels[nSample].length <= empty || this.curveLabels[nSample][empty] == null || this.curveLabels[nSample][empty].isEmpty()) continue;
                hasLabel = true;
                break;
            }
            if (hasLabel) continue;
            reallyEmpty.add(empty);
        }
        if (reallyEmpty.isEmpty()) {
            return;
        }
        empties = reallyEmpty;
        ArrayList<TaxonTrack> newTracks = new ArrayList<TaxonTrack>();
        Iterator<TaxonTrack> it = this.tracks.iterator();
        int i = 0;
        while (it.hasNext()) {
            TaxonTrack t = it.next();
            if (!empties.contains(i)) {
                newTracks.add(t);
            }
            ++i;
        }
        this.tracks = newTracks;
        float[][][] newCurveData = new float[this.parent.getnSamples()][this.nTracks - empties.size()][this.nCurves];
        boolean[][] newCurveDataOutsideCount = new boolean[this.parent.getnSamples()][this.nCurves];
        boolean[][] newMarkerData = null;
        if (this.markerData != null) {
            newMarkerData = new boolean[this.parent.getnSamples()][this.nTracks];
        }
        String[][] newCurveLabels = new String[this.parent.getnSamples()][this.nTracks];
        Color[][] newCurveColour = null;
        if (!this.p().colourSuites) {
            newCurveColour = new Color[this.nTracks - empties.size()][this.nCurves];
        }
        for (int nSample = 0; nSample < this.parent.getnSamples(); ++nSample) {
            int track = 0;
            for (int nTrack = 0; nTrack < this.nTracks; ++nTrack) {
                if (empties.contains(nTrack)) continue;
                System.arraycopy(this.curveData[nSample][nTrack], 0, newCurveData[nSample][track], 0, this.nCurves);
                newCurveLabels[nSample][track] = this.curveLabels[nSample][nTrack];
                if (!this.p().colourSuites) {
                    System.arraycopy(this.colours[nTrack], 0, newCurveColour[track], 0, this.nCurves);
                }
                if (this.markerData != null && this.p().highlightMarkers) {
                    newMarkerData[nSample][track] = this.markerData[nSample][nTrack];
                }
                ++track;
            }
            System.arraycopy(this.curveHasOutsideCount[nSample], 0, newCurveDataOutsideCount[nSample], 0, this.nCurves);
        }
        int nOrigTracks = this.nTracks;
        this.nTracks -= empties.size();
        this.curveData = newCurveData;
        this.curveHasOutsideCount = newCurveDataOutsideCount;
        this.curveLabels = newCurveLabels;
        this.markerData = newMarkerData;
        if (!this.p().colourSuites) {
            this.colours = newCurveColour;
        }
        if (this.p().drawEvents && this.events != null) {
            ChartObject[][] newEvents = new ChartObject[this.nTracks][];
            int track = 0;
            for (int nTrack = 0; nTrack < nOrigTracks; ++nTrack) {
                if (empties.contains(nTrack)) continue;
                newEvents[track] = this.events[nTrack];
                ++track;
            }
            this.events = newEvents;
        }
    }

    private void drawGrid(SBGraphics g, float xpos, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) {
        double blockTopDepth;
        g.setDashStroke(0.1f, 1.7f);
        g.setColor(Color.LIGHT_GRAY);
        TickScheme scheme = new TickScheme();
        scheme.calcScaleLabels(this.getBlock().getTopDepth(), this.getBlock().getScale(), this.getBlock().getProp().getUnits());
        float depth = 0.0f;
        float x2 = xpos + this.getTracksWidth();
        double blockBaseDepth = this.getBlock().getProp() == bp ? (double)this.getBlock().getBaseDepth() : (double)bp.getMax();
        double d = blockTopDepth = this.getBlock().getProp() == bp ? (double)this.getBlock().getTopDepth() : (double)bp.getMin();
        if ((double)depth > blockTopDepth) {
            while ((double)depth > blockTopDepth) {
                depth -= scheme.getLabelInterval();
            }
            depth += scheme.getLabelInterval();
        } else {
            while ((double)depth < blockTopDepth) {
                depth += scheme.getLabelInterval();
            }
        }
        while ((double)depth <= blockBaseDepth + (double)0.0029f) {
            float ypos = this.getBlock().scaleDepth(depth) + y + this.getPanelHeaderHeight(cp, mode);
            g.drawLine(xpos, ypos, x2, ypos);
            depth += scheme.getLabelInterval();
        }
        g.setColor(cp.foreground);
    }

    void setDataImages(final ChartProperties cp, final double[][] sections) throws SBException {
        final float width = this.p().imageWidth - this.p().imagePadding;
        LinkedList<ChartImage> newImages = new LinkedList<ChartImage>();
        ChartImage.ChartImageObserver imageObserver = new ChartImage.ChartImageObserver(){
            int nImagesLoaded;
            int total;
            final /* synthetic */ PanelTaxon this$0;
            {
                PanelTaxon panelTaxon = this$0;
                Objects.requireNonNull(panelTaxon);
                this.this$0 = panelTaxon;
            }

            @Override
            public boolean imageUpdate(Image img, int infoflags, int x, int y, int width2, int height) {
                if ((infoflags & 0x20) != 0) {
                    this.imageLoaded();
                    return false;
                }
                return true;
            }

            @Override
            public void imageLoaded() {
                ++this.nImagesLoaded;
                LOGGER.log(Level.CONFIG, "Image loaded (" + this.nImagesLoaded + "/" + this.total + ")");
                if (this.total > 0 && this.nImagesLoaded == this.total) {
                    this.allImagesLoaded();
                }
            }

            @Override
            public void setTotalImages(int target) {
                this.total = target;
                LOGGER.log(Level.CONFIG, "Setting image total (" + this.nImagesLoaded + "/" + this.total + ")");
                if (target > 0 && this.nImagesLoaded == target) {
                    this.allImagesLoaded();
                }
            }

            private void allImagesLoaded() {
                this.this$0.moveImagePositions(cp, sections, width);
            }
        };
        try {
            Iterator sampleIt = this.getBlock().getWell().getSamples().iterator();
            int i = 0;
            while (sampleIt.hasNext()) {
                Sample sample = (Sample)sampleIt.next();
                for (Smpdtl smpdtl : sample.getSmpdtls()) {
                    if (!this.parent.useAnalysis(smpdtl, true)) continue;
                    for (TaxonOcc occ : smpdtl.getOccurSorted()) {
                        if (occ.getImageSetID() <= 0 || !this.useOcc(occ) || this.p().filterMkrImages && !occ.isMarker()) continue;
                        double sampleDepth = this.getBlock().getWell().getDepth(sample, cp.correctDepths, cp.correctCuttings);
                        float yPos = this.getBlock().scaleDepth((float)sampleDepth);
                        ChartImage pi = null;
                        if (this.images != null && this.images.size() > i) {
                            if (this.images.get(i).getObject() == occ) {
                                pi = this.images.get(i);
                                pi.setOrigTop(yPos);
                                pi.setDepth(sampleDepth);
                            } else {
                                this.images = null;
                            }
                        }
                        if (pi == null) {
                            pi = new ChartImage(occ.getImageSetID(), yPos, width, this.parent.getDb().getImageRecordService(), this.parent.getDb().getImageLoader());
                            pi.setObserver(imageObserver);
                            pi.setObject(occ);
                            pi.setDepth(sampleDepth);
                        }
                        newImages.add(pi);
                        ++i;
                    }
                }
            }
        }
        catch (Exception e) {
            StackError.showStackError((Exception)e);
            throw new SBException("Error setting data in taxon images panel:\n" + e.getMessage());
        }
        this.images = newImages;
        if (this.images.isEmpty()) {
            return;
        }
        imageObserver.setTotalImages(this.images.size());
        this.parent.getDb().getTaxonImageService().addListener((TaxonImageService.TaxonImageListener)this);
        this.moveImagePositions(cp, sections, width);
    }

    private void moveImagePositions(ChartProperties cp, double[][] sections, float width) {
        if (this.images == null || this.images.isEmpty()) {
            return;
        }
        LOGGER.log(Level.CONFIG, "Moving image positions");
        float[] symbolSizes = new float[this.images.size()];
        float[] movedPositions = new float[this.images.size()];
        for (int i = 0; i < this.images.size(); ++i) {
            ChartImage pi = this.images.get(i);
            float imageHeight = pi.getHeight();
            if (imageHeight < 0.0f) {
                imageHeight = width;
            }
            symbolSizes[i] = imageHeight + 1.0f + cp.getFontSizeSmall();
            movedPositions[i] = pi.getOrigTop() - pi.getHeight() / 2.0f;
        }
        if (sections != null) {
            boolean ypos = false;
            boolean ddepth = true;
            int pos = 0;
            for (int j = 0; j < sections.length - 1; ++j) {
                int k;
                for (k = pos; k < movedPositions.length && !(this.images.get(k).getDepth() > sections[j + 1][1]); ++k) {
                }
                if (k - pos > 0) {
                    float[] section = Arrays.copyOfRange(movedPositions, pos, k);
                    float pos1 = (float)sections[j][0];
                    float pos2 = (float)sections[j + 1][0];
                    float[] symbolSizesSection = Arrays.copyOfRange(symbolSizes, pos, k);
                    SBPanel.moveSamplePositions(k - pos, section, symbolSizesSection, Math.min(pos1, pos2), Math.max(pos1, pos2) - symbolSizesSection[symbolSizesSection.length - 1]);
                    System.arraycopy(section, 0, movedPositions, pos, k - pos);
                }
                pos = k;
            }
        } else {
            float hPosition = this.getBlock().scaleDepth(this.getBlock().getTopDepth());
            float lPosition = this.getBlock().scaleDepth(this.getBlock().getBaseDepth()) - this.images.getLast().getHeight() - cp.getFontSizeSmall() - 2.0f;
            SBPanel.moveSamplePositions(this.images.size(), movedPositions, symbolSizes, hPosition, lPosition);
        }
        for (int i = 0; i < this.images.size(); ++i) {
            this.images.get(i).setMovedTop(movedPositions[i]);
        }
    }

    public void imagesForTaxonUpdated(int specID) {
        if (this.images == null || this.images.isEmpty()) {
            return;
        }
        float width = this.p().imageWidth - this.p().imagePadding;
        for (ChartImage image : this.images) {
            TaxonOcc occ;
            Object object = image.getObject();
            if (!(object instanceof TaxonOcc) || (occ = (TaxonOcc)object).getSpecID() != specID) continue;
            if (occ.getImageSetID() > 0) {
                ChartImage newImage = new ChartImage(occ.getImageSetID(), image.getOrigTop(), width, this.parent.getDb().getImageRecordService(), this.parent.getDb().getImageLoader());
                newImage.setObject(occ);
                newImage.setMovedTop(image.getMovedTop());
                int index = this.images.indexOf(image);
                this.images.add(index, newImage);
                this.images.remove(image);
                return;
            }
            this.images.remove(image);
            return;
        }
    }

    private void drawImagesPanel(SBGraphics g, float y, float xpos, BlockProperties bp, ChartProperties cp, Chart.Mode mode) throws SQLException, SBException {
        if (this.images == null || this.images.isEmpty()) {
            return;
        }
        if (mode != Chart.Mode.NO_HEADER && (bp == this.getBlock().getProp() || (double)Math.abs(this.getBlock().getTopDepth() - bp.getMin()) < 0.01)) {
            float ref = y + cp.panelCaptionHeight + (this.parent.alphabeticKey() ? cp.panelSubHeaderHeight / 2.0f : 0.0f);
            if (this.getCaption() != null && this.parent.size() > 1 && !this.parent.alphabeticKey()) {
                ref += this.parent.getInnerPanelCaptionHeight(cp);
            }
            g.drawLine(xpos, ref, xpos, y + bp.getHeight() + this.getPanelHeaderHeight(cp, mode));
            String subHeader = "Images" + (this.p().filterMkrImages ? " (markers)" : "");
            this.drawSubHeader(g, xpos, xpos + this.p().imageWidth, y, cp, bp, subHeader);
        } else {
            g.drawLine(xpos, y + this.getPanelHeaderHeight(cp, mode) + this.getBlock().scaleDepth(bp.getNormal() ? bp.getMin() : bp.getMax()), xpos, y + bp.getHeight() + this.getPanelHeaderHeight(cp, mode) + this.getBlock().scaleDepth(bp.getNormal() ? bp.getMin() : bp.getMax()));
        }
        g.setStroke(0.1f);
        g.setColor(cp.foreground);
        g.setFontSize(cp.getFontSizeSmall());
        float shift = y + this.getPanelHeaderHeight(cp, mode);
        float xincr = this.p().imagePadding / 3.0f;
        for (ChartImage pi : this.images) {
            float xleft;
            if (bp instanceof SubBlockProperties && (pi.getDepth() < (double)bp.getMin() || pi.getDepth() > (double)bp.getMax()) || !g.isVisible(xleft = xpos, pi.getMovedTop() + shift + 0.5f, pi.getWidth(), pi.getHeight())) continue;
            g.drawLine(xleft, pi.getOrigTop() + shift, xleft += xincr, pi.getOrigTop() + shift);
            g.drawLine(xleft, pi.getOrigTop() + shift, xleft += xincr, pi.getMovedTop() + shift + pi.getHeight() / 2.0f);
            g.drawLine(xleft, pi.getMovedTop() + shift + pi.getHeight() / 2.0f, xleft += xincr, pi.getMovedTop() + shift + pi.getHeight() / 2.0f);
            g.drawImage(pi.getImage(cp.requestHighResolution), xleft, pi.getMovedTop() + shift + 0.5f, pi.getWidth(), pi.getHeight());
            g.drawRect(xleft, pi.getMovedTop() + shift + 0.5f, this.p().imageWidth - this.p().imagePadding, pi.getHeight());
            float yString = pi.getMovedTop() + shift + pi.getHeight() + cp.getFontSizeSmall() + 0.5f;
            g.drawString(((TaxonOcc)pi.getObject()).toString(false, false), xleft, yString, this.p().imageWidth - this.p().imagePadding, 1, true);
        }
    }

    public char getDiscID() {
        return this.parent.getDiscID().getChar();
    }

    private float[][][] sortTracks(float[][][] sampleData, HashMap[][] tally) {
        assert (this.tracks.size() == this.nTracks);
        if (this.isOverplot()) {
            return sampleData;
        }
        Object[] trackArr = this.tracks.toArray();
        Collections.sort(this.tracks, new TaxonTrackComparator(this, this.p().sortType));
        float[][][] newSampleData = new float[this.parent.getnSamples()][this.nTracks][];
        boolean[][] newMarkerData = null;
        if (this.markerData != null) {
            newMarkerData = new boolean[this.parent.getnSamples()][this.nTracks];
        }
        String[][] newCurveLabels = new String[this.parent.getnSamples()][this.nTracks];
        Color[][] newColours = new Color[this.nTracks][];
        ChartObject[][] newEvents = this.events == null ? null : new ChartObject[this.nTracks][];
        HashMap[][] newTally = tally == null ? null : new HashMap[this.parent.getnSamples()][this.nTracks];
        block0: for (int b = 0; b < this.nTracks; ++b) {
            TaxonTrack track = this.tracks.get(b);
            for (int a = 0; a < this.nTracks; ++a) {
                if (trackArr[a] != track) continue;
                for (int s = 0; s < this.parent.getnSamples(); ++s) {
                    newSampleData[s][b] = sampleData[s][a];
                    newCurveLabels[s][b] = this.curveLabels[s][a];
                    if (this.markerData != null) {
                        newMarkerData[s][b] = this.markerData[s][a];
                    }
                    if (newTally == null) continue;
                    newTally[s][b] = tally[s][a];
                }
                if (!this.p().colourSuites) {
                    newColours[b] = this.colours[a];
                }
                if (newEvents == null) continue block0;
                newEvents[b] = this.events[a];
                continue block0;
            }
        }
        this.curveLabels = newCurveLabels;
        this.markerData = newMarkerData;
        this.events = newEvents;
        if (!this.p().colourSuites) {
            this.colours = newColours;
        }
        if (newTally != null && tally != null) {
            System.arraycopy(newTally, 0, tally, 0, tally.length);
        }
        return newSampleData;
    }

    @Override
    String getDataProps() {
        String[] data = new String[5];
        Object props = "";
        for (String string : data) {
            props = (String)props + string + "|";
        }
        return props;
    }

    Iterator getTrackIterator() {
        return this.tracks.iterator();
    }

    @Override
    int getnKeyTracks() {
        assert (this.nTracks == this.tracks.size());
        if (this.p().group == PanelTaxonProperties.Group.SPEC || this.p().group == PanelTaxonProperties.Group.GENUS) {
            return this.tracks.size();
        }
        return 0;
    }

    @Override
    String getTextTitle(String delim) {
        Object titles = "";
        switch (this.p().track_style) {
            case SINGLE: {
                for (TaxonTrack track : this.tracks) {
                    if (!((String)titles).isEmpty()) {
                        titles = (String)titles + delim;
                    }
                    Object trackName = track.name;
                    if (track.name.contains(delim)) {
                        trackName = "\"" + (String)trackName + "\"";
                    }
                    titles = (String)titles + (String)trackName;
                }
                break;
            }
            case MULTI: {
                for (String s : this.tracks.get((int)0).curveNames) {
                    if (!((String)titles).isEmpty()) {
                        titles = (String)titles + delim;
                    }
                    titles = (String)titles + s;
                }
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return titles;
    }

    @Override
    String getText(int nSample, String delim) {
        Object text = "";
        switch (this.p().track_style) {
            case SINGLE: {
                for (int i = 0; i < this.nTracks; ++i) {
                    if (i > 0) {
                        text = (String)text + delim;
                    }
                    if (this.p().showAbundance) {
                        if (this.curveLabels[nSample][i] == null) continue;
                        text = (String)text + this.curveLabels[nSample][i];
                        continue;
                    }
                    int nCurve = this.curveData[nSample][i].length - 1;
                    text = (String)text + String.valueOf(this.curveData[nSample][i][nCurve] > 0.0f ? Float.valueOf(this.curveData[nSample][i][nCurve]) : "");
                    if (!this.p().showFlags) continue;
                    text = (String)text + (this.curveLabels[nSample][i] != null ? this.curveLabels[nSample][i] : "");
                }
                break;
            }
            case MULTI: {
                for (int i = 0; i < this.nCurves; ++i) {
                    if (i > 0) {
                        text = (String)text + delim;
                    }
                    if (this.curveData[nSample][0][i] > 0.0f) {
                        float val = this.curveData[nSample][0][i] - (i > 0 ? this.curveData[nSample][0][i - 1] : 0.0f);
                        if (val > 0.0f) {
                            text = (String)text + val;
                            continue;
                        }
                        if (!this.curveHasOutsideCount[nSample][i]) continue;
                        text = (String)text + "+";
                        continue;
                    }
                    if (!this.curveHasOutsideCount[nSample][i]) continue;
                    text = (String)text + "+";
                }
                break;
            }
        }
        return text;
    }

    int getNtracks() {
        return this.nTracks;
    }

    int getNcurves() {
        return this.nCurves;
    }

    float[][][] getCurveData() {
        return this.curveData;
    }

    private String[] getTemplateNames(PanelTaxonProperties p, PanelTaxonOcc occ) throws SQLException {
        switch (p.group) {
            case CAT: {
                if (occ.getFilterCat() == null) break;
                return new String[]{occ.getFilterCat().getMnemonic()};
            }
            case GROUP: {
                if (occ.getFilter() == PanelTaxonOcc.Filter.FOR_EACH_GROUP) {
                    return new String[]{"Group"};
                }
                TxGroupSet set = null;
                if (occ.getFilterSet() != null) {
                    set = occ.getFilterSet();
                } else if (this.parent.getFilterSet() != null) {
                    set = this.parent.getFilterSet();
                }
                if (set != null) {
                    List groups = set.getGroups();
                    String[] groupNames = new String[groups.size()];
                    for (int i = 0; i < groupNames.length; ++i) {
                        groupNames[i] = ((TxGroup)groups.get(i)).getName();
                    }
                    return groupNames;
                }
                assert (false);
                return new String[]{"Group"};
            }
        }
        if (templateNames.get((Object)p.group) == null || p.group == PanelTaxonProperties.Group.TOTAL) {
            String[] names = p.group.getCurveNames();
            if (names == null || p.group == PanelTaxonProperties.Group.TOTAL) {
                switch (p.group) {
                    case SPEC: {
                        names = new String[]{"Species A", "Species B", "Species C", "Species D", "Species E", "Species F", "Species G", "Species H"};
                        break;
                    }
                    case GENUS: {
                        names = new String[]{"Genusone", "Genustwo", "Genusthree", "Genusfour", "Genusfive", "Genussix"};
                        break;
                    }
                    case CAT: {
                        names = new String[]{"CATA", "CATB", "CATC", "CATD"};
                        break;
                    }
                    case SUBTYPE: {
                        names = new String[]{"Adult", "Juvenile"};
                        break;
                    }
                    case TOTAL: {
                        names = new String[]{PanelTaxon.getPanelTotalTitle(p)};
                        break;
                    }
                    case GROUP: {
                        names = new String[]{"Group"};
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
            }
            templateNames.put(p.group, names);
        }
        return templateNames.get((Object)p.group);
    }

    private int getNTemplateTracks(PanelTaxonProperties p, PanelTaxonOcc occ) throws SQLException {
        switch (p.group) {
            case SPEC: {
                return 8;
            }
            case CAT: {
                if (occ.getFilter() instanceof Category) {
                    return 1;
                }
                return 4;
            }
            case GROUP: {
                if (occ.getFilter() instanceof TxGroupSet) {
                    return ((TxGroupSet)occ.getFilter()).getGroups().size();
                }
                if (occ.getFilter() == PanelTaxonOcc.Filter.FOR_EACH_GROUP) {
                    return 1;
                }
                if (this.parent.getFilterSet() != null) {
                    return this.parent.getFilterSet().getGroups().size();
                }
                assert (false);
                return 1;
            }
            case GENUS: {
                return 6;
            }
            case SITU: {
                return 4;
            }
            case CONF: 
            case SUBTYPE: {
                return 2;
            }
            case TOTAL: {
                return 1;
            }
        }
        assert (false);
        return 0;
    }

    private Color[] getTemplateColours(PanelTaxonProperties p, PanelTaxonOcc occ) throws SQLException {
        switch (p.group) {
            case SPEC: 
            case TOTAL: {
                return new Color[this.getNTemplateTracks(p, occ)];
            }
        }
        return Arrays.copyOf(templateColours, this.getNTemplateTracks(p, occ));
    }

    private String[] getTemplateTaxonAlphacodes(PanelTaxonProperties p, PanelTaxonOcc occ) throws SQLException {
        switch (p.group) {
            case SPEC: {
                String[] codes = new String[]{"Spc A", "Spc B", "Spc C", "Spc D", "Spc E", "Spc F", "Spc G", "Spc H"};
                assert (this.getNTemplateTracks(p, occ) <= codes.length);
                return codes;
            }
        }
        return null;
    }

    static float[][] getTemplateDiversityData() {
        if (diversityTemplateData == null) {
            diversityTemplateData = new float[8][];
            PanelTaxon.diversityTemplateData[0] = new float[]{2.78f, 2.88f, 0.0f, 3.21f, 2.95f};
            PanelTaxon.diversityTemplateData[1] = new float[]{0.9f, 1.0f, 0.0f, 0.0f, 0.0f};
            PanelTaxon.diversityTemplateData[2] = new float[]{0.0f, 1.0f, 0.0f, 0.0f, 1.2f};
            PanelTaxon.diversityTemplateData[3] = new float[]{2.35f, 3.13f, 2.56f, 3.1f, 3.41f};
            PanelTaxon.diversityTemplateData[4] = new float[]{1.45f, 1.89f, 1.0f, 1.87f, 2.31f};
            PanelTaxon.diversityTemplateData[5] = new float[]{0.0f, 1.74f, 0.0f, 1.89f, 2.35f};
            PanelTaxon.diversityTemplateData[6] = new float[]{0.0f, 2.67f, 0.0f, 3.51f, 1.54f};
            PanelTaxon.diversityTemplateData[7] = new float[]{2.11f, 2.21f, 1.13f, 1.56f, 0.0f};
        }
        return diversityTemplateData;
    }

    class TaxonTrack {
        final AttributedString attName;
        String name;
        final String codeName;
        final Object object;
        final String[] curveNames;
        float width;
        Double minAge;
        Double maxAge;
        String unit1;
        String unit2;
        Color col1;
        Color col2;
        Integer nSampleTop;
        Integer nSampleBase;
        final /* synthetic */ PanelTaxon this$0;

        TaxonTrack(PanelTaxon this$0, AttributedString attName, String name, String[] curveNames, Object object, String code) {
            PanelTaxon panelTaxon = this$0;
            Objects.requireNonNull(panelTaxon);
            this.this$0 = panelTaxon;
            this.width = this.this$0.p().minWidth;
            this.minAge = null;
            this.maxAge = null;
            this.unit1 = null;
            this.unit2 = null;
            this.col1 = null;
            this.col2 = null;
            if (name == null) {
                name = "";
            }
            this.name = name;
            this.codeName = code != null && !code.isEmpty() ? code : null;
            this.curveNames = curveNames;
            this.attName = attName;
            this.object = object;
        }

        String getToken(int i) {
            StringTokenizer tok = new StringTokenizer(this.name, "   ");
            String cat = tok.nextToken();
            if (i == 0) {
                return cat;
            }
            Object tname = "";
            if (tok.hasMoreTokens()) {
                tname = tok.nextToken();
            }
            while (tok.hasMoreTokens()) {
                tname = (String)tname + " " + tok.nextToken();
            }
            if (i == 1) {
                return tname;
            }
            return "";
        }

        boolean hasHeaderData() {
            return this.minAge != null || this.maxAge != null || this.unit1 != null || this.unit2 != null;
        }

        void setDataRange(int nSample, Boolean outside) {
            if (outside != null) {
                if (outside.booleanValue()) {
                    this.nSampleTop = -1;
                } else {
                    this.nSampleBase = -1;
                }
            } else {
                if (this.nSampleTop == null || nSample < this.nSampleTop) {
                    this.nSampleTop = nSample;
                }
                if (this.nSampleBase == null || nSample > this.nSampleBase) {
                    this.nSampleBase = nSample;
                }
            }
        }

        boolean hasData() {
            return this.nSampleTop != null && this.nSampleBase != null;
        }

        public String toString() {
            return this.name + " (" + this.nSampleTop + " - " + this.nSampleBase + ")";
        }

        private model3.Taxon getTaxon() {
            if (this.object instanceof model3.Taxon) {
                return (model3.Taxon)this.object;
            }
            if (this.object instanceof CompositeStandardEvent) {
                return ((CompositeStandardEvent)this.object).getEvent().getTaxon();
            }
            return null;
        }
    }

    public class PanelTaxonObject {
        TaxonTrack track;
        Sample sample;
        Smpdtl smpdtl;
        WellEvent event;

        PanelTaxonObject(PanelTaxon this$0, TaxonTrack track, Sample sample, Smpdtl smpdtl) {
            Objects.requireNonNull(this$0);
            this.track = track;
            this.sample = sample;
            this.smpdtl = smpdtl;
        }

        public Object getObject() {
            if (this.track.object instanceof CompositeStandardEvent) {
                return ((CompositeStandardEvent)this.track.object).getEvent().getTaxon();
            }
            return this.track.object;
        }

        public model3.Taxon getTaxon() {
            return this.track.getTaxon();
        }

        public Sample getSample() {
            return this.sample;
        }

        public Smpdtl getSmpdtl() {
            return this.smpdtl;
        }

        public WellEvent getEvent() {
            return this.event;
        }
    }

    private class TaxonTrackComparator
    implements Comparator {
        private final PanelTaxonProperties.Sort sort;
        final /* synthetic */ PanelTaxon this$0;

        TaxonTrackComparator(PanelTaxon panelTaxon, PanelTaxonProperties.Sort sort) {
            PanelTaxon panelTaxon2 = panelTaxon;
            Objects.requireNonNull(panelTaxon2);
            this.this$0 = panelTaxon2;
            this.sort = sort;
        }

        /*
         * Unable to fully structure code
         */
        public int compare(Object o1, Object o2) {
            if (!(o1 instanceof TaxonTrack) || !(o2 instanceof TaxonTrack)) {
                throw new IllegalArgumentException("Unidentified object in Taxon Track Comparator");
            }
            t1 = (TaxonTrack)o1;
            t2 = (TaxonTrack)o2;
            v0 = t1.object instanceof model3.Taxon != false ? ((model3.Taxon)t1.object).toString(false, false, false) : (t1name = t1.object instanceof Genus != false ? ((Genus)t1.object).toString(false) : t1.name);
            t2name = t2.object instanceof model3.Taxon != false ? ((model3.Taxon)t2.object).toString(false, false, false) : (t2.object instanceof Genus != false ? ((Genus)t2.object).toString(false) : t2.name);
            switch (2.$SwitchMap$jsbchart$panel$PanelTaxonProperties$Sort[this.sort.ordinal()]) {
                case 1: {
                    if (!(t1.object instanceof CompositeStandardEvent) || !(t2.object instanceof CompositeStandardEvent)) ** GOTO lbl17
                    e1 = (CompositeStandardEvent)t1.object;
                    e2 = (CompositeStandardEvent)t2.object;
                    if (e1.getCSU() < e2.getCSU()) {
                        return -1;
                    }
                    if (e1.getCSU() > e2.getCSU()) {
                        return 1;
                    }
                    ** GOTO lbl19
lbl17:
                    // 1 sources

                    if (this.this$0.parent.getBlock().getWell() != null) if (!TaxonTrackComparator.$assertionsDisabled) {
                        throw new AssertionError();
                    }
                }
lbl19:
                // 4 sources

                case 2: {
                    if (t1.object instanceof model3.Taxon && t2.object instanceof model3.Taxon) {
                        return ((model3.Taxon)t1.object).getSpecies().compareTo(((model3.Taxon)t2.object).getSpecies());
                    }
                }
                case 3: {
                    if (t1.object instanceof TxGroup && t2.object instanceof TxGroup && (this.this$0.parent.getFilterSet() != null || this.this$0.getFilterSet() != null)) {
                        if (!TaxonTrackComparator.$assertionsDisabled && this.this$0.p().group != PanelTaxonProperties.Group.GROUP) {
                            throw new AssertionError();
                        }
                        v1 = set = this.this$0.getFilterSet() != null ? this.this$0.getFilterSet() : this.this$0.parent.getFilterSet();
                        if (set.isOrdered()) {
                            return set.compareGroups((TxGroup)t1.object, (TxGroup)t2.object);
                        }
                    }
                    return t1name.compareTo(t2name);
                }
                case 4: 
                case 5: {
                    if (!t1.hasData() || !t2.hasData()) {
                        if (!t1.hasData() && !t2.hasData()) {
                            return t1.name.compareTo(t2.name);
                        }
                        if (t1.hasData()) {
                            return -1;
                        }
                        return 1;
                    }
                    if (this.sort == PanelTaxonProperties.Sort.SORTDOWNHOLE) {
                        if (t1.nSampleTop < t2.nSampleTop) {
                            return -1;
                        }
                        if (t1.nSampleTop > t2.nSampleTop) {
                            return 1;
                        }
                        if (t1.nSampleBase < t2.nSampleBase) {
                            return -1;
                        }
                        if (t1.nSampleBase > t2.nSampleBase) {
                            return 1;
                        }
                        return t1name.compareTo(t2name);
                    }
                    t1nSampleBase = t1.nSampleBase == -1 ? 0x7FFFFFFF : t1.nSampleBase;
                    v2 = t2nSampleBase = t2.nSampleBase == -1 ? 0x7FFFFFFF : t2.nSampleBase;
                    if (t1nSampleBase > t2nSampleBase) {
                        return -1;
                    }
                    if (t1nSampleBase < t2nSampleBase) {
                        return 1;
                    }
                    if (t1.nSampleTop > t2.nSampleTop) {
                        return -1;
                    }
                    if (t1.nSampleTop < t2.nSampleTop) {
                        return 1;
                    }
                    return t1name.compareTo(t2name);
                }
            }
            return 0;
        }
    }
}

