/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import com.stratadata.model3.taxon.Category;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Observer;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsbchart.block.BlockProperties;
import jsbchart.block.CorrelationPoint;
import jsbchart.block.WellBlock;
import jsbchart.core.Chart;
import jsbchart.core.ChartProperties;
import jsbchart.graphics.SBGraphics;
import jsbchart.listener.ChartEvent;
import jsbchart.listener.ChartNode;
import jsbchart.listener.ChartUpdate;
import jsbchart.panel.PanelTaxonGroup;
import jsbchart.panel.PanelTaxonOcc;
import jsbchart.panel.PanelTaxonPropertiesBase;
import jsbchart.panel.SBPanel;
import model3.CompositeStandard;
import model3.Sample;
import model3.Taxon;
import model3.TaxonOcc;
import model3.TxGroup;
import model3.TxGroupSet;
import model3.WellInterp;
import util.SBException;

public abstract class PanelTaxonBase
extends ChartNode
implements Observer {
    final PanelTaxonGroup parent;
    private final PanelTaxonOcc panelOcc;
    private PanelTaxonOcc.Filter forEachFilter;
    private boolean isPropertiesSelected = false;
    private boolean isPanelOccSelected = false;
    private static float[][] specTemplateData;
    static final int N_SPECIES_TRACKS = 8;

    PanelTaxonBase(PanelTaxonGroup parent, PanelTaxonOcc occ) {
        this.parent = parent;
        this.panelOcc = occ;
    }

    PanelTaxonBase(PanelTaxonGroup parent, PanelTaxonOcc occ, PanelTaxonOcc.Filter filter) {
        this.parent = parent;
        this.panelOcc = occ;
        if (filter.filter == null) {
            filter = null;
        }
        if (occ.getForEachInt() == null && filter != null && parent.getBlock().getWell() != null) {
            throw new IllegalArgumentException("Attempt to create forEach element with no filter");
        }
        this.forEachFilter = filter;
    }

    public PanelTaxonOcc getPanelTaxonOcc() {
        return this.panelOcc;
    }

    abstract PanelTaxonPropertiesBase getPanelTaxonProperties();

    abstract float draw(SBGraphics var1, float var2, float var3, ChartProperties var4, BlockProperties var5, Chart.Mode var6, int var7, int var8, Integer var9, HashSet<CorrelationPoint> var10, List<String> var11, float var12) throws SBException;

    abstract int getnKeyTracks();

    abstract float getWidth(BlockProperties var1);

    abstract String getTooltip(float var1, float var2, ChartProperties var3, BlockProperties var4, float var5);

    abstract Object getObject(float var1, float var2, ChartProperties var3, BlockProperties var4, float var5);

    abstract void setData(ChartProperties var1, double[][] var2) throws SQLException, SBException;

    void terminate() {
    }

    @Override
    public void setData(ChartEvent e, ChartUpdate update) throws SBException, SQLException, IOException {
        Logger.getLogger(this.getClass().getName()).log(Level.CONFIG, "{0}.setData ({1})", new Object[]{this.getClass().getSimpleName(), this});
        this.setData(update.getChartProperties(), update.getDataSections());
    }

    @Override
    public void prepareData(ChartUpdate update) {
    }

    public WellBlock getBlock() {
        return this.parent.getBlock();
    }

    boolean hasFilter() {
        return this.getFilterCat() != null || this.getFilterGroup() != null || this.getFilterSet() != null || this.getFilterSpec() != null;
    }

    public boolean getIncludeSubCats() {
        return this.panelOcc.getIncludeSubCats();
    }

    public Taxon getFilterSpec() {
        return this.panelOcc.getFilterSpec();
    }

    public Category getFilterCat() {
        Category filter = this.panelOcc.getFilterCat();
        if (filter == null && this.forEachFilter != null && this.forEachFilter.filter instanceof Category) {
            assert (this.panelOcc.getFilterObj().filter == PanelTaxonOcc.Filter.FOR_EACH_CAT);
            filter = (Category)this.forEachFilter.filter;
        }
        return filter;
    }

    public TxGroupSet getFilterSet() {
        return this.panelOcc.getFilterSet();
    }

    public TxGroup getFilterGroup() {
        TxGroup filter = this.panelOcc.getFilterGroup();
        if (filter == null && this.forEachFilter != null && this.forEachFilter.filter instanceof TxGroup) {
            assert (this.panelOcc.getFilterObj().filter == PanelTaxonOcc.Filter.FOR_EACH_GROUP);
            filter = (TxGroup)this.forEachFilter.filter;
        }
        return filter;
    }

    CompositeStandard getFilterCmpStd() {
        return this.panelOcc.getFilterCmpStd();
    }

    String getCaption() {
        if (this.panelOcc.getCaption() != null) {
            return this.panelOcc.getCaption();
        }
        return this.getFilterString();
    }

    String getFilterString() {
        String hdr = null;
        if (this.getFilterCat() != null) {
            hdr = this.getFilterCat().getMnemonic();
        } else if (this.getFilterGroup() != null) {
            hdr = this.getFilterGroup().getName();
        } else if (this.getFilterSet() != null) {
            hdr = this.getFilterSet().getName();
        } else if (this.getFilterSpec() != null) {
            hdr = this.getFilterSpec().toString(false, false);
        } else if (this.getFilterCmpStd() != null) {
            hdr = this.getFilterCmpStd().toString();
        }
        return hdr;
    }

    public String toString() {
        Object caption = this.getCaption();
        if (caption == null) {
            caption = "all " + this.parent.getDiscID().getAbr(true);
        }
        return caption;
    }

    boolean drawInnerCaption(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp) {
        String caption = this.getCaption();
        if (caption == null || caption.isEmpty()) {
            return false;
        }
        caption = this.parent.convertCaption(caption, cp);
        float fontSize = cp.getFontSizePanel();
        g.setFont(cp.font, 1, fontSize);
        if (!g.drawString(caption, x, y + fontSize, this.getWidth(bp), 0, false)) {
            if (caption.contains(" ")) {
                g.drawString(caption, x, y + fontSize, this.getWidth(bp), 0, true);
            } else {
                g.setColor(cp.background);
                g.fillRect(x + 1.0f, y + 1.0f, g.stringHeightSB(), g.stringWidth(caption));
                g.setColor(cp.foreground);
                g.drawStringVertical(caption, x + g.stringHeightSB() + 0.75f, y + g.stringWidth(caption) + 1.0f);
                return false;
            }
        }
        return true;
    }

    protected boolean useOccNoException(TaxonOcc occ) {
        try {
            return this.useOcc(occ);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    boolean useOcc(TaxonOcc occ) throws SQLException {
        if (!this.parentUseOcc(occ)) {
            return false;
        }
        if (this.getFilterCat() != null) {
            if (this.getIncludeSubCats() ? !occ.getTaxon().getCatMnem().startsWith(this.getFilterCat().getMnemonic()) : !occ.getTaxon().getCatMnem().equals(this.getFilterCat().getMnemonic())) {
                return false;
            }
        } else if (this.getFilterSet() != null) {
            boolean found = false;
            for (TxGroup group : this.getFilterSet().getGroups()) {
                if (!group.isMember(occ.getTaxon().getSpecID(), this.parent.p.applySynToGroups ? this.parent.p.getSynSchID() : 0)) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
        } else if (this.getFilterGroup() != null ? !this.getFilterGroup().isMember(occ.getTaxon().getSpecID(), this.parent.p.applySynToGroups ? this.parent.p.getSynSchID() : 0) : (this.getFilterSpec() != null ? occ.getTaxon().getSpecID() != this.getFilterSpec().getSpecID() : this.getFilterCmpStd() != null && !this.getFilterCmpStd().hasTaxon(occ.getTaxon().getSpecID(), this.parent.p.applySynToGroups ? this.parent.p.getSynSchID() : 0))) {
            return false;
        }
        PanelTaxonPropertiesBase p = this.getPanelTaxonProperties();
        if (p.subTypes != null && !p.subTypes.contains(occ.getSpecType())) {
            return false;
        }
        if (p.exclGroup != null && p.exclGroup.isMember(occ.getTaxon().getSpecID(), this.parent.p.getSynSchID())) {
            return false;
        }
        if (occ.getTransported() && Objects.equals(p.includeTr, Boolean.FALSE)) {
            return false;
        }
        if (occ.getReworked() && Objects.equals(p.includeRw, Boolean.FALSE)) {
            return false;
        }
        if (occ.getCaved() && Objects.equals(p.includeCv, Boolean.FALSE)) {
            return false;
        }
        if (occ.getContamination() && Objects.equals(p.includeCn, Boolean.FALSE)) {
            return false;
        }
        if (occ.getQuestionable() && Objects.equals(p.includeQ, Boolean.FALSE)) {
            return false;
        }
        if (Objects.equals(p.includeTr, Boolean.TRUE) && !occ.getTransported()) {
            return false;
        }
        if (Objects.equals(p.includeRw, Boolean.TRUE) && !occ.getReworked()) {
            return false;
        }
        if (Objects.equals(p.includeQ, Boolean.TRUE) && !occ.getQuestionable()) {
            return false;
        }
        if (Objects.equals(p.includeCv, Boolean.TRUE) && !occ.getCaved()) {
            return false;
        }
        if (Objects.equals(p.includeCn, Boolean.TRUE) && !occ.getContamination()) {
            return false;
        }
        return occ.getTotalCount() >= p.thresholdCount || !occ.getSubAbund(false).isEmpty();
    }

    boolean parentUseOcc(TaxonOcc occ) throws SQLException {
        if (this.parent.getFilterSet() != null) {
            boolean found = false;
            for (TxGroup group : this.parent.getFilterSet().getGroups()) {
                if (!group.isMember(occ.getTaxon().getSpecID(), this.parent.p.applySynToGroups ? this.parent.getProperties().getSynSchID() : 0)) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
        } else if (this.parent.p.hasFilterCat()) {
            return this.parent.p.useCat(occ.getTaxon().getCatMnem());
        }
        return true;
    }

    Boolean isOutsideBlockRange(Sample sample) {
        float depth = (float)sample.getDepth();
        if (depth < this.getBlock().getTopDepth(sample.getWellID())) {
            return true;
        }
        if (depth > this.getBlock().getBaseDepth(sample.getWellID())) {
            return false;
        }
        return null;
    }

    abstract String getDataProps();

    float getPanelHeaderHeight(ChartProperties cp, Chart.Mode mode) {
        if (this.getBlock() != null) {
            return SBPanel.getPanelHeaderHeight(cp, mode, this.getBlock());
        }
        switch (mode) {
            case NO_HEADER: {
                return 0.0f;
            }
        }
        return cp.getPanelHeaderHeight();
    }

    void drawSubHeader(SBGraphics g, float leftX, float rightX, float y, ChartProperties p, BlockProperties bp, String subHeader) {
        g.setFont(p.font, 0, p.getFontSizeHeader());
        g.drawStringVertical(subHeader, leftX + (rightX - leftX) / 2.0f, y + this.parent.getBlock().getHeaderHeight(p) - p.getFontSizeHeader(), p.panelSubHeaderHeight - p.getFontSizeHeader(), true, false, true);
    }

    void setPropertiesSelected(boolean isSelected) {
        this.isPropertiesSelected = isSelected;
    }

    void setPanelOccSelected(boolean isSelected) {
        this.isPanelOccSelected = isSelected;
    }

    protected boolean isPropertiesSelected() {
        return this.isPropertiesSelected;
    }

    protected boolean isPanelOccSelected() {
        return this.isPanelOccSelected;
    }

    public PanelTaxonGroup getParent() {
        return this.parent;
    }

    abstract String getText(int var1, String var2);

    abstract String getTextTitle(String var1);

    WellInterp getInterp() {
        int interpID = this.getParent().getInterpID(this.getParent().getBlock());
        try {
            return this.getParent().getBlock().getWell().getInterp(interpID);
        }
        catch (SBException sbe) {
            return null;
        }
    }

    static float[][] getTemplateData() {
        if (specTemplateData == null) {
            specTemplateData = new float[8][];
            PanelTaxonBase.specTemplateData[0] = new float[]{6.0f, 6.0f, 0.0f, 24.0f, 8.0f};
            PanelTaxonBase.specTemplateData[1] = new float[]{2.0f, 1.0f, 0.0f, 0.0f, 0.0f};
            PanelTaxonBase.specTemplateData[2] = new float[]{0.0f, 1.0f, 0.0f, 0.0f, 3.0f};
            PanelTaxonBase.specTemplateData[3] = new float[]{17.0f, 45.0f, 1.0f, 71.0f, 134.0f};
            PanelTaxonBase.specTemplateData[4] = new float[]{5.0f, 6.0f, 1.0f, 4.0f, 2.0f};
            PanelTaxonBase.specTemplateData[5] = new float[]{0.0f, 4.0f, 0.0f, 2.0f, 8.0f};
            PanelTaxonBase.specTemplateData[6] = new float[]{0.0f, 17.0f, 0.0f, 26.0f, 5.0f};
            PanelTaxonBase.specTemplateData[7] = new float[]{2.0f, 9.0f, 2.0f, 17.0f, 0.0f};
        }
        return specTemplateData;
    }
}

