/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.taxon.Category;
import com.stratadata.model3.user.Userdef;
import com.stratadata.model3.well.analysis.SpeciesType;
import com.stratadata.model3.well.sample.SampleType;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jsbchart.panel.ChartPanel;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelTaxonOcc;
import jsbchart.panel.PanelTaxonProperties;
import jsbchart.panel.PanelTaxonPropertiesBase;
import jsbchart.panel.PanelTaxonType;
import jsbchart.panel.PanelType;
import model3.SBdb;
import model3.SynonymScheme;
import model3.TxGroupSet;
import org.apache.commons.lang3.StringUtils;
import util.SB;

public class PanelTaxonGroupProperties
extends PanelProperties {
    private static final Logger LOGGER = Logger.getLogger(PanelTaxonGroupProperties.class.getName());
    private LinkedList<PanelTaxonOcc> innerPanels;
    Set<SampleType> sampleTypes = null;
    TxGroupSet filter_set = null;
    private List<Category> filter_cat = null;
    List<Userdef> analysts;
    Set<Integer> suiteNos;
    boolean moveSamplePositions = true;
    boolean alphabeticKey = false;
    int synschID = 0;
    boolean applySynToGroups = true;
    boolean showJuniorSynonyms = true;
    AnalysisTypeFilter analysisTypeFilter = AnalysisTypeFilter.ANALYSED_ONLY;
    public static final int PROP_FILTER = 0;
    public static final int PROP_SAMPTYPES = 1;
    public static final int PROP_ANALYSTS = 2;
    public static final int PROP_SUITE_NOS = 3;
    public static final int PROP_PREPAREDSAMPLES = 4;
    public static final int PROP_MVSMPLPOS = 5;
    public static final int PROP_ALPHAKEY = 6;
    public static final int PROP_SYNSCH = 7;
    public static final int PROP_SYN_JR = 8;
    public static final int PROP_APPLY_SYN_GROUPS = 9;
    private static final String[] propNames = new String[]{"Restrict data to", "Sample types", "Analysts", "Suite numbers", "Plot analyses", "Distribute samples", "Alphabetic key", "Synonym scheme", "Show junior synonyms", "Apply synonymy to groups & cmps."};
    private static final int[] TITLE_ROWS = new int[]{7};
    private static final String[] TITLE_NAMES = new String[]{"Synonymy"};

    public LinkedList<PanelTaxonOcc> getInnerPanels() {
        return new LinkedList<PanelTaxonOcc>(this.innerPanels);
    }

    public final PanelTaxonOcc addInnerPanel(PanelTaxonType ptType) {
        PanelTaxonOcc newOcc = new PanelTaxonOcc(ptType, this.getDefaultProperties(ptType), true, false);
        for (int i = 0; i < newOcc.getProperties().getnProps(); ++i) {
            String invalidString = this.verifyInnerPanelProperty(newOcc, i, newOcc.getProperties().getProperty(i));
            if (invalidString == null) continue;
            System.out.println("New inner panel property was invalid: " + invalidString);
            newOcc.setIsDefault(false);
            newOcc.setPropertiesObj(PanelTaxonPropertiesBase.getDefaultProperties(newOcc.getType()));
            break;
        }
        this.innerPanels.add(newOcc);
        return newOcc;
    }

    public final void addInnerPanel(PanelTaxonOcc occ) {
        this.innerPanels.add(occ);
    }

    public void removeInnerPanel(PanelTaxonOcc occ) {
        ListIterator it = this.innerPanels.listIterator();
        while (it.hasNext()) {
            PanelTaxonOcc pto = (PanelTaxonOcc)it.next();
            if (pto != occ) continue;
            if (PanelTaxonGroupProperties.isOverplotBase(this.innerPanels, occ)) {
                for (PanelTaxonOcc overplotted : PanelTaxonGroupProperties.getOverplotted(this.innerPanels, occ)) {
                    overplotted.setOverplot(false);
                }
            }
            it.remove();
            return;
        }
        throw new IllegalArgumentException("Attempt to remove PanelTaxonOcc which wasn't in PanelTaxonGroupProperties");
    }

    public boolean moveInnerPanel(PanelTaxonOcc occ, boolean left) {
        int index = this.innerPanelIndexOf(occ);
        if (left) {
            int baseIndex;
            newIndex = index - 1;
            if (newIndex < 0) {
                return false;
            }
            if (occ.isOverplot() && newIndex <= (baseIndex = this.innerPanelIndexOf(PanelTaxonGroupProperties.getOverplotBase(this.innerPanels, occ)))) {
                return false;
            }
        } else {
            newIndex = index + 1;
            if (newIndex > this.innerPanels.size() - 1) {
                return false;
            }
            if (occ.isOverplot() && !this.innerPanels.get(newIndex).isOverplot()) {
                return false;
            }
            if (PanelTaxonGroupProperties.isOverplotBase(this.innerPanels, occ)) {
                for (int i = newIndex; i < this.innerPanels.size() && this.innerPanels.get(i).isOverplot(); ++i) {
                    if (i != this.innerPanels.size() - 1) continue;
                    return false;
                }
            }
        }
        boolean hasOverplotted = false;
        for (PanelTaxonOcc inner : this.innerPanels) {
            if (!inner.isOverplot()) continue;
            hasOverplotted = true;
            break;
        }
        if (hasOverplotted && !occ.isOverplot()) {
            ArrayList stacks = new ArrayList();
            ArrayList<PanelTaxonOcc> currentStack = new ArrayList<PanelTaxonOcc>();
            ArrayList<PanelTaxonOcc> theChosenStack = null;
            for (PanelTaxonOcc panelTaxonOcc : this.innerPanels) {
                if (!panelTaxonOcc.isOverplot() && !currentStack.isEmpty()) {
                    stacks.add(currentStack);
                    if (currentStack.get(0) == occ) {
                        theChosenStack = currentStack;
                    }
                    currentStack = new ArrayList();
                }
                currentStack.add(panelTaxonOcc);
            }
            if (!currentStack.isEmpty()) {
                stacks.add(currentStack);
            }
            if (theChosenStack == null) {
                assert (currentStack.get(0) == occ);
                theChosenStack = currentStack;
            }
            index = stacks.indexOf(theChosenStack);
            stacks.remove(theChosenStack);
            stacks.add(left ? index - 1 : index + 1, theChosenStack);
            this.innerPanels.clear();
            for (List list : stacks) {
                this.innerPanels.addAll(list);
            }
        } else {
            PanelTaxonOcc removed = this.innerPanels.remove(index);
            assert (removed == occ);
            this.innerPanels.add(left ? index - 1 : index + 1, occ);
        }
        return true;
    }

    private int innerPanelIndexOf(PanelTaxonOcc occ) {
        for (int i = 0; i < this.innerPanels.size(); ++i) {
            if (this.innerPanels.get(i) != occ) continue;
            return i;
        }
        throw new IllegalStateException("Inner panel not in list: " + String.valueOf(occ));
    }

    public PanelTaxonOcc addInnerPanel(ChartPanel panel, PanelTaxonType type) {
        this.checkLocalPanelProperties(panel);
        return this.addInnerPanel(type);
    }

    public void moveInnerPanel(ChartPanel panel, PanelTaxonOcc occ, boolean left) {
        this.checkLocalPanelProperties(panel);
        this.moveInnerPanel(occ, left);
    }

    public void removeInnerPanel(ChartPanel panel, PanelTaxonOcc occ) {
        this.checkLocalPanelProperties(panel);
        this.removeInnerPanel(occ);
    }

    private void checkLocalPanelProperties(ChartPanel panel) {
        if (panel == null) {
            throw new IllegalArgumentException("Illegal use of removeInnerPanel");
        }
        if (panel.getProperties() != this || panel.getTemplate().getProperties() == this || panel.getTemplate().getEditableProp() == this) {
            throw new IllegalArgumentException("Illegal use of removeInnerPanel");
        }
    }

    public void updateOcc(ChartPanel panel, PanelTaxonOcc occ, int nProp, Object prop) {
        this.checkLocalPanelProperties(panel);
        if (!this.innerPanels.contains(occ)) {
            throw new IllegalStateException("Illegal attempt to edit panelOcc");
        }
        block0 : switch (nProp) {
            case 0: {
                occ.setCaption((String)prop);
                break;
            }
            case 1: {
                boolean didEdit;
                boolean isOverplotBase = PanelTaxonGroupProperties.isOverplotBase(this.innerPanels, occ);
                PanelTaxonOcc.Filter filter = (PanelTaxonOcc.Filter)prop;
                if (isOverplotBase && filter != null && filter.isForEach() || !(didEdit = occ.setFilter(filter)) || !isOverplotBase) break;
                for (PanelTaxonOcc overplotted : PanelTaxonGroupProperties.getOverplotted(this.innerPanels, occ)) {
                    overplotted.setFilter(filter);
                }
                break;
            }
            case 2: {
                boolean didEdit = occ.setIncludeSubCats((Boolean)prop);
                if (!didEdit || !PanelTaxonGroupProperties.isOverplotBase(this.innerPanels, occ)) break;
                for (PanelTaxonOcc overplotted : PanelTaxonGroupProperties.getOverplotted(this.innerPanels, occ)) {
                    overplotted.setIncludeSubCats((Boolean)prop);
                }
                break;
            }
            case 3: {
                boolean didEdit = occ.setIsDefault((Boolean)prop);
                if (!didEdit) break;
                boolean isNowDefault = (Boolean)prop;
                if (!isNowDefault) {
                    occ.setPropertiesObj(occ.getProperties().createCopy());
                    break;
                }
                for (PanelTaxonOcc pto : this.getInnerPanels()) {
                    if (pto == occ || pto.type != occ.type || !pto.isDefault()) continue;
                    occ.setPropertiesObj(pto.getProperties());
                    break block0;
                }
                break;
            }
            case 4: {
                PanelTaxonOcc overplotBase;
                boolean overplot = (Boolean)prop;
                boolean didEdit = false;
                if (!overplot || PanelTaxonGroupProperties.canOverplot(this.innerPanels, occ)) {
                    didEdit = occ.setOverplot(overplot);
                }
                if (!didEdit || !overplot) break;
                if (occ.isDefault()) {
                    this.updateOcc(panel, occ, 3, false);
                }
                if ((overplotBase = PanelTaxonGroupProperties.getOverplotBase(this.innerPanels, occ)).getFilterObj() != null) {
                    if (overplotBase.getFilterObj().isForEach()) {
                        overplotBase.setFilter(null);
                    } else {
                        occ.setFilter(new PanelTaxonOcc.Filter(overplotBase.getFilterObj().filter, overplotBase.getFilterObj().includeSubCats));
                    }
                } else {
                    occ.setFilter(null);
                }
                PanelTaxonProperties overplotBaseProp = (PanelTaxonProperties)overplotBase.getProperties();
                for (int iProp = 0; iProp < ((PanelTaxonProperties)occ.getProperties()).getnProps(); ++iProp) {
                    if (!PanelTaxonProperties.isOverplotRow(iProp)) continue;
                    occ.getProperties().setProperty(iProp, overplotBaseProp.getProperty(iProp));
                }
                if (!overplotBase.isDefault()) break;
                this.updateOcc(panel, occ, 3, false);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    PanelTaxonPropertiesBase getDefaultProperties(PanelTaxonType type) {
        for (PanelTaxonOcc occ : this.innerPanels) {
            if (occ.type != type || !occ.isDefault()) continue;
            return occ.getProperties();
        }
        return PanelTaxonPropertiesBase.getDefaultProperties(type);
    }

    @Override
    public int getnProps() {
        return propNames.length;
    }

    @Override
    public String getPropertyName(int nProp) {
        return propNames[nProp];
    }

    @Override
    public int[] getTitleRows() {
        return TITLE_ROWS;
    }

    @Override
    public boolean showRow(int row) {
        if (row == 8 || row == 9) {
            return this.synschID > 0;
        }
        return true;
    }

    @Override
    public boolean hasShowRowDependencies(int nProp) {
        return nProp == 7;
    }

    @Override
    public String getTitleName(int titleNo) {
        if (titleNo < 0 || titleNo > TITLE_NAMES.length - 1) {
            return null;
        }
        return TITLE_NAMES[titleNo];
    }

    @Override
    public Object getProperty(int nProp) {
        switch (nProp) {
            case 0: {
                if (this.filter_set == null && this.filter_cat == null) {
                    return null;
                }
                return new PanelTaxonOcc.Filter(this.filter_set != null ? this.filter_set : this.filter_cat.toArray(new Category[this.filter_cat.size()]), true);
            }
            case 1: {
                return this.sampleTypes;
            }
            case 2: {
                return this.analysts;
            }
            case 3: {
                return this.suiteNos;
            }
            case 4: {
                return this.analysisTypeFilter;
            }
            case 5: {
                return this.moveSamplePositions;
            }
            case 6: {
                return this.alphabeticKey;
            }
            case 7: {
                return this.synschID;
            }
            case 8: {
                return this.showJuniorSynonyms;
            }
            case 9: {
                return this.applySynToGroups;
            }
        }
        assert (false);
        return null;
    }

    @Override
    public boolean setProperty(int nProp, Object prop) {
        if (this.getProperty(nProp) == null ^ prop == null || this.getProperty(nProp) != null && !this.getProperty(nProp).equals(prop)) {
            switch (nProp) {
                case 0: {
                    prop = prop instanceof PanelTaxonOcc.Filter ? ((PanelTaxonOcc.Filter)prop).filter : null;
                    if ((prop == null || prop instanceof Category[]) && this.filter_set != null) {
                        for (PanelTaxonOcc inner : this.innerPanels) {
                            if (inner.type != PanelTaxonType.TAXON || ((PanelTaxonProperties)inner.getProperties()).group != PanelTaxonProperties.Group.GROUP || inner.getFilterSet() != null) continue;
                            return false;
                        }
                    }
                    if (prop == null) {
                        this.filter_set = null;
                        this.filter_cat = null;
                        break;
                    }
                    if (prop instanceof TxGroupSet) {
                        this.filter_set = (TxGroupSet)prop;
                        this.filter_cat = null;
                        break;
                    }
                    if (!(prop instanceof Category[])) break;
                    Category[] catArr = (Category[])prop;
                    this.filter_cat = Arrays.stream(catArr).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedList::new));
                    this.filter_set = null;
                    break;
                }
                case 1: {
                    this.sampleTypes = (Set)prop;
                    if (!this.sampleTypes.isEmpty() && this.sampleTypes.size() != SampleType.values().length) break;
                    this.sampleTypes = null;
                    break;
                }
                case 2: {
                    if (prop instanceof Collection) {
                        this.analysts = new LinkedList<Userdef>((Collection)prop);
                        Collections.sort(this.analysts);
                        if (!this.analysts.isEmpty()) break;
                        this.analysts = null;
                        break;
                    }
                    this.analysts = null;
                    break;
                }
                case 3: {
                    if (prop instanceof Collection) {
                        this.suiteNos = new HashSet<Integer>((Collection)prop);
                        if (!this.suiteNos.isEmpty()) break;
                        this.suiteNos = null;
                        break;
                    }
                    this.suiteNos = null;
                    break;
                }
                case 5: {
                    this.moveSamplePositions = (Boolean)prop;
                    break;
                }
                case 6: {
                    this.alphabeticKey = (Boolean)prop;
                    break;
                }
                case 7: {
                    this.synschID = prop != null ? (Integer)prop : 0;
                    break;
                }
                case 4: {
                    this.analysisTypeFilter = (AnalysisTypeFilter)((Object)prop);
                    break;
                }
                case 9: {
                    this.applySynToGroups = (Boolean)prop;
                    break;
                }
                case 8: {
                    this.showJuniorSynonyms = (Boolean)prop;
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public Class<?> getPropertyClass(int nProp) {
        switch (nProp) {
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                return Boolean.class;
            }
            case 4: {
                return AnalysisTypeFilter.class;
            }
            case 7: {
                return SynonymScheme.class;
            }
            case 1: {
                return SampleType.class;
            }
            case 0: {
                return PanelTaxonOcc.Filter.class;
            }
            case 2: {
                return Userdef[].class;
            }
            case 3: {
                return Integer[].class;
            }
        }
        assert (false);
        return null;
    }

    public PanelTaxonGroupProperties(PanelType panelType, SBdb sbdb, String props, LinkedList<PanelTaxonOcc> innerPanels, int synSchID, TxGroupSet filter_set, Collection<Userdef> analysts) throws SQLException {
        super(panelType);
        if (innerPanels == null) {
            this.innerPanels = new LinkedList();
            this.addInnerPanel(PanelTaxonType.SAMPLES);
            this.addInnerPanel(PanelTaxonType.TAXON);
        } else {
            this.innerPanels = innerPanels;
        }
        this.synschID = synSchID;
        this.filter_set = filter_set;
        if (analysts != null && !analysts.isEmpty()) {
            this.analysts = new LinkedList<Userdef>(analysts);
        }
        if (props != null) {
            String[] s = props.split("\\|");
            block10: for (int i = 0; i < s.length; ++i) {
                switch (i) {
                    case 0: {
                        String[] typeStrings;
                        if (s[i].isEmpty()) continue block10;
                        this.sampleTypes = new HashSet<SampleType>();
                        for (String strg : typeStrings = s[i].split(",")) {
                            this.sampleTypes.add(SampleType.valueOf((String)strg));
                        }
                        continue block10;
                    }
                    case 1: {
                        this.moveSamplePositions = Integer.parseInt(s[i]) == 1;
                        continue block10;
                    }
                    case 2: {
                        this.alphabeticKey = Integer.parseInt(s[i]) == 1;
                        continue block10;
                    }
                    case 3: {
                        String[] sStrings;
                        if (s[i].isEmpty()) continue block10;
                        this.suiteNos = new HashSet<Integer>();
                        for (String strg : sStrings = s[i].split(",")) {
                            this.suiteNos.add(Integer.parseInt(strg));
                        }
                        continue block10;
                    }
                    case 4: {
                        if (s[i].isEmpty() || this.filter_set != null) continue block10;
                        String[] catString = s[i].split(",");
                        this.filter_cat = new LinkedList<Category>();
                        for (int j = 0; j < catString.length; ++j) {
                            String mnemonic = catString[j];
                            Category cat = sbdb.getCategoryService().findCategory(mnemonic).orElse(null);
                            if (cat == null && !sbdb.isConnected()) {
                                cat = sbdb.getCategoryService().addCategory(mnemonic, Discipline.MICRO, mnemonic, Color.BLACK);
                            }
                            if (cat == null) continue;
                            this.filter_cat.add(cat);
                        }
                        continue block10;
                    }
                    case 5: {
                        this.analysisTypeFilter = AnalysisTypeFilter.parseDbInt(Integer.parseInt(s[i]));
                        continue block10;
                    }
                    case 6: {
                        this.applySynToGroups = Integer.parseInt(s[i]) == 1;
                        continue block10;
                    }
                    case 7: {
                        this.showJuniorSynonyms = Integer.parseInt(s[i]) == 1;
                    }
                }
            }
        }
    }

    @Override
    public String getPrefs() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getSynSchID() {
        return this.synschID;
    }

    @Override
    public int getGrpSetID() {
        if (this.filter_set != null) {
            return this.filter_set.getID();
        }
        return 0;
    }

    public TxGroupSet getFilterSet() {
        return this.filter_set;
    }

    public boolean hasFilterCat() {
        return this.filter_cat != null;
    }

    public List<Category> getFilterCats() {
        return this.filter_cat != null ? new LinkedList<Category>(this.filter_cat) : Collections.EMPTY_LIST;
    }

    public String getFilterCatString(boolean mnem) {
        String s = "";
        if (this.filter_cat != null) {
            ArrayList<Category> categories = new ArrayList<Category>(this.filter_cat);
            Collections.sort(categories);
            s = categories.stream().map(cat -> mnem ? cat.getMnemonic() : cat.getName()).collect(Collectors.joining(", "));
        }
        return s;
    }

    boolean useCat(String mnem) {
        if (this.filter_cat == null) {
            return true;
        }
        if (mnem == null) {
            return false;
        }
        String upperCaseMnem = mnem.toUpperCase();
        return this.filter_cat.stream().anyMatch(cat -> upperCaseMnem.startsWith(cat.getMnemonic()));
    }

    public String getOccCaption(PanelTaxonOcc occ) {
        if (!this.innerPanels.contains(occ)) {
            // empty if block
        }
        if (occ.getCaption() != null && !occ.getCaption().isEmpty()) {
            return occ.getCaption();
        }
        if (occ.type == PanelTaxonType.SAMPLES) {
            return "Analyses";
        }
        Object hdr = occ.getFilterObj() != null ? occ.getFilterObj().toString() : "all " + this.getDiscID().getAbr(true);
        if (occ.getCaption() != null && occ.getCaption().isEmpty()) {
            hdr = (String)hdr + " (blank caption)";
        }
        return hdr;
    }

    private Discipline getDiscID() {
        switch (this.getPanelType()) {
            case MICRO: {
                return Discipline.MICRO;
            }
            case NANNO: {
                return Discipline.NANNO;
            }
            case PALY: {
                return Discipline.PALY;
            }
            case MACRO: {
                return Discipline.MACRO;
            }
        }
        assert (false);
        return null;
    }

    private String separateWithComma(List<String> strings) {
        Object string = "";
        for (String s : strings) {
            if (!((String)string).isEmpty()) {
                string = (String)string + ",";
            }
            string = (String)string + s;
        }
        return string;
    }

    PanelTaxonGroupProperties(PanelType panelType) {
        super(panelType);
        this.innerPanels = new LinkedList();
    }

    private static PanelTaxonGroupProperties createCopy(PanelTaxonGroupProperties rhs) {
        PanelTaxonGroupProperties p = new PanelTaxonGroupProperties(rhs.getPanelType());
        p.copy(rhs);
        return p;
    }

    @Override
    public PanelProperties copy() {
        return PanelTaxonGroupProperties.createCopy(this);
    }

    @Override
    public void copy(PanelProperties pp) {
        if (!(pp instanceof PanelTaxonGroupProperties)) {
            throw new IllegalArgumentException("PanelTaxonGroupProperties cannot copy " + String.valueOf(pp));
        }
        PanelTaxonGroupProperties rhs = (PanelTaxonGroupProperties)pp;
        this.innerPanels = new LinkedList();
        EnumMap<PanelTaxonType, PanelTaxonPropertiesBase> newDefaults = new EnumMap<PanelTaxonType, PanelTaxonPropertiesBase>(PanelTaxonType.class);
        for (PanelTaxonOcc occ : rhs.innerPanels) {
            PanelTaxonOcc newOcc = new PanelTaxonOcc(occ);
            assert (newOcc != occ);
            if (newOcc.isDefault()) {
                if (newDefaults.get((Object)newOcc.type) == null) {
                    newDefaults.put(newOcc.type, newOcc.getProperties());
                } else {
                    newOcc.setPropertiesObj((PanelTaxonPropertiesBase)newDefaults.get((Object)newOcc.type));
                }
            }
            this.innerPanels.add(newOcc);
        }
        block5: for (int i = 0; i < this.getnProps(); ++i) {
            switch (i) {
                case 0: {
                    this.filter_set = rhs.filter_set;
                    this.filter_cat = rhs.filter_cat;
                    continue block5;
                }
                case 1: {
                    this.sampleTypes = rhs.sampleTypes != null ? new HashSet<SampleType>(rhs.sampleTypes) : null;
                    continue block5;
                }
                default: {
                    this.setProperty(i, rhs.getProperty(i));
                }
            }
        }
    }

    @Override
    public Collection getAnalystList() {
        return this.analysts;
    }

    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + (this.innerPanels != null ? this.innerPanels.hashCode() : 0);
        hash = 83 * hash + (this.filter_set != null ? this.filter_set.hashCode() : 0);
        hash = 83 * hash + (this.filter_cat != null ? this.filter_cat.hashCode() : 0);
        hash = 83 * hash + (this.sampleTypes != null ? this.sampleTypes.hashCode() : 0);
        hash = 83 * hash + (this.analysts != null ? this.analysts.hashCode() : 0);
        hash = 83 * hash + (this.suiteNos != null ? this.suiteNos.hashCode() : 0);
        hash = 83 * hash + (this.moveSamplePositions ? 1 : 0);
        hash = 83 * hash + this.analysisTypeFilter.dbInt;
        hash = 83 * hash + (this.alphabeticKey ? 1 : 0);
        hash = 83 * hash + this.synschID;
        hash = 83 * hash + (this.applySynToGroups ? 1 : 0);
        hash = 83 * hash + (this.showJuniorSynonyms ? 1 : 0);
        return hash;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isSimilarTo(PanelProperties comp) {
        void var5_9;
        if (!(comp instanceof PanelTaxonGroupProperties)) {
            return false;
        }
        if (this.equals(comp)) {
            return true;
        }
        PanelTaxonGroupProperties rhs = (PanelTaxonGroupProperties)comp;
        for (int i = 0; i < this.getnProps(); ++i) {
            if (Objects.equals(this.getProperty(i), rhs.getProperty(i))) continue;
            return false;
        }
        ArrayList<PanelTaxonType> thisTypes = new ArrayList<PanelTaxonType>();
        for (PanelTaxonOcc panelTaxonOcc : this.innerPanels) {
            thisTypes.add(panelTaxonOcc.type);
        }
        ArrayList<PanelTaxonType> compTypes = new ArrayList<PanelTaxonType>();
        for (PanelTaxonOcc occ : rhs.innerPanels) {
            compTypes.add(occ.type);
        }
        if (!thisTypes.equals(compTypes)) {
            return false;
        }
        boolean bl = false;
        while (var5_9 < this.innerPanels.size()) {
            PanelTaxonOcc thisOcc = this.innerPanels.get((int)var5_9);
            PanelTaxonOcc compOcc = rhs.innerPanels.get((int)var5_9);
            if (!thisOcc.getProperties().isSimilarTo(compOcc.getProperties())) {
                return false;
            }
            ++var5_9;
        }
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PanelTaxonGroupProperties other = (PanelTaxonGroupProperties)obj;
        if (!(this.innerPanels == other.innerPanels || this.innerPanels != null && this.innerPanels.equals(other.innerPanels))) {
            return false;
        }
        if (!(this.filter_set == other.filter_set || this.filter_set != null && this.filter_set.equals((Object)other.filter_set))) {
            return false;
        }
        if (!(this.filter_cat == other.filter_cat || this.filter_cat != null && this.filter_cat.equals(other.filter_cat))) {
            return false;
        }
        if (!(this.sampleTypes == other.sampleTypes || this.sampleTypes != null && this.sampleTypes.equals(other.sampleTypes))) {
            return false;
        }
        if (!(this.analysts == other.analysts || this.analysts != null && this.analysts.equals(other.analysts))) {
            return false;
        }
        if (!(this.suiteNos == other.suiteNos || this.suiteNos != null && this.suiteNos.equals(other.suiteNos))) {
            return false;
        }
        if (this.moveSamplePositions != other.moveSamplePositions) {
            return false;
        }
        if (this.analysisTypeFilter != other.analysisTypeFilter) {
            return false;
        }
        if (this.alphabeticKey != other.alphabeticKey) {
            return false;
        }
        if (this.applySynToGroups != other.applySynToGroups) {
            return false;
        }
        if (this.showJuniorSynonyms != other.showJuniorSynonyms) {
            return false;
        }
        return this.synschID == other.synschID;
    }

    @Override
    public String getPropertiesString() {
        Iterator<Object> it;
        Object[] data = new String[8];
        if (this.sampleTypes != null) {
            ArrayList<String> sampleTypeStrings = new ArrayList<String>();
            it = this.sampleTypes.iterator();
            while (it.hasNext()) {
                sampleTypeStrings.add(it.next().name());
            }
            data[0] = this.separateWithComma(sampleTypeStrings);
        } else {
            data[0] = "";
        }
        data[1] = "" + (this.moveSamplePositions ? 1 : 0);
        data[2] = "" + (this.alphabeticKey ? 1 : 0);
        if (this.suiteNos != null && !this.suiteNos.isEmpty()) {
            ArrayList<String> suiteStrings = new ArrayList<String>();
            it = this.suiteNos.iterator();
            while (it.hasNext()) {
                suiteStrings.add("" + (Integer)it.next());
            }
            data[3] = this.separateWithComma(suiteStrings);
        } else {
            data[3] = "";
        }
        String data4 = "";
        if (this.filter_cat != null) {
            data4 = this.filter_cat.stream().map(Category::getMnemonic).collect(Collectors.joining(","));
        }
        data[4] = data4;
        data[5] = "" + this.analysisTypeFilter.dbInt;
        data[6] = "" + (this.applySynToGroups ? 1 : 0);
        data[7] = "" + (this.showJuniorSynonyms ? 1 : 0);
        return StringUtils.join((Object[])data, (String)"|");
    }

    public boolean hasOtherPanelsLike(PanelTaxonOcc occ) {
        boolean foundOcc = false;
        boolean others = false;
        for (PanelTaxonOcc panel : this.innerPanels) {
            if (panel == occ) {
                foundOcc = true;
            } else if (panel.type == occ.type && !panel.isOverplot()) {
                others = true;
            }
            if (!foundOcc || !others) continue;
            break;
        }
        if (!foundOcc) {
            throw new IllegalArgumentException("PanelTaxonOcc not in parent panel");
        }
        return others;
    }

    public static boolean canOverplot(List<PanelTaxonOcc> innerPanels, PanelTaxonOcc occ) {
        if (!innerPanels.contains(occ)) {
            throw new IllegalArgumentException("PanelOcc does not belong to list");
        }
        for (PanelTaxonOcc panel : innerPanels) {
            if (panel == occ) {
                return false;
            }
            if (panel.type != PanelTaxonType.TAXON || ((PanelTaxonProperties)panel.getProperties()).track_style != PanelTaxonProperties.Track.SINGLE) continue;
            return true;
        }
        assert (false);
        return false;
    }

    public static boolean isOverplotBase(List<PanelTaxonOcc> innerPanels, PanelTaxonOcc occ) {
        int index = innerPanels.indexOf(occ);
        return !occ.isOverplot() && index < innerPanels.size() - 1 && innerPanels.get(index + 1).isOverplot();
    }

    public static PanelTaxonOcc getOverplotBase(List<PanelTaxonOcc> innerPanels, PanelTaxonOcc occ) {
        int index = innerPanels.indexOf(occ);
        for (int i = index - 1; i >= 0; --i) {
            if (innerPanels.get(i).isOverplot()) continue;
            return innerPanels.get(i);
        }
        throw new IllegalArgumentException("No overplot base");
    }

    public static List<PanelTaxonOcc> getOverplotted(List<PanelTaxonOcc> innerPanels, PanelTaxonOcc occ) {
        if (!PanelTaxonGroupProperties.isOverplotBase(innerPanels, occ)) {
            throw new IllegalArgumentException("PanelTaxonOcc is not overplot base");
        }
        ArrayList<PanelTaxonOcc> list = new ArrayList<PanelTaxonOcc>();
        for (int i = innerPanels.indexOf(occ) + 1; i < innerPanels.size() && innerPanels.get(i).isOverplot(); ++i) {
            list.add(innerPanels.get(i));
        }
        return list;
    }

    public String verifyInnerPanelProperty(PanelTaxonOcc occ, int nProp, Object prop) {
        if (occ.type != PanelTaxonType.TAXON) {
            return null;
        }
        PanelTaxonProperties ptp = (PanelTaxonProperties)occ.getProperties();
        switch (nProp) {
            case 12: {
                if (prop != PanelTaxonProperties.Group.GROUP || this.filter_set != null || occ.getFilterSet() != null) break;
                return "The inner or outer panel must be restricted to a group set.";
            }
            case 13: {
                if (prop == PanelTaxonProperties.SubGroup.NONE) break;
                if (ptp.abn_style.setSemiQuant()) {
                    return "Abundance must be quantitative or mixed";
                }
                if (ptp.calc_style != PanelTaxonProperties.Calc.RICHNESS && ptp.calc_style != PanelTaxonProperties.Calc.SHANNON) break;
                return "Can't use sub-grouping for calculation style '" + String.valueOf((Object)ptp.calc_style) + "'";
            }
            case 9: {
                if (!((Boolean)prop).booleanValue() || !ptp.abn_style.setSemiQuant()) break;
                return "Can't use split factors for semi-quantitative abundance";
            }
            case 14: {
                if (prop != PanelTaxonProperties.Track.MULTI) break;
                if (PanelTaxonGroupProperties.isOverplotBase(this.innerPanels, occ)) {
                    return "Can't use stacked curves under superimposed panels";
                }
                if (!ptp.abn_style.setSemiQuant()) break;
                return "Can't stack " + String.valueOf((Object)ptp.abn_style) + " data";
            }
            case 15: {
                if (((PanelTaxonProperties.Calc)((Object)prop)).isDiversity || prop == PanelTaxonProperties.Calc.RICHNESS) {
                    String s;
                    String string = s = prop == PanelTaxonProperties.Calc.COSINETHETA ? "similarity" : "diversity";
                    if (ptp.track_style == PanelTaxonProperties.Track.MULTI) {
                        return "Can't calculate " + s + " for stacked curves";
                    }
                    if (ptp.group == PanelTaxonProperties.Group.SPEC) {
                        return "Can't calculate " + s + " for species";
                    }
                }
                if (prop != PanelTaxonProperties.Calc.ABS && ptp.abn_style == PanelTaxonProperties.Abundance.PA) {
                    return "You must use '" + String.valueOf((Object)PanelTaxonProperties.Calc.ABS) + "' for " + String.valueOf((Object)PanelTaxonProperties.Abundance.PA) + " plots";
                }
                if (prop != PanelTaxonProperties.Calc.RELATIVE_OUTER || ptp.exclGroup != null || occ.getFilter() != null && this.filter_set != occ.getFilter() && this.filter_cat != occ.getFilter()) break;
                return "Outer panel data is the same as inner panel data!";
            }
            case 16: {
                if (prop != PanelTaxonProperties.Plot.NUMBERS || ptp.abn_style.setSemiQuant()) {
                    // empty if block
                }
                if (prop == PanelTaxonProperties.Plot.HIST || ptp.abn_style != PanelTaxonProperties.Abundance.PA) break;
                return "You must use '" + String.valueOf((Object)PanelTaxonProperties.Plot.HIST) + "' for " + String.valueOf((Object)PanelTaxonProperties.Abundance.PA) + " plots";
            }
            case 23: {
                if (prop == PanelTaxonProperties.Justify.CENTRE) {
                    if (ptp.track_style == PanelTaxonProperties.Track.MULTI) {
                        return "You can't centre-justify stacked curves";
                    }
                    if (ptp.plot_style != PanelTaxonProperties.Plot.CURVE) break;
                    return "You can't centre-justify the curve style";
                }
                if (ptp.abn_style != PanelTaxonProperties.Abundance.PA) break;
                return String.valueOf((Object)PanelTaxonProperties.Abundance.PA) + " plots must be centre-justified";
            }
            case 31: {
                if (((Boolean)prop).booleanValue() || ptp.plot_style != PanelTaxonProperties.Plot.NUMBERS) break;
                return "You must show labels when plotting " + PanelTaxonProperties.Plot.NUMBERS.toString();
            }
            case 30: {
                if ((!((Boolean)prop).booleanValue() || ptp.plot_style != PanelTaxonProperties.Plot.CURVE) && ptp.plot_style != PanelTaxonProperties.Plot.SAWTOOTH && ptp.plot_style != PanelTaxonProperties.Plot.STICKNDOT) break;
                return "You can't use suite colours for " + String.valueOf((Object)ptp.plot_style) + " plots";
            }
            case 27: {
                if (prop != PanelTaxonProperties.Sort.SORTAGE) break;
                if (ptp.group != PanelTaxonProperties.Group.SPEC) {
                    return "Group by species to sort on event age";
                }
                if (!ptp.calc_style.isRelative) break;
                return "You can't use a relative calculation style - some tracks may be repeated";
            }
        }
        return null;
    }

    public String[] getDependentInnerPanelPropertyUpdates(PanelTaxonOcc occ, int nProp, Object prop) {
        if (occ.type != PanelTaxonType.TAXON) {
            return null;
        }
        PanelTaxonProperties ptp = (PanelTaxonProperties)occ.getProperties();
        ArrayList<Object> strings = new ArrayList<Object>();
        switch (nProp) {
            case 8: {
                if (((PanelTaxonProperties.Abundance)((Object)prop)).setSemiQuant()) {
                    if (ptp.track_style == PanelTaxonProperties.Track.MULTI) {
                        strings.add("Track style reset to " + String.valueOf((Object)PanelTaxonProperties.Track.SINGLE));
                    }
                    if (ptp.subgroup != PanelTaxonProperties.SubGroup.NONE) {
                        strings.add("Sub-grouping reset to 'none'");
                    }
                    if (ptp.useSplits) {
                        strings.add("Use of split factors reset");
                    }
                    if (ptp.calc_style != PanelTaxonProperties.Calc.ABS) {
                        strings.add("Calculation style reset to 'absolute'");
                    }
                    if (ptp.plot_style != PanelTaxonProperties.Plot.HIST) {
                        strings.add("Curve style reset to 'histograms'");
                    }
                    if (ptp.justify != PanelTaxonProperties.Justify.CENTRE) {
                        strings.add("Justification set to " + String.valueOf((Object)PanelTaxonProperties.Justify.CENTRE));
                    }
                    if (ptp.hist_height == 2.5f) break;
                    strings.add("Histogram height reset to 2.5mm");
                    break;
                }
                if (ptp.justify == PanelTaxonProperties.Justify.LEFT) break;
                strings.add("Justification set to " + String.valueOf((Object)PanelTaxonProperties.Justify.LEFT));
                break;
            }
            case 12: {
                if (prop == PanelTaxonProperties.Group.SPEC) {
                    if (!ptp.calc_style.isDiversity) break;
                    strings.add("Calculation style reset to 'absolute'");
                    break;
                }
                if (ptp.sortType != PanelTaxonProperties.Sort.SORTAGE) break;
                strings.add("Sorting reset to " + String.valueOf((Object)PanelTaxonProperties.Sort.SORTDOWNHOLE));
                break;
            }
            case 14: {
                if (prop != PanelTaxonProperties.Track.MULTI) break;
                if (ptp.calc_style.isDiversity) {
                    strings.add("Calculation style reset to 'absolute'");
                }
                if (ptp.justify == PanelTaxonProperties.Justify.CENTRE) {
                    strings.add("Justification reset to " + String.valueOf((Object)PanelTaxonProperties.Justify.LEFT));
                }
                if (ptp.plot_style != PanelTaxonProperties.Plot.NUMBERS) break;
                strings.add("Curve style reset to " + String.valueOf((Object)PanelTaxonProperties.Plot.SAWTOOTH));
                break;
            }
            case 15: {
                if ((prop == PanelTaxonProperties.Calc.RICHNESS || prop == PanelTaxonProperties.Calc.SHANNON) && ptp.subgroup != PanelTaxonProperties.SubGroup.NONE) {
                    strings.add("Sub-grouping reset to 'none'");
                }
                if (prop != PanelTaxonProperties.Calc.ABS && ptp.abn_style.setSemiQuant()) {
                    strings.add("Abundance style reset to " + String.valueOf((Object)PanelTaxonProperties.Abundance.Q));
                }
                if (!((PanelTaxonProperties.Calc)((Object)prop)).isRelative || ptp.sortType != PanelTaxonProperties.Sort.SORTAGE) break;
                strings.add("Sorting reset to " + String.valueOf((Object)PanelTaxonProperties.Sort.SORTDOWNHOLE));
                break;
            }
            case 16: {
                if (prop == PanelTaxonProperties.Plot.NUMBERS) {
                    if (!ptp.showAbundance) {
                        strings.add("Showing abundance labels");
                    }
                    if (ptp.track_style != PanelTaxonProperties.Track.MULTI) break;
                    strings.add("Plot type reset to " + String.valueOf((Object)PanelTaxonProperties.Track.SINGLE));
                    break;
                }
                if (prop != PanelTaxonProperties.Plot.CURVE || ptp.justify != PanelTaxonProperties.Justify.CENTRE) break;
                strings.add("Justification reset to " + String.valueOf((Object)PanelTaxonProperties.Justify.LEFT));
            }
        }
        if (!strings.isEmpty()) {
            return strings.toArray(new String[strings.size()]);
        }
        return null;
    }

    public void writeInnerPanelsXML(BufferedWriter out, int indent, SBdb ws) throws IOException {
        String ind1 = SB.getXMLIndent((int)indent);
        String ind2 = SB.getXMLIndent((int)(indent + 3));
        for (PanelTaxonOcc panel : this.innerPanels) {
            out.write(ind1 + "<InnerPanel Type=\"" + panel.type.name() + "\">\n");
            out.write(ind2 + "<Properties>" + SB.getXMLstring((String)panel.getPropertiesString()) + "</Properties>\n");
            if (panel.getCaption() != null && !panel.getCaption().isEmpty()) {
                out.write(ind2 + "<Caption>" + SB.getXMLstring((String)panel.getCaption()) + "</Caption>\n");
            }
            if (panel.getFilterSpec() != null) {
                out.write(ind2 + "<FilterSpecies>" + panel.getFilterSpec().getSpecID() + "</FilterSpecies>\n");
            }
            if (panel.getFilterGroup() != null) {
                out.write(ind2 + "<FilterTaxonGroup>" + panel.getFilterGroup().getID() + "</FilterTaxonGroup>\n");
            }
            if (panel.getFilterSet() != null) {
                out.write(ind2 + "<FilterGroupSet>" + panel.getFilterSet().getID() + "</FilterGroupSet>\n");
            }
            if (panel.getFilterCat() != null) {
                out.write(ind2 + "<FilterCategory>" + panel.getFilterCat().getMnemonic() + "</FilterCategory>\n");
            }
            if (panel.getStdID() != null) {
                if (panel.getFilterCmpStd() != null) {
                    out.write(ind2 + "<FilterCompositeStandard>" + panel.getFilterCmpStd().getID() + "</FilterCompositeStandard>\n");
                }
                if (panel.getProperties() instanceof PanelTaxonProperties && ((PanelTaxonProperties)panel.getProperties()).cmpStd != null) {
                    out.write(ind2 + "<HeaderCompositeStandard>" + ((PanelTaxonProperties)panel.getProperties()).cmpStd.getID() + "</HeaderCompositeStandard>\n");
                }
            }
            if (panel.getProperties() instanceof PanelTaxonProperties) {
                PanelTaxonProperties prop = (PanelTaxonProperties)panel.getProperties();
                if (prop.hdrScheme != null) {
                    out.write(ind2 + "<HeaderStratigraphicScheme>" + prop.hdrScheme.getID() + "</HeaderStratigraphicScheme>\n");
                }
                if (prop.exclGroup != null) {
                    out.write(ind2 + "<ExcludeTaxonGroup>" + prop.exclGroup.getID() + "</ExcludeTaxonGroup>\n");
                }
                if (prop.highlightGroup != null) {
                    out.write(ind2 + "<HighlightTaxonGroup>" + prop.highlightGroup.getID() + "</HighlightTaxonGroup>\n");
                }
                if (prop.subTypes != null) {
                    for (Integer subTypeID : prop.getSubTypes()) {
                        out.write(ind2 + "<SpeciesTypeFilter>" + ws.getSpeciesTypeService().getSpeciesType(subTypeID.intValue()).map(SpeciesType::description).orElse("") + "</SpeciesTypeFilter>\n");
                    }
                }
            }
            if (panel.getForEachInt() != null) {
                out.write(ind2 + "<ForEachFilter>" + PanelTaxonOcc.Filter.getForEachString(panel.getForEachInt()) + "</ForEachFilter>\n");
            }
            out.write(ind2 + "<IsDefault>" + panel.isDefault() + "</IsDefault>\n");
            if (panel.isOverplot()) {
                out.write(ind2 + "<Overplot>LEFT</Overplot>\n");
            }
            out.write(ind1 + "</InnerPanel>\n");
        }
    }

    public static enum AnalysisTypeFilter {
        ANALYSED_ONLY("Analysed only", 0),
        ANALYSED_AND_PREPARED("Include prepared", 1),
        PREPARED_ONLY("Prepared only", 2);

        private final String descr;
        private final int dbInt;

        private AnalysisTypeFilter(String descr, int dbInt) {
            this.descr = descr;
            this.dbInt = dbInt;
        }

        public String toString() {
            return this.descr;
        }

        static AnalysisTypeFilter parseDbInt(int dbInt) {
            for (AnalysisTypeFilter f : AnalysisTypeFilter.values()) {
                if (dbInt != f.dbInt) continue;
                return f;
            }
            return ANALYSED_ONLY;
        }
    }
}

