/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import java.awt.Color;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;
import javax.swing.JSlider;
import jsbchart.panel.InvalidTaxonFieldException;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelTaxonGroup;
import jsbchart.panel.PanelTaxonPropertiesBase;
import model3.AnalystHeader;
import model3.CompositeStandard;
import model3.IGDScheme;
import model3.TxGroup;
import model3.Well;
import org.apache.commons.lang3.StringUtils;
import util.ColourUtils;
import util.SB;
import util.SBException;

public class PanelTaxonProperties
extends PanelTaxonPropertiesBase {
    public static final int PROP_TR = 0;
    public static final int PROP_RW = 1;
    public static final int PROP_CV = 2;
    public static final int PROP_CN = 3;
    public static final int PROP_Q = 4;
    public static final int PROP_EXCL_GRP = 5;
    public static final int PROP_SUBTYPES = 6;
    public static final int PROP_MIN_COUNT = 7;
    public static final int PROP_ABN = 8;
    public static final int PROP_SPLITS = 9;
    public static final int PROP_NORMAL = 10;
    public static final int PROP_NORMAL_WEIGHT = 11;
    public static final int PROP_GROUP = 12;
    public static final int PROP_SUBGROUP = 13;
    public static final int PROP_TRACKSTYLE = 14;
    public static final int PROP_CALCSTYLE = 15;
    public static final int PROP_CURVESTYLE = 16;
    public static final int PROP_HIST_HEIGHT = 17;
    public static final int PROP_HIST_SAMPLE_RANGE = 18;
    public static final int PROP_SAW_ENHANCED = 19;
    public static final int PROP_SAW_ENHANCEMENT = 20;
    public static final int PROP_SAWTOOTH_CUTOFF = 21;
    public static final int PROP_STRATRANGE = 22;
    public static final int PROP_JUSTIFY = 23;
    public static final int PROP_CUTOFF = 24;
    public static final int PROP_MAX_WIDTH = 25;
    public static final int PROP_MIN_WIDTH = 26;
    public static final int PROP_SORT = 27;
    public static final int PROP_COLOUR = 28;
    public static final int PROP_COLOUR_INHERIT = 29;
    public static final int PROP_COLOUR_SUITES = 30;
    public static final int PROP_LABELS = 31;
    public static final int PROP_FLAGS = 32;
    public static final int PROP_OCC_COMMENTS = 33;
    public static final int PROP_OCC_COMMENTS_MAX = 34;
    public static final int PROP_COLOUR_LABELS = 35;
    public static final int PROP_EMPTYTRACKS = 36;
    public static final int PROP_GRID = 37;
    public static final int PROP_HIGHLIGHT_MARKERS = 38;
    public static final int PROP_IMAGES = 39;
    public static final int PROP_IMAGE_MKRS = 40;
    public static final int PROP_IMAGE_WIDTH = 41;
    public static final int PROP_HDR_CAT = 42;
    public static final int PROP_HDR_ALPHACODE = 43;
    public static final int PROP_HDR_AUTHOR = 44;
    public static final int PROP_HDR_ITALICS = 45;
    public static final int PROP_HDR_GROUP = 46;
    public static final int PROP_HDR_GROUPCOLOUR = 47;
    public static final int PROP_HDR_STD = 48;
    public static final int PROP_HDR_SCHEME = 49;
    public static final int PROP_HDR_SCHABRS = 50;
    public static final int PROP_HDR_KEY = 51;
    public static final int PROP_EVENTS = 52;
    public static final int PROP_ONLY_SHOW_EVENT_LINKED_TAXA = 53;
    private static final String[] propNames = new String[]{"Transported", "Reworked", "Caved", "Contamination", "Questionable", "Exclude group", "Include sub-types", "Minimum count", "Abundance", "Split factors", "Normalise weights", "Normal weight (g)", "Group data by", "Sub-group data by", "Plot type", "Calculation style", "Curve style", "Histogram height", "Histogram height is sample top-base depth range", "Sawtooth enhanced", "by", "Max. Sawtooth vertical span", "Stratigraphic range", "Justify", "Scale limit", "Default column width (mm)", "Min column width (mm)", "Sorting", "Default colour", "Inherit colours", "Use analyst suite colours", "Abundance labels", "Flags for Rw, Cv, ? etc", "Occurrence comments", "..with length less than", "Colour labels and flags", "Hide empty columns", "Grid", "Highlight marker occurrences", "Images column", "Markers only", "Column width", "Category", "Use codes", "Author", "Use Italics", "Highlight group", "Highlight group colour", "Age from composite", "Unit from scheme", "Scheme abbreviations", "Explanatory text", "Events", "Show only taxa linked to events"};
    private static final int[] titleRows = new int[]{0, 9, 14, 17, 28, 32, 45, 48, 58};
    private static final String[] titleNames = new String[]{"Data", "Abundance", "Grouping", "Style", "Horizontal scale", "Options", "Images column", "Header", "Interpretations"};
    Group group = Group.SPEC;
    SubGroup subgroup = SubGroup.NONE;
    Track track_style = Track.SINGLE;
    Calc calc_style = Calc.ABS;
    Sort sortType = Sort.SORTDOWNHOLE;
    Plot plot_style = Plot.HIST;
    Justify justify = Justify.LEFT;
    boolean stratRange = false;
    boolean sawtoothEnhanced = false;
    int sawtoothEnhancement = 5;
    public static final float HIST_HEIGHT = 2.5f;
    static final float HIST_HEIGHT_MAX = 8.0f;
    static final float HIST_HEIGHT_MIN = 0.25f;
    float hist_height = 2.5f;
    boolean histHeightSampleRange = false;
    boolean onlyIncludeTaxaLinkedToEvents = false;
    boolean highlightMarkers = false;
    Abundance abn_style = Abundance.MIX;
    boolean showImages = true;
    boolean filterMkrImages = true;
    float imageWidth = 35.0f;
    float imagePadding = 6.0f;
    float cutoff = 100.0f;
    float maxWidth = 40.0f;
    float horzScale = this.maxWidth / this.cutoff;
    float minWidth = 4.0f;
    float sawtoothCutoff = 20.0f;
    boolean showFlags = true;
    boolean showOccComments = false;
    int occCommentsMaxLength = 10;
    boolean showAbundance = true;
    Color colour = Color.RED;
    boolean inheritFilterColour = true;
    boolean colourSuites = false;
    boolean colourLabels = false;
    boolean grid = true;
    boolean clearEmptyTracks = true;
    boolean hdr_cat = true;
    boolean hdr_alphacodes = false;
    boolean hdr_author = false;
    boolean hdr_italics = true;
    CompositeStandard cmpStd;
    IGDScheme hdrScheme;
    boolean schAbrs = true;
    TxGroup highlightGroup;
    Color highlightColour = Color.RED;
    boolean hdr_key = true;
    boolean drawEvents = false;
    static final int TAB_DATA = 0;
    static final int TAB_ABN = 1;
    static final int TAB_GROUP = 2;
    static final int TAB_STYLE = 3;
    static final int TAB_OPTIONS = 4;
    static final int TAB_HDR = 5;

    @Override
    public PanelTaxonPropertiesBase createCopy() {
        return new PanelTaxonProperties(this);
    }

    PanelTaxonProperties(String props, CompositeStandard std) {
        if (props != null) {
            String[] splits = props.split("\\|");
            block53: for (int i = 0; i < splits.length; ++i) {
                switch (i) {
                    case 0: {
                        int rwInt = Integer.parseInt(splits[i]);
                        this.includeRw = rwInt == 1 ? null : Boolean.valueOf(rwInt == 2);
                        continue block53;
                    }
                    case 1: {
                        int cvInt = Integer.parseInt(splits[i]);
                        this.includeCv = cvInt == 1 ? null : Boolean.valueOf(cvInt == 2);
                        continue block53;
                    }
                    case 2: {
                        int qInt = Integer.parseInt(splits[i]);
                        this.includeQ = qInt == 1 ? null : Boolean.valueOf(qInt == 2);
                        continue block53;
                    }
                    case 3: {
                        continue block53;
                    }
                    case 4: {
                        this.abn_style = Abundance.valueOf(splits[i]);
                        continue block53;
                    }
                    case 5: {
                        this.useSplits = Integer.parseInt(splits[i]) == 1;
                        continue block53;
                    }
                    case 6: {
                        this.normaliseWeight = Integer.parseInt(splits[i]) == 1;
                        continue block53;
                    }
                    case 7: {
                        this.normalWeight = Float.parseFloat(splits[i]);
                        continue block53;
                    }
                    case 8: {
                        this.group = Group.valueOf(splits[i]);
                        continue block53;
                    }
                    case 9: {
                        this.subgroup = SubGroup.valueOf(splits[i]);
                        continue block53;
                    }
                    case 10: {
                        this.track_style = Track.valueOf(splits[i]);
                        continue block53;
                    }
                    case 11: {
                        this.calc_style = Calc.valueOf(splits[i]);
                        continue block53;
                    }
                    case 12: {
                        this.plot_style = Plot.valueOf(splits[i]);
                        continue block53;
                    }
                    case 13: {
                        this.sawtoothEnhanced = Integer.valueOf(splits[i]) == 1;
                        continue block53;
                    }
                    case 14: {
                        this.sawtoothEnhancement = Integer.valueOf(splits[i]);
                        continue block53;
                    }
                    case 15: {
                        this.stratRange = Integer.valueOf(splits[i]) == 1;
                        continue block53;
                    }
                    case 16: {
                        this.justify = Justify.valueOf(splits[i]);
                        continue block53;
                    }
                    case 17: {
                        this.cutoff = Float.parseFloat(splits[i]);
                        continue block53;
                    }
                    case 18: {
                        this.maxWidth = Float.parseFloat(splits[i]);
                        continue block53;
                    }
                    case 19: {
                        this.minWidth = Float.parseFloat(splits[i]);
                        continue block53;
                    }
                    case 20: {
                        this.sortType = Sort.valueOf(splits[i]);
                        continue block53;
                    }
                    case 21: {
                        this.colour = ColourUtils.getColour((String)splits[i]);
                        continue block53;
                    }
                    case 22: {
                        this.inheritFilterColour = Integer.parseInt(splits[i]) == 1;
                        continue block53;
                    }
                    case 23: {
                        this.colourSuites = Integer.parseInt(splits[i]) == 1;
                        continue block53;
                    }
                    case 24: {
                        this.colourLabels = Integer.parseInt(splits[i]) == 1;
                        continue block53;
                    }
                    case 25: {
                        this.showFlags = Integer.parseInt(splits[i]) == 1;
                        continue block53;
                    }
                    case 26: {
                        this.showAbundance = Integer.parseInt(splits[i]) == 1;
                        continue block53;
                    }
                    case 27: {
                        this.clearEmptyTracks = Integer.parseInt(splits[i]) == 1;
                        continue block53;
                    }
                    case 28: {
                        this.grid = Integer.parseInt(splits[i]) == 1;
                        continue block53;
                    }
                    case 29: {
                        this.showImages = Integer.parseInt(splits[i]) == 1;
                        continue block53;
                    }
                    case 30: {
                        this.filterMkrImages = Integer.parseInt(splits[i]) == 1;
                        continue block53;
                    }
                    case 31: {
                        this.imageWidth = Float.parseFloat(splits[i]);
                        continue block53;
                    }
                    case 32: {
                        this.hdr_cat = Integer.parseInt(splits[i]) == 1;
                        continue block53;
                    }
                    case 33: {
                        this.hdr_author = Integer.parseInt(splits[i]) == 1;
                        continue block53;
                    }
                    case 34: {
                        this.highlightColour = ColourUtils.getColour((String)splits[i]);
                        continue block53;
                    }
                    case 35: {
                        this.schAbrs = Integer.parseInt(splits[i]) == 1;
                        continue block53;
                    }
                    case 36: {
                        this.drawEvents = Integer.parseInt(splits[i]) == 1;
                        continue block53;
                    }
                    case 37: {
                        this.cmpStd = Integer.parseInt(splits[i]) == 1 ? std : null;
                        continue block53;
                    }
                    case 38: {
                        this.thresholdCount = Integer.parseInt(splits[i]);
                        continue block53;
                    }
                    case 39: {
                        this.hdr_key = Integer.parseInt(splits[i]) == 1;
                        continue block53;
                    }
                    case 40: {
                        this.hist_height = Float.parseFloat(splits[i]);
                        continue block53;
                    }
                    case 41: {
                        this.sawtoothCutoff = Float.parseFloat(splits[i]);
                        continue block53;
                    }
                    case 42: {
                        this.hdr_italics = Integer.parseInt(splits[i]) == 1;
                        continue block53;
                    }
                    case 43: {
                        this.histHeightSampleRange = Integer.parseInt(splits[i]) == 1;
                        continue block53;
                    }
                    case 44: {
                        this.hdr_alphacodes = Integer.parseInt(splits[i]) == 1;
                        continue block53;
                    }
                    case 45: {
                        this.onlyIncludeTaxaLinkedToEvents = Integer.parseInt(splits[i]) == 1;
                        continue block53;
                    }
                    case 46: {
                        this.showOccComments = Integer.parseInt(splits[i]) == 1;
                        continue block53;
                    }
                    case 47: {
                        this.occCommentsMaxLength = Integer.parseInt(splits[i]);
                        continue block53;
                    }
                    case 48: {
                        this.highlightMarkers = Integer.parseInt(splits[i]) == 1;
                        continue block53;
                    }
                    case 49: {
                        int trInt = Integer.parseInt(splits[i]);
                        this.includeTr = trInt == 1 ? null : Boolean.valueOf(trInt == 2);
                        continue block53;
                    }
                    case 50: {
                        int cnInt = Integer.parseInt(splits[i]);
                        this.includeCn = cnInt == 1 ? null : Boolean.valueOf(cnInt == 2);
                    }
                }
            }
        }
    }

    private PanelTaxonProperties(PanelTaxonProperties rhs) {
        super(rhs);
        this.sortType = rhs.sortType;
        this.group = rhs.group;
        this.track_style = rhs.track_style;
        this.calc_style = rhs.calc_style;
        this.plot_style = rhs.plot_style;
        this.justify = rhs.justify;
        this.cutoff = rhs.cutoff;
        this.maxWidth = rhs.maxWidth;
        this.minWidth = rhs.minWidth;
        this.colour = rhs.colour;
        this.colourLabels = rhs.colourLabels;
        this.colourSuites = rhs.colourSuites;
        this.inheritFilterColour = rhs.inheritFilterColour;
        this.abn_style = rhs.abn_style;
        this.showFlags = rhs.showFlags;
        this.showOccComments = rhs.showOccComments;
        this.occCommentsMaxLength = rhs.occCommentsMaxLength;
        this.subgroup = rhs.subgroup;
        this.hdr_cat = rhs.hdr_cat;
        this.hdr_alphacodes = rhs.hdr_alphacodes;
        this.hdr_author = rhs.hdr_author;
        this.hdr_italics = rhs.hdr_italics;
        this.hdr_key = rhs.hdr_key;
        this.hdrScheme = rhs.hdrScheme;
        this.cmpStd = rhs.cmpStd;
        this.schAbrs = rhs.schAbrs;
        this.grid = rhs.grid;
        this.showImages = rhs.showImages;
        this.filterMkrImages = rhs.filterMkrImages;
        this.imageWidth = rhs.imageWidth;
        this.clearEmptyTracks = rhs.clearEmptyTracks;
        this.highlightColour = rhs.highlightColour;
        this.highlightGroup = rhs.highlightGroup;
        this.showAbundance = rhs.showAbundance;
        this.stratRange = rhs.stratRange;
        this.hist_height = rhs.hist_height;
        this.histHeightSampleRange = rhs.histHeightSampleRange;
        this.sawtoothEnhanced = rhs.sawtoothEnhanced;
        this.sawtoothEnhancement = rhs.sawtoothEnhancement;
        this.drawEvents = rhs.drawEvents;
        this.sawtoothCutoff = rhs.sawtoothCutoff;
        this.onlyIncludeTaxaLinkedToEvents = rhs.onlyIncludeTaxaLinkedToEvents;
        this.highlightMarkers = rhs.highlightMarkers;
        this.setScale();
    }

    final void setScale() {
        this.horzScale = this.maxWidth / this.cutoff;
    }

    @Override
    public String getPrefs() {
        Object[] props = new String[]{this.colour.getRed() + "," + this.colour.getGreen() + "," + this.colour.getBlue(), this.abn_style.toString(), this.plot_style == Plot.CURVE ? Plot.SAWTOOTH.toString() : this.plot_style.toString(), "" + (this.hdr_cat ? 1 : 0), "" + (this.hdr_author ? 1 : 0), "" + (this.grid ? 1 : 0), "" + (this.showImages ? 1 : 0), "" + (this.filterMkrImages ? 1 : 0), "" + this.imageWidth, "" + (this.clearEmptyTracks ? 1 : 0), this.highlightColour.getRed() + "," + this.highlightColour.getGreen() + "," + this.highlightColour.getBlue(), "" + (this.colourSuites ? 1 : 0), "" + (this.colourLabels ? 1 : 0), "" + (this.showAbundance ? 1 : 0), "" + (this.stratRange ? 1 : 0), this.justify == Justify.CENTRE ? Justify.LEFT.name() : this.justify.name(), "", "" + (this.inheritFilterColour ? 1 : 0), "" + (this.hdr_italics ? 1 : 0), "" + (this.hdr_alphacodes ? 1 : 0)};
        return StringUtils.join((Object[])props, (String)"|");
    }

    final void verify(Well well, boolean doCorrections, PanelTaxonGroup outerPanel) throws InvalidTaxonFieldException, SQLException, SBException {
        if (this.abn_style == Abundance.SEMIQ) {
            LinkedList notSet = new LinkedList();
            HashSet schemeIDs = new HashSet();
            for (Object object : well.getAnalystHeaders()) {
            }
            if (notSet.size() > 0) {
                if (doCorrections) {
                    this.abn_style = Abundance.MIX;
                } else {
                    Object msg = "All analysis suites must have an abundance scheme set to plot semi-quant data.\n";
                    msg = (String)msg + "Abundance scheme not set for suite" + (notSet.size() > 1 ? "s:\n" : ":\n");
                    for (AnalystHeader ah : notSet) {
                        msg = (String)msg + ah.toString() + "\n";
                    }
                    msg = (String)msg + "\nSet abundance schemes or use quantitative abundance.\n";
                    throw new InvalidTaxonFieldException((String)msg, 1);
                }
            }
            if (this.group != Group.SPEC && schemeIDs.size() > 1) {
                if (doCorrections) {
                    this.group = Group.SPEC;
                } else {
                    throw new InvalidTaxonFieldException("All analysis suites must use the same abundance scheme\nwhen grouping is not by species.", 2);
                }
            }
        }
        if (this.abn_style.setSemiQuant) {
            if (this.subgroup != SubGroup.NONE) {
                if (doCorrections) {
                    this.subgroup = SubGroup.NONE;
                } else {
                    throw new InvalidTaxonFieldException("Sub-grouping is not supported for " + this.abn_style.toString() + " diagrams.", 2);
                }
            }
            if (this.plot_style == Plot.NUMBERS && doCorrections) {
                this.plot_style = Plot.HIST;
            }
        }
        if (this.abn_style == Abundance.PA) {
            this.plot_style = Plot.HIST;
            this.calc_style = Calc.ABS;
            this.track_style = Track.SINGLE;
            this.justify = Justify.CENTRE;
        }
        if ((this.justify == Justify.CENTRE || this.plot_style == Plot.NUMBERS || this.calc_style == Calc.SHANNON) && this.track_style == Track.MULTI) {
            this.track_style = Track.SINGLE;
        }
        if (this.plot_style == Plot.NUMBERS) {
            this.showAbundance = true;
        }
        if (this.calc_style == Calc.SHANNON) {
            if (this.subgroup != SubGroup.NONE) {
                if (doCorrections) {
                    this.subgroup = SubGroup.NONE;
                } else {
                    throw new InvalidTaxonFieldException("You cannot use sub-groups in diversity calculation", 3);
                }
            }
            if (this.group == Group.SPEC) {
                if (doCorrections) {
                    this.calc_style = Calc.ABS;
                } else {
                    throw new InvalidTaxonFieldException("You cannot calculate diversity for species", 2);
                }
            }
        }
        if (this.subgroup == SubGroup.CMF) {
            if (this.calc_style == Calc.RICHNESS || this.calc_style == Calc.SHANNON) {
                if (doCorrections) {
                    this.calc_style = Calc.ABS;
                } else {
                    throw new InvalidTaxonFieldException("You cannot sub-group by size fraction and use species richness or diversity calculations.\nChoose absolute or relative abundance calculation.", 3);
                }
            }
            this.useSplits = false;
        }
        if (this.plot_style == Plot.CURVE || this.plot_style == Plot.SAWTOOTH || this.plot_style == Plot.STICKNDOT) {
            this.colourSuites = false;
        }
        if (this.plot_style != Plot.SAWTOOTH || this.plot_style == Plot.STICKNDOT) {
            this.sawtoothEnhanced = false;
        }
    }

    public String toString() {
        String s = "Panel Taxon Properties";
        return s;
    }

    @Override
    public String getPropertiesString() {
        String[] data = new String[]{"" + (this.includeRw == null ? 1 : (this.includeRw != false ? 2 : 0)), "" + (this.includeCv == null ? 1 : (this.includeCv != false ? 2 : 0)), "" + (this.includeQ == null ? 1 : (this.includeQ != false ? 2 : 0)), "", this.abn_style.name(), "" + (this.useSplits ? 1 : 0), "" + (this.normaliseWeight ? 1 : 0), "" + this.normalWeight, this.group.name(), this.subgroup.name(), this.track_style.name(), this.calc_style.name(), this.plot_style.name(), "" + (this.sawtoothEnhanced ? 1 : 0), "" + this.sawtoothEnhancement, "" + (this.stratRange ? 1 : 0), this.justify.name(), "" + this.cutoff, "" + this.maxWidth, "" + this.minWidth, this.sortType.name(), ColourUtils.DBColourString((Color)this.colour, (boolean)false, (boolean)false), "" + (this.inheritFilterColour ? 1 : 0), "" + (this.colourSuites ? 1 : 0), "" + (this.colourLabels ? 1 : 0), "" + (this.showFlags ? 1 : 0), "" + (this.showAbundance ? 1 : 0), "" + (this.clearEmptyTracks ? 1 : 0), "" + (this.grid ? 1 : 0), "" + (this.showImages ? 1 : 0), "" + (this.filterMkrImages ? 1 : 0), "" + this.imageWidth, "" + (this.hdr_cat ? 1 : 0), "" + (this.hdr_author ? 1 : 0), ColourUtils.DBColourString((Color)this.highlightColour, (boolean)false, (boolean)false), "" + (this.schAbrs ? 1 : 0), "" + (this.drawEvents ? 1 : 0), "" + (this.cmpStd != null ? 1 : 0), "" + this.thresholdCount, "" + (this.hdr_key ? 1 : 0), "" + this.hist_height, "" + this.sawtoothCutoff, "" + (this.hdr_italics ? 1 : 0), "" + (this.histHeightSampleRange ? 1 : 0), "" + (this.hdr_alphacodes ? 1 : 0), "" + (this.onlyIncludeTaxaLinkedToEvents ? 1 : 0), "" + (this.showOccComments ? 1 : 0), "" + this.occCommentsMaxLength, "" + (this.highlightMarkers ? 1 : 0), "" + (this.includeTr == null ? 1 : (this.includeTr != false ? 2 : 0)), "" + (this.includeCn == null ? 1 : (this.includeCn != false ? 2 : 0))};
        Object props = "";
        for (String string : data) {
            props = (String)props + string + "|";
        }
        return props;
    }

    @Override
    public int getnProps() {
        return propNames.length;
    }

    @Override
    public String getPropertyName(int nProp) {
        switch (nProp) {
            case 24: {
                switch (this.calc_style.ordinal()) {
                    default: {
                        return propNames[nProp] + " (counts)";
                    }
                    case 1: 
                    case 5: 
                }
                return propNames[nProp] + " (%)";
            }
        }
        return propNames[nProp];
    }

    @Override
    public int[] getTitleRows() {
        return titleRows;
    }

    @Override
    public String getTitleName(int titleNo) {
        if (titleNo < 0 || titleNo > titleNames.length - 1) {
            return null;
        }
        return titleNames[titleNo];
    }

    @Override
    public Object getProperty(int nProp) {
        switch (nProp) {
            case 2: {
                return this.includeCv == null ? null : (this.includeCv != false ? OccFilter.INCLUDE : OccFilter.EXCLUDE);
            }
            case 1: {
                return this.includeRw == null ? null : (this.includeRw != false ? OccFilter.INCLUDE : OccFilter.EXCLUDE);
            }
            case 0: {
                return this.includeTr == null ? null : (this.includeTr != false ? OccFilter.INCLUDE : OccFilter.EXCLUDE);
            }
            case 3: {
                return this.includeCn == null ? null : (this.includeCn != false ? OccFilter.INCLUDE : OccFilter.EXCLUDE);
            }
            case 4: {
                return this.includeQ == null ? null : (this.includeQ != false ? OccFilter.INCLUDE : OccFilter.EXCLUDE);
            }
            case 5: {
                return this.exclGroup;
            }
            case 6: {
                return this.subTypes;
            }
            case 7: {
                return this.thresholdCount;
            }
            case 8: {
                return this.abn_style;
            }
            case 9: {
                return this.useSplits;
            }
            case 10: {
                return this.normaliseWeight;
            }
            case 11: {
                return Float.valueOf(this.normalWeight);
            }
            case 12: {
                return this.group;
            }
            case 13: {
                return this.subgroup;
            }
            case 14: {
                return this.track_style;
            }
            case 15: {
                return this.calc_style;
            }
            case 16: {
                return this.plot_style;
            }
            case 19: {
                return this.sawtoothEnhanced;
            }
            case 20: {
                return Float.valueOf((float)this.sawtoothEnhancement / 10.0f);
            }
            case 21: {
                return Float.valueOf(this.sawtoothCutoff);
            }
            case 22: {
                return this.stratRange;
            }
            case 23: {
                return this.justify;
            }
            case 24: {
                return Float.valueOf(this.cutoff);
            }
            case 26: {
                return Float.valueOf(this.minWidth);
            }
            case 25: {
                return Float.valueOf(this.maxWidth);
            }
            case 27: {
                return this.sortType;
            }
            case 28: {
                return this.colour;
            }
            case 29: {
                return this.inheritFilterColour;
            }
            case 30: {
                return this.colourSuites;
            }
            case 35: {
                return this.colourLabels;
            }
            case 32: {
                return this.showFlags;
            }
            case 31: {
                return this.showAbundance;
            }
            case 36: {
                return this.clearEmptyTracks;
            }
            case 37: {
                return this.grid;
            }
            case 39: {
                return this.showImages;
            }
            case 40: {
                return this.filterMkrImages;
            }
            case 41: {
                return (int)this.imageWidth;
            }
            case 42: {
                return this.hdr_cat;
            }
            case 43: {
                return this.hdr_alphacodes;
            }
            case 44: {
                return this.hdr_author;
            }
            case 46: {
                return this.highlightGroup;
            }
            case 47: {
                return this.highlightColour;
            }
            case 48: {
                return this.cmpStd;
            }
            case 49: {
                return this.hdrScheme;
            }
            case 50: {
                return this.schAbrs;
            }
            case 51: {
                return this.hdr_key;
            }
            case 52: {
                return this.drawEvents;
            }
            case 17: {
                return Float.valueOf(this.hist_height);
            }
            case 18: {
                return this.histHeightSampleRange;
            }
            case 45: {
                return this.hdr_italics;
            }
            case 53: {
                return this.onlyIncludeTaxaLinkedToEvents;
            }
            case 33: {
                return this.showOccComments;
            }
            case 34: {
                return this.occCommentsMaxLength;
            }
            case 38: {
                return this.highlightMarkers;
            }
        }
        return null;
    }

    @Override
    public boolean showRow(int row) {
        switch (row) {
            case 11: {
                return this.normaliseWeight;
            }
            case 19: 
            case 21: {
                return this.plot_style == Plot.SAWTOOTH || this.plot_style == Plot.STICKNDOT;
            }
            case 20: {
                return (this.plot_style == Plot.SAWTOOTH || this.plot_style == Plot.STICKNDOT) && this.sawtoothEnhanced;
            }
            case 35: {
                return this.showAbundance || this.showFlags;
            }
            case 40: 
            case 41: {
                return this.showImages;
            }
            case 42: 
            case 43: 
            case 44: 
            case 46: {
                return this.group == Group.SPEC;
            }
            case 47: {
                return this.highlightGroup != null && this.group == Group.SPEC;
            }
            case 50: {
                return this.hdrScheme != null;
            }
            case 17: 
            case 18: {
                return this.plot_style == Plot.HIST;
            }
            case 33: {
                return this.group == Group.SPEC;
            }
            case 34: {
                return this.group == Group.SPEC && this.showOccComments;
            }
            case 38: {
                return this.group == Group.SPEC && this.track_style == Track.SINGLE;
            }
        }
        return true;
    }

    @Override
    public boolean hasShowRowDependencies(int nProp) {
        switch (nProp) {
            case 10: 
            case 12: 
            case 16: 
            case 19: 
            case 21: 
            case 31: 
            case 32: 
            case 33: 
            case 39: 
            case 46: 
            case 49: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean setProperty(int nProp, Object prop) {
        if (this.getProperty(nProp) == null ^ prop == null || this.getProperty(nProp) != null && !this.getProperty(nProp).equals(prop)) {
            switch (nProp) {
                case 2: {
                    OccFilter f = (OccFilter)((Object)prop);
                    this.includeCv = f != null ? Boolean.valueOf(f.isQualified()) : null;
                    break;
                }
                case 1: {
                    OccFilter f = (OccFilter)((Object)prop);
                    this.includeRw = f != null ? Boolean.valueOf(f.isQualified()) : null;
                    break;
                }
                case 0: {
                    OccFilter f = (OccFilter)((Object)prop);
                    this.includeTr = f != null ? Boolean.valueOf(f.isQualified()) : null;
                    break;
                }
                case 3: {
                    OccFilter f = (OccFilter)((Object)prop);
                    this.includeCn = f != null ? Boolean.valueOf(f.isQualified()) : null;
                    break;
                }
                case 4: {
                    OccFilter f = (OccFilter)((Object)prop);
                    this.includeQ = f != null ? Boolean.valueOf(f.isQualified()) : null;
                    break;
                }
                case 5: {
                    this.exclGroup = (TxGroup)prop;
                    break;
                }
                case 6: {
                    this.subTypes = (Set)prop;
                    break;
                }
                case 7: {
                    this.thresholdCount = prop instanceof Integer ? (Integer)prop : Integer.parseInt(prop != null ? prop.toString() : "");
                    break;
                }
                case 8: {
                    this.abn_style = (Abundance)((Object)prop);
                    if (this.abn_style.setSemiQuant) {
                        this.subgroup = SubGroup.NONE;
                        this.useSplits = false;
                        this.track_style = Track.SINGLE;
                        this.calc_style = Calc.ABS;
                        this.plot_style = Plot.HIST;
                        this.justify = Justify.CENTRE;
                        this.hist_height = 2.5f;
                        break;
                    }
                    if (this.justify != Justify.CENTRE) break;
                    this.justify = Justify.LEFT;
                    break;
                }
                case 9: {
                    this.useSplits = (Boolean)prop;
                    break;
                }
                case 10: {
                    this.normaliseWeight = (Boolean)prop;
                    break;
                }
                case 11: {
                    float f = prop instanceof Float ? ((Float)prop).floatValue() : Float.parseFloat(prop.toString());
                    if ((double)f < 0.1 || (double)Math.abs(f - this.normalWeight) < 0.1) {
                        return false;
                    }
                    this.normalWeight = f;
                    break;
                }
                case 12: {
                    this.group = (Group)((Object)prop);
                    if (this.group == Group.SPEC && this.calc_style.isDiversity) {
                        this.calc_style = Calc.ABS;
                    }
                    if (this.group == Group.SPEC || this.sortType != Sort.SORTAGE) break;
                    this.sortType = Sort.SORTDOWNHOLE;
                    break;
                }
                case 13: {
                    this.subgroup = (SubGroup)((Object)prop);
                    break;
                }
                case 14: {
                    this.track_style = (Track)((Object)prop);
                    if (this.track_style != Track.MULTI) break;
                    if (this.calc_style.isDiversity) {
                        this.calc_style = Calc.ABS;
                    }
                    if (this.justify == Justify.CENTRE) {
                        this.justify = Justify.LEFT;
                    }
                    if (this.plot_style != Plot.NUMBERS) break;
                    this.plot_style = Plot.SAWTOOTH;
                    break;
                }
                case 15: {
                    this.calc_style = (Calc)((Object)prop);
                    if (this.calc_style.isDiversity || this.calc_style == Calc.RICHNESS) {
                        this.subgroup = SubGroup.NONE;
                    }
                    if (this.calc_style != Calc.ABS && this.abn_style.setSemiQuant) {
                        this.abn_style = Abundance.Q;
                    }
                    if (!this.calc_style.isRelative || this.sortType != Sort.SORTAGE) break;
                    this.sortType = Sort.SORTDOWNHOLE;
                    break;
                }
                case 16: {
                    this.plot_style = (Plot)((Object)prop);
                    if (this.plot_style == Plot.NUMBERS) {
                        this.showAbundance = true;
                        this.track_style = Track.SINGLE;
                        break;
                    }
                    if (this.plot_style != Plot.CURVE || this.justify != Justify.CENTRE) break;
                    this.justify = Justify.LEFT;
                    break;
                }
                case 19: {
                    this.sawtoothEnhanced = (Boolean)prop;
                    break;
                }
                case 20: {
                    return this.setSawtoothEnhancement(prop instanceof Float ? ((Float)prop).floatValue() : Float.parseFloat(prop.toString()));
                }
                case 21: {
                    float sawCut = (float)SB.round((double)(prop instanceof Float ? (double)((Float)prop).floatValue() : (double)Float.parseFloat(prop.toString())), (int)1);
                    if (sawCut >= 20.0f && sawCut <= 200.0f) {
                        this.sawtoothCutoff = sawCut;
                        break;
                    }
                    return false;
                }
                case 22: {
                    this.stratRange = (Boolean)prop;
                    break;
                }
                case 23: {
                    this.justify = (Justify)((Object)prop);
                    break;
                }
                case 24: {
                    float cOff;
                    float f = cOff = prop instanceof Float ? ((Float)prop).floatValue() : Float.parseFloat(prop.toString());
                    if (cOff < 5.0f && this.calc_style != Calc.COSINETHETA) {
                        cOff = 5.0f;
                    } else if (this.calc_style.isRelative && cOff > 100.0f) {
                        cOff = 100.0f;
                    }
                    if ((double)Math.abs(this.cutoff - cOff) < 0.1) {
                        return false;
                    }
                    this.cutoff = cOff;
                    this.setScale();
                    break;
                }
                case 25: {
                    float mWidth;
                    float f = mWidth = prop instanceof Float ? ((Float)prop).floatValue() : Float.parseFloat(prop.toString());
                    if (mWidth < 3.0f) {
                        mWidth = 3.0f;
                    }
                    if ((double)Math.abs(mWidth - this.maxWidth) < 0.1) {
                        return false;
                    }
                    this.maxWidth = mWidth;
                    this.setScale();
                    break;
                }
                case 26: {
                    float colWidth;
                    float f = colWidth = prop instanceof Float ? ((Float)prop).floatValue() : Float.parseFloat(prop.toString());
                    if (colWidth < 3.0f) {
                        colWidth = 3.0f;
                    }
                    if ((double)Math.abs(colWidth - this.minWidth) < 0.1) {
                        return false;
                    }
                    this.minWidth = colWidth;
                    break;
                }
                case 27: {
                    this.sortType = (Sort)((Object)prop);
                    break;
                }
                case 28: {
                    this.colour = (Color)prop;
                    break;
                }
                case 29: {
                    this.inheritFilterColour = (Boolean)prop;
                    break;
                }
                case 30: {
                    this.colourSuites = (Boolean)prop;
                    break;
                }
                case 35: {
                    this.colourLabels = (Boolean)prop;
                    break;
                }
                case 32: {
                    this.showFlags = (Boolean)prop;
                    break;
                }
                case 31: {
                    this.showAbundance = (Boolean)prop;
                    break;
                }
                case 36: {
                    this.clearEmptyTracks = (Boolean)prop;
                    break;
                }
                case 37: {
                    this.grid = (Boolean)prop;
                    break;
                }
                case 39: {
                    this.showImages = (Boolean)prop;
                    break;
                }
                case 40: {
                    this.filterMkrImages = (Boolean)prop;
                    break;
                }
                case 41: {
                    float imgWidth;
                    float f = imgWidth = prop instanceof Float ? ((Float)prop).floatValue() : Float.parseFloat(prop.toString());
                    if (imgWidth < 20.0f) {
                        imgWidth = 20.0f;
                    } else if (imgWidth > 150.0f) {
                        imgWidth = 150.0f;
                    }
                    if (Math.abs(imgWidth - this.imageWidth) < 1.0f) {
                        return false;
                    }
                    this.imageWidth = imgWidth;
                    break;
                }
                case 42: {
                    this.hdr_cat = (Boolean)prop;
                    break;
                }
                case 43: {
                    this.hdr_alphacodes = (Boolean)prop;
                    break;
                }
                case 44: {
                    this.hdr_author = (Boolean)prop;
                    break;
                }
                case 45: {
                    this.hdr_italics = (Boolean)prop;
                    break;
                }
                case 46: {
                    this.highlightGroup = (TxGroup)prop;
                    break;
                }
                case 47: {
                    this.highlightColour = (Color)prop;
                    break;
                }
                case 48: {
                    this.cmpStd = (CompositeStandard)prop;
                    break;
                }
                case 51: {
                    this.hdr_key = (Boolean)prop;
                    break;
                }
                case 49: {
                    this.hdrScheme = (IGDScheme)prop;
                    break;
                }
                case 50: {
                    this.schAbrs = (Boolean)prop;
                    break;
                }
                case 52: {
                    this.drawEvents = (Boolean)prop;
                    break;
                }
                case 17: {
                    float histHeight = (float)SB.round((double)(prop instanceof Float ? (double)((Float)prop).floatValue() : (double)Float.parseFloat(prop.toString())), (int)1);
                    if (histHeight >= 0.25f && histHeight <= 8.0f) {
                        this.hist_height = histHeight;
                        break;
                    }
                    return false;
                }
                case 18: {
                    this.histHeightSampleRange = (Boolean)prop;
                    break;
                }
                case 53: {
                    this.onlyIncludeTaxaLinkedToEvents = (Boolean)prop;
                    break;
                }
                case 33: {
                    this.showOccComments = (Boolean)prop;
                    break;
                }
                case 34: {
                    this.occCommentsMaxLength = prop instanceof Integer ? (Integer)prop : Integer.parseInt(prop != null ? prop.toString() : "");
                    break;
                }
                case 38: {
                    this.highlightMarkers = (Boolean)prop;
                }
            }
            return true;
        }
        return false;
    }

    private boolean setSawtoothEnhancement(float enhancement) {
        int i = (int)(enhancement * 10.0f);
        if (i < 2 || i > 10) {
            return false;
        }
        this.sawtoothEnhancement = i;
        return true;
    }

    @Override
    public Class<?> getPropertyClass(int nProp) {
        switch (nProp) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return OccFilter.class;
            }
            case 9: 
            case 10: 
            case 18: 
            case 19: 
            case 22: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                return Boolean.class;
            }
            case 6: {
                return Integer[].class;
            }
            case 8: {
                return Abundance.class;
            }
            case 11: 
            case 17: 
            case 21: 
            case 24: 
            case 25: 
            case 26: {
                return Float.class;
            }
            case 7: 
            case 34: 
            case 41: {
                return Integer.class;
            }
            case 12: {
                return Group.class;
            }
            case 13: {
                return SubGroup.class;
            }
            case 14: {
                return Track.class;
            }
            case 15: {
                return Calc.class;
            }
            case 16: {
                return Plot.class;
            }
            case 20: {
                return JSlider.class;
            }
            case 23: {
                return Justify.class;
            }
            case 27: {
                return Sort.class;
            }
            case 28: 
            case 47: {
                return Color.class;
            }
            case 5: 
            case 46: {
                return TxGroup.class;
            }
            case 48: {
                return CompositeStandard.class;
            }
            case 49: {
                return IGDScheme.class;
            }
        }
        return null;
    }

    @Override
    public Integer getFilterGrpID() {
        return this.highlightGroup != null ? Integer.valueOf(this.highlightGroup.getID()) : null;
    }

    @Override
    Integer getStdID() {
        return this.cmpStd != null ? Integer.valueOf(this.cmpStd.getStdID()) : null;
    }

    @Override
    public Integer getSchID() {
        return this.hdrScheme != null ? Integer.valueOf(this.hdrScheme.getID()) : null;
    }

    @Override
    public PanelProperties copy() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void copy(PanelProperties pp) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof PanelTaxonProperties)) {
            return false;
        }
        PanelTaxonProperties rhs = (PanelTaxonProperties)o;
        if (!super.equals(rhs)) {
            return false;
        }
        if (this.sortType != rhs.sortType) {
            return false;
        }
        if (this.group != rhs.group) {
            return false;
        }
        if (this.track_style != rhs.track_style) {
            return false;
        }
        if (this.calc_style != rhs.calc_style) {
            return false;
        }
        if (this.plot_style != rhs.plot_style) {
            return false;
        }
        if (this.justify != rhs.justify) {
            return false;
        }
        if (this.cutoff != rhs.cutoff) {
            return false;
        }
        if (this.maxWidth != rhs.maxWidth) {
            return false;
        }
        if (this.minWidth != rhs.minWidth) {
            return false;
        }
        if (!this.colour.equals(rhs.colour)) {
            return false;
        }
        if (this.colourLabels != rhs.colourLabels) {
            return false;
        }
        if (this.colourSuites != rhs.colourSuites) {
            return false;
        }
        if (this.inheritFilterColour != rhs.inheritFilterColour) {
            return false;
        }
        if (this.abn_style != rhs.abn_style) {
            return false;
        }
        if (this.showFlags != rhs.showFlags) {
            return false;
        }
        if (this.subgroup != rhs.subgroup) {
            return false;
        }
        if (this.hdr_cat != rhs.hdr_cat) {
            return false;
        }
        if (this.hdr_alphacodes != rhs.hdr_alphacodes) {
            return false;
        }
        if (this.hdr_author != rhs.hdr_author) {
            return false;
        }
        if (this.hdr_italics != rhs.hdr_italics) {
            return false;
        }
        if (this.hdr_key != rhs.hdr_key) {
            return false;
        }
        if (this.hdrScheme != rhs.hdrScheme) {
            return false;
        }
        if (this.cmpStd != rhs.cmpStd) {
            return false;
        }
        if (this.schAbrs != rhs.schAbrs) {
            return false;
        }
        if (this.grid != rhs.grid) {
            return false;
        }
        if (this.showImages != rhs.showImages) {
            return false;
        }
        if (this.filterMkrImages != rhs.filterMkrImages) {
            return false;
        }
        if (this.imageWidth != rhs.imageWidth) {
            return false;
        }
        if (this.clearEmptyTracks != rhs.clearEmptyTracks) {
            return false;
        }
        if (!this.highlightColour.equals(rhs.highlightColour)) {
            return false;
        }
        if (this.highlightGroup != rhs.highlightGroup) {
            return false;
        }
        if (this.showAbundance != rhs.showAbundance) {
            return false;
        }
        if (this.stratRange != rhs.stratRange) {
            return false;
        }
        if (this.sawtoothEnhanced != rhs.sawtoothEnhanced) {
            return false;
        }
        if (this.sawtoothEnhancement != rhs.sawtoothEnhancement) {
            return false;
        }
        if (this.sawtoothCutoff != rhs.sawtoothCutoff) {
            return false;
        }
        if (this.hist_height != rhs.hist_height) {
            return false;
        }
        if (this.histHeightSampleRange != rhs.histHeightSampleRange) {
            return false;
        }
        if (this.onlyIncludeTaxaLinkedToEvents != rhs.onlyIncludeTaxaLinkedToEvents) {
            return false;
        }
        if (this.showOccComments != rhs.showOccComments) {
            return false;
        }
        if (this.occCommentsMaxLength != rhs.occCommentsMaxLength) {
            return false;
        }
        if (this.highlightMarkers != rhs.highlightMarkers) {
            return false;
        }
        return this.drawEvents == rhs.drawEvents;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + super.hashCode();
        hash = 37 * hash + (this.group != null ? this.group.hashCode() : 0);
        hash = 37 * hash + (this.subgroup != null ? this.subgroup.hashCode() : 0);
        hash = 37 * hash + (this.track_style != null ? this.track_style.hashCode() : 0);
        hash = 37 * hash + (this.calc_style != null ? this.calc_style.hashCode() : 0);
        hash = 37 * hash + this.sortType.hashCode();
        hash = 37 * hash + (this.plot_style != null ? this.plot_style.hashCode() : 0);
        hash = 37 * hash + (this.justify != null ? this.justify.hashCode() : 0);
        hash = 37 * hash + (this.stratRange ? 1 : 0);
        hash = 37 * hash + (this.sawtoothEnhanced ? 1 : 0);
        hash = 37 * hash + this.sawtoothEnhancement;
        hash = 37 * hash + Float.floatToIntBits(this.sawtoothCutoff);
        hash = 37 * hash + (this.abn_style != null ? this.abn_style.hashCode() : 0);
        hash = 37 * hash + (this.showImages ? 1 : 0);
        hash = 37 * hash + (this.filterMkrImages ? 1 : 0);
        hash = 37 * hash + Float.floatToIntBits(this.imageWidth);
        hash = 37 * hash + Float.floatToIntBits(this.cutoff);
        hash = 37 * hash + Float.floatToIntBits(this.maxWidth);
        hash = 37 * hash + Float.floatToIntBits(this.minWidth);
        hash = 37 * hash + Float.floatToIntBits(this.hist_height);
        hash = 37 * hash + (this.showFlags ? 1 : 0);
        hash = 37 * hash + (this.showAbundance ? 1 : 0);
        hash = 37 * hash + (this.colour != null ? this.colour.hashCode() : 0);
        hash = 37 * hash + (this.colourSuites ? 1 : 0);
        hash = 37 * hash + (this.colourLabels ? 1 : 0);
        hash = 37 * hash + (this.inheritFilterColour ? 1 : 0);
        hash = 37 * hash + (this.grid ? 1 : 0);
        hash = 37 * hash + (this.clearEmptyTracks ? 1 : 0);
        hash = 37 * hash + (this.hdr_cat ? 1 : 0);
        hash = 37 * hash + (this.hdr_author ? 1 : 0);
        hash = 37 * hash + (this.hdr_key ? 1 : 0);
        hash = 37 * hash + (this.cmpStd != null ? this.cmpStd.hashCode() : 0);
        hash = 37 * hash + (this.hdrScheme != null ? this.hdrScheme.hashCode() : 0);
        hash = 37 * hash + (this.schAbrs ? 1 : 0);
        hash = 37 * hash + (this.highlightGroup != null ? this.highlightGroup.hashCode() : 0);
        hash = 37 * hash + (this.highlightColour != null ? this.highlightColour.hashCode() : 0);
        hash = 37 * hash + (this.drawEvents ? 1 : 0);
        hash = 37 * hash + (this.hdr_italics ? 1 : 0);
        hash = 37 * hash + (this.histHeightSampleRange ? 1 : 0);
        hash = 37 * hash + (this.hdr_alphacodes ? 1 : 0);
        hash = 37 * hash + (this.onlyIncludeTaxaLinkedToEvents ? 1 : 0);
        hash = 37 * hash + (this.showOccComments ? 1 : 0);
        hash = 37 * hash + this.occCommentsMaxLength;
        hash = 37 * hash + (this.highlightMarkers ? 1 : 0);
        return hash;
    }

    @Override
    public boolean isSimilarTo(PanelProperties comp) {
        if (!(comp instanceof PanelTaxonProperties)) {
            return false;
        }
        if (this.equals(comp)) {
            return true;
        }
        PanelTaxonProperties rhs = (PanelTaxonProperties)comp;
        block7: for (int i = 0; i < this.getnProps(); ++i) {
            switch (i) {
                case 41: {
                    if (!(Math.abs(this.imageWidth - rhs.imageWidth) > 3.0f)) continue block7;
                    return false;
                }
                case 25: {
                    if (!(Math.abs(this.maxWidth - rhs.maxWidth) > 5.0f)) continue block7;
                    return false;
                }
                case 26: {
                    if (!(Math.abs(this.minWidth - rhs.minWidth) > 2.0f)) continue block7;
                    return false;
                }
                case 17: {
                    if (!((double)Math.abs(this.hist_height - rhs.hist_height) > 0.5)) continue block7;
                    return false;
                }
                case 28: 
                case 45: 
                case 47: {
                    continue block7;
                }
                default: {
                    if (Objects.equals(this.getProperty(i), rhs.getProperty(i))) continue block7;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isOverplotRow(int row) {
        return row <= 7 || row == 12 || row == 27 || row == 14 || row == 36;
    }

    public static enum Group {
        SPEC("species", false, null),
        CAT("categories", true, null),
        GROUP("groups", true, null),
        GENUS("genera", false, null),
        SITU("situation", true, new String[]{"In-situ", "Tr", "Rw", "Cv"}),
        SUBTYPE("sub-type", false, null),
        CONF("confidence", true, new String[]{"Confident", "Questionable"}),
        TOTAL("panel total", false, new String[]{"Total count"});

        private final String trackAdj;
        private final boolean hasColours;
        private final String[] curveNames;

        private Group(String trackAdj, boolean hasColours, String[] curveNames) {
            this.trackAdj = trackAdj;
            this.hasColours = hasColours;
            this.curveNames = curveNames;
        }

        String getTrackAdj() {
            return this.trackAdj;
        }

        boolean hasColours() {
            return this.hasColours;
        }

        public String toString() {
            return this.trackAdj;
        }

        String[] getCurveNames() {
            return this.curveNames;
        }
    }

    public static enum SubGroup {
        NONE("none", new String[]{"No subgroups"}),
        SITU("situation", new String[]{"In-Situ", "Transported", "Reworked", "Caved", "Contamination"}),
        CONF("confidence", new String[]{"Confident", "Questionable"}),
        CMF("size fraction", new String[]{"Coarse", "Medium", "Fine"}),
        SUBTYPE("sub-type", null);

        final String[] groupNames;
        final String descr;

        private SubGroup(String descr, String[] groupNames) {
            this.descr = descr;
            this.groupNames = groupNames;
        }

        String[] getGroupNames() {
            return this.groupNames;
        }

        public String toString() {
            return this.descr;
        }
    }

    public static enum Track {
        SINGLE("individual columns"),
        MULTI("stacked curves");

        final String name;

        private Track(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum Calc {
        ABS("absolute", false, false),
        RELATIVE("relative (inner)", true, false),
        RICHNESS("species richness", false, false),
        SHANNON("Shannon diversity", false, true),
        FISHER("Fisher's alpha diversity", false, true),
        RELATIVE_OUTER("relative (outer)", true, false),
        COSINETHETA("cosine theta similarity", false, true);

        final String name;
        final boolean isRelative;
        final boolean isDiversity;

        private Calc(String name, boolean isRelative, boolean isDiversity) {
            this.name = name;
            this.isRelative = isRelative;
            this.isDiversity = isDiversity;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum Sort {
        SORTDOWNHOLE("first downhole occurrence", 0),
        SORTUPHOLE("first uphole occurrence", 1),
        SORTALPHA("alphabetical", 3),
        SORTALPHASPEC("alphabetical (species)", 3),
        SORTAGE("event age", -1),
        SORTCUSTOM("custom order", -1);

        private final String name;
        private final int integerEquivalent;

        private Sort(String name, int integerEquivalent) {
            this.name = name;
            this.integerEquivalent = integerEquivalent;
        }

        public String toString() {
            return this.name;
        }

        public int getIntegerEquivalent() {
            return this.integerEquivalent;
        }
    }

    public static enum Plot {
        HIST("histogram"),
        SAWTOOTH("sawtooth"),
        NUMBERS("numbers/labels only"),
        CURVE("curve"),
        STICKNDOT("sawtooth, stick and dot");

        final String name;

        private Plot(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum Justify {
        LEFT("left"),
        RIGHT("right"),
        CENTRE("centre");

        final String name;

        private Justify(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum Abundance {
        Q("quantitative", false),
        SEMIQ("semi-quantitative", true),
        MIX("quant/semi-quant", false),
        PA("presence/absence", true);

        private final String description;
        private final boolean setSemiQuant;

        private Abundance(String description, boolean setSemiQuant) {
            this.description = description;
            this.setSemiQuant = setSemiQuant;
        }

        public String toString() {
            return this.description;
        }

        public boolean setSemiQuant() {
            return this.setSemiQuant;
        }
    }

    public static enum OccFilter {
        EXCLUDE("Exclude", false),
        INCLUDE("Include only", true);

        private final String name;
        private final boolean isQualified;

        private OccFilter(String name, boolean isQualified) {
            this.name = name;
            this.isQualified = isQualified;
        }

        public String toString() {
            return this.name;
        }

        public boolean isQualified() {
            return this.isQualified;
        }
    }
}

