/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import com.stratadata.model3.well.sample.SampleType;
import java.util.Objects;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelSamplesProperties;
import jsbchart.panel.PanelTaxonPropertiesBase;
import org.apache.commons.lang3.StringUtils;

public class PanelTaxonSamplesProperties
extends PanelTaxonPropertiesBase {
    PanelSamplesProperties panelSamplesProperties;
    boolean analystPanel = true;
    boolean analystColours = true;
    boolean plotBarren = true;
    boolean analysisLabels = false;
    private static final int N_EXTRA = 4;
    private static final int PROP_ANALY = 0;
    private static final int PROP_ANALY_COLOUR = 1;
    private static final int PROP_BARREN = 2;
    private static final int PROP_ANALYSIS_LABELS = 3;
    private static final String[] propNames = new String[]{"Analyst column", "Analyst colours", "Mark barren", "Analysis labels"};
    private static final int[] TITLE_ROWS = new int[]{4};
    private static final String[] TITLE_NAMES = new String[]{"Sampling panel"};

    PanelTaxonSamplesProperties(String props) {
        this.panelSamplesProperties = new PanelSamplesProperties();
        if (props != null) {
            this.decode(props);
        }
    }

    private void decode(String string) {
        String[] s = string.split("\\|");
        block11: for (int i = 0; i < s.length; ++i) {
            switch (i) {
                case 0: {
                    this.analystPanel = Integer.parseInt(s[i]) == 1;
                    continue block11;
                }
                case 1: {
                    this.plotBarren = Integer.parseInt(s[i]) == 1;
                    continue block11;
                }
                case 2: {
                    this.analystColours = Integer.parseInt(s[i]) == 1;
                    continue block11;
                }
                case 3: {
                    this.panelSamplesProperties.setProperty(2, Integer.parseInt(s[i]) == 1);
                    continue block11;
                }
                case 4: {
                    this.panelSamplesProperties.setProperty(1, Integer.parseInt(s[i]) == 1);
                    continue block11;
                }
                case 5: {
                    this.panelSamplesProperties.setProperty(4, Integer.parseInt(s[i]) == 1);
                    continue block11;
                }
                case 6: {
                    this.panelSamplesProperties.setProperty(3, Integer.parseInt(s[i]) == 1);
                    continue block11;
                }
                case 7: {
                    this.panelSamplesProperties.setProperty(0, Integer.parseInt(s[i]) == 1);
                    continue block11;
                }
                case 8: {
                    this.analysisLabels = Integer.parseInt(s[i]) == 1;
                }
            }
        }
    }

    private PanelTaxonSamplesProperties(PanelTaxonSamplesProperties rhs) {
        this.analystPanel = rhs.analystPanel;
        this.analystColours = rhs.analystColours;
        this.plotBarren = rhs.plotBarren;
        this.analysisLabels = rhs.analysisLabels;
        this.panelSamplesProperties = new PanelSamplesProperties(rhs.panelSamplesProperties);
    }

    @Override
    public PanelTaxonPropertiesBase createCopy() {
        return new PanelTaxonSamplesProperties(this);
    }

    @Override
    public String getPropertiesString() {
        Object[] data = new String[]{"" + (this.analystPanel ? 1 : 0), "" + (this.plotBarren ? 1 : 0), "" + (this.analystColours ? 1 : 0), "" + (this.panelSamplesProperties.drawLabels() ? 1 : 0), "" + (this.panelSamplesProperties.isDrawDepths() ? 1 : 0), "" + (this.panelSamplesProperties.drawRange() ? 1 : 0), "" + (this.panelSamplesProperties.drawUnshifted() ? 1 : 0), "" + (this.panelSamplesProperties.drawSymbols() ? 1 : 0), "" + (this.analysisLabels ? 1 : 0)};
        return StringUtils.join((Object[])data, (String)"|");
    }

    @Override
    public int[] getTitleRows() {
        return TITLE_ROWS;
    }

    @Override
    public String getTitleName(int titleNo) {
        if (titleNo < 0 || titleNo > TITLE_NAMES.length - 1) {
            return null;
        }
        return TITLE_NAMES[titleNo];
    }

    @Override
    public String getPrefs() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getnProps() {
        return propNames.length + this.panelSamplesProperties.getnProps() - SampleType.values().length;
    }

    @Override
    public String getPropertyName(int nProp) {
        switch (nProp) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return propNames[nProp];
            }
        }
        return this.panelSamplesProperties.getPropertyName(nProp - 4);
    }

    @Override
    public Object getProperty(int nProp) {
        return switch (nProp) {
            case 0 -> this.analystPanel;
            case 1 -> this.analystColours;
            case 2 -> this.plotBarren;
            case 3 -> this.analysisLabels;
            default -> this.panelSamplesProperties.getProperty(nProp - 4);
        };
    }

    @Override
    public boolean setProperty(int nProp, Object prop) {
        if (this.getProperty(nProp) == null ^ prop == null || this.getProperty(nProp) != null && !this.getProperty(nProp).equals(prop)) {
            switch (nProp) {
                case 0: {
                    this.analystPanel = (Boolean)prop;
                    break;
                }
                case 1: {
                    this.analystColours = (Boolean)prop;
                    break;
                }
                case 2: {
                    this.plotBarren = (Boolean)prop;
                    break;
                }
                case 3: {
                    this.analysisLabels = (Boolean)prop;
                    break;
                }
                default: {
                    return this.panelSamplesProperties.setProperty(nProp - 4, prop);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public Class<?> getPropertyClass(int nProp) {
        switch (nProp) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return Boolean.class;
            }
        }
        return this.panelSamplesProperties.getPropertyClass(nProp - 4);
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 59 * hash + (this.panelSamplesProperties != null ? this.panelSamplesProperties.hashCode() : 0);
        hash = 59 * hash + (this.analystPanel ? 1 : 0);
        hash = 59 * hash + (this.analystColours ? 1 : 0);
        hash = 59 * hash + (this.plotBarren ? 1 : 0);
        hash = 59 * hash + (this.analysisLabels ? 1 : 0);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PanelTaxonSamplesProperties other = (PanelTaxonSamplesProperties)obj;
        if (!Objects.equals(this.panelSamplesProperties, other.panelSamplesProperties)) {
            return false;
        }
        if (this.plotBarren != other.plotBarren) {
            return false;
        }
        if (this.analystColours != other.analystColours) {
            return false;
        }
        if (this.analysisLabels != other.analysisLabels) {
            return false;
        }
        return this.analystPanel == other.analystPanel;
    }

    @Override
    public PanelProperties copy() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void copy(PanelProperties pp) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isSimilarTo(PanelProperties comp) {
        return this.equals(comp);
    }
}

