/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.event.EventType;
import com.stratadata.model3.scheme.Confidence;
import com.stratadata.model3.taxon.Category;
import com.stratadata.model3.well.analysis.hdr.AbundanceScheme;
import com.stratadata.model3.well.sample.SampleType;
import com.stratadata.model3.wellinterp.DuplicateNodeException;
import com.stratadata.model3.wellinterp.LOCNode;
import java.awt.Color;
import java.awt.Font;
import java.awt.Shape;
import java.awt.font.TextAttribute;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.sql.SQLException;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.undo.UndoableEdit;
import jsbchart.block.BlockProperties;
import jsbchart.block.ChartBlock;
import jsbchart.block.CorrelationPoint;
import jsbchart.block.ProjectBlock;
import jsbchart.block.SchemeBlock;
import jsbchart.block.WellBlock;
import jsbchart.core.Chart;
import jsbchart.core.ChartFactory;
import jsbchart.core.ChartProperties;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.correlation.CorrelationType;
import jsbchart.graphics.SBGraphics;
import jsbchart.panel.PanelCompositeStandard;
import jsbchart.panel.PanelEnv;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelSamples;
import jsbchart.panel.PanelWellDepthAgeProperties;
import jsbchart.panel.SBPanel;
import jsbchart.util.DrawingUtils;
import model3.CompositeStandard;
import model3.CompositeStandardEvent;
import model3.IGDInterval;
import model3.IGDIntervalZone;
import model3.IGDScheme;
import model3.IGDUnit;
import model3.IGDUnitBase;
import model3.LOC;
import model3.SBEvent;
import model3.SBdb;
import model3.SQPick;
import model3.Sample;
import model3.Smpdtl;
import model3.Surface;
import model3.TVDList;
import model3.TaxonOcc;
import model3.Well;
import model3.WellEvent;
import model3.WellInterp;
import model3.WsWell;
import model3.project.WellList;
import model3.wellinterp.InterpItem;
import util.ColourUtils;
import util.DepthUnits;
import util.DepthUtils;
import util.InvalidFieldException;
import util.SB;
import util.SBException;

public class PanelWellDepthAge
extends SBPanel {
    private BlockProperties sBlockProp;
    private SchemeBlock sBlock;
    private PanelWellDepthAgeProperties prop;
    private final WellBlock block;
    private static final Logger LOGGER = Logger.getLogger(PanelWellDepthAge.class.getName());
    private static final float SNAPDEPTH = 2.0f;
    private static final float BRACKET = 2.0f;
    private static final double AGEBRACKET = 0.1;
    private static final Color DEEP_GREEN = new Color(0, 128, 128);
    private static final Color LIGHT_GREEN = new Color(0, 180, 180);
    private final Color hstColour;
    private final Color tstColour;
    private final Color lstColour;
    private List<CompositeStandardEvent> compositeStandardEvents = null;
    private CompositeStandard cmpStd = null;
    private static final double[][] LOC_TEMPLATE_DEPTH = new double[3][];
    private static final double[][] LOC_TEMPLATE_AGE = new double[3][];
    private static final Color[] LOC_COLOURS = new Color[]{null, Color.RED, Color.BLUE};
    private static final LOC[] LOC_TEMPLATES;
    private static final float[] EV_TOP_AGES;
    private static final float[] EV_TOP_DEPTHS;
    private static final float[] EV_BASE_AGES;
    private static final float[] EV_BASE_DEPTHS;

    PanelWellDepthAge(WellBlock block, PanelTemplate template, PanelOcc occ) throws SQLException, SBException {
        super(template, occ != null ? occ : new PanelOcc(template.getID()));
        this.block = block;
        this.prop = (PanelWellDepthAgeProperties)template.getProperties();
        this.hstColour = this.getDb().getMiscColour("COL_HST", Color.RED);
        this.tstColour = this.getDb().getMiscColour("COL_TST", Color.GREEN);
        this.lstColour = this.getDb().getMiscColour("COL_LST", Color.BLUE);
        this.init();
        if (this.prop.sBlockTempl != null) {
            this.sBlock = (SchemeBlock)ChartFactory.createBlock(this.getDb(), this.prop.sBlockTempl);
            this.sBlock.setWells(block.getWells());
            this.sBlockProp = new BlockProperties(block.getProp().getAltProp(BlockProperties.ScaleType.AGE).getProperties());
            this.sBlock.setProperties(this.sBlockProp);
        }
        this.restrictSBlock();
    }

    private void init() throws SQLException, SBException {
        BlockProperties altProp = null;
        if (!this.block.getProp().hasAltProp(BlockProperties.ScaleType.AGE)) {
            altProp = this.block.getProp().getAltProp(BlockProperties.ScaleType.AGE);
        }
        if (this.block.getWells() != null && !this.block.getWells().isEmpty()) {
            for (Well well : this.block.getWells()) {
                well.loadInterps();
                WellInterp interp = well.getInterp(this.getInterpID(this.block));
                well.loadInterp(interp);
                interp.addWeakObserver((Observer)this);
                if (altProp == null || interp.getLOC() == null) continue;
                altProp.setMin((float)Math.min((double)altProp.getMin(), interp.getLOC().getMinAge()));
                altProp.setMax((float)Math.max((double)altProp.getMax(), interp.getLOC().getMaxAge()));
            }
            if (altProp != null) {
                altProp.setScale(SchemeBlock.calcIdealScale(altProp.getMin(), altProp.getMax()));
            }
        } else if (altProp != null) {
            altProp.setMin(this.prop.getCmpStd() != null ? (float)this.prop.getCmpStd().getMinAge() : 0.0f);
            altProp.setMax(this.prop.getCmpStd() != null ? (float)this.prop.getCmpStd().getMaxAge() : 100.0f);
            altProp.setScale(SchemeBlock.calcIdealScale(altProp.getMin(), altProp.getMax()) / 2.0f);
        }
        this.buildEventCache();
    }

    private void buildEventCache() {
        if (this.prop.getCmpStd() != null && this.prop.getCmpStd() != this.cmpStd) {
            this.cmpStd = this.prop.getCmpStd();
            this.cmpStd.addObserver((Observer)this);
            this.compositeStandardEvents = this.cmpStd.getEvents(true);
            CompositeStandardEvent.sort(this.compositeStandardEvents, (int)2);
        }
    }

    private void restrictSBlock() {
        if (this.prop.restrictAgeRangeToCurve && this.block.getWells() != null && this.block.getWells().size() == 1) {
            this.sBlockProp = null;
            if (this.getWellInterp().getLOC() != null) {
                if (this.block.getProp().getScaleType() == BlockProperties.ScaleType.AGE) {
                    if (this.sBlockProp == null) {
                        this.sBlockProp = new BlockProperties(this.block.getProp().getAltProp(BlockProperties.ScaleType.AGE).getProperties());
                    }
                    this.sBlockProp.setMin(this.block.getProp().getMin());
                    this.sBlockProp.setMax(this.block.getProp().getMax());
                } else {
                    double min = this.getWellInterp().getLOC().getAge(this.block.getMDLimit(true), true);
                    double max = this.getWellInterp().getLOC().getAge(this.block.getMDLimit(false), false);
                    if (min > (double)this.block.getProp().getAltMin(BlockProperties.ScaleType.AGE)) {
                        if (this.sBlockProp == null) {
                            this.sBlockProp = new BlockProperties(this.block.getProp().getAltProp(BlockProperties.ScaleType.AGE).getProperties());
                        }
                        this.sBlockProp.setMin((float)min - this.prop.extraAge);
                        if (this.sBlockProp.getMin() < 0.0f) {
                            this.sBlockProp.setMin(0.0f);
                        }
                        if (this.sBlockProp.getMin() < this.block.getProp().getAltMin(BlockProperties.ScaleType.AGE)) {
                            this.sBlockProp.setMin(this.block.getProp().getAltMin(BlockProperties.ScaleType.AGE));
                        }
                    }
                    if (max < (double)this.block.getProp().getAltMax(BlockProperties.ScaleType.AGE)) {
                        if (this.sBlockProp == null) {
                            this.sBlockProp = new BlockProperties(this.block.getProp().getAltProp(BlockProperties.ScaleType.AGE).getProperties());
                        }
                        this.sBlockProp.setMax((float)max + this.prop.extraAge);
                        if (this.sBlockProp.getMax() > this.block.getProp().getAltMax(BlockProperties.ScaleType.AGE)) {
                            this.sBlockProp.setMax(this.block.getProp().getAltMax(BlockProperties.ScaleType.AGE));
                        }
                    }
                }
            }
        } else {
            this.sBlockProp = null;
        }
        if (this.sBlock != null) {
            this.sBlock.setProperties(this.sBlockProp != null ? this.sBlockProp : this.block.getProp().getAltProp(BlockProperties.ScaleType.AGE));
        }
    }

    public String toString() {
        ProjectBlock b;
        Object s = "";
        if (this.block instanceof ProjectBlock && (b = (ProjectBlock)this.block).getWellList() != null) {
            s = String.valueOf(b.getWellList()) + " ";
        }
        if (this.block != null && this.block.getWell() != null) {
            switch (this.block.getProp().getScaleType()) {
                case MD: {
                    return (String)s + "Depth/Age Plot";
                }
                case TVD: {
                    return (String)s + "TVD/Age Plot";
                }
                case SUBSIDENCE: {
                    return (String)s + "Subsidence";
                }
            }
            return "Depth/Age Panel";
        }
        switch (this.getPanelType()) {
            case DEPTHAGE: {
                return "Depth/Age Plot";
            }
            case SUBSIDENCE: {
                return "Subsidence";
            }
        }
        assert (false);
        return "Depth/Age Panel";
    }

    public boolean interactive() {
        return this.block.getProp().getScaleType() == BlockProperties.ScaleType.MD;
    }

    @Override
    public String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        String s;
        LOCNode node;
        Sample sample;
        Object obj = this.getObject(x, y, cp, bp, zoom);
        if (obj instanceof SchemeBlock) {
            return null;
        }
        if (obj instanceof WellEvent) {
            WellEvent wellEvent = (WellEvent)obj;
            Object string = "<html><strong>";
            boolean insertBreak = false;
            for (WellEvent event : this.getEvents(x, wellEvent.getSample(), bp, zoom)) {
                if (insertBreak) {
                    string = (String)string + "<br>";
                }
                SBEvent sbEvent = event.getEvent();
                double age = this.getProperties().getCmpStd().getAge(sbEvent.getEvID(), event.getTypeObj());
                string = (String)string + cp.ageFormat.toAgeString(age, 2) + "   Event: " + event.toString(true, true, true, event.getSample().displayUnits, true, false);
                insertBreak = true;
            }
            string = (String)string + "</strong></html>";
            return string;
        }
        if (obj instanceof CompositeStandardEvent && (sample = this.getSample(y, zoom, cp)) != null) {
            CompositeStandardEvent[] cse = this.getCmpStdEvent(x, bp, zoom);
            Object occString = "";
            for (Smpdtl smpdtl : sample.getSmpdtls()) {
                for (TaxonOcc occ : smpdtl.getOccurUnsorted()) {
                    for (CompositeStandardEvent ev : cse) {
                        if (occ.getSpecID() != ev.getEvent().getSpecID()) continue;
                        occString = (String)occString + occ.toString();
                        occString = (String)occString + "<br>";
                    }
                }
            }
            if (!((String)occString).isEmpty()) {
                Object cmpStdString = "<html>";
                cmpStdString = (String)cmpStdString + cp.ageFormat.toAgeString((double)this.getAge(x), 2) + " ";
                cmpStdString = (String)cmpStdString + " (" + String.valueOf(sample) + ")";
                cmpStdString = (String)cmpStdString + "<br>Occurrence : ";
                cmpStdString = (String)cmpStdString + (String)occString;
                return (String)cmpStdString + "</html>";
            }
            return cp.ageFormat.toAgeString((double)this.getAge(x), 2);
        }
        if (this.getWellInterp() != null && this.getWellInterp().getLOC() != null && (node = this.getLocNode(x, y, zoom)) != null) {
            String locString = "Depth/Age Curve: " + cp.ageFormat.toAgeString(node.getAge(), 2) + " (" + SB.floatString((double)DepthUtils.convFromM((double)node.getDepth(), (char)this.block.getProp().getUnits()), (int)2) + DepthUnits.getUnits((char)this.block.getProp().getUnits()).getAbr() + ")";
            return locString;
        }
        String strg = cp.ageFormat.toAgeString((double)this.getAge(x), 2) + " ";
        if (this.block instanceof ProjectBlock && (s = this.getUnitName(this.getAge(x), true)) != null) {
            strg = strg + s + " ";
        }
        if (obj != null) {
            SQPick sqPick = null;
            if (obj instanceof Sample && this.getWellInterp() != null && (sqPick = this.getWellInterp().getSQPick((Sample)obj)) != null) {
                strg = strg + " - " + sqPick.toString() + " ";
            }
            if (sqPick == null) {
                strg = strg + "(" + obj.toString() + ")";
            }
        }
        return strg;
    }

    private WellInterp getWellInterp() {
        if (this.block instanceof ProjectBlock) {
            return null;
        }
        if (this.block.getWell() == null) {
            return null;
        }
        try {
            return this.block.getWell().getInterp(this.getInterpID(this.block));
        }
        catch (SBException e) {
            e.printStackTrace();
            return null;
        }
    }

    public UndoableEdit updateLOCNodeBnd(float x, float y, int bnd, float zoom) throws SBException, SQLException, InvalidFieldException {
        if (this.getWellInterp() == null) {
            throw new SBException("No version/composite standard selected");
        }
        Point2D.Float node = this.getLOCorigin(x, y, zoom);
        if (node == null) {
            throw new SBException("No node found near cursor.\n(use upper node to select line below, expand depth/age range of chart if at edge of panel)");
        }
        float SMALL = 1.0E-4f;
        boolean done = false;
        LOC loc = this.getWellInterp().getLOC();
        int originalBnd = -1;
        Iterator nodeIt = loc.getNodeIterator();
        while (nodeIt.hasNext()) {
            LOCNode locNode = (LOCNode)nodeIt.next();
            float yN = this.block.scaleDepth((float)locNode.getDepth());
            float xN = this.getXPos((float)locNode.getAge());
            if (!(Math.abs(((Point2D)node).getY() - (double)yN) < (double)SMALL) || !(Math.abs(((Point2D)node).getX() - (double)xN) < (double)SMALL)) continue;
            if (locNode.getBnd() == bnd) {
                return null;
            }
            if (IGDIntervalZone.isDisconformableBnd((int)bnd)) {
                if (!nodeIt.hasNext()) {
                    throw new InvalidFieldException("Cannot set disconfirmity at last node");
                }
                LOCNode nextNode = (LOCNode)nodeIt.next();
                if (Math.abs(locNode.getDepth() - nextNode.getDepth()) > 2.0) {
                    throw new InvalidFieldException("Unconformity can only be set between horizontal nodes");
                }
                if (Math.abs(locNode.getDepth() - nextNode.getDepth()) > (double)0.001f) {
                    return this.getWellInterp().updateLOCNode(locNode, nextNode.getDepth(), locNode.getAge(), bnd, this.block.getWell().getWellID());
                }
            }
            return this.getWellInterp().updateLOCNode(locNode, locNode.getDepth(), locNode.getAge(), bnd, this.block.getWell().getWellID());
        }
        return null;
    }

    public Point2D.Float getLOCorigin(float x, float y, float zoom) {
        LOCNode node = this.getLocNode(x, y, zoom);
        if (node != null) {
            float xN = this.getXPos((float)node.getAge());
            float yN = this.block.scaleDepth((float)node.getDepth());
            return new Point2D.Float(xN, yN);
        }
        return null;
    }

    public LOCNode getLocNode(float x, float y, float zoom) {
        if (this.getWellInterp() == null) {
            return null;
        }
        float nearest = 1000.0f;
        LOCNode origin = null;
        LOC locLine = this.getWellInterp().getLOC();
        if (locLine != null) {
            Iterator it = locLine.getNodeIterator();
            while (it.hasNext()) {
                float yN;
                LOCNode loc = (LOCNode)it.next();
                float xN = this.getXPos((float)loc.getAge());
                float tryNearest = this.isNear(x, xN, y, yN = this.block.scaleDepth((float)loc.getDepth()), nearest, zoom);
                if (!(tryNearest < nearest)) continue;
                nearest = tryNearest;
                origin = loc;
            }
            return origin;
        }
        return null;
    }

    public Point2D.Float getNeighbourPoint(float x, float y, boolean before) {
        if (this.getWellInterp() == null) {
            return null;
        }
        float SMALL = 1.0E-4f;
        LOC locLine = this.getWellInterp().getLOC();
        Iterator it = locLine.getNodeIterator();
        LOCNode previous = null;
        while (it.hasNext()) {
            LOCNode loc = (LOCNode)it.next();
            float xN = this.getXPos((float)loc.getAge());
            float yN = this.block.scaleDepth((float)loc.getDepth());
            if (Math.abs(y - yN) < SMALL && Math.abs(x - xN) < SMALL) {
                if (!before) {
                    if (it.hasNext()) {
                        LOCNode next = (LOCNode)it.next();
                        return new Point2D.Float(this.getXPos((float)next.getAge()), this.block.scaleDepth((float)next.getDepth()));
                    }
                } else if (previous != null) {
                    return new Point2D.Float(this.getXPos((float)previous.getAge()), this.block.scaleDepth((float)previous.getDepth()));
                }
                return null;
            }
            previous = loc;
        }
        return null;
    }

    public Point2D.Float[] getDisconfNeighbours(float x, float y) {
        if (this.getWellInterp() == null) {
            return null;
        }
        float SMALL = 1.5f;
        if (this.getWellInterp().getLOC() == null) {
            return null;
        }
        Iterator it = this.getWellInterp().getLOC().getNodeIterator();
        LOCNode previous = null;
        while (it.hasNext()) {
            LOCNode node = (LOCNode)it.next();
            if (previous != null && IGDIntervalZone.isDisconformableBnd((int)previous.getBnd())) {
                assert (Math.abs(node.getDepth() - previous.getDepth()) < 1.5);
                float xN = this.getXPos((float)(Math.abs(node.getAge() - previous.getAge()) / 2.0 + Math.min(node.getAge(), previous.getAge())));
                float yN = this.block.scaleDepth((float)node.getDepth());
                if (Math.abs(y - yN) < 1.5f && Math.abs(x - xN) < 1.5f) {
                    return new Point2D.Float[]{new Point2D.Float(this.getXPos((float)previous.getAge()), this.block.scaleDepth((float)previous.getDepth())), new Point2D.Float(this.getXPos((float)node.getAge()), this.block.scaleDepth((float)previous.getDepth()))};
                }
            }
            previous = node;
        }
        return null;
    }

    private float isNear(float x, float x1, float y, float y1, float nearest, float zoom) {
        if (Math.abs(x - x1) < 2.0f / zoom && Math.abs(y - y1) < 2.0f / zoom && Math.abs(x - x1) + Math.abs(y - y1) < nearest) {
            nearest = Math.abs(x - x1) + Math.abs(y - y1);
        }
        return nearest;
    }

    public UndoableEdit updateLOCNode(Point2D oldPoint, Point2D newPoint, int bnd) throws SQLException, SBException, InvalidFieldException {
        WellInterp wellInterp = this.getWellInterp();
        if (wellInterp == null) {
            return null;
        }
        float age = this.block.getProp().getAltAgeLeftToRight(BlockProperties.ScaleType.AGE) ? (float)newPoint.getX() / this.block.getProp().getAltScale(BlockProperties.ScaleType.AGE) + this.getMinAge() : this.getMaxAge() - (float)newPoint.getX() / this.block.getProp().getAltScale(BlockProperties.ScaleType.AGE);
        float y = this.block.getDepth((float)newPoint.getY());
        float SMALL = 0.1f;
        LOC locLine = wellInterp.getLOC();
        Iterator it = locLine.getNodeIterator();
        while (it.hasNext()) {
            LOCNode loc = (LOCNode)it.next();
            float xN = this.getXPos((float)loc.getAge());
            float yN = this.block.scaleDepth((float)loc.getDepth());
            if (!(Math.abs(oldPoint.getX() - (double)xN) < (double)SMALL) || !(Math.abs(oldPoint.getY() - (double)yN) < (double)SMALL)) continue;
            return wellInterp.updateLOCNode(loc, SB.round((double)y, (int)3), SB.round((double)age, (int)2), bnd > 0 ? bnd : loc.getBnd(), this.block.getWell().getWellID());
        }
        return null;
    }

    public UndoableEdit updateDisconf(float oldY, float newY) throws SQLException, SBException, InvalidFieldException {
        WellInterp wellInterp = this.getWellInterp();
        if (wellInterp == null) {
            return null;
        }
        return wellInterp.updateLOCDisconf((double)this.block.getDepth(oldY), (double)this.block.getDepth(newY), this.block.getWellID());
    }

    @Override
    public PanelWellDepthAgeProperties getProperties() {
        return this.prop;
    }

    @Override
    public void setProperties(PanelProperties prop) {
        if (!(prop instanceof PanelWellDepthAgeProperties)) {
            throw new IllegalArgumentException("Attempt to set PanelWellDepthAge properties to " + String.valueOf(prop));
        }
        this.prop = (PanelWellDepthAgeProperties)prop;
    }

    @Override
    public Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        CompositeStandardEvent[] cmpStdEvent;
        Sample nearestSample;
        if (y < 0.0f) {
            return this.sBlock;
        }
        float depth = this.block.getDepth(y, bp);
        Float obj = Float.valueOf(DepthUtils.convFromM((float)depth, (char)this.block.getProp().getUnits()));
        if (this.block.getWell() != null && (nearestSample = this.getSample(y, zoom, cp)) != null) {
            obj = nearestSample;
            WellEvent event = this.getEvent(x, nearestSample, bp, zoom);
            if (event != null) {
                return event;
            }
            List<Sample> samples = this.getSamples(y, zoom, cp);
            if (samples != null) {
                for (Sample sample : samples) {
                    event = this.getEvent(x, sample, bp, zoom);
                    if (event == null) continue;
                    return event;
                }
            }
        }
        if ((cmpStdEvent = this.getCmpStdEvent(x, bp, zoom)) != null && cmpStdEvent.length > 0) {
            return cmpStdEvent[0];
        }
        return obj;
    }

    public Sample getSample(float y, float zoom, ChartProperties cp) {
        List samples;
        float depth = this.block.getDepth(y, null);
        float DEPTH_BRACKET = this.block.getDepth(y + 2.0f / zoom) - depth;
        Sample sample = null;
        try {
            samples = this.block.getWell().getSamples();
            if (samples == null || samples.isEmpty()) {
                return sample;
            }
        }
        catch (Exception ex) {
            return sample;
        }
        try {
            double minSampDepth = this.block.getWell().getDepth((Sample)samples.get(0), cp.correctDepths, cp.correctCuttings);
            double maxSampDepth = this.block.getWell().getDepth((Sample)samples.get(samples.size() - 1), cp.correctDepths, cp.correctCuttings);
            if ((double)depth < minSampDepth - (double)DEPTH_BRACKET || (double)depth > maxSampDepth + (double)DEPTH_BRACKET) {
                return sample;
            }
        }
        catch (Exception e) {
            return sample;
        }
        float distance = 1000.0f;
        for (Sample s : samples) {
            try {
                double sDepth = this.block.getWell().getDepth(s, cp.correctDepths, cp.correctCuttings);
                if (sDepth >= (double)(depth - DEPTH_BRACKET) && sDepth <= (double)(depth + DEPTH_BRACKET)) {
                    if (!(Math.abs(sDepth - (double)depth) < (double)distance)) continue;
                    distance = Math.abs((float)sDepth - depth);
                    sample = s;
                    continue;
                }
                if (!(sDepth > (double)(depth + DEPTH_BRACKET))) continue;
                break;
            }
            catch (Exception e) {
                System.out.println("Exception in getSample loop of PanelWellDepth.getObject: " + e.getMessage());
            }
        }
        return sample;
    }

    public List<Sample> getSamples(float y, float zoom, ChartProperties cp) {
        List wellSamples;
        float depth = this.block.getDepth(y, null);
        float DEPTH_BRACKET = this.block.getDepth(y + 2.0f / zoom) - depth;
        try {
            wellSamples = this.block.getWell().getSamples();
            if (wellSamples == null || wellSamples.isEmpty()) {
                return null;
            }
            double minSampDepth = this.block.getWell().getDepth((Sample)wellSamples.get(0), cp.correctDepths, cp.correctCuttings);
            double maxSampDepth = this.block.getWell().getDepth((Sample)wellSamples.get(wellSamples.size() - 1), cp.correctDepths, cp.correctCuttings);
            if ((double)depth < minSampDepth - (double)DEPTH_BRACKET || (double)depth > maxSampDepth + (double)DEPTH_BRACKET) {
                return null;
            }
        }
        catch (Exception ex) {
            return null;
        }
        float distance = 1000.0f;
        ArrayList<Sample> samples = null;
        for (Sample s : wellSamples) {
            try {
                double sDepth = this.block.getWell().getDepth(s, cp.correctDepths, cp.correctCuttings);
                if (sDepth >= (double)(depth - DEPTH_BRACKET) && sDepth <= (double)(depth + DEPTH_BRACKET)) {
                    if (samples == null) {
                        samples = new ArrayList<Sample>();
                    }
                    samples.add(s);
                    continue;
                }
                if (!(sDepth > (double)(depth + DEPTH_BRACKET))) continue;
                break;
            }
            catch (Exception e) {
                System.out.println("Exception in getSample loop of PanelWellDepth.getObject: " + e.getMessage());
            }
        }
        return samples;
    }

    private WellEvent getEvent(float x, Sample sample, BlockProperties bp, float zoom) {
        List<WellEvent> events = this.getEvents(x, sample, bp, zoom);
        if (events != null) {
            return events.get(0);
        }
        return null;
    }

    String getUnitName(double age, boolean top) {
        if (this.prop.getScheme() != null) {
            try {
                IGDUnit unit = this.prop.getScheme().findUnit(age, top, true);
                if (unit != null) {
                    return " " + unit.getName();
                }
            }
            catch (SQLException sql) {
                sql.printStackTrace();
                return null;
            }
        }
        return null;
    }

    private List<WellEvent> getEvents(float x, Sample sample, BlockProperties bp, float zoom) {
        if (!this.prop.drawEvents) {
            return null;
        }
        WellInterp wellInterp = this.getWellInterp();
        if (wellInterp == null) {
            return null;
        }
        if (this.getProperties().getCmpStd() == null) {
            return null;
        }
        double zoomBracket = 0.1 / (double)zoom;
        List wellEvents = wellInterp.getEvents();
        LinkedList<WellEvent> returnedEvents = null;
        WellEvent nearest = null;
        float distance = 1000.0f;
        block0: for (WellEvent event : wellEvents) {
            if (event.getSample() != sample) continue;
            for (CompositeStandardEvent csEvent : this.compositeStandardEvents) {
                float evAge = (float)this.getProperties().getCmpStd().getAge(csEvent.getCSU());
                float age = this.getAge(x);
                if ((double)age > (double)evAge - zoomBracket && (double)age < (double)evAge + zoomBracket && csEvent.getEvent() == event.getEvent() && csEvent.getEvType() == event.getCharType() && Math.abs(evAge - age) < distance) {
                    distance = Math.abs(evAge - age);
                    nearest = event;
                    if (returnedEvents == null) {
                        returnedEvents = new LinkedList<WellEvent>();
                    }
                    returnedEvents.add(event);
                }
                if (!((double)evAge - zoomBracket > (double)age)) continue;
                continue block0;
            }
        }
        if (returnedEvents != null && returnedEvents.size() > 1) {
            returnedEvents.remove(nearest);
            returnedEvents.add(0, nearest);
        }
        return returnedEvents;
    }

    private CompositeStandardEvent[] getCmpStdEvent(float x, BlockProperties bp, float zoom) {
        if (this.getProperties().getCmpStd() == null) {
            return null;
        }
        double age = this.getAge(x);
        if (!(age <= this.prop.getCmpStd().getMaxAge()) || !(age >= this.prop.getCmpStd().getMinAge())) {
            return null;
        }
        this.buildEventCache();
        LinkedList<CompositeStandardEvent> events = new LinkedList<CompositeStandardEvent>();
        double zoomBracket = 0.1 / (double)zoom;
        for (CompositeStandardEvent e : this.compositeStandardEvents) {
            double eage = this.cmpStd.getAge(e.getCSU());
            if (age < eage + zoomBracket && age > eage - zoomBracket) {
                events.add(e);
            }
            if (!(eage > age + zoomBracket)) continue;
            break;
        }
        return events.toArray(new CompositeStandardEvent[events.size()]);
    }

    @Override
    public float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode, EnumMap<CorrelationType, HashSet<CorrelationPoint>> cLines) {
        try {
            Color[] colours = null;
            if (this.block instanceof ProjectBlock) {
                colours = this.getColours();
            }
            switch (mode) {
                case NORMAL: 
                case HEADER_ONLY: {
                    float ypos = y + cp.panelCaptionHeight;
                    if (this.block instanceof ProjectBlock || this.prop.drawLOCAlternatives) {
                        ypos += this.drawKey(g, x, ypos, cp, bp, colours);
                    }
                    if (this.sBlock != null) {
                        float sPos = y + this.block.getPanelHeaderHeight(cp, mode) - this.sBlock.getWidth(cp) - this.getEnvHeaderHeight();
                        this.sBlock.drawHorz(g, x, sPos, cp);
                        ypos += this.sBlock.getWidth(cp);
                    }
                    if (this.prop.getEnvScheme() != null && this.block.getWell() != null) {
                        PanelEnv.drawHorz(g, x, ypos, cp, this.sBlockProp != null ? this.sBlockProp : this.block.getProp().getAltProp(BlockProperties.ScaleType.AGE), ((ProjectBlock)this.block).getWells(), this.prop.getEnvScheme(), this.getInterpID(this.block), this.prop.wellSort);
                    }
                }
                case NO_HEADER: {
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            switch (mode) {
                case NORMAL: 
                case NO_HEADER: {
                    if (this.prop.drawLOCAlternatives) {
                        this.drawAltCurves(g, x, y, cp, mode);
                    }
                    if (this.prop.drawLOCs) {
                        this.drawLOC(g, x, y, cp, mode, colours);
                    }
                    if (this.prop.drawSampleAges) {
                        this.drawSampleAges(g, x, y, cp, bp, mode);
                    }
                    if (this.prop.drawEvents) {
                        this.drawEvents(g, x, y, cp, bp, mode, colours);
                    }
                    if (this.getProperties().drawOccs) {
                        this.drawOccurrences(g, x, y, cp, bp, mode);
                    }
                }
                case HEADER_ONLY: {
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
        catch (Exception e) {
            this.handleException(g, x, y, cp, bp, e);
        }
        return x + this.getWidth(bp);
    }

    @Override
    public void drawBackground(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) {
        try {
            switch (mode) {
                case NORMAL: 
                case NO_HEADER: {
                    if (this.prop.drawZones) {
                        this.drawIGD(g, x, y, cp, bp, mode);
                    }
                    if (this.prop.drawSQPicks) {
                        this.drawSQPicks(g, x, y, cp, bp, mode);
                    }
                }
                case HEADER_ONLY: {
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
        catch (Exception e) {
            this.handleException(g, x, y, cp, bp, e);
        }
    }

    @Override
    protected String getCaption() {
        if (this.getPanelOcc() != null && this.getPanelOcc().getCaption() != null) {
            return this.getPanelOcc().getCaption();
        }
        return this.toString();
    }

    @Override
    protected String getSubCaption() {
        if (this.getPanelOcc() != null && this.getPanelOcc().getSubCaption() != null) {
            return this.getPanelOcc().getSubCaption();
        }
        Object subcap = "";
        try {
            this.getDb().getInterp(this.getInterpID(this.block));
        }
        catch (SQLException sql) {
            sql.printStackTrace();
        }
        if (this.prop.getCmpStd() != null) {
            if (!((String)subcap).isEmpty()) {
                subcap = (String)subcap + ", ";
            }
            subcap = (String)subcap + "Composite: " + this.prop.getCmpStd().getName();
        }
        if (this.prop.getScheme() != null) {
            if (!((String)subcap).isEmpty()) {
                subcap = (String)subcap + ", ";
            }
            subcap = (String)subcap + "Scheme: " + this.prop.getScheme().toString();
        }
        if (this.prop.getEnvScheme() != null) {
            Object envString = "";
            if (!((String)subcap).isEmpty()) {
                envString = (String)envString + ", ";
            }
            try {
                envString = (String)envString + "Palaeoenvironments: " + String.valueOf(this.prop.getEnvScheme());
                subcap = (String)subcap + (String)envString;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return subcap;
    }

    private float drawKey(SBGraphics g, float x, float ypos, ChartProperties cp, BlockProperties bp, Color[] wellColours) {
        float fontSize = cp.getFontSize();
        ypos += fontSize;
        String strg = "Showing " + (this.block.getProp().getScaleType() == BlockProperties.ScaleType.SUBSIDENCE ? "subsidence" : "depth/age") + " curves for ";
        LinkedList<Object> strings = new LinkedList<Object>();
        LinkedList<Color> colours = new LinkedList<Color>();
        if (this.block instanceof ProjectBlock) {
            ProjectBlock pb = (ProjectBlock)this.block;
            strg = strg + " wells: ";
            if (pb.getWellList() == null) {
                strings.add("<all with data>");
                colours.add(Color.RED);
            } else {
                Iterator<Well> wellIterator = ((ProjectBlock)this.block).getWells().iterator();
                int i = 0;
                while (wellIterator.hasNext()) {
                    Well well = wellIterator.next();
                    strings.add(well.getWellName());
                    colours.add(wellColours[i]);
                    ++i;
                }
            }
        } else {
            strg = strg + " versions: ";
            if (this.prop.drawLOCAlternatives) {
                if (this.block.getWell() == null) {
                    for (int i = 1; i < LOC_TEMPLATES.length; ++i) {
                        strings.add("alternative " + i);
                        colours.add(ColourUtils.getLighterColour((Color)LOC_COLOURS[i]));
                    }
                } else {
                    Iterator it = this.block.getWell().getInterpIterator();
                    while (it.hasNext()) {
                        WellInterp interp = (WellInterp)it.next();
                        if (interp.getLOC() == null || interp.getHeader().getInterpID() == this.getInterpID(this.block)) continue;
                        strings.add(interp.getHeader().getDescription());
                        colours.add(ColourUtils.getLighterColour((Color)interp.getLOC().getColour()));
                    }
                }
            }
        }
        if (strings.isEmpty()) {
            return 0.0f;
        }
        g.setFontSize(fontSize);
        assert (strings.size() == colours.size());
        for (int i = 0; i < strings.size(); ++i) {
            if (i > 0) {
                strg = strg + ", ";
            }
            strg = strg + (String)strings.get(i);
        }
        AttributedString attString = new AttributedString(strg);
        g.setColor(cp.foreground);
        attString.addAttributes(PanelWellDepthAge.getAttributes(g), 0, attString.getIterator().getEndIndex());
        for (int j = 0; j < strings.size(); ++j) {
            int begin = strg.indexOf((String)strings.get(j));
            int end = begin + ((String)strings.get(j)).length();
            attString.addAttribute(TextAttribute.FOREGROUND, colours.get(j), begin, end);
        }
        g.drawString(attString, x + 1.0f, ypos, this.getWidth(bp), true);
        return fontSize + 2.0f;
    }

    public float getHeaderHeight(ChartProperties cp) {
        return this.getKeyHeight(cp) + this.getSchemeHeaderHeight(cp) + this.getEnvHeaderHeight();
    }

    private float getSchemeHeaderHeight(ChartProperties cp) {
        float height = 0.0f;
        if (this.sBlock != null) {
            height = this.sBlock.getWidth(cp);
        }
        return height;
    }

    private float getEnvHeaderHeight() {
        if (this.block instanceof ProjectBlock && this.prop.getEnvScheme() != null) {
            if (this.block.getWell() == null) {
                return 10.0f;
            }
            float width = 0.0f;
            for (Well well : ((ProjectBlock)this.block).getWells()) {
                try {
                    if (well.getInterp(this.getInterpID(this.block)) == null || well.getInterp(this.getInterpID(this.block)).getLOC() == null || well.getInterp(this.getInterpID(this.block)).getEnvScheme() != this.prop.getEnvScheme()) continue;
                    width += 10.0f;
                }
                catch (SQLException | SBException sbe) {
                    sbe.printStackTrace();
                }
            }
            return width;
        }
        return 0.0f;
    }

    private float getKeyHeight(ChartProperties cp) {
        float keyHeight = 0.0f;
        float fontSize = cp.getFontSize();
        if (this.block instanceof ProjectBlock) {
            keyHeight += fontSize + 2.0f;
        } else if (this.prop.drawLOCAlternatives) {
            if (this.block.getWell() == null) {
                keyHeight += fontSize + 2.0f;
            } else {
                Iterator it = this.block.getWell().getInterpIterator();
                while (it.hasNext()) {
                    WellInterp interp = (WellInterp)it.next();
                    if (interp.getHeader().getInterpID() == this.getInterpID(this.block) || interp.getLOC() == null) continue;
                    keyHeight += fontSize + 2.0f;
                    break;
                }
            }
        }
        return keyHeight;
    }

    private void drawSampleAges(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) throws SQLException, SBException {
        List<Object> samples;
        int interpID;
        if (this.block instanceof ProjectBlock) {
            return;
        }
        if (this.block.getWell() == null) {
            interpID = 0;
            samples = this.block.getTemplateSamples();
            double sampleAge = (double)this.getMinAge() + (double)(this.getMaxAge() - this.getMinAge()) * LOC_TEMPLATE_AGE[0][1];
            ((Sample)samples.get(0)).setAge(interpID, Double.valueOf(sampleAge), null, Float.valueOf(1.6f), Float.valueOf(1.2f), null, 0);
        } else {
            interpID = this.getInterpID(this.block);
            samples = this.block.getWell().getSamples();
        }
        float symbolSize = 2.0f;
        float thickLine = 0.32f;
        float thinLine = 0.05f;
        float endLine = symbolSize * 1.5f;
        Color logSampleColour = DEEP_GREEN;
        Color sampleColour = LIGHT_GREEN;
        for (Sample sample : samples) {
            float barxPos;
            if (!(sample.getDepth() >= (double)this.block.getTopDepth()) || !(sample.getDepth() <= (double)this.block.getBaseDepth()) || !sample.hasAgeData(interpID) || !(sample.getAge(interpID) >= (double)this.getMinAge()) || !(sample.getAge(interpID) <= (double)this.getMaxAge()) || !(sample.getAge(interpID) > 0.0)) continue;
            float yPos = this.block.scaleDepth((float)sample.getDepth()) + y + this.getPanelHeaderHeight(cp, mode);
            float xPos = x + this.getXPos(sample.getAge(interpID).floatValue());
            if (sample.getAgeErrorMinus(interpID) != null && sample.getAgeErrorMinus(interpID).floatValue() != 0.0f) {
                g.setStroke(thickLine);
                g.setColor(sample.getType() == SampleType.LOG ? logSampleColour : sampleColour);
                barxPos = x + this.getXPos(sample.getAge(interpID).floatValue() - sample.getAgeErrorMinus(interpID).floatValue());
                g.drawLine(xPos, yPos, barxPos, yPos);
                g.drawLine(barxPos, yPos + endLine / 2.0f, barxPos, yPos - endLine / 2.0f);
            }
            if (sample.getAgeErrorPlus(interpID) != null && sample.getAgeErrorPlus(interpID).floatValue() != 0.0f) {
                g.setStroke(thickLine);
                g.setColor(sample.getType() == SampleType.LOG ? logSampleColour : sampleColour);
                barxPos = x + this.getXPos(sample.getAge(interpID).floatValue() + sample.getAgeErrorPlus(interpID).floatValue());
                g.drawLine(xPos, yPos, barxPos, yPos);
                g.drawLine(barxPos, yPos + endLine / 2.0f, barxPos, yPos - endLine / 2.0f);
            }
            if (sample.getAgeBelow(interpID) != null && sample.getAgeBelow(interpID) > (double)sample.getAge(interpID).floatValue()) {
                float xPos2 = x + this.getXPos(sample.getAgeBelow(interpID).floatValue());
                g.setStroke(thinLine);
                g.fillEllipse(xPos2 - symbolSize / 2.0f, yPos - symbolSize / 2.0f, symbolSize, symbolSize, sample.getType() == SampleType.LOG ? logSampleColour : sampleColour);
                g.setStroke(thinLine);
                g.setColor(Color.LIGHT_GRAY);
                GeneralPath gp = SBGraphics.createGeneralPath(xPos, yPos);
                g.appendUnconf(gp, xPos, xPos2, yPos, false, false, false, false);
                g.drawShape(gp);
            }
            g.setColor(sample.getType() == SampleType.LOG ? logSampleColour : sampleColour);
            g.setStroke(thinLine);
            g.fillEllipse(xPos - symbolSize / 2.0f, yPos - symbolSize / 2.0f, symbolSize, symbolSize, sample.getType() == SampleType.LOG ? logSampleColour : sampleColour);
        }
    }

    private void drawOccurrences(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) throws SBException, SQLException {
        if (this.block instanceof ProjectBlock || this.prop.getCmpStd() == null) {
            return;
        }
        if (this.compositeStandardEvents == null) {
            return;
        }
        float meanSymbolSize = 0.3f;
        g.setStroke(0.2f);
        HashMap<Integer, Double> specAgeTop = new HashMap<Integer, Double>();
        HashMap<Integer, Double> specAgeBase = new HashMap<Integer, Double>();
        this.buildEventCache();
        for (CompositeStandardEvent event : this.compositeStandardEvents) {
            if (event.getEvent().getSpecID() <= 0) continue;
            switch (event.getType()) {
                case TOP: {
                    specAgeTop.put(event.getEvent().getSpecID(), this.cmpStd.getAge(event.getCSU()));
                    break;
                }
                case BASE: {
                    specAgeBase.put(event.getEvent().getSpecID(), this.cmpStd.getAge(event.getCSU()));
                }
            }
        }
        if (this.block.getWell() != null) {
            for (Discipline disc : Discipline.values()) {
                List analyses = this.block.getWell().getAnalyses(disc, null, 0);
                for (Smpdtl smpdtl : analyses) {
                    float depth = (float)this.block.getWell().getDepth(smpdtl.getSample(), cp.correctDepths, cp.correctCuttings);
                    if (!(depth <= this.block.getBaseDepth()) || !(depth >= this.block.getTopDepth())) continue;
                    float yPos = this.block.scaleDepth(depth) + y + this.getPanelHeaderHeight(cp, mode);
                    for (TaxonOcc fss : smpdtl.getOccurUnsorted()) {
                        float baseAge;
                        float topAge;
                        if (!this.getProperties().includeCvRw && (fss.getCaved() || fss.getReworked() || fss.getContamination())) continue;
                        if (fss.getCaved() || fss.getReworked() || fss.getContamination()) {
                            g.setColor(Color.LIGHT_GRAY);
                        } else {
                            g.setColor(Color.DARK_GRAY);
                        }
                        float symbolSize = 0.3f;
                        if (smpdtl.getHeader().getAbnSchID() > 0) {
                            AbundanceScheme abnScheme = (AbundanceScheme)this.getDb().getAbundanceSchemeService().findAbundanceScheme(smpdtl.getHeader().getAbnSchID()).orElseThrow();
                            int entry = fss.getTotalCount() > 0 ? abnScheme.getIndex(fss.getTotalCount()) : (!fss.isOutsideCount() ? abnScheme.getIndex(fss.getSubAbund()) : 1);
                            symbolSize = 0.3f * (float)(entry + 1) * 2.0f / 3.0f;
                        }
                        if (specAgeTop.get(fss.getSpecID()) != null && (topAge = ((Double)specAgeTop.get(fss.getSpecID())).floatValue()) > 0.0f && topAge >= this.getMinAge() && topAge <= this.getMaxAge()) {
                            if (topAge < this.block.getProp().getAltMin(BlockProperties.ScaleType.AGE)) {
                                topAge = this.block.getProp().getAltMin(BlockProperties.ScaleType.AGE);
                            }
                            float xPosTop = this.getXPos(topAge);
                            g.drawLine((xPosTop += x) - symbolSize, yPos, xPosTop + symbolSize, yPos);
                            g.drawLine(xPosTop, yPos - symbolSize, xPosTop, yPos + symbolSize);
                        }
                        if (specAgeBase.get(fss.getSpecID()) == null || !((baseAge = ((Double)specAgeBase.get(fss.getSpecID())).floatValue()) > 0.0f) || !(baseAge >= this.getMinAge()) || !(baseAge <= this.getMaxAge())) continue;
                        if (baseAge > this.block.getProp().getAltMax(BlockProperties.ScaleType.AGE)) {
                            baseAge = this.block.getProp().getAltMax(BlockProperties.ScaleType.AGE);
                        }
                        float xPosBase = this.getXPos(baseAge);
                        this.drawOccSymbol(g, false, symbolSize, xPosBase += x, yPos);
                    }
                }
            }
        } else {
            float top = this.block.getTopDepth();
            float[][] depthMultipliers = new float[][]{{0.1f, 0.25f, 0.5f, 0.7f}, {0.25f, 0.51f, 0.67f, 0.85f}, {0.12f, 0.23f, 0.6f}};
            int m = 0;
            int nEvents = EV_TOP_AGES.length + EV_BASE_AGES.length;
            for (int i = 0; i < nEvents; ++i) {
                boolean topEvent = i < EV_TOP_AGES.length;
                float evDepth = top + (this.block.getBaseDepth() - top) * (topEvent ? EV_TOP_DEPTHS[i] : EV_BASE_DEPTHS[i - EV_TOP_DEPTHS.length]);
                if (m > depthMultipliers.length - 1) {
                    m = 0;
                }
                float xPos = x + this.getXPos(this.getMinAge() + (this.getMaxAge() - this.getMinAge()) * (topEvent ? EV_TOP_AGES[i] : EV_BASE_AGES[i - EV_TOP_AGES.length]));
                float range = (evDepth - top) * 0.3f;
                for (int j = 0; j < depthMultipliers[m].length; ++j) {
                    if ((m == 1 || m == 3) && (topEvent ? j == 0 : j == depthMultipliers[m].length - 1)) {
                        if (!this.prop.includeCvRw) continue;
                        g.setColor(Color.LIGHT_GRAY);
                    } else {
                        g.setColor(Color.DARK_GRAY);
                    }
                    float multiplier = range * depthMultipliers[m][j];
                    float depth = top + evDepth + (topEvent ? multiplier : -multiplier);
                    if (depth > this.block.getBaseDepth() || depth < this.block.getTopDepth()) continue;
                    this.drawOccSymbol(g, topEvent, 0.3f, xPos, this.block.scaleDepth(depth) + y + this.getPanelHeaderHeight(cp, mode));
                }
                ++m;
            }
        }
    }

    private void drawOccSymbol(SBGraphics g, boolean topEvent, float symbolSize, float xPos, float yPos) {
        if (topEvent) {
            g.drawLine(xPos - symbolSize, yPos, xPos + symbolSize, yPos);
            g.drawLine(xPos, yPos - symbolSize, xPos, yPos + symbolSize);
        } else {
            g.drawEllipse(xPos - 0.5f * symbolSize, yPos - 0.5f * symbolSize, symbolSize, symbolSize);
        }
    }

    private void drawAltCurves(SBGraphics g, float x, float y, ChartProperties cp, Chart.Mode mode) throws SQLException {
        block5: {
            block4: {
                if (this.block.getWell() == null) break block4;
                if (this.getWellInterp() == null) break block5;
                Iterator it = this.block.getWell().getInterpIterator();
                while (it.hasNext()) {
                    WellInterp interp = (WellInterp)it.next();
                    try {
                        if (interp.getHeader().getInterpID() == this.getInterpID(this.block)) continue;
                        interp.loadLOC(this.block.getWellID());
                        if (interp.getLOC() == null) continue;
                        Color c = interp.getLOC().getColour();
                        c = ColourUtils.getLighterColour((Color)c);
                        this.drawCurve(g, x, y, cp, mode, this.block.getWell(), interp.getLOC(), true, c);
                    }
                    catch (SBException e) {
                        LOGGER.log(Level.WARNING, "SBException from loading alt LOC", e);
                    }
                }
                break block5;
            }
            for (int i = 1; i < LOC_TEMPLATES.length; ++i) {
                Color c = LOC_COLOURS[i];
                c = ColourUtils.getLighterColour((Color)c);
                this.drawCurve(g, x, y, cp, mode, this.block.getWell(), this.getTemplateLOC(cp, i), true, c);
            }
        }
    }

    private void drawLOC(SBGraphics g, float x, float y, ChartProperties cp, Chart.Mode mode, Color[] colours) throws SQLException, SBException {
        if (this.block instanceof ProjectBlock) {
            ProjectBlock pBlock = (ProjectBlock)this.block;
            if (pBlock.getWellList() == null) {
                for (int i = 0; i < LOC_TEMPLATES.length; ++i) {
                    this.drawCurve(g, x, y, cp, mode, null, this.getTemplateLOC(cp, i), false, colours[i]);
                }
            } else {
                Iterator<Well> wellIterator = pBlock.getWells().iterator();
                int i = 0;
                while (wellIterator.hasNext()) {
                    WellInterp interp;
                    Well well = wellIterator.next();
                    if (well.hasInterpLoaded(this.getInterpID(this.block)) && (interp = well.getInterp(this.getInterpID(this.block))).getLOC() != null) {
                        this.drawCurve(g, x, y, cp, mode, well, interp.getLOC(), false, colours[i]);
                    }
                    ++i;
                }
            }
        } else if (this.block.getWell() == null) {
            this.drawCurve(g, x, y, cp, mode, null, this.getTemplateLOC(cp, 0), false, cp.foreground);
        } else if (this.getWellInterp() != null && this.getWellInterp().getLOC() != null) {
            this.drawCurve(g, x, y, cp, mode, this.block.getWell(), this.getWellInterp().getLOC(), false, this.getWellInterp().getLOC().getColour());
        }
    }

    private void drawCurve(SBGraphics g, float x, float y, ChartProperties cp, Chart.Mode mode, Well well, LOC locLine, boolean basic, Color colour) throws SQLException {
        if (locLine == null) {
            return;
        }
        float symbolSize = basic ? 0.5f : 0.75f;
        g.setColor(colour);
        g.setFontSize(cp.getFontSize());
        GeneralPath gp = null;
        LinkedList<Point2D.Float> nodePoints = new LinkedList<Point2D.Float>();
        Iterator it = locLine.getNodeIterator();
        Rectangle2D.Float boundary = new Rectangle2D.Float(this.getMinAge(), this.block.getTopDepth(), this.getMaxAge() - this.getMinAge(), this.block.getBaseDepth() - this.block.getTopDepth());
        if (this.block.getProp().getScaleType() == BlockProperties.ScaleType.SUBSIDENCE) {
            boundary = new Rectangle2D.Float(this.getMinAge(), 0.0f, this.getMaxAge() - this.getMinAge(), this.block.getBaseDepth() - this.block.getTopDepth());
        }
        float subsidenceShift = 0.0f;
        if (locLine != null && this.block.getProp().getScaleType() == BlockProperties.ScaleType.SUBSIDENCE) {
            subsidenceShift = this.calcSubsidenceTVDShift(well, locLine);
        }
        float lastDepth = 0.0f;
        float lastAge = 0.0f;
        int bnd = 0;
        LOCNode lastNode = null;
        while (it.hasNext()) {
            LOCNode loc = (LOCNode)it.next();
            double d = loc.getDepth();
            switch (this.block.getProp().getScaleType()) {
                case TVD: 
                case SUBSIDENCE: {
                    d = this.convertDepthToTVDForSubsidence((float)d, well) + subsidenceShift;
                    break;
                }
            }
            if (lastNode != null) {
                if (this.block.getProp().getScaleType() == BlockProperties.ScaleType.AGE && Float.compare((float)d, lastDepth) == 0) {
                    bnd = loc.getBnd();
                    continue;
                }
                Line2D.Float line = new Line2D.Float(lastAge, lastDepth, (float)loc.getAge(), (float)d);
                if (boundary.intersectsLine(line) && g.clipLine(line, boundary.x, boundary.y, boundary.x + boundary.width, boundary.y + boundary.height)) {
                    float y2;
                    float y1;
                    float x1 = this.getXPos(line.x1) + x;
                    float x2 = this.getXPos(line.x2) + x;
                    if (this.block.getProp().getScaleType() == BlockProperties.ScaleType.SUBSIDENCE || this.block.getProp().getScaleType() == BlockProperties.ScaleType.TVD) {
                        y1 = this.block.getProp().scaleDepth(line.y1) + y + this.getPanelHeaderHeight(cp, mode);
                        y2 = this.block.getProp().scaleDepth(line.y2) + y + this.getPanelHeaderHeight(cp, mode);
                    } else {
                        y1 = this.block.scaleDepth(line.y1, well) + y + this.getPanelHeaderHeight(cp, mode);
                        y2 = this.block.scaleDepth(line.y2, well) + y + this.getPanelHeaderHeight(cp, mode);
                    }
                    if (gp == null) {
                        gp = SBGraphics.createGeneralPath(x1, y1);
                    }
                    if (bnd == 1) {
                        g.setDotStroke(locLine.getLineWidth());
                    } else if (bnd == 2) {
                        g.setDashStroke(locLine.getLineWidth());
                    }
                    Shape s = g.appendBnd(gp, bnd, x1, x2, y1, y2);
                    if (bnd == 5) {
                        Font f = g.getFont();
                        g.setFontStyle(1);
                        g.setFontSize(cp.getFontSizeHeader());
                        g.drawString("?", (x1 + x2) / 2.0f, y1 - symbolSize * 2.0f);
                        g.setFont(f);
                    } else if (s != null) {
                        g.fillShape(s, g.getColor());
                    }
                    if (!(this.block instanceof ProjectBlock)) {
                        if (lastAge >= this.getMinAge() && lastDepth >= this.block.getTopDepth()) {
                            nodePoints.add(new Point2D.Float(x1, y1));
                        }
                        if ((float)loc.getAge() <= this.getMaxAge() && (float)loc.getDepth() <= this.block.getBaseDepth()) {
                            nodePoints.add(new Point2D.Float(x2, y2));
                        }
                        if (!basic && this.prop.drawRates) {
                            String string = locLine.getRateString(lastNode, this.block.getProp().getUnits(), cp.ageFormat, well);
                            g.drawString(string, new Point2D.Float(x1, y1), new Point2D.Float(x2, y2));
                        }
                    }
                }
            }
            lastNode = loc;
            lastDepth = (float)d;
            lastAge = (float)loc.getAge();
            bnd = loc.getBnd();
        }
        if (gp != null) {
            g.setStroke(basic ? locLine.getLineWidth() / 2.0f : locLine.getLineWidth());
            g.drawShape(gp);
        }
        if (!nodePoints.isEmpty()) {
            for (Point2D point2D : nodePoints) {
                g.fillEllipse((float)point2D.getX() - symbolSize / 2.0f, (float)point2D.getY() - symbolSize / 2.0f, symbolSize, symbolSize, locLine.getColour());
            }
        }
    }

    private float convertDepthToTVDForSubsidence(float depthMD, Well well) {
        Double tvDepth;
        TVDList tvdList = null;
        float depth = depthMD;
        try {
            if (well != null) {
                tvdList = well.getTVDlist(false);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(PanelWellDepthAge.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (tvdList != null && (tvDepth = tvdList.getTVDwithExtrapolation((double)depthMD).getTVDepth()) != null) {
            depth = tvDepth.floatValue();
        }
        return depth;
    }

    private float calcSubsidenceTVDShift(Well well, LOC locLine) {
        float maxLOCDepth = (float)locLine.getMaxDepth();
        maxLOCDepth = this.convertDepthToTVDForSubsidence(maxLOCDepth, well);
        float shift = 0.0f;
        if (this.block.getProp().getMax() > maxLOCDepth) {
            shift = this.block.getProp().getMax() - maxLOCDepth;
        }
        return shift;
    }

    private LOC getTemplateLOC(ChartProperties cp, int n) {
        if (LOC_TEMPLATES[n] == null) {
            LOC loc = new LOC(null, 0, 0, 0, cp.foreground, 1.0f);
            float topDepth = this.block.getTopDepth();
            float baseDepth = this.block.getBaseDepth();
            float depthRange = baseDepth - topDepth;
            float minAge = this.getMinAge();
            float maxAge = this.getMaxAge();
            float ageRange = maxAge - minAge;
            if (depthRange < 1.0f || ageRange < 1.0f) {
                return loc;
            }
            try {
                loc.addNode((double)topDepth + (double)depthRange * LOC_TEMPLATE_DEPTH[n][0], (double)minAge + (double)ageRange * LOC_TEMPLATE_AGE[n][0], 3);
                loc.addNode((double)topDepth + (double)depthRange * LOC_TEMPLATE_DEPTH[n][1], (double)minAge + (double)ageRange * LOC_TEMPLATE_AGE[n][1], 3);
                loc.addNode((double)topDepth + (double)depthRange * LOC_TEMPLATE_DEPTH[n][2], (double)minAge + (double)ageRange * LOC_TEMPLATE_AGE[n][2], 4);
                loc.addNode((double)topDepth + (double)depthRange * LOC_TEMPLATE_DEPTH[n][3], (double)minAge + (double)ageRange * LOC_TEMPLATE_AGE[n][3], 3);
                loc.addNode((double)topDepth + (double)depthRange * LOC_TEMPLATE_DEPTH[n][4], (double)minAge + (double)ageRange * LOC_TEMPLATE_AGE[n][4], 3);
            }
            catch (DuplicateNodeException e) {
                e.printStackTrace();
            }
            PanelWellDepthAge.LOC_TEMPLATES[n] = loc;
        }
        return LOC_TEMPLATES[n];
    }

    void drawEvents(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode, Color[] colours) throws SQLException, SBException {
        if (this.block instanceof ProjectBlock) {
            if (((ProjectBlock)this.block).getWellList() == null) {
                this.drawEvents(g, x, y, cp, bp, mode, null, true, colours[0]);
                return;
            }
            this.prop.useCatColours = false;
            Iterator<Well> wellIterator = ((ProjectBlock)this.block).getWells().iterator();
            int i = -1;
            while (wellIterator.hasNext()) {
                Well well = wellIterator.next();
                if (!well.hasInterpLoaded(this.getInterpID(this.block))) continue;
                this.drawEvents(g, x, y, cp, bp, mode, well, true, colours[++i]);
            }
        } else {
            this.drawEvents(g, x, y, cp, bp, mode, this.block.getWell(), false, null);
        }
    }

    CmpStdEvAge getCachedCmpStdEventAge(int evID, EventType eventType) {
        for (CompositeStandardEvent cmpStdEvt : this.compositeStandardEvents) {
            if (cmpStdEvt.getEvID() != evID || cmpStdEvt.getType() != eventType) continue;
            return new CmpStdEvAge(this, cmpStdEvt, this.cmpStd.getAge(cmpStdEvt.getCSU()));
        }
        return null;
    }

    void drawEvents(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode, Well well, boolean basic, Color colour) throws SQLException, SBException {
        if (this.getProperties().getCmpStd() == null) {
            return;
        }
        this.getProperties().getCmpStd().loadEvents();
        float yTop = y + this.getPanelHeaderHeight(cp, mode);
        g.setStroke(0.25f);
        g.setFontSize(cp.getFontSizeSmall());
        LinkedList<EventLabel> eventLabels = new LinkedList<EventLabel>();
        if (well != null) {
            WellInterp interp = well.getInterp(this.getInterpID(this.block));
            well.loadInterp(interp);
            List events = interp.getEvents();
            for (WellEvent event : events) {
                Color c;
                Color evColour;
                if (!this.plotEvent(event)) continue;
                double depth = well.getDepth(event.getSample(), cp.correctDepths, cp.correctCuttings);
                int evID = event.getEvent().getEvID();
                CmpStdEvAge cmpStdEvt = this.getCachedCmpStdEventAge(evID, event.getTypeObj());
                if (cmpStdEvt == null || !(cmpStdEvt.age >= this.getMinAge()) || !(cmpStdEvt.age <= this.getMaxAge())) continue;
                float xPos = x + this.getXPos(cmpStdEvt.age);
                float yPos = this.block.scaleDepth((float)depth, well) + y + this.getPanelHeaderHeight(cp, mode);
                if (this.block.getProp().getScaleType() != BlockProperties.ScaleType.SUBSIDENCE ? depth - (double)0.0029f > (double)this.block.getBaseDepth() || depth + (double)0.0029f < (double)this.block.getTopDepth() : yPos < y + this.getPanelHeaderHeight(cp, mode) || y > y + this.block.getHeight()) continue;
                Color color = evColour = colour != null ? colour : cp.foreground;
                if (!(this.block instanceof ProjectBlock) && this.prop.useCatColours && event.getEvent().getTaxon() != null && (c = ((Category)this.getDb().getCategoryService().findCategory(event.getEvent().getTaxon().getCatMnem()).get()).getColour()) != null) {
                    evColour = c;
                }
                Confidence ageConfidence = null;
                if (this.prop.useEvConf) {
                    evColour = this.getConfidenceColor(event.getConfidence(), evColour);
                    ageConfidence = cmpStdEvt.cmpStdEvt.getConfidence();
                }
                Sample prevSample = null;
                Sample nextSample = null;
                if (!basic && this.prop.drawDepthErrorBars) {
                    int index = this.block.getWell().getSamples().indexOf(event.getSample()) - 1;
                    while (index >= 0) {
                        prevSample = (Sample)this.block.getWell().getSamples().get(index);
                        if (prevSample.getType() != SampleType.LOG) {
                            if (event.getDiscipline() == null || prevSample.hasDisciplineData(event.getDiscipline().getChar())) break;
                            --index;
                            continue;
                        }
                        --index;
                    }
                    index = this.block.getWell().getSamples().indexOf(event.getSample()) + 1;
                    while (index >= 0 && index < this.block.getWell().getSamples().size()) {
                        nextSample = (Sample)this.block.getWell().getSamples().get(index);
                        if (nextSample.getType() != SampleType.LOG) {
                            if (event.getDiscipline() == null || nextSample.hasDisciplineData(event.getDiscipline().getChar())) break;
                            ++index;
                            continue;
                        }
                        ++index;
                    }
                }
                Object label = "";
                if (this.prop.drawEventAbbreviations && event.getEvent().getAbr() != null) {
                    label = (String)label + event.getEvent().getAbr();
                }
                if (this.prop.drawEventQualifiers) {
                    if (!((String)label).isEmpty()) {
                        label = (String)label + " ";
                    }
                    label = (String)label + event.getQualifier();
                }
                if (this.prop.drawEventComments) {
                    if (!((String)label).isEmpty()) {
                        label = (String)label + " ";
                    }
                    label = (String)label + event.getComments();
                }
                if (((String)label).length() > 50) {
                    label = ((String)label).substring(0, 50) + "...";
                }
                this.drawEvent(g, well, cp, event, event.getTypeObj(), cmpStdEvt.cmpStdEvt, x, xPos, yTop, yPos, evColour, bp, !basic && this.prop.drawEventLines, prevSample, nextSample, (String)label, ageConfidence, eventLabels);
            }
        } else {
            int i;
            float ageRange = this.getMaxAge() - this.getMinAge();
            float depthRange = this.block.getBaseDepth() - this.block.getTopDepth();
            if (colour == null) {
                colour = cp.foreground;
            }
            for (i = 0; i < EV_TOP_AGES.length; ++i) {
                this.drawEvent(g, null, cp, null, EventType.TOP, null, x, x + this.getXPos(this.getMinAge() + ageRange * EV_TOP_AGES[i]), yTop, yTop + this.block.scaleDepth(this.block.getTopDepth() + depthRange * EV_TOP_DEPTHS[i]), this.prop.useCatColours ? Color.RED : colour, bp, !basic && this.prop.drawEventLines, null, null, this.prop.drawEventQualifiers && i == 1 ? "qualifier" : null, null, eventLabels);
            }
            for (i = 0; i < EV_BASE_AGES.length; ++i) {
                this.drawEvent(g, null, cp, null, EventType.BASE, null, x, x + this.getXPos(this.getMinAge() + ageRange * EV_BASE_AGES[i]), yTop, yTop + this.block.scaleDepth(this.block.getTopDepth() + depthRange * EV_BASE_DEPTHS[i]), this.prop.useCatColours ? Color.RED : colour, bp, !basic && this.prop.drawEventLines, null, null, this.prop.drawEventQualifiers && i == 3 ? "qualifier" : null, null, eventLabels);
            }
        }
        if (!eventLabels.isEmpty()) {
            this.drawEventLabels(g, eventLabels, cp);
        }
    }

    public boolean plotEvent(WellEvent e) throws SQLException {
        if (this.prop.getCmpStd() == null) {
            return false;
        }
        if (this.sBlock != null) {
            for (SBPanel p : this.sBlock.getPanels()) {
                PanelCompositeStandard pcs;
                if (!(p instanceof PanelCompositeStandard) || (pcs = (PanelCompositeStandard)p).getCmpStd() != this.prop.getCmpStd()) continue;
                if (!pcs.getProperties().plotEventDisc(e.getDiscIDTaxon())) {
                    return false;
                }
                if (!pcs.getProperties().plotEventCategory(e.getEvent().getCatMnem())) {
                    return false;
                }
                return pcs.getProperties().plotEventType(e.getCharType());
            }
        }
        return true;
    }

    private void drawEvent(SBGraphics g, Well well, ChartProperties cp, WellEvent wellEvent, EventType type, CompositeStandardEvent cmpStdEvt, float x, float xPos, float yTop, float yPos, Color evColour, BlockProperties bp, boolean eventLines, Sample prevSample, Sample nextSample, String qualifier, Confidence ageConf, List<EventLabel> labels) throws SQLException {
        boolean overPlot;
        if (eventLines) {
            g.setColor(Color.LIGHT_GRAY);
            g.setStroke(0.05f);
            g.drawLine(xPos, yPos, xPos, yTop);
            if (this.block.getProp().getAltAgeLeftToRight(BlockProperties.ScaleType.AGE)) {
                g.drawLine(xPos, yPos, x, yPos);
            } else {
                g.drawLine(xPos, yPos, x + this.getWidth(bp), yPos);
            }
        }
        float symbolSize = this.prop.symbolSize;
        g.setColor(evColour);
        if (ageConf != null) {
            g.setStroke(this.getConfidenceStroke(ageConf, 0.4f));
        } else {
            g.setStroke(0.4f);
        }
        double errorTop = -1.0;
        double errorBase = -1.0;
        switch (type) {
            case TOP: {
                g.drawLine(xPos, yPos - symbolSize, xPos, yPos + symbolSize);
                g.drawLine(xPos - symbolSize, yPos, xPos + symbolSize, yPos);
                if (wellEvent == null || !this.prop.drawDepthErrorBars) break;
                if (wellEvent.getErrMinus() != null) {
                    errorTop = well.getDepth(wellEvent.getSample(), cp.correctDepths, cp.correctCuttings) - wellEvent.getErrMinus();
                }
                if (wellEvent.getErrPlus() == null) break;
                errorBase = well.getDepth(wellEvent.getSample(), cp.correctDepths, cp.correctCuttings) + wellEvent.getErrPlus();
                break;
            }
            case BASE: {
                g.drawEllipse(xPos - symbolSize / 2.0f, yPos - symbolSize / 2.0f, symbolSize, symbolSize);
                if (wellEvent == null || !this.prop.drawDepthErrorBars) break;
                if (wellEvent.getErrMinus() != null) {
                    errorTop = well.getDepth(wellEvent.getSample(), cp.correctDepths, cp.correctCuttings) - wellEvent.getErrMinus();
                }
                if (wellEvent.getErrPlus() == null) break;
                errorBase = well.getDepth(wellEvent.getSample(), cp.correctDepths, cp.correctCuttings) + wellEvent.getErrPlus();
                break;
            }
            case SINGLE: {
                g.drawLine(xPos - symbolSize, yPos - symbolSize, xPos + symbolSize, yPos + symbolSize);
                g.drawEllipse(xPos - symbolSize / 2.0f, yPos - symbolSize / 2.0f, symbolSize, symbolSize);
                if (wellEvent == null) break;
                if (wellEvent.getErrMinus() != null) {
                    errorTop = well.getDepth(wellEvent.getSample(), cp.correctDepths, cp.correctCuttings) - wellEvent.getErrMinus();
                }
                if (wellEvent.getErrPlus() == null) break;
                errorBase = well.getDepth(wellEvent.getSample(), cp.correctDepths, cp.correctCuttings) + wellEvent.getErrPlus();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (errorTop > 0.0) {
            overPlot = false;
            if (errorTop < (double)this.block.getTopDepth()) {
                overPlot = true;
            }
            float prevYPos = this.block.scaleDepth(overPlot ? this.block.getTopDepth() : (float)errorTop) + yTop;
            g.setStroke(0.25f);
            g.drawLine(xPos, prevYPos, xPos, yPos);
            if (!overPlot) {
                g.drawLine(xPos - symbolSize / 2.0f, prevYPos, xPos + symbolSize / 2.0f, prevYPos);
            }
        }
        if (errorBase > 0.0) {
            overPlot = false;
            if (errorBase > (double)this.block.getBaseDepth()) {
                overPlot = true;
            }
            float nextYPos = this.block.scaleDepth(overPlot ? this.block.getBaseDepth() : (float)errorBase) + yTop;
            g.setStroke(0.25f);
            g.drawLine(xPos, nextYPos, xPos, yPos);
            if (!overPlot) {
                g.drawLine(xPos - symbolSize / 2.0f, nextYPos, xPos + symbolSize / 2.0f, nextYPos);
            }
        }
        if (this.prop.drawAgeErrorBars) {
            g.setStroke(0.25f);
            Float[] errXpos = new Float[2];
            if (cmpStdEvt != null) {
                if (cmpStdEvt.getErrMinus() != null) {
                    errXpos[0] = Float.valueOf(x + this.getXPos((float)(cmpStdEvt.getCSU() - cmpStdEvt.getErrMinus())));
                }
                if (cmpStdEvt.getErrPlus() != null) {
                    errXpos[1] = Float.valueOf(x + this.getXPos((float)(cmpStdEvt.getCSU() + cmpStdEvt.getErrPlus())));
                }
            } else if (wellEvent == null) {
                errXpos[0] = Float.valueOf(xPos - 2.5f);
                errXpos[1] = Float.valueOf(xPos + 4.0f);
            }
            for (Float f : errXpos) {
                if (f == null) continue;
                float xErr = f.floatValue();
                boolean overPlot2 = false;
                if (xErr < x) {
                    overPlot2 = true;
                    xErr = x;
                } else if (xErr > x + this.getWidth(bp)) {
                    overPlot2 = true;
                    xErr = x + this.getWidth(bp);
                }
                g.drawLine(xErr, yPos, xPos, yPos);
                if (overPlot2) continue;
                g.drawLine(xErr, yPos - symbolSize / 2.0f, xErr, yPos + symbolSize / 2.0f);
            }
        }
        if (qualifier != null && !qualifier.isEmpty()) {
            labels.add(new EventLabel(qualifier, evColour, xPos + symbolSize, yPos));
        }
    }

    private void drawEventLabels(SBGraphics g, List<EventLabel> labels, ChartProperties cp) {
        float offset = g.stringHeightSB() / 2.0f;
        LinkedList columns = new LinkedList();
        for (EventLabel eventLabel : labels) {
            eventLabel.stringWidth = Float.valueOf(g.stringWidth(eventLabel.label));
            List addedToColumn = null;
            ListIterator columnIterator = columns.listIterator();
            block1: while (columnIterator.hasNext()) {
                List column = (List)columnIterator.next();
                for (EventLabel comp : column) {
                    if (!(eventLabel.xpos >= comp.xpos && eventLabel.xpos <= comp.xpos + comp.stringWidth.floatValue()) && (!(eventLabel.xpos + eventLabel.stringWidth.floatValue() >= comp.xpos) || !(eventLabel.xpos + eventLabel.stringWidth.floatValue() <= comp.xpos + comp.stringWidth.floatValue()))) continue;
                    if (addedToColumn == null) {
                        column.add(eventLabel);
                        addedToColumn = column;
                        continue block1;
                    }
                    addedToColumn.addAll(column);
                    columnIterator.remove();
                    continue block1;
                }
            }
            if (addedToColumn != null) continue;
            LinkedList<EventLabel> newColumn = new LinkedList<EventLabel>();
            newColumn.add(eventLabel);
            columns.add(newColumn);
        }
        for (List list : columns) {
            int i;
            Collections.sort(list, new Comparator<EventLabel>(this){
                {
                    Objects.requireNonNull(this$0);
                }

                @Override
                public int compare(EventLabel o1, EventLabel o2) {
                    if (o1.ypos < o2.ypos) {
                        return -1;
                    }
                    if (o1.ypos > o2.ypos) {
                        return 1;
                    }
                    return 0;
                }
            });
            float[] newPositions = new float[list.size()];
            for (i = 0; i < newPositions.length; ++i) {
                newPositions[i] = ((EventLabel)list.get((int)i)).ypos;
            }
            if (list.size() > 1) {
                PanelSamples.moveSamplePositions(list.size(), newPositions, cp.getFontSizeSmall(), ((EventLabel)list.get((int)0)).ypos, ((EventLabel)list.get((int)(list.size() - 1))).ypos);
            } else {
                newPositions[0] = ((EventLabel)list.get((int)0)).ypos;
            }
            for (i = 0; i < list.size(); ++i) {
                EventLabel label = (EventLabel)list.get(i);
                g.setColor(label.colour);
                g.drawString(label.label, label.xpos, newPositions[i] + offset);
            }
        }
    }

    private void drawIGD(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) throws SQLException, SBException {
        block23: {
            block22: {
                if (this.prop.getScheme() == null) {
                    return;
                }
                if (!(this.block instanceof ProjectBlock)) break block22;
                if (!this.prop.drawShading) break block23;
                this.prop.getScheme().loadUnits();
                for (IGDScheme.ShadeInterval shadeInterval : this.prop.getScheme().getShadingIntervals(this.getMinAge(), this.getMaxAge())) {
                    float ux = PanelWellDepthAge.getXPos(shadeInterval.getUage(), this.block.getProp().getAltProp());
                    float lx = PanelWellDepthAge.getXPos(shadeInterval.getLage(), this.block.getProp().getAltProp());
                    float x1 = Math.min(ux, lx);
                    float x2 = Math.max(ux, lx);
                    g.setColor(shadeInterval.getColour());
                    Color colour = ColourUtils.getLighterColour((Color)shadeInterval.getColour());
                    g.fillRect(x1 + x, y + this.getPanelHeaderHeight(cp, mode), x2 - x1, bp.getHeight(), colour);
                }
                break block23;
            }
            if (this.prop.drawZones) {
                float panelRight = this.getXPos(this.block.getProp().getAltAgeLeftToRight(BlockProperties.ScaleType.AGE) ? this.getMaxAge() : this.getMinAge());
                g.setStroke(0.2f);
                LinkedList<Color> colours = new LinkedList<Color>();
                LinkedList<Rectangle2D.Float> rects = new LinkedList<Rectangle2D.Float>();
                LinkedList<Object> names = new LinkedList<Object>();
                if (this.block.getWell() != null) {
                    if (this.getWellInterp() == null) {
                        return;
                    }
                    if (this.prop.getScheme().getIGDType() == 10) {
                        return;
                    }
                    List zones = this.getWellInterp().getIGDList(this.prop.getScheme().getIGDType(), this.getProperties().getScheme().getID(), 1, IGDIntervalZone.getNHier((int)this.prop.getScheme().getIGDType(), (boolean)true));
                    for (IGDIntervalZone zone : zones) {
                        Color lighter;
                        if (zone.getSchID() != this.prop.getScheme().getID()) continue;
                        double topDepth = this.block.getWell().getDepth(zone.getTopSample(), cp.correctDepths, cp.correctCuttings);
                        double baseDepth = this.block.getWell().getDepth(zone.getBaseSample(), cp.correctDepths, cp.correctCuttings);
                        if (baseDepth < (double)this.block.getTopDepth() || topDepth > (double)this.block.getBaseDepth()) continue;
                        if ((double)this.block.getTopDepth() > topDepth) {
                            topDepth = this.block.getTopDepth();
                        }
                        if (baseDepth > (double)this.block.getBaseDepth()) {
                            baseDepth = this.block.getBaseDepth();
                        }
                        float ytop = y + this.getPanelHeaderHeight(cp, mode) + this.block.scaleDepth((float)topDepth);
                        float ybase = y + this.getPanelHeaderHeight(cp, mode) + this.block.scaleDepth((float)baseDepth);
                        IGDUnitBase unit = this.prop.getScheme().findUnitBase(zone.getUppZone());
                        if (unit != null && unit.hasAges()) {
                            xleft = this.getXPos((float)(this.block.getProp().getAltAgeLeftToRight(BlockProperties.ScaleType.AGE) ? unit.getUage().doubleValue() : unit.getLage().doubleValue()));
                            xright = this.getXPos((float)(this.block.getProp().getAltAgeLeftToRight(BlockProperties.ScaleType.AGE) ? unit.getLage().doubleValue() : unit.getUage().doubleValue()));
                            if (!(xright < 0.0f) && !(xleft > panelRight)) {
                                xright = Math.min(xright, panelRight) + x;
                                xleft = Math.max(xleft, 0.0f) + x;
                                names.add((zone.isQUzone() ? "?" : "") + (zone.getUppInf().isEmpty() ? unit.getName() : zone.getUppInf()));
                                rects.add(new Rectangle2D.Float(xleft, ytop, xright - xleft, ybase - ytop));
                                colours.add(unit.getColour().equals(Color.WHITE) ? Color.lightGray : unit.getColour());
                                if (this.prop.drawShading) {
                                    g.setColor(unit.getColour());
                                    lighter = ColourUtils.getLighterColour((Color)unit.getColour());
                                    g.fillRect(xleft, y + this.getPanelHeaderHeight(cp, mode), xright - xleft, ytop - y - this.getPanelHeaderHeight(cp, mode), lighter);
                                    if (this.block.getProp().getAltAgeLeftToRight(BlockProperties.ScaleType.AGE)) {
                                        g.fillRect(x, ytop, xleft - x, ybase - ytop, lighter);
                                    } else {
                                        g.fillRect(xright, ytop, x + panelRight - xright, ybase - ytop, lighter);
                                    }
                                }
                            }
                        }
                        if (zone.getLowZone() <= 0 || (unit = this.prop.getScheme().findUnitBase(zone.getLowZone())) == null || !unit.hasAges()) continue;
                        xleft = this.getXPos((float)(this.block.getProp().getAltAgeLeftToRight(BlockProperties.ScaleType.AGE) ? unit.getUage().doubleValue() : unit.getLage().doubleValue()));
                        xright = this.getXPos((float)(this.block.getProp().getAltAgeLeftToRight(BlockProperties.ScaleType.AGE) ? unit.getLage().doubleValue() : unit.getUage().doubleValue()));
                        if (xright < 0.0f || xleft > panelRight) continue;
                        xright = Math.min(xright, panelRight) + x;
                        xleft = Math.max(xleft, 0.0f) + x;
                        colours.add(unit.getColour().equals(Color.WHITE) ? Color.lightGray : unit.getColour());
                        rects.add(new Rectangle2D.Float(xleft, ytop, xright - xleft, ybase - ytop));
                        names.add((zone.isQLzone() ? "?" : "") + (zone.getLowInf().isEmpty() ? unit.getName() : zone.getLowInf()));
                        if (!this.prop.drawShading) continue;
                        g.setColor(unit.getColour());
                        lighter = ColourUtils.getLighterColour((Color)unit.getColour());
                        g.fillRect(xleft, y + this.getPanelHeaderHeight(cp, mode), xright - xleft, ytop - y - this.getPanelHeaderHeight(cp, mode), lighter);
                        if (this.block.getProp().getAltAgeLeftToRight(BlockProperties.ScaleType.AGE)) {
                            g.fillRect(x, ytop, xleft - x, ybase - ytop, lighter);
                            continue;
                        }
                        g.fillRect(xright, ytop, x + panelRight - xright, ybase - ytop, lighter);
                    }
                } else {
                    double topDepth = this.block.getTemplateSamples().get(2).getDepth();
                    double baseDepth = this.block.getTemplateSamples().get(3).getDepth();
                    float ytop = y + this.getPanelHeaderHeight(cp, mode) + this.block.scaleDepth((float)topDepth);
                    float ybase = y + this.getPanelHeaderHeight(cp, mode) + this.block.scaleDepth((float)baseDepth);
                    double uAge = (double)this.getMinAge() + (double)(this.getMaxAge() - this.getMinAge()) * LOC_TEMPLATE_AGE[0][1];
                    double lAge = (double)this.getMinAge() + (double)(this.getMaxAge() - this.getMinAge()) * LOC_TEMPLATE_AGE[0][2];
                    xleft = this.getXPos((float)(this.block.getProp().getAltAgeLeftToRight(BlockProperties.ScaleType.AGE) ? uAge : lAge));
                    xright = this.getXPos((float)(this.block.getProp().getAltAgeLeftToRight(BlockProperties.ScaleType.AGE) ? lAge : uAge));
                    rects.add(new Rectangle2D.Float(xleft, ytop, xright - xleft, ybase - ytop));
                    names.add("Sub Zone 2");
                    Color c = new Color(132, 207, 150);
                    colours.add(c);
                    if (this.prop.drawShading) {
                        g.setColor(c);
                        Color lighter = ColourUtils.getLighterColour((Color)c);
                        g.fillRect(xleft, y + this.getPanelHeaderHeight(cp, mode), xright - xleft, ytop - y - this.getPanelHeaderHeight(cp, mode), lighter);
                        if (this.block.getProp().getAltAgeLeftToRight(BlockProperties.ScaleType.AGE)) {
                            g.fillRect(x, ytop, xleft - x, ybase - ytop, lighter);
                        } else {
                            g.fillRect(xright, ytop, x + panelRight - xright, ybase - ytop, lighter);
                        }
                    }
                }
                assert (colours.size() == rects.size());
                assert (names.size() == rects.size());
                for (int i = 0; i < rects.size(); ++i) {
                    Color c = (Color)colours.get(i);
                    Rectangle2D r = (Rectangle2D)rects.get(i);
                    g.setColor(c);
                    g.fillRect((float)r.getX(), (float)r.getY(), (float)r.getWidth(), (float)r.getHeight(), (Color)colours.get(i));
                    g.setColor(cp.foreground);
                    this.drawString(g, (String)names.get(i), (float)r.getX(), (float)r.getY(), (float)r.getWidth(), (float)r.getHeight(), cp.font, 0, cp.getFontSizePanel());
                    if (g.drawStringBox((String)names.get(i), (float)r.getX(), (float)r.getY(), (float)r.getWidth(), (float)r.getHeight(), false)) continue;
                    g.drawStringBox((String)names.get(i), (float)r.getX(), (float)r.getY(), (float)r.getWidth(), (float)r.getHeight(), true);
                }
            }
        }
    }

    boolean drawString(SBGraphics g, String string, float x, float y, float width, float height, String fontName, int fontStyle, float fontSize) {
        if (fontSize < 1.0f) {
            return false;
        }
        g.setFont(fontName, fontStyle, fontSize);
        if (!g.drawStringBox(string, x, y, width, height, false) && !g.drawStringBox(string, x, y, width, height, true)) {
            this.drawString(g, string, x, y, width, height, fontName, fontStyle, fontSize - 0.5f);
        }
        return true;
    }

    void drawSQPicks(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) {
        if (!this.prop.drawSQPicks) {
            return;
        }
        float yTop = y + this.getPanelHeaderHeight(cp, mode);
        if (this.block.getWell() != null) {
            for (SQPick pick : this.getWellInterp().getSQPicks()) {
                double depth;
                try {
                    depth = this.block.getWell().getDepth(pick.getSample(), cp.correctDepths, cp.correctCuttings);
                }
                catch (SQLException sql) {
                    sql.printStackTrace();
                    depth = pick.getSample().getDepth();
                }
                if (!(depth >= (double)this.block.getTopDepth()) || !(depth <= (double)this.block.getBaseDepth())) continue;
                float yPos = this.block.scaleDepth((float)depth) + yTop;
                double age = pick.getSurface().getAge();
                if (!(age > (double)this.getMinAge()) || !(age < (double)this.getMaxAge())) continue;
                float xPos = x + this.getXPos((float)age);
                this.drawSQPick(g, x, xPos, yTop, yPos, pick.getSurfaceType(), pick.getBndInt(), bp);
            }
        } else {
            float ageRange = this.getMaxAge() - this.getMinAge();
            int[] bnds = new int[]{4, 3, 2, 4};
            Surface.SurfaceType[] surfaceTypes = new Surface.SurfaceType[]{Surface.SurfaceType.SB, Surface.SurfaceType.MFS, Surface.SurfaceType.TS, Surface.SurfaceType.SB};
            float[] ages = new float[]{0.25f, 0.35f, 0.4f, 0.78f};
            for (int i = 0; i < 4; ++i) {
                this.drawSQPick(g, x, x + this.getXPos(this.getMinAge() + ageRange * ages[i]), yTop, this.block.scaleDepth((float)this.block.getTemplateSamples().get(i).getDepth()) + yTop, surfaceTypes[i], bnds[i], bp);
            }
        }
    }

    private void drawSQPick(SBGraphics g, float x, float xPos, float y, float yPos, Surface.SurfaceType surfaceType, int bnd, BlockProperties bp) {
        switch (surfaceType) {
            case MFS: {
                g.setColor(this.hstColour);
                break;
            }
            case SB: 
            case CC: {
                g.setColor(this.lstColour);
                break;
            }
            case TS: {
                g.setColor(this.tstColour);
            }
        }
        g.setStroke(0.15f);
        if (bnd == 4 || bnd == 5) {
            GeneralPath p = SBGraphics.createGeneralPath(x + this.getWidth(bp), yPos);
            Shape q = g.appendUnconf(p, x + this.getWidth(bp), xPos, yPos, bnd == 5, true, true, false);
            g.drawShape(p);
            if (q != null) {
                g.drawShape(q);
            }
        } else {
            DrawingUtils.drawBoundary(bnd, xPos, x + this.getWidth(bp), yPos, g, 0.15f);
        }
        g.setStroke(0.15f);
        g.drawLine(xPos, yPos, xPos, y);
    }

    private float getXPos(float age) {
        float xpos = this.block.getProp().getAltAgeLeftToRight(BlockProperties.ScaleType.AGE) ? (age - this.getMinAge()) * this.block.getProp().getAltScale(BlockProperties.ScaleType.AGE) : (this.getMaxAge() - age) * this.block.getProp().getAltScale(BlockProperties.ScaleType.AGE);
        return xpos;
    }

    public float getAge(float xpos) {
        float age = this.block.getProp().getAltAgeLeftToRight(BlockProperties.ScaleType.AGE) ? xpos / this.block.getProp().getAltScale(BlockProperties.ScaleType.AGE) + this.getMinAge() : this.getMaxAge() - xpos / this.block.getProp().getAltScale(BlockProperties.ScaleType.AGE);
        return age;
    }

    @Override
    public float getWidth(BlockProperties bp) {
        float width = (this.getMaxAge() - this.getMinAge()) * this.block.getProp().getAltScale(BlockProperties.ScaleType.AGE);
        return width;
    }

    private float getMaxAge() {
        if (this.sBlockProp != null) {
            return this.sBlockProp.getMax();
        }
        return this.block.getProp().getAltMax(BlockProperties.ScaleType.AGE);
    }

    private float getMinAge() {
        if (this.sBlockProp != null) {
            return this.sBlockProp.getMin();
        }
        return this.block.getProp().getAltMin(BlockProperties.ScaleType.AGE);
    }

    @Override
    public boolean pipe() {
        return false;
    }

    @Override
    public ChartBlock getBlock() {
        return this.block;
    }

    private Color[] getColours() {
        int nColours;
        WellList wellList = ((ProjectBlock)this.block).getWellList();
        if (wellList == null) {
            nColours = LOC_TEMPLATES.length;
        } else {
            nColours = ((ProjectBlock)this.block).getWells().size();
            if (nColours == 0) {
                return null;
            }
        }
        Color[] colours = new Color[nColours];
        float inc = 1.0f / (float)colours.length;
        float hue = 0.0f;
        float saturation = 0.8f;
        float brightness = 0.8f;
        for (int i = 0; i < colours.length; ++i) {
            colours[i] = Color.getHSBColor(hue, saturation, brightness);
            hue += inc;
        }
        return colours;
    }

    @Override
    public void setData(ChartProperties cp, double[][] sections) {
        if (this.block.getWell() == null) {
            for (int i = 0; i < LOC_TEMPLATES.length; ++i) {
                PanelWellDepthAge.LOC_TEMPLATES[i] = null;
            }
        }
        if (this.prop.sBlockTempl == null) {
            this.sBlock = null;
        } else if (this.sBlock == null || this.sBlock.getTemplate() != this.prop.sBlockTempl) {
            try {
                this.sBlock = (SchemeBlock)ChartFactory.createBlock(this.getDb(), this.prop.sBlockTempl);
                this.sBlock.setWells(this.block.getWells());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.sBlock = null;
            }
        }
        this.restrictSBlock();
        if (this.sBlock != null) {
            try {
                if (this.sBlock.getInterpID() != this.getInterpID(this.block)) {
                    this.sBlock.setInterpID(this.getInterpID(this.block));
                }
                this.sBlock.setData(cp);
            }
            catch (IOException | SQLException | SBException sql) {
                throw new RuntimeException("Error setting data for scheme block header", sql);
            }
        }
    }

    @Override
    public void update(Observable obs, Object arg) {
        if (obs instanceof Well) {
            if (!this.block.getWells().contains((Well)obs)) assert (false);
            return;
        }
        if (obs instanceof WellInterp) {
            if (((WellInterp)obs).getHeader().getInterpID() == this.getInterpID(this.block)) {
                if (arg instanceof LOC) {
                    this.setSoftChanged();
                }
            } else assert (false);
            this.notifyListeners();
            return;
        }
        if (obs instanceof CompositeStandard) {
            this.cmpStd = null;
            this.buildEventCache();
        }
        super.update(obs, arg);
    }

    @Override
    public void fillWorkspaceWellData(SBdb ws, Set<Integer> dataTypes) throws SQLException, SBException {
        double depth;
        LinkedList<Object> toFill;
        WsWell wsWell = (WsWell)ws.getWell(this.block.getWell().getWellID());
        if (this.prop.drawLOCAlternatives && !(this.block instanceof ProjectBlock)) {
            Iterator<Well> it = this.block.getWell().getInterpIterator();
            while (it.hasNext()) {
                WellInterp dbAltInterp = (WellInterp)it.next();
                if (dbAltInterp.getHeader().getInterpID() == this.getInterpID(this.block)) continue;
                if (ws.getInterp(dbAltInterp.getHeader().getInterpID()) == null) {
                    ws.fillInterp(dbAltInterp.getHeader());
                }
                wsWell.getAddInterp(ws.fillInterp(dbAltInterp.getHeader())).fillLOC(dbAltInterp);
                dataTypes.add(17);
            }
        }
        if (this.prop.drawLOCs) {
            for (Well dbWell : this.block.getWells()) {
                ws.getWell(dbWell.getWellID()).getAddInterp(ws.fillInterp(this.getDb().getInterp(this.getInterpID(this.block)))).fillLOC(dbWell.getInterp(this.getInterpID(this.block)));
                dataTypes.add(17);
            }
        }
        if (this.prop.drawZones && this.prop.getScheme() != null && !(this.block instanceof ProjectBlock)) {
            toFill = new LinkedList<Object>();
            List zones = this.getWellInterp().getIGDList(this.prop.getScheme().getIGDType(), this.getProperties().getScheme().getID(), 1, IGDIntervalZone.getNHier((int)this.prop.getScheme().getIGDType(), (boolean)true));
            Iterator iterator = zones.iterator();
            while (iterator.hasNext()) {
                IGDIntervalZone zone = (IGDIntervalZone)iterator.next();
                if (zone.getSchID() != this.prop.getScheme().getID() || zone.getUppZone() == 0 || zone.getBaseSample().getDepth() < (double)this.block.getTopDepth() || zone.getTopSample().getDepth() > (double)this.block.getBaseDepth()) continue;
                toFill.add(zone);
            }
            if (!toFill.isEmpty()) {
                dataTypes.add(IGDInterval.igdType2dType((int)this.prop.getScheme().getIGDType()));
                wsWell.getAddInterp(ws.fillInterp(this.getDb().getInterp(this.getInterpID(this.block)))).fillIntervals(wsWell, true, toFill.toArray(new IGDIntervalZone[toFill.size()]));
            }
        }
        if (this.prop.drawSQPicks && !(this.block instanceof ProjectBlock)) {
            toFill = new LinkedList();
            for (SQPick pick : this.getWellInterp().getSQPicks()) {
                double age = pick.getSurface().getAge();
                if (!(age > (double)this.getMinAge()) || !(age < (double)this.getMaxAge())) continue;
                toFill.add(pick);
            }
            wsWell.getAddInterp(ws.fillInterp(this.getDb().getInterp(this.getInterpID(this.block)))).fillWorkspace(wsWell, true, (InterpItem[])toFill.toArray(new SQPick[toFill.size()]));
        }
        if (this.prop.drawEvents) {
            LinkedList<Well> dbWells = new LinkedList<Well>();
            if (this.block instanceof ProjectBlock) {
                for (Well well : ((ProjectBlock)this.block).getWells()) {
                    if (!well.hasInterpLoaded(this.getInterpID(this.block))) continue;
                    dbWells.add(well);
                }
            } else {
                dbWells.add(this.block.getWell());
            }
            for (Well well : dbWells) {
                WellInterp dbInterp = well.getInterp(this.getInterpID(this.block));
                LinkedList<WellEvent> toFill2 = new LinkedList<WellEvent>();
                for (WellEvent event : dbInterp.getEvents()) {
                    if (!this.plotEvent(event)) continue;
                    depth = event.getSample().getDepth();
                    float age = (float)this.getProperties().getCmpStd().getAge(event.getEvent().getEvID(), event.getTypeObj());
                    if (!(depth - (double)0.0029f <= (double)this.block.getBaseDepth()) || !(depth + (double)0.0029f >= (double)this.block.getTopDepth()) || !(age >= this.getMinAge()) || !(age <= this.getMaxAge())) continue;
                    toFill2.add(event);
                }
                if (toFill2.isEmpty()) continue;
                WsWell workspaceWell = (WsWell)ws.getWell(well.getWellID());
                workspaceWell.getAddInterp(ws.fillInterp(dbInterp.getHeader())).fillEvents(workspaceWell, true, toFill2.toArray(new WellEvent[toFill2.size()]));
                dataTypes.add(16);
            }
        }
        if (this.prop.drawOccs && !(this.block instanceof ProjectBlock)) {
            toFill = new LinkedList();
            for (Discipline disc : Discipline.values()) {
                for (Smpdtl smpdtl : this.block.getWell().getAnalyses(disc, null, 0)) {
                    depth = smpdtl.getSample().getDepth();
                    if (!(depth <= (double)this.block.getBaseDepth()) || !(depth >= (double)this.block.getTopDepth())) continue;
                    boolean found = false;
                    for (TaxonOcc fss : smpdtl.getOccurUnsorted()) {
                        float topAge = (float)this.getProperties().getCmpStd().getSpecAge(fss.getSpecID(), EventType.TOP);
                        if (!(topAge > 0.0f) || !(topAge >= this.getMinAge()) || !(topAge <= this.getMaxAge())) continue;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    toFill.add(smpdtl);
                }
            }
            wsWell.fillAnalyses(toFill, true, 0);
        }
    }

    static {
        PanelWellDepthAge.LOC_TEMPLATE_DEPTH[0] = new double[]{0.15, 0.22, 0.55, 0.55, 0.78};
        PanelWellDepthAge.LOC_TEMPLATE_DEPTH[1] = new double[]{0.17, 0.23, 0.58, 0.58, 0.8};
        PanelWellDepthAge.LOC_TEMPLATE_DEPTH[2] = new double[]{0.17, 0.21, 0.56, 0.56, 0.95};
        PanelWellDepthAge.LOC_TEMPLATE_AGE[0] = new double[]{0.18, 0.26, 0.45, 0.67, 0.91};
        PanelWellDepthAge.LOC_TEMPLATE_AGE[1] = new double[]{0.1, 0.28, 0.47, 0.64, 0.93};
        PanelWellDepthAge.LOC_TEMPLATE_AGE[2] = new double[]{0.14, 0.28, 0.47, 0.71, 0.87};
        LOC_TEMPLATES = new LOC[3];
        EV_TOP_AGES = new float[]{0.22f, 0.31f, 0.35f, 0.36f, 0.8f, 0.82f};
        EV_TOP_DEPTHS = new float[]{0.24f, 0.32f, 0.38f, 0.4f, 0.86f, 0.88f};
        EV_BASE_AGES = new float[]{0.36f, 0.365f, 0.42f, 0.81f};
        EV_BASE_DEPTHS = new float[]{0.37f, 0.39f, 0.45f, 0.67f};
    }

    class CmpStdEvAge {
        CompositeStandardEvent cmpStdEvt;
        float age;

        CmpStdEvAge(PanelWellDepthAge this$0, CompositeStandardEvent cmpStdEvt, Double age) {
            Objects.requireNonNull(this$0);
            this.cmpStdEvt = cmpStdEvt;
            this.age = age.floatValue();
        }
    }

    private static class EventLabel {
        final Color colour;
        final String label;
        float xpos;
        float ypos;
        Float stringWidth;

        EventLabel(String label, Color colour, float xpos, float ypos) {
            this.colour = colour;
            this.label = label;
            this.xpos = xpos;
            this.ypos = ypos;
        }

        public String toString() {
            return this.label;
        }
    }
}

