/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import com.stratadata.model3.well.WellGeoSort;
import java.sql.SQLException;
import java.util.Objects;
import jsbchart.block.SchemeBlock;
import jsbchart.core.BlockTemplate;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelType;
import model3.CompositeStandard;
import model3.EnvScheme;
import model3.IGDScheme;
import model3.SBdb;

public class PanelWellDepthAgeProperties
extends PanelProperties {
    private CompositeStandard cmpStd = null;
    private IGDScheme scheme;
    private EnvScheme envScheme;
    WellGeoSort wellSort = WellGeoSort.NS;
    boolean restrictAgeRangeToCurve = false;
    float extraAge = 10.0f;
    boolean drawLOCs = true;
    boolean drawSampleAges = true;
    boolean drawRates = false;
    boolean drawLOCAlternatives = false;
    boolean drawEvents = true;
    boolean drawOccs = true;
    boolean includeCvRw = false;
    boolean useCatColours = true;
    boolean drawDepthErrorBars = true;
    boolean drawAgeErrorBars = true;
    boolean drawEventQualifiers = true;
    boolean drawEventComments = true;
    boolean drawEventAbbreviations = true;
    boolean useEvConf = true;
    float symbolSize = 1.3f;
    boolean drawZones = true;
    boolean drawShading = true;
    boolean drawEventLines = true;
    boolean drawSQPicks = false;
    BlockTemplate sBlockTempl;
    public static final float ENV_WELL_HEIGHT = 10.0f;
    public static final int PROP_SBLOCK_TEMPL = 0;
    public static final int PROP_RESTRICT_AGE = 1;
    public static final int PROP_EXTRA_AGE = 2;
    public static final int PROP_LOC = 3;
    public static final int PROP_LOCALTS = 4;
    public static final int PROP_RATES = 5;
    public static final int PROP_SAMP_AGES = 6;
    public static final int PROP_CMPSTD = 7;
    public static final int PROP_EVENTS = 8;
    public static final int PROP_OCCS = 9;
    public static final int PROP_CVRW = 10;
    public static final int PROP_CATCOL = 11;
    public static final int PROP_ERRORBAR = 12;
    public static final int PROP_AGERRORBAR = 13;
    public static final int PROP_EVQUAL = 14;
    public static final int PROP_EVCOMM = 15;
    public static final int PROP_EVCONF = 16;
    public static final int PROP_EVLINES = 17;
    public static final int PROP_EVSIZE = 18;
    public static final int PROP_ABBRS = 19;
    public static final int PROP_SCH = 20;
    public static final int PROP_ZONES = 21;
    public static final int PROP_SHADING = 22;
    public static final int PROP_PICKS = 23;
    public static final int PROP_ENVSCH = 24;
    public static final int PROP_WELL_SORT = 25;
    private static final int[] titleRows = new int[]{3, 7, 20};
    private static final String[] propNames = new String[]{"Scheme block (header)", "Restrict age range to curve", "Extra age", "Depth/Age curves", "Alternative curves", "Accumulation rates", "Sample ages", "Composite Standard", "Events", "Occurrences", "Rw/Cv occurrences", "Category colours", "Depth Error bars", "Age Error bars", "Qualifiers", "Event comments", "Confidence", "Guide lines", "Symbol size", "Use abbrs.", "Scheme", "Interval outlines", "Interval shading", "Sequence picks", "Environment scheme", "Well sorting"};
    private static final String[] titleNames = new String[]{"Depth/Age Curves", "Events", "Interpretations"};
    private static final Float EVSIZE_MIN = Float.valueOf(0.5f);
    private static final Float EVSIZE_MAX = Float.valueOf(5.0f);

    private PanelWellDepthAgeProperties(PanelType panelType) {
        super(panelType);
    }

    PanelWellDepthAgeProperties(SBdb sbdb, PanelType panelType, SchemeBlock block, CompositeStandard cmpStd, IGDScheme scheme, EnvScheme envScheme, String prop) throws SQLException {
        super(panelType);
        this.cmpStd = cmpStd;
        if (cmpStd != null) {
            cmpStd.loadEvents();
        }
        this.scheme = scheme;
        this.envScheme = envScheme;
        if (block != null) {
            this.sBlockTempl = block.getTemplate();
        }
        if (prop == null || prop.isEmpty()) {
            return;
        }
        String[] s = prop.split("\\|");
        block34: for (int i = 0; i < s.length; ++i) {
            switch (i) {
                case 0: {
                    continue block34;
                }
                case 1: {
                    continue block34;
                }
                case 2: {
                    this.restrictAgeRangeToCurve = Integer.parseInt(s[i]) == 1;
                    continue block34;
                }
                case 3: {
                    continue block34;
                }
                case 4: {
                    continue block34;
                }
                case 5: {
                    this.drawLOCs = Integer.parseInt(s[i]) == 1;
                    continue block34;
                }
                case 6: {
                    this.drawLOCAlternatives = Integer.parseInt(s[i]) == 1;
                    continue block34;
                }
                case 7: {
                    this.drawRates = Integer.parseInt(s[i]) == 1;
                    continue block34;
                }
                case 8: {
                    this.drawSampleAges = Integer.parseInt(s[i]) == 1;
                    continue block34;
                }
                case 9: {
                    this.drawEvents = Integer.parseInt(s[i]) == 1;
                    continue block34;
                }
                case 10: {
                    this.drawOccs = Integer.parseInt(s[i]) == 1;
                    continue block34;
                }
                case 11: {
                    this.includeCvRw = Integer.parseInt(s[i]) == 1;
                    continue block34;
                }
                case 12: {
                    this.useCatColours = Integer.parseInt(s[i]) == 1;
                    continue block34;
                }
                case 13: {
                    this.drawDepthErrorBars = Integer.parseInt(s[i]) == 1;
                    continue block34;
                }
                case 14: {
                    this.drawEventQualifiers = Integer.parseInt(s[i]) == 1;
                    continue block34;
                }
                case 15: {
                    this.drawEventLines = Integer.parseInt(s[i]) == 1;
                    continue block34;
                }
                case 16: {
                    this.drawZones = Integer.parseInt(s[i]) == 1;
                    continue block34;
                }
                case 17: {
                    this.drawShading = Integer.parseInt(s[i]) == 1;
                    continue block34;
                }
                case 18: {
                    this.drawSQPicks = Integer.parseInt(s[i]) == 1;
                    continue block34;
                }
                case 19: {
                    this.drawEventComments = Integer.parseInt(s[i]) == 1;
                    continue block34;
                }
                case 20: {
                    this.extraAge = Float.parseFloat(s[i]);
                    continue block34;
                }
                case 21: {
                    this.useEvConf = Integer.parseInt(s[i]) == 1;
                    continue block34;
                }
                case 22: {
                    this.symbolSize = Float.parseFloat(s[i]);
                    continue block34;
                }
                case 23: {
                    int ws = Integer.parseInt(s[i]);
                    switch (ws) {
                        case 0: 
                        case 1: {
                            this.wellSort = WellGeoSort.NS;
                            break;
                        }
                        case 2: 
                        case 180: {
                            this.wellSort = WellGeoSort.SN;
                            break;
                        }
                        case 3: 
                        case 270: {
                            this.wellSort = WellGeoSort.WE;
                            break;
                        }
                        case 4: 
                        case 90: {
                            this.wellSort = WellGeoSort.EW;
                        }
                    }
                    continue block34;
                }
                case 24: {
                    this.drawEventAbbreviations = Integer.parseInt(s[i]) == 1;
                    continue block34;
                }
                case 25: {
                    this.drawAgeErrorBars = Integer.parseInt(s[i]) == 1;
                }
            }
        }
    }

    @Override
    public boolean showRow(int row) {
        switch (row) {
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 23: {
                return this.getPanelType() == PanelType.DEPTHAGE;
            }
            case 24: 
            case 25: {
                return this.getPanelType() == PanelType.SUBSIDENCE;
            }
            case 2: {
                return this.restrictAgeRangeToCurve;
            }
        }
        return true;
    }

    public CompositeStandard getCmpStd() {
        return this.cmpStd;
    }

    @Override
    public String getPrefs() {
        throw new UnsupportedOperationException("Unsupported");
    }

    public IGDScheme getScheme() {
        return this.scheme;
    }

    @Override
    public int getnProps() {
        return propNames.length;
    }

    @Override
    public String getPropertyName(int nProp) {
        return propNames[nProp];
    }

    @Override
    public int[] getTitleRows() {
        return titleRows;
    }

    @Override
    public String getTitleName(int titleNo) {
        if (titleNo < 0 || titleNo > titleNames.length - 1) {
            return null;
        }
        return titleNames[titleNo];
    }

    @Override
    public Object getProperty(int nProp) {
        switch (nProp) {
            case 0: {
                return this.sBlockTempl;
            }
            case 7: {
                return this.cmpStd;
            }
            case 20: {
                return this.scheme;
            }
            case 24: {
                return this.getEnvScheme();
            }
            case 25: {
                return this.wellSort;
            }
            case 1: {
                return this.restrictAgeRangeToCurve;
            }
            case 2: {
                return Float.valueOf(this.extraAge);
            }
            case 3: {
                return this.drawLOCs;
            }
            case 4: {
                return this.drawLOCAlternatives;
            }
            case 5: {
                return this.drawRates;
            }
            case 6: {
                return this.drawSampleAges;
            }
            case 8: {
                return this.drawEvents;
            }
            case 9: {
                return this.drawOccs;
            }
            case 10: {
                return this.includeCvRw;
            }
            case 11: {
                return this.useCatColours;
            }
            case 12: {
                return this.drawDepthErrorBars;
            }
            case 13: {
                return this.drawAgeErrorBars;
            }
            case 14: {
                return this.drawEventQualifiers;
            }
            case 15: {
                return this.drawEventComments;
            }
            case 16: {
                return this.useEvConf;
            }
            case 17: {
                return this.drawEventLines;
            }
            case 18: {
                return Float.valueOf(this.symbolSize);
            }
            case 19: {
                return this.drawEventAbbreviations;
            }
            case 21: {
                return this.drawZones;
            }
            case 22: {
                return this.drawShading;
            }
            case 23: {
                return this.drawSQPicks;
            }
        }
        throw new IllegalArgumentException("No property at: " + nProp);
    }

    EnvScheme getEnvScheme() {
        return this.envScheme;
    }

    @Override
    public boolean setProperty(int nProp, Object prop) {
        if (nProp == 0 || this.getProperty(nProp) == null ^ prop == null || this.getProperty(nProp) != null && !this.getProperty(nProp).equals(prop)) {
            switch (nProp) {
                case 0: {
                    this.sBlockTempl = (BlockTemplate)prop;
                    break;
                }
                case 7: {
                    this.cmpStd = (CompositeStandard)prop;
                    break;
                }
                case 20: {
                    this.scheme = (IGDScheme)prop;
                    break;
                }
                case 24: {
                    this.envScheme = (EnvScheme)prop;
                    break;
                }
                case 25: {
                    this.wellSort = (WellGeoSort)prop;
                    break;
                }
                case 1: {
                    this.restrictAgeRangeToCurve = (Boolean)prop;
                    break;
                }
                case 2: {
                    this.extraAge = prop instanceof Float ? ((Float)prop).floatValue() : (prop != null ? Float.parseFloat(prop.toString()) : 0.0f);
                    break;
                }
                case 3: {
                    this.drawLOCs = (Boolean)prop;
                    break;
                }
                case 4: {
                    this.drawLOCAlternatives = (Boolean)prop;
                    break;
                }
                case 5: {
                    this.drawRates = (Boolean)prop;
                    break;
                }
                case 6: {
                    this.drawSampleAges = (Boolean)prop;
                    break;
                }
                case 8: {
                    this.drawEvents = (Boolean)prop;
                    break;
                }
                case 9: {
                    this.drawOccs = (Boolean)prop;
                    break;
                }
                case 10: {
                    this.includeCvRw = (Boolean)prop;
                    break;
                }
                case 11: {
                    this.useCatColours = (Boolean)prop;
                    break;
                }
                case 12: {
                    this.drawDepthErrorBars = (Boolean)prop;
                    break;
                }
                case 13: {
                    this.drawAgeErrorBars = (Boolean)prop;
                    break;
                }
                case 14: {
                    this.drawEventQualifiers = (Boolean)prop;
                    break;
                }
                case 15: {
                    this.drawEventComments = (Boolean)prop;
                    break;
                }
                case 19: {
                    this.drawEventAbbreviations = (Boolean)prop;
                    break;
                }
                case 16: {
                    this.useEvConf = (Boolean)prop;
                    break;
                }
                case 17: {
                    this.drawEventLines = (Boolean)prop;
                    break;
                }
                case 18: {
                    float newSize;
                    float f = prop instanceof Float ? ((Float)prop).floatValue() : (newSize = prop != null ? Float.parseFloat(prop.toString()) : 0.0f);
                    if (newSize < EVSIZE_MIN.floatValue() || newSize > EVSIZE_MAX.floatValue()) {
                        return false;
                    }
                    this.symbolSize = newSize;
                    break;
                }
                case 21: {
                    this.drawZones = (Boolean)prop;
                    break;
                }
                case 22: {
                    this.drawShading = (Boolean)prop;
                    break;
                }
                case 23: {
                    this.drawSQPicks = (Boolean)prop;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public PanelProperties copy() {
        return PanelWellDepthAgeProperties.createCopy(this);
    }

    @Override
    public String getPropertiesString() {
        Object string = new String();
        String[] props = new String[]{"", "", "" + (this.restrictAgeRangeToCurve ? 1 : 0), "", "", "" + (this.drawLOCs ? 1 : 0), "" + (this.drawLOCAlternatives ? 1 : 0), "" + (this.drawRates ? 1 : 0), "" + (this.drawSampleAges ? 1 : 0), "" + (this.drawEvents ? 1 : 0), "" + (this.drawOccs ? 1 : 0), "" + (this.includeCvRw ? 1 : 0), "" + (this.useCatColours ? 1 : 0), "" + (this.drawDepthErrorBars ? 1 : 0), "" + (this.drawEventQualifiers ? 1 : 0), "" + (this.drawEventLines ? 1 : 0), "" + (this.drawZones ? 1 : 0), "" + (this.drawShading ? 1 : 0), "" + (this.drawSQPicks ? 1 : 0), "" + (this.drawEventComments ? 1 : 0), "" + this.extraAge, "" + (this.useEvConf ? 1 : 0), "" + this.symbolSize, "" + this.wellSort.toInt(), "" + (this.drawEventAbbreviations ? 1 : 0), "" + (this.drawAgeErrorBars ? 1 : 0)};
        for (String prop : props) {
            string = (String)string + prop + "|";
        }
        return string;
    }

    @Override
    public void copy(PanelProperties pp) {
        if (!(pp instanceof PanelWellDepthAgeProperties)) {
            throw new IllegalArgumentException("PanelWellDepthAgeProperties cannot copy " + String.valueOf(pp));
        }
        PanelWellDepthAgeProperties rhs = (PanelWellDepthAgeProperties)pp;
        for (int i = 0; i < this.getnProps(); ++i) {
            switch (i) {
                default: 
            }
            this.setProperty(i, rhs.getProperty(i));
        }
    }

    private static PanelWellDepthAgeProperties createCopy(PanelWellDepthAgeProperties rhs) {
        PanelWellDepthAgeProperties p = new PanelWellDepthAgeProperties(rhs.getPanelType());
        p.copy(rhs);
        return p;
    }

    @Override
    public Class<?> getPropertyClass(int nProp) {
        switch (nProp) {
            case 0: {
                return SchemeBlock.class;
            }
            case 7: {
                return CompositeStandard.class;
            }
            case 20: {
                return IGDScheme[].class;
            }
            case 24: {
                return EnvScheme.class;
            }
            case 25: {
                return WellGeoSort.class;
            }
            case 2: 
            case 18: {
                return Float.class;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 23: {
                return Boolean.class;
            }
        }
        throw new IllegalArgumentException("No property at: " + nProp);
    }

    @Override
    public int getCmpStdID() {
        if (this.cmpStd != null) {
            return this.cmpStd.getStdID();
        }
        return super.getCmpStdID();
    }

    @Override
    public int getIGDSchemeID() {
        if (this.scheme != null) {
            return this.scheme.getID();
        }
        return super.getIGDSchemeID();
    }

    @Override
    public int getEnvSchID() {
        if (this.envScheme != null) {
            return this.envScheme.getID();
        }
        return 0;
    }

    @Override
    public int getBlockMbrTemplateID() {
        if (this.sBlockTempl != null) {
            return this.sBlockTempl.getID();
        }
        return 0;
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + (this.cmpStd != null ? this.cmpStd.hashCode() : 0);
        hash = 47 * hash + (this.scheme != null ? this.scheme.hashCode() : 0);
        hash = 47 * hash + (this.drawLOCs ? 1 : 0);
        hash = 47 * hash + (this.drawSampleAges ? 1 : 0);
        hash = 47 * hash + (this.drawRates ? 1 : 0);
        hash = 47 * hash + (this.drawLOCAlternatives ? 1 : 0);
        hash = 47 * hash + (this.drawEvents ? 1 : 0);
        hash = 47 * hash + (this.drawOccs ? 1 : 0);
        hash = 47 * hash + (this.includeCvRw ? 1 : 0);
        hash = 47 * hash + (this.useCatColours ? 1 : 0);
        hash = 47 * hash + (this.drawDepthErrorBars ? 1 : 0);
        hash = 47 * hash + (this.drawEventQualifiers ? 1 : 0);
        hash = 47 * hash + (this.drawEventComments ? 1 : 0);
        hash = 47 * hash + (this.drawZones ? 1 : 0);
        hash = 47 * hash + (this.drawShading ? 1 : 0);
        hash = 47 * hash + (this.drawEventLines ? 1 : 0);
        hash = 47 * hash + (this.drawSQPicks ? 1 : 0);
        hash = 47 * hash + (this.sBlockTempl != null ? this.sBlockTempl.getID() : 0);
        hash = 47 * hash + (this.envScheme != null ? this.envScheme.getID() : 0);
        hash = 47 * hash + (this.restrictAgeRangeToCurve ? 1 : 0);
        hash = 47 * hash + Float.floatToIntBits(this.extraAge);
        hash = 47 * hash + (this.useEvConf ? 1 : 0);
        hash = 47 * hash + Float.floatToIntBits(this.symbolSize);
        hash = 47 * hash + (this.drawEventAbbreviations ? 1 : 0);
        hash = 47 * hash + (this.drawAgeErrorBars ? 1 : 0);
        return hash;
    }

    @Override
    public boolean isSimilarTo(PanelProperties comp) {
        if (!(comp instanceof PanelWellDepthAgeProperties)) {
            return false;
        }
        if (this.equals(comp)) {
            return true;
        }
        PanelWellDepthAgeProperties rhs = (PanelWellDepthAgeProperties)comp;
        block4: for (int i = 0; i < this.getnProps(); ++i) {
            switch (i) {
                case 2: {
                    if (!(Math.abs(this.extraAge - rhs.extraAge) > 5.0f)) continue block4;
                    return false;
                }
                case 18: {
                    if (!(Math.abs(this.symbolSize - rhs.symbolSize) > 1.0f)) continue block4;
                    return false;
                }
                default: {
                    if (Objects.equals(this.getProperty(i), rhs.getProperty(i))) continue block4;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean allowNull(int nProp) {
        switch (nProp) {
            case 7: 
            case 20: 
            case 24: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasShowRowDependencies(int row) {
        return row == 1;
    }
}

