/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import com.stratadata.model3.Discipline;
import java.util.Arrays;
import java.util.Objects;
import jsbchart.core.ChartProperties;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelType;
import model3.DataType;
import model3.IGDIntervalZone;

public class PanelZonesProperties
extends PanelProperties {
    boolean[] plotCols;
    float columnWidth = 40.0f;
    boolean drawBndDepths = true;
    boolean useAbrs = false;
    boolean useColours = true;
    boolean vertPref = false;
    boolean multiScheme = false;
    ChartProperties.FontSizeExtended fontSize = ChartProperties.FontSizeExtended.PANEL;
    boolean boldFont = false;
    PanelProperties.ColumnWidth commentsCol = new PanelProperties.ColumnWidth(DEFAULT_COMMENT_WIDTH, false);
    boolean disconformities;
    boolean uppercase = false;
    public static float DEFAULT_COMMENT_WIDTH = 30.0f;
    private static final String[] propNames = new String[]{"Column width", "Show depths", "Use abbrs.", "Use colours", "Vertical text", "Multi scheme", "Font size", "Bold font", "Uppercase", "Comments", "Disconformities"};
    public static final int PROP_COLWIDTH = 0;
    public static final int PROP_DEPTH = 1;
    public static final int PROP_ABRS = 2;
    public static final int PROP_COLOURS = 3;
    public static final int PROP_VERTPREF = 4;
    public static final int PROP_MULTISCHEME = 5;
    public static final int PROP_FONTSIZE = 6;
    public static final int PROP_BOLD = 7;
    public static final int PROP_ALL_CAPS = 8;
    public static final int PROP_COMMENTS = 9;
    public static final int PROP_FAULTS = 10;
    public static final int PROP_HIER_MIN = 11;
    public static final int PROPS_ALL_CAPS_STRING_INDEX = 11;
    private static final int[] titleRows = new int[]{11};
    private static final String[] titleNames = new String[]{"Mapped Columns"};
    public static final String FOR_EACH = "<All available schemes in separate columns>";
    public static final String FOR_EACH_SHORT = "<Column per scheme>";
    public static final String FOR_EACH_MULTI = "<All available schemes in one columm>";
    public static final String FOR_EACH_MULTI_SHORT = "<All Schemes>";

    private void setColumns() {
        int nHier = IGDIntervalZone.getNHier((int)this.getIGDtype(), (boolean)true);
        this.plotCols = new boolean[nHier];
        for (int i = 0; i < this.plotCols.length; ++i) {
            this.plotCols[i] = true;
        }
    }

    @Override
    public void copy(PanelProperties pp) {
        if (!(pp instanceof PanelZonesProperties)) {
            throw new IllegalArgumentException("PanelZonesProperties cannot copy " + String.valueOf(pp));
        }
        if (pp.getPanelType() != this.getPanelType()) {
            throw new IllegalArgumentException("Panel type mismatch in PanelZonesProperties copy: " + String.valueOf(this.getPanelType()) + " : " + String.valueOf(pp.getPanelType()));
        }
        PanelZonesProperties rhs = (PanelZonesProperties)pp;
        this.plotCols = Arrays.copyOf(rhs.plotCols, this.plotCols.length);
        this.columnWidth = rhs.columnWidth;
        this.drawBndDepths = rhs.drawBndDepths;
        this.useAbrs = rhs.useAbrs;
        this.useColours = rhs.useColours;
        this.vertPref = rhs.vertPref;
        this.multiScheme = rhs.multiScheme;
        this.fontSize = rhs.fontSize;
        this.commentsCol = new PanelProperties.ColumnWidth(rhs.commentsCol);
        this.disconformities = rhs.disconformities;
        this.boldFont = rhs.boldFont;
        this.uppercase = rhs.uppercase;
    }

    public PanelZonesProperties(PanelType type) {
        super(type);
        this.setColumns();
    }

    public static PanelZonesProperties createCopy(PanelZonesProperties rhs) {
        PanelZonesProperties p = new PanelZonesProperties(rhs.getPanelType());
        p.copy(rhs);
        return p;
    }

    @Override
    public String getPrefs() {
        Object string = new String();
        String[] props = new String[12];
        props[0] = "" + this.columnWidth;
        props[1] = "" + (this.drawBndDepths ? 1 : 0);
        props[2] = "" + (this.useAbrs ? 1 : 0);
        props[3] = "" + (this.useColours ? 1 : 0);
        props[4] = "" + (this.vertPref ? 1 : 0);
        props[5] = "" + (this.multiScheme ? 1 : 0);
        props[6] = this.fontSize.name();
        props[7] = "" + this.commentsCol.width();
        props[8] = "" + (this.disconformities ? 1 : 0);
        String colString = Arrays.toString(this.plotCols);
        props[9] = colString.substring(1, colString.length() - 1);
        props[10] = "" + (this.boldFont ? 1 : 0);
        props[11] = "" + (this.uppercase ? 1 : 0);
        for (String prop : props) {
            string = (String)string + prop + "|";
        }
        return string;
    }

    PanelZonesProperties(String prefs, PanelType type) {
        this(type);
        if (prefs == null) {
            return;
        }
        String[] s = prefs.trim().split("\\|");
        block23: for (int i = 0; i < s.length; ++i) {
            try {
                switch (i) {
                    case 0: {
                        this.columnWidth = Float.parseFloat(s[i]);
                        break;
                    }
                    case 1: {
                        this.drawBndDepths = Integer.parseInt(s[i]) == 1;
                        break;
                    }
                    case 2: {
                        this.useAbrs = Integer.parseInt(s[i]) == 1;
                        break;
                    }
                    case 3: {
                        this.useColours = Integer.parseInt(s[i]) == 1;
                        break;
                    }
                    case 4: {
                        this.vertPref = Integer.parseInt(s[i]) == 1;
                        break;
                    }
                    case 5: {
                        this.multiScheme = Integer.parseInt(s[i]) == 1;
                        break;
                    }
                    case 6: {
                        try {
                            this.fontSize = ChartProperties.FontSizeExtended.valueOf(s[i]);
                        }
                        catch (IllegalArgumentException e) {
                            this.fontSize = ChartProperties.FontSizeExtended.SMALL;
                        }
                        break;
                    }
                    case 7: {
                        this.commentsCol = new PanelProperties.ColumnWidth(Float.parseFloat(s[i]), DEFAULT_COMMENT_WIDTH, true);
                        break;
                    }
                    case 8: {
                        this.disconformities = Integer.parseInt(s[i]) == 1;
                        break;
                    }
                    case 9: {
                        String[] split2 = s[i].split(",");
                        if (split2.length == this.plotCols.length) {
                            for (int j = 0; j < split2.length; ++j) {
                                this.plotCols[j] = Boolean.valueOf(split2[j].trim());
                            }
                            continue block23;
                        }
                        if (split2.length != 4 || this.plotCols.length != 8) break;
                        int plotColIndex = 0;
                        for (int j = 0; j < split2.length; ++j) {
                            switch (j + 1) {
                                case 1: {
                                    plotColIndex = 2;
                                    break;
                                }
                                default: {
                                    plotColIndex = 4;
                                    break;
                                }
                                case 3: {
                                    plotColIndex = 5;
                                    break;
                                }
                                case 4: {
                                    plotColIndex = 8;
                                }
                            }
                            this.plotCols[--plotColIndex] = Boolean.valueOf(split2[j].trim());
                        }
                        continue block23;
                    }
                    case 10: {
                        this.boldFont = Integer.parseInt(s[i]) == 1;
                        break;
                    }
                    case 11: {
                        this.uppercase = Integer.parseInt(s[i]) == 1;
                    }
                }
                continue;
            }
            catch (NumberFormatException nfe) {
                System.out.println("Number format exception in PanelZonesProperties init: " + nfe.getMessage() + " " + i + " " + prefs);
                break;
            }
        }
    }

    @Override
    public int getnProps() {
        return propNames.length + this.plotCols.length;
    }

    @Override
    public String getPropertyName(int nProp) {
        if (nProp < propNames.length) {
            return propNames[nProp];
        }
        return "    " + IGDIntervalZone.getHierName((int)this.getIGDtype(), (int)(nProp - propNames.length + 1));
    }

    @Override
    public int[] getTitleRows() {
        return titleRows;
    }

    @Override
    public String getTitleName(int titleNo) {
        if (titleNo < 0 || titleNo > titleNames.length - 1) {
            return null;
        }
        return titleNames[titleNo];
    }

    private int getIGDtype() {
        switch (this.getPanelType()) {
            case CHRONOZONE: {
                return 3;
            }
            case LITHOZONE: {
                return 2;
            }
            case MICROZONE: 
            case NANNOZONE: 
            case PALYZONE: 
            case MACROZONE: {
                return 4;
            }
        }
        throw new IllegalStateException("Incorrect panel type for PanelZones: " + String.valueOf(this.getPanelType()));
    }

    @Override
    public Object getProperty(int nProp) {
        switch (nProp) {
            case 0: {
                return (int)this.columnWidth;
            }
            case 1: {
                return this.drawBndDepths;
            }
            case 2: {
                return this.useAbrs;
            }
            case 3: {
                return this.useColours;
            }
            case 4: {
                return this.vertPref;
            }
            case 5: {
                return this.multiScheme;
            }
            case 6: {
                return this.fontSize;
            }
            case 7: {
                return this.boldFont;
            }
            case 9: {
                return this.commentsCol;
            }
            case 10: {
                return this.disconformities;
            }
            case 8: {
                return this.uppercase;
            }
        }
        return this.plotCols[nProp -= propNames.length];
    }

    @Override
    public boolean setProperty(int nProp, Object prop) {
        if (this.getProperty(nProp) == null ^ prop == null || this.getProperty(nProp) != null && !this.getProperty(nProp).equals(prop)) {
            switch (nProp) {
                case 0: {
                    if (prop instanceof String) {
                        this.setColWidth(Float.parseFloat((String)prop));
                        break;
                    }
                    this.setColWidth(((Float)prop).floatValue());
                    break;
                }
                case 1: {
                    this.drawBndDepths = (Boolean)prop;
                    break;
                }
                case 2: {
                    this.useAbrs = (Boolean)prop;
                    break;
                }
                case 3: {
                    this.useColours = (Boolean)prop;
                    break;
                }
                case 4: {
                    this.vertPref = (Boolean)prop;
                    break;
                }
                case 5: {
                    this.multiScheme = (Boolean)prop;
                    break;
                }
                case 6: {
                    this.fontSize = (ChartProperties.FontSizeExtended)((Object)prop);
                    break;
                }
                case 7: {
                    this.boldFont = (Boolean)prop;
                    break;
                }
                case 9: {
                    if (prop == null) {
                        this.commentsCol.showColumn(false);
                        break;
                    }
                    this.commentsCol = (PanelProperties.ColumnWidth)prop;
                    break;
                }
                case 10: {
                    this.disconformities = (Boolean)prop;
                    break;
                }
                case 8: {
                    this.uppercase = (Boolean)prop;
                    break;
                }
                default: {
                    this.plotCols[nProp -= PanelZonesProperties.propNames.length] = (Boolean)prop;
                }
            }
            return true;
        }
        return false;
    }

    private boolean setColWidth(float colWidth) {
        if (Math.abs((int)this.columnWidth - (int)colWidth) >= 1 && (int)colWidth > 4 && (int)colWidth < 250) {
            this.columnWidth = (int)colWidth;
            return true;
        }
        return false;
    }

    @Override
    public PanelProperties copy() {
        return PanelZonesProperties.createCopy(this);
    }

    @Override
    public String getPropertiesString() {
        return this.getPrefs();
    }

    @Override
    public Class<?> getPropertyClass(int nProp) {
        switch (nProp) {
            case 0: {
                return Integer.class;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: {
                return Boolean.class;
            }
            case 6: {
                return ChartProperties.FontSizeExtended.class;
            }
            case 9: {
                return PanelProperties.ColumnWidth.class;
            }
        }
        if (nProp > propNames.length - 1) {
            return Boolean.class;
        }
        assert (false);
        return null;
    }

    public int hashCode() {
        int hash = 5;
        hash = 19 * hash + Float.floatToIntBits(this.columnWidth);
        hash = 19 * hash + (this.drawBndDepths ? 1 : 0);
        hash = 19 * hash + (this.useAbrs ? 1 : 0);
        hash = 19 * hash + (this.useColours ? 1 : 0);
        hash = 19 * hash + (this.vertPref ? 1 : 0);
        hash = 19 * hash + (this.boldFont ? 1 : 0);
        hash = 19 * hash + (this.multiScheme ? 1 : 0);
        hash = 19 * hash + (this.disconformities ? 1 : 0);
        hash = 19 * hash + (this.uppercase ? 1 : 0);
        hash = 19 * hash + this.fontSize.hashCode();
        hash = 19 * hash + Arrays.hashCode(this.plotCols);
        return hash;
    }

    @Override
    public boolean isSimilarTo(PanelProperties comp) {
        if (!(comp instanceof PanelZonesProperties)) {
            return false;
        }
        if (this.equals(comp)) {
            return true;
        }
        PanelZonesProperties rhs = (PanelZonesProperties)comp;
        block5: for (int i = 0; i < this.getnProps(); ++i) {
            switch (i) {
                case 7: {
                    continue block5;
                }
                case 0: {
                    if (!(Math.abs(this.columnWidth - rhs.columnWidth) > 3.0f)) continue block5;
                    return false;
                }
                case 9: {
                    if (this.commentsCol.isSimilarTo(rhs.commentsCol)) continue block5;
                    return false;
                }
                default: {
                    Object iProp1 = this.getProperty(i);
                    Object iProp2 = rhs.getProperty(i);
                    if (Objects.equals(iProp1, iProp2)) continue block5;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public DataType getDataType() {
        switch (this.getPanelType()) {
            case CHRONOZONE: {
                return DataType.CHRONOSTRAT;
            }
            case LITHOZONE: {
                return DataType.LITHOSTRAT;
            }
            case MICROZONE: 
            case NANNOZONE: 
            case PALYZONE: 
            case MACROZONE: {
                return DataType.BIOZONE;
            }
        }
        return null;
    }

    @Override
    public boolean showRow(int row) {
        if (row == 5) {
            return PanelType.isBiozonePanel(this.getPanelType());
        }
        return super.showRow(row);
    }

    public Discipline getDisc() {
        return this.getPanelType().getDiscipine();
    }

    boolean plotColumn(int minHier, int maxHier) {
        --minHier;
        --maxHier;
        for (int i = 0; i < this.plotCols.length; ++i) {
            if (!this.plotCols[i] || i < minHier || i > maxHier) continue;
            return true;
        }
        return false;
    }

    public String getForEachString(boolean shortString) {
        if (this.multiScheme) {
            return shortString ? FOR_EACH_MULTI_SHORT : FOR_EACH_MULTI;
        }
        return shortString ? FOR_EACH_SHORT : FOR_EACH;
    }

    public boolean isMultiScheme() {
        return this.multiScheme;
    }
}

