/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel.spatial;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import jsbchart.panel.spatial.CategoryFillEntry;

public class CategoryFillList {
    private List<CategoryFillEntry> entries = new ArrayList<CategoryFillEntry>();
    private final String propertyName;
    private Color defaultFill = null;

    public CategoryFillList(String propertyName) {
        this.propertyName = propertyName;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void addEntry(CategoryFillEntry entry) {
        this.entries.add(entry);
    }

    public void removeEntry(CategoryFillEntry entry) {
        this.entries.remove(entry);
    }

    public int getSize() {
        return this.entries.size();
    }

    public CategoryFillEntry getEntry(int i) {
        return this.entries.get(i);
    }

    public List<CategoryFillEntry> getList() {
        return new ArrayList<CategoryFillEntry>(this.entries);
    }

    public void clearList() {
        this.entries.clear();
    }

    public List<String> findDuplicateEntryValues() {
        ArrayList<String> duplicateValues = new ArrayList<String>();
        ArrayList<String> foundValues = new ArrayList<String>();
        for (CategoryFillEntry entry : this.entries) {
            if (foundValues.contains(entry.getValue()) && !duplicateValues.contains(entry.getValue())) {
                duplicateValues.add(entry.getValue());
            }
            if (foundValues.contains(entry.getValue())) continue;
            foundValues.add(entry.getValue());
        }
        return duplicateValues;
    }

    public void setDefaultFill(Color fill) {
        this.defaultFill = fill;
    }

    public Color getDefaultFill() {
        return this.defaultFill;
    }
}

