/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel.spatial;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.data.Query;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.filter.spatial.Overlaps;
import org.geotools.api.filter.spatial.Within;
import org.geotools.api.geometry.BoundingBox;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.TopologyException;

public class FeatureProcessor {
    private static final Logger LOGGER = Logger.getLogger(FeatureProcessor.class.getName());
    private final FilterFactory ff = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());

    public SimpleFeatureCollection filterFeaturesToEnvelope(SimpleFeatureSource source, ReferencedEnvelope envelope) throws IOException, TransformException {
        SimpleFeatureType featureType = (SimpleFeatureType)source.getSchema();
        return this.findFeaturesByBBox(featureType, envelope, source);
    }

    public SimpleFeatureCollection filterAndClipFeaturesToEnvelope(SimpleFeatureSource source, ReferencedEnvelope envelope) throws IOException, TransformException {
        SimpleFeatureType featureType = (SimpleFeatureType)source.getSchema();
        CoordinateReferenceSystem sourceCRS = this.getTypeCRS(featureType);
        BoundingBox transformedMapBounds = envelope.toBounds(sourceCRS);
        Polygon polygon = JTS.toGeometry((BoundingBox)transformedMapBounds);
        if ("MultiPolygon".equals(featureType.getGeometryDescriptor().getType().getName().toString())) {
            SimpleFeatureCollection featuresWithin = this.findFeaturesWithinPoly(featureType, polygon, source);
            SimpleFeatureCollection featuresOverlapping = this.findFeaturesOverlappingPoly(featureType, polygon, source);
            SimpleFeatureCollection clippedFeatures = FeatureProcessor.clipGeometry(featuresOverlapping, polygon);
            return this.combineFeatureCollections(featuresWithin, clippedFeatures, featureType);
        }
        SimpleFeatureCollection features = this.findFeaturesByBBox(featureType, envelope, source);
        return FeatureProcessor.clipGeometry(features, polygon);
    }

    private SimpleFeatureCollection combineFeatureCollections(SimpleFeatureCollection featuresWithin, SimpleFeatureCollection featuresOverlapping, SimpleFeatureType featureType) {
        SimpleFeatureBuilder featureBuilder;
        Feature f;
        SimpleFeatureType schema;
        ArrayList<SimpleFeature> newFeatures = new ArrayList<SimpleFeature>();
        try (SimpleFeatureIterator i = featuresWithin.features();){
            schema = (SimpleFeatureType)featuresWithin.getSchema();
            while (i.hasNext()) {
                f = i.next();
                featureBuilder = new SimpleFeatureBuilder(schema);
                f.getProperties().forEach(p -> featureBuilder.set(p.getName(), p.getValue()));
                newFeatures.add(featureBuilder.buildFeature(f.getIdentifier().getID()));
            }
        }
        i = featuresOverlapping.features();
        try {
            schema = (SimpleFeatureType)featuresOverlapping.getSchema();
            while (i.hasNext()) {
                f = i.next();
                featureBuilder = new SimpleFeatureBuilder(schema);
                f.getProperties().forEach(p -> featureBuilder.set(p.getName(), p.getValue()));
                newFeatures.add(featureBuilder.buildFeature(f.getIdentifier().getID()));
            }
        }
        finally {
            if (i != null) {
                i.close();
            }
        }
        Object newFeatureCollection = newFeatures.size() == 0 ? new DefaultFeatureCollection((String)null, featureType) : DataUtilities.collection(newFeatures);
        return newFeatureCollection;
    }

    private SimpleFeatureCollection findFeaturesOverlappingPoly(SimpleFeatureType featureType, Polygon polygon, SimpleFeatureSource source) throws IOException {
        Overlaps filter = this.ff.overlaps((Expression)this.getGeomProp(featureType), (Expression)this.ff.literal((Object)polygon));
        Query query = new Query(featureType.getTypeName(), (Filter)filter);
        return source.getFeatures(query);
    }

    private SimpleFeatureCollection findFeaturesWithinPoly(SimpleFeatureType featureType, Polygon polygon, SimpleFeatureSource source) throws IOException {
        Within filter = this.ff.within((Expression)this.getGeomProp(featureType), (Expression)this.ff.literal((Object)polygon));
        Query query = new Query(featureType.getTypeName(), (Filter)filter);
        return source.getFeatures(query);
    }

    private SimpleFeatureCollection findFeaturesByBBox(SimpleFeatureType featureType, ReferencedEnvelope envelope, SimpleFeatureSource source) throws TransformException, IOException {
        CoordinateReferenceSystem sourceCRS = this.getTypeCRS(featureType);
        BoundingBox transformedMapBounds = envelope.toBounds(sourceCRS);
        BBOX filter = this.ff.bbox((Expression)this.getGeomProp(featureType), transformedMapBounds);
        Query query = new Query(featureType.getTypeName(), (Filter)filter);
        return source.getFeatures(query);
    }

    private static SimpleFeatureCollection clipGeometry(SimpleFeatureCollection features, Polygon limits) {
        SimpleFeatureType schema = (SimpleFeatureType)features.getSchema();
        ArrayList<SimpleFeature> newFeatures = new ArrayList<SimpleFeature>();
        try (SimpleFeatureIterator fi = features.features();){
            long stime = System.currentTimeMillis();
            int i = 0;
            while (fi.hasNext()) {
                LOGGER.log(Level.FINE, "clipping geometry of feature {0}", new Object[]{++i});
                Feature f = fi.next();
                SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(schema);
                f.getProperties().forEach(p -> {
                    if (p.getName().toString().equals(schema.getGeometryDescriptor().getLocalName()) && p.getValue() instanceof Geometry) {
                        Geometry value = (Geometry)p.getValue();
                        try {
                            Geometry g = value.intersection((Geometry)limits);
                            featureBuilder.set(p.getName(), (Object)g);
                        }
                        catch (TopologyException ex) {
                            LOGGER.log(Level.FINE, "Exception from building feature {0}", ex);
                        }
                    } else {
                        featureBuilder.set(p.getName(), p.getValue());
                    }
                });
                newFeatures.add(featureBuilder.buildFeature(f.getIdentifier().getID()));
            }
            LOGGER.log(Level.FINE, "clipped {0} features in {1}ms", new Object[]{i, System.currentTimeMillis() - stime});
        }
        SimpleFeatureCollection newFeatureCollection = DataUtilities.collection(newFeatures);
        return newFeatureCollection;
    }

    private PropertyName getGeomProp(SimpleFeatureType ft) {
        String geomName = ft.getGeometryDescriptor().getLocalName();
        return this.ff.property(geomName);
    }

    private CoordinateReferenceSystem getTypeCRS(SimpleFeatureType ft) {
        CoordinateReferenceSystem crs = ft.getCoordinateReferenceSystem();
        if (crs == null) {
            crs = DefaultGeographicCRS.WGS84;
        }
        return crs;
    }
}

