/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel.spatial;

import com.stratadata.util.depth.DepthUnits;
import com.stratadata.util.depth.DepthUtils;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import jsbchart.block.BlockProperties;
import jsbchart.block.IBlockProperties;
import jsbchart.block.MapBlock;
import jsbchart.block.MapBlockProperties;
import jsbchart.core.ChartProperties;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.data.ScaleConverter;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.spatial.DataSeries;
import jsbchart.panel.spatial.LayerAccumulationRateProperties;
import jsbchart.panel.spatial.SolidPointDataLayer;
import model3.Well;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import util.SB;

public class LayerAccumulationRate
extends SolidPointDataLayer {
    private static final String FEATURE_ATTRIBUTE_NAME_ACCMRATE_COLOUR = "accmrate_c";
    private LayerAccumulationRateProperties p;
    private Map<Integer, Float> wellData;
    private float min;
    private float max;
    private BlockProperties.ScaleType scaleType;

    public LayerAccumulationRate(PanelTemplate template, PanelOcc panelOcc, MapBlock block) {
        super(template, panelOcc != null ? panelOcc : new PanelOcc(template.getID()), block);
        this.p = template != null ? (LayerAccumulationRateProperties)template.getProperties() : new LayerAccumulationRateProperties();
    }

    @Override
    String getColourFeatureAttributeName() {
        return FEATURE_ATTRIBUTE_NAME_ACCMRATE_COLOUR;
    }

    @Override
    public void setFeatureAttributes(Well well, SimpleFeatureBuilder featureBuilder) {
        boolean hasData;
        Color wellColour;
        if (this.wellData == null || this.wellData.get(well.getWellID()) == null) {
            wellColour = DataSeries.UNSAMPLED_COLOUR;
            hasData = false;
        } else {
            wellColour = this.p.getSpectrum().getColour(this.wellData.get(well.getWellID()).floatValue());
            hasData = true;
        }
        featureBuilder.set("has_data", (Object)hasData);
        featureBuilder.set(FEATURE_ATTRIBUTE_NAME_ACCMRATE_COLOUR, (Object)DataSeries.hexColour(wellColour));
    }

    @Override
    public void setData(ChartProperties cp) {
        HashMap rawWellData = new HashMap();
        this.wellData = new HashMap<Integer, Float>();
        this.getBlock().clearLegendForLayer(this.getTemplateID());
        this.getBlock().getWellsWithLocation().forEach(well -> this.summariseWellData(rawWellData, (Well)well, cp));
        if (!rawWellData.isEmpty()) {
            this.min = 1.0E8f;
            this.max = 0.0f;
            for (Float f : rawWellData.values()) {
                if (f.floatValue() < this.min) {
                    this.min = f.floatValue();
                }
                if (!(f.floatValue() > this.max)) continue;
                this.max = f.floatValue();
            }
            for (Integer key : rawWellData.keySet()) {
                float rawValue = ((Float)rawWellData.get(key)).floatValue();
                float normValue = this.max - this.min > 0.0f ? (rawValue - this.min) / (this.max - this.min) : rawValue - this.min;
                this.wellData.put(key, Float.valueOf(normValue));
            }
            this.getBlock().addLegendItem(this.getTemplateID(), this.p.getSpectrum().getColour(0.0f), "" + SB.roundToSignificantFigures((double)this.min, (int)2));
            if (this.max - this.min > 0.0f) {
                this.getBlock().addLegendItem(this.getTemplateID(), this.p.getSpectrum().getColour(0.25f), "" + SB.roundToSignificantFigures((double)((this.max - this.min) / 4.0f + this.min), (int)2));
                this.getBlock().addLegendItem(this.getTemplateID(), this.p.getSpectrum().getColour(0.5f), "" + SB.roundToSignificantFigures((double)((this.max - this.min) / 2.0f + this.min), (int)2));
                this.getBlock().addLegendItem(this.getTemplateID(), this.p.getSpectrum().getColour(0.75f), "" + SB.roundToSignificantFigures((double)((this.max - this.min) * 3.0f / 4.0f + this.min), (int)2));
                this.getBlock().addLegendItem(this.getTemplateID(), this.p.getSpectrum().getColour(1.0f), "" + SB.roundToSignificantFigures((double)this.max, (int)2));
            }
        }
    }

    private void summariseWellData(Map<Integer, Float> wellData, Well well, ChartProperties cp) {
        ScaleConverter scaleConverter = this.getBlock().getScaleConverter(well, cp);
        Double minMD = scaleConverter.getScaleLimitAsMeasuredDepth(IBlockProperties.ScaleLimitType.MIN).orElse(null);
        Double maxMD = scaleConverter.getScaleLimitAsMeasuredDepth(IBlockProperties.ScaleLimitType.MAX).orElse(null);
        if (minMD == null || maxMD == null) {
            return;
        }
        Double minTVD = scaleConverter.convert(minMD, BlockProperties.ScaleType.MD, BlockProperties.ScaleType.TVD);
        Double maxTVD = scaleConverter.convert(maxMD, BlockProperties.ScaleType.MD, BlockProperties.ScaleType.TVD);
        if (minTVD == null || maxTVD == null) {
            return;
        }
        double totalDurationTVD = maxTVD - minTVD;
        if (!(totalDurationTVD > 0.0)) {
            return;
        }
        switch (this.getBlock().getProp().getDataRangeStyle()) {
            case BOUNDARIES: {
                Double minAGE = scaleConverter.convert(minMD, BlockProperties.ScaleType.MD, BlockProperties.ScaleType.AGE);
                Double maxAGE = scaleConverter.convert(maxMD, BlockProperties.ScaleType.MD, BlockProperties.ScaleType.AGE);
                if (minAGE == null || maxAGE == null) {
                    return;
                }
                double totalDurationTime = maxAGE - minAGE;
                if (!(totalDurationTime > 0.0)) {
                    return;
                }
                double accumulationRate = DepthUtils.convFromM((double)totalDurationTVD, (DepthUnits)this.p.getScaleUnits()) / totalDurationTime;
                wellData.put(well.getWellID(), Float.valueOf((float)accumulationRate));
                break;
            }
            case LITHOSTRAT: {
                double thickness = DepthUtils.convFromM((double)totalDurationTVD, (DepthUnits)this.p.getScaleUnits());
                wellData.put(well.getWellID(), Float.valueOf((float)thickness));
            }
        }
    }

    @Override
    public String summaryString() {
        return switch (this.getBlock().getProp().getDataRangeStyle()) {
            default -> throw new MatchException(null, null);
            case MapBlockProperties.DataRangeStyle.BOUNDARIES -> this.p.getScaleUnits().getAbr() + " per Ma";
            case MapBlockProperties.DataRangeStyle.LITHOSTRAT -> this.p.getScaleUnits().getAbr() + " total";
        };
    }

    @Override
    public PanelProperties getProperties() {
        return this.p;
    }

    @Override
    protected Class<? extends PanelProperties> getPropertiesClass() {
        return LayerAccumulationRateProperties.class;
    }
}

