/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel.spatial;

import com.stratadata.util.depth.DepthUnits;
import com.stratadata.util.depth.DepthUtils;
import java.awt.Color;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import jsbchart.block.MapBlock;
import jsbchart.core.ChartProperties;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.data.ScaleConverter;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.spatial.DataSeries;
import jsbchart.panel.spatial.LayerDataCoverageProperties;
import jsbchart.panel.spatial.SolidPointDataLayer;
import jsbchart.util.colour.ColourScale;
import model3.Smpdtl;
import model3.Well;
import model3.exception.SuppressedSQLException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import util.SBException;

public class LayerDataCoverage
extends SolidPointDataLayer {
    private static final String FEATURE_ATTRIBUTE_NAME_COVERAGE_COLOUR = "coverage_c";
    private LayerDataCoverageProperties p;
    private Map<Integer, Float> wellData;

    public LayerDataCoverage(PanelTemplate template, PanelOcc panelOcc, MapBlock block) {
        super(template, panelOcc != null ? panelOcc : new PanelOcc(template.getID()), block);
        this.p = template != null ? (LayerDataCoverageProperties)template.getProperties() : new LayerDataCoverageProperties();
    }

    @Override
    String getColourFeatureAttributeName() {
        return FEATURE_ATTRIBUTE_NAME_COVERAGE_COLOUR;
    }

    @Override
    public void setFeatureAttributes(Well well, SimpleFeatureBuilder featureBuilder) {
        boolean hasData;
        Color wellColour;
        if (this.wellData == null || this.wellData.get(well.getWellID()) == null) {
            wellColour = DataSeries.UNSAMPLED_COLOUR;
            hasData = false;
        } else {
            wellColour = this.p.getScale().getColour(this.wellData.get(well.getWellID()).floatValue());
            hasData = true;
        }
        featureBuilder.set("has_data", (Object)hasData);
        featureBuilder.set(FEATURE_ATTRIBUTE_NAME_COVERAGE_COLOUR, (Object)DataSeries.hexColour(wellColour));
    }

    @Override
    public void setData(ChartProperties cp) {
        this.wellData = new HashMap<Integer, Float>();
        this.getBlock().clearLegendForLayer(this.getTemplateID());
        this.getBlock().getWellsWithLocation().forEach(well -> this.summariseWellData(this.wellData, (Well)well, cp));
        if (!this.wellData.isEmpty()) {
            List<ColourScale.ValueColour> scale = this.p.getScale().getScale();
            for (int i = 0; i < scale.size(); ++i) {
                ColourScale.ValueColour valueColour = scale.get(i);
                Object maxValueString = valueColour.maxValue() == null ? (i == 0 ? "all" : "> " + scale.get(i - 1).maxValue()) : (i == 0 ? "< " + valueColour.maxValue() : scale.get(i - 1).maxValue() + " - " + valueColour.maxValue());
                this.getBlock().addLegendItem(this.getTemplateID(), valueColour.colour(), (String)maxValueString);
            }
        }
    }

    private void summariseWellData(Map<Integer, Float> wellData, Well well, ChartProperties cp) {
        ScaleConverter scaleConverter = this.getBlock().getScaleConverter(well, cp);
        double totalDuration = scaleConverter.getPlottableDurationAsMeasuredDepth();
        if (!(totalDuration > 0.0)) {
            return;
        }
        try {
            List analyses = well.getAnalyses(null, null, 0);
            Predicate<Smpdtl> disciplinePredicate = smpdtl -> this.p.useDiscipline(smpdtl.getDiscipline());
            Predicate<Smpdtl> depthPredicate = smpdtl -> scaleConverter.isWithinPlottableRange(smpdtl.getSample().getDepth());
            long nAnalyses = analyses.stream().filter(disciplinePredicate.and(depthPredicate)).count();
            double coverageIndex = (double)nAnalyses / DepthUtils.convFromM((double)totalDuration, (DepthUnits)this.p.getScaleUnits());
            wellData.put(well.getWellID(), Float.valueOf((float)coverageIndex));
        }
        catch (SQLException sqlE) {
            throw SuppressedSQLException.withoutRollback((SQLException)sqlE);
        }
        catch (SBException sbe) {
            throw new RuntimeException(sbe);
        }
    }

    @Override
    public String summaryString() {
        return this.p.getCoverageDataType().toString() + " per " + this.p.getScaleUnits().getAbr();
    }

    @Override
    public PanelProperties getProperties() {
        return this.p;
    }

    @Override
    protected Class<? extends PanelProperties> getPropertiesClass() {
        return LayerDataCoverageProperties.class;
    }
}

