/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel.spatial;

import com.stratadata.model3.Discipline;
import com.stratadata.util.depth.DepthUnits;
import jsbchart.panel.BasicPanelProperties;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelPropertyItem;
import jsbchart.panel.PanelType;
import jsbchart.util.colour.ColourScale;

public class LayerDataCoverageProperties
extends BasicPanelProperties {
    private final PanelPropertyItem<CoverageDataType> type = PanelPropertyItem.nonNullable("Data type", CoverageDataType.ANALYSES);
    private final PanelPropertyItem<ColourScale> scale = PanelPropertyItem.nonNullable("Scale", ColourScale.getDefault());
    private final PanelPropertyItem<DepthUnits> scaleUnits = PanelPropertyItem.nonNullable("Scale units", DepthUnits.M);
    private final PanelPropertyItem<Discipline> discipline = PanelPropertyItem.nullable("Discipline", Discipline.class);

    public LayerDataCoverageProperties() {
        super(PanelType.COVERAGE);
        this.items.add(this.type);
        this.items.add(this.scale);
        this.items.add(this.scaleUnits);
        this.items.add(this.discipline);
    }

    public LayerDataCoverageProperties(String props) {
        super(PanelType.COVERAGE);
        this.items.add(this.type);
        this.items.add(this.scale);
        this.items.add(this.scaleUnits);
        this.items.add(this.discipline);
        this.setValuesFromPropertiesString(props);
    }

    public CoverageDataType getCoverageDataType() {
        return this.type.getValue();
    }

    public ColourScale getScale() {
        return this.scale.getValue();
    }

    public DepthUnits getScaleUnits() {
        return this.scaleUnits.getValue();
    }

    public boolean useDiscipline(Discipline discipline) {
        return this.discipline.getValue() == null || this.discipline.getValue() == discipline;
    }

    @Override
    public boolean allowNull(int nProp) {
        if (nProp == this.items.indexOf(this.discipline)) {
            return true;
        }
        return super.allowNull(nProp);
    }

    @Override
    public PanelProperties copy() {
        LayerDataCoverageProperties p = new LayerDataCoverageProperties();
        p.copy(this);
        return p;
    }

    @Override
    public void copy(PanelProperties pp) {
        if (pp == null) {
            throw new NullPointerException("Cannot copy null panel properties");
        }
        if (!(pp instanceof LayerDataCoverageProperties)) {
            throw new IllegalArgumentException(this.getClass().getName() + " cannot copy " + pp.getClass().getName());
        }
        LayerDataCoverageProperties rhs = (LayerDataCoverageProperties)pp;
        for (int i = 0; i < this.getnProps(); ++i) {
            this.setProperty(i, rhs.getProperty(i));
        }
    }

    @Override
    public boolean isSimilarTo(PanelProperties comp) {
        return false;
    }

    public static enum CoverageDataType {
        ANALYSES("Analyses");

        final String description;

        private CoverageDataType(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }
}

