/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel.spatial;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jsbchart.block.IBlockProperties;
import jsbchart.block.MapBlock;
import jsbchart.block.MapBlockProperties;
import jsbchart.core.ChartProperties;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.data.ScaleConverter;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.spatial.DataSeries;
import jsbchart.panel.spatial.LayerEnvProperties;
import jsbchart.panel.spatial.SBPointDataLayer;
import model3.EnvScheme;
import model3.IGDIntervalEnv;
import model3.Well;
import model3.WellInterp;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;

public class LayerEnv
extends SBPointDataLayer {
    private static final Logger LOGGER = Logger.getLogger(LayerEnv.class.getName());
    private LayerEnvProperties p;
    private DataSeries data;
    private final HashMap<Integer, EnvScheme> keyData = new HashMap();

    public LayerEnv(PanelTemplate template, PanelOcc panelOcc, MapBlock block) {
        super(template, panelOcc != null ? panelOcc : new PanelOcc(template.getID()), block);
        this.p = template != null ? (LayerEnvProperties)template.getProperties() : new LayerEnvProperties();
    }

    @Override
    public void addFeatureTypeAttributes(SimpleFeatureTypeBuilder builder) {
        if (this.data == null) {
            return;
        }
        this.data.getDataHeaders().forEach(dh -> builder.add("env_v_" + dh.idString(), Float.class));
    }

    @Override
    public void setFeatureAttributes(Well well, SimpleFeatureBuilder featureBuilder) {
        if (this.data == null) {
            return;
        }
        Map<DataSeries.DataPointHeader, Float> dataForWell = this.data.getDataForWell(well.getWellID());
        for (Map.Entry<DataSeries.DataPointHeader, Float> entry : dataForWell.entrySet()) {
            DataSeries.DataPointHeader header = entry.getKey();
            Float value = entry.getValue();
            featureBuilder.set("env_v_" + header.idString(), (Object)value);
            LOGGER.log(Level.CONFIG, "{0} ({1})  {2} ({3}) = {4}", new Object[]{well.getWellName(), well.getWellID(), header.label(), header.idString(), value});
            if (header.isUnsampled() || !(value.floatValue() > 0.0f)) continue;
            featureBuilder.set("has_data", (Object)Boolean.TRUE);
        }
    }

    @Override
    public void setData(ChartProperties cp) {
        float blockScaleDuration = 0.0f;
        if (this.getBlock().getProp().getDataRangeStyle() == MapBlockProperties.DataRangeStyle.BOUNDARIES) {
            blockScaleDuration = this.getBlock().getProp().getScaleLimit(IBlockProperties.ScaleLimitType.MAX) - this.getBlock().getProp().getScaleLimit(IBlockProperties.ScaleLimitType.MIN);
        }
        this.data = new DataSeries(blockScaleDuration);
        this.keyData.clear();
        this.getBlock().getWellsWithLocation().forEach(well -> {
            WellInterp interp = this.getBlock().getInterp((Well)well, this.getLayerInterpID());
            if (interp != null) {
                this.summariseWellData(this.data, (Well)well, interp, cp);
            }
        });
        this.getBlock().clearLegendForLayer(this.getTemplateID());
        this.keyData.values().forEach(envScheme -> {
            if (cp.key != null && cp.key.envSchemes) {
                this.getBlock().addLegendItem(this.getTemplateID(), "Scheme: " + envScheme.getName(), "(see chart key)");
            } else {
                for (int i = 1; i <= envScheme.getNClasses(); ++i) {
                    this.getBlock().addLegendItem(this.getTemplateID(), envScheme.getColour(i), envScheme.getTerm(i, true));
                }
            }
        });
    }

    private void summariseWellData(DataSeries ds, Well well, WellInterp interp, ChartProperties cp) {
        ScaleConverter scaleConverter = this.getBlock().getScaleConverter(well, cp);
        ds.setDurationForWell(well.getWellID(), (float)scaleConverter.getPlottableDuration());
        List envs = interp.getEnvs();
        try {
            for (IGDIntervalEnv env : envs) {
                float baseValue;
                float topValue;
                float intervalDuration;
                float baseSampleMD;
                float topSampleMD = (float)well.getDepth(env.getTopSample(), cp.correctDepths, cp.correctCuttings);
                if (!scaleConverter.isWithinPlottableRange((double)topSampleMD, baseSampleMD = (float)well.getDepth(env.getBaseSample(), cp.correctDepths, cp.correctCuttings)) || !((intervalDuration = Math.abs((topValue = (float)scaleConverter.convertAndTrimMeasuredDepth(topSampleMD)) - (baseValue = (float)scaleConverter.convertAndTrimMeasuredDepth(baseSampleMD)))) > 0.0f)) continue;
                float divisor = env.getUd() - env.getUp() + 1;
                EnvScheme scheme = env.getScheme();
                for (int ienv = env.getUp(); ienv <= env.getUd(); ++ienv) {
                    ds.addData(well.getWellID(), ienv, scheme.getTerm(ienv), scheme.getColour(ienv), intervalDuration / divisor);
                }
                this.keyData.put(scheme.getID(), scheme);
            }
        }
        catch (SQLException sqlex) {
            sqlex.printStackTrace();
        }
    }

    @Override
    public int preferredSize() {
        return 1000;
    }

    @Override
    public Optional<String> getChartParameterString(ChartProperties cp) {
        if (this.data == null) {
            return Optional.empty();
        }
        StringBuilder uriBuilder = new StringBuilder("cht=p");
        uriBuilder.append("&chs=500x500");
        uriBuilder.append("&chd=t:");
        this.data.getDataHeaders().forEach(header -> uriBuilder.append("${env_v_" + header.idString() + "},"));
        uriBuilder.delete(uriBuilder.length() - 1, uriBuilder.length());
        uriBuilder.append("&chco=").append(this.data.getDataHeaders().stream().map(DataSeries.DataPointHeader::hexColour).collect(Collectors.joining(",")));
        uriBuilder.append("&sb_chtprop_bg=").append(DataSeries.hexColour(cp.background));
        return Optional.of(uriBuilder.toString());
    }

    @Override
    public PanelProperties getProperties() {
        return this.p;
    }

    @Override
    protected Class<? extends PanelProperties> getPropertiesClass() {
        return LayerEnvProperties.class;
    }

    @Override
    public String summaryString() {
        return "Palaeoenvironments";
    }

    @Override
    public void putKeyData(ChartProperties cp) {
        if (!cp.key.envSchemes) {
            return;
        }
        this.keyData.values().forEach(scheme -> cp.getKeyData().putEnvScheme((EnvScheme)scheme));
    }
}

