/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel.spatial;

import java.awt.Color;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import jsbchart.SVGFillArtist;
import jsbchart.block.MapBlock;
import jsbchart.block.MapBlockProperties;
import jsbchart.core.ChartProperties;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.graphics.map.CrsCode;
import jsbchart.graphics.map.GeotoolsSymbolizerHelper;
import jsbchart.graphics.text.MapFill;
import jsbchart.listener.ChartEvent;
import jsbchart.listener.ChartUpdate;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.spatial.CategoryFillEntry;
import jsbchart.panel.spatial.CategoryFillList;
import jsbchart.panel.spatial.FeatureProcessor;
import jsbchart.panel.spatial.LayerShapeProperties;
import jsbchart.panel.spatial.SBLayerFactory;
import jsbchart.panel.spatial.ShapeDataStoreException;
import jsbchart.util.GeotoolsUtils;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.referencing.IdentifiedObject;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.Fill;
import org.geotools.api.style.Graphic;
import org.geotools.api.style.LineSymbolizer;
import org.geotools.api.style.Mark;
import org.geotools.api.style.PolygonSymbolizer;
import org.geotools.api.style.Rule;
import org.geotools.api.style.Stroke;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyleFactory;
import org.geotools.api.style.Symbolizer;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.wfs.WFSDataStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import util.SBException;

public class LayerShape
extends SBLayerFactory {
    private static final Logger LOGGER = Logger.getLogger(LayerShape.class.getName());
    private final FeatureProcessor fp = new FeatureProcessor();
    private LayerShapeProperties p;
    private CrsCode crsForCachedLayer = null;
    private SimpleFeatureSource cachedFeatureSource;
    private CategoryFillList categoryFillList = null;

    public LayerShape(PanelTemplate template, PanelOcc panelOcc, MapBlock block) {
        super(template, panelOcc != null ? panelOcc : new PanelOcc(template.getID()), block);
        this.p = template != null ? (LayerShapeProperties)template.getProperties() : new LayerShapeProperties();
    }

    public void setCategoryFillList(CategoryFillList list) {
        this.categoryFillList = list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Layer createLayer(ChartProperties cp) {
        this.cachedFeatureSource = null;
        this.crsForCachedLayer = null;
        DataStore store = null;
        try {
            WFSDataStore wfsStore;
            ArrayList<SimpleFeature> featuresFromWFS;
            SimpleFeatureSource featureSource;
            block28: {
                store = this.p.getDataStore();
                if (store == null) {
                    LOGGER.warning("Could not create layer: null data store");
                    return null;
                }
                LOGGER.info("Store: " + store.toString());
                String featureTypeName = store.getTypeNames().length == 1 ? store.getTypeNames()[0] : this.p.getFeatureTypeName();
                if (featureTypeName == null || featureTypeName.isEmpty()) {
                    LOGGER.warning("Could not create layer: no feature type name");
                    return null;
                }
                featureSource = store.getFeatureSource(featureTypeName);
                if (featureSource == null) {
                    LOGGER.log(Level.WARNING, "Could not create layer: could not create featureSource for ''{0}''", featureTypeName);
                    return null;
                }
                if (((SimpleFeatureType)featureSource.getSchema()).getCoordinateReferenceSystem() == null) {
                    LOGGER.log(Level.WARNING, "No CRS found for featureSource {0} from store {1}. Possibly missing .prj file for shapefiles?", new Object[]{featureSource.getName(), store});
                }
                featuresFromWFS = new ArrayList<SimpleFeature>();
                try (SimpleFeatureIterator sfi = featureSource.getFeatures().features();){
                    while (sfi.hasNext()) {
                        try {
                            SimpleFeature f = (SimpleFeature)sfi.next();
                            featuresFromWFS.add(f);
                        }
                        catch (Exception e2) {
                            LOGGER.log(Level.WARNING, "Could not create feature from featureSource: {0}", e2.getMessage());
                        }
                    }
                }
                catch (RuntimeException e) {
                    LOGGER.log(Level.SEVERE, "Could not read data from feature source: {0}", e.getCause() != null ? e.getCause().getMessage() : e.getMessage());
                    if (!featuresFromWFS.isEmpty()) break block28;
                    return null;
                }
            }
            SimpleFeatureCollection featureCollection = DataUtilities.collection(featuresFromWFS);
            if (store instanceof WFSDataStore && (wfsStore = (WFSDataStore)store).getWfsClient().getCapabilitiesURL().toString().contains("&replace=1")) {
                try {
                    CoordinateReferenceSystem originalCRS = ((SimpleFeatureType)featureCollection.getSchema()).getCoordinateReferenceSystem();
                    LOGGER.log(Level.FINE, "Original axis order = {0}", new Object[]{CRS.getAxisOrder((CoordinateReferenceSystem)originalCRS)});
                    String identifier = CRS.lookupIdentifier((IdentifiedObject)originalCRS, (boolean)true);
                    CoordinateReferenceSystem newCRS = CRS.decode((String)identifier, (boolean)false);
                    LOGGER.log(Level.FINE, "new axis order = {0}", new Object[]{CRS.getAxisOrder((CoordinateReferenceSystem)newCRS)});
                    if (CRS.getAxisOrder((CoordinateReferenceSystem)originalCRS) != CRS.getAxisOrder((CoordinateReferenceSystem)newCRS)) {
                        featureCollection = GeotoolsUtils.buildNewFeatureCollectionWithCRS(featureSource, newCRS);
                        LOGGER.log(Level.FINE, "new features collection axis order = {0}", new Object[]{CRS.getAxisOrder((CoordinateReferenceSystem)((SimpleFeatureType)featureCollection.getSchema()).getCoordinateReferenceSystem())});
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Error occurred while trying to change the axis order", e);
                }
            }
            MapBlockProperties prop = this.getBlock().getProp();
            FeatureLayer newLayer = null;
            try {
                SimpleFeatureSource fs2 = DataUtilities.source((FeatureCollection)featureCollection);
                SimpleFeatureCollection features = this.fp.filterAndClipFeaturesToEnvelope(fs2, prop.getCrsCode().getMaxBounds(prop.getReferenceEnvelopeWGS84()));
                if (features.size() == 0) {
                    LOGGER.log(Level.WARNING, "No features found in filtered features - reverting to ALL features");
                    features = featureCollection;
                }
                if (features.getSchema() == null) {
                    LOGGER.log(Level.WARNING, "No schema found in filtered features.");
                    return null;
                }
                if (((SimpleFeatureType)features.getSchema()).getCoordinateReferenceSystem() == null) {
                    LOGGER.log(Level.WARNING, "No CRS found!");
                }
                this.cachedFeatureSource = DataUtilities.source((FeatureCollection)features);
                Style style = this.createStyle(this.cachedFeatureSource, cp);
                this.crsForCachedLayer = prop.getCrsCode();
                newLayer = new FeatureLayer((FeatureSource)this.cachedFeatureSource, style);
                return newLayer;
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Error creating shape layer", ex);
            }
            return newLayer;
        }
        catch (IOException | ShapeDataStoreException e) {
            LOGGER.log(Level.SEVERE, "Exception while creating a Layer object from LayerShape with shape store name: " + this.p.getShapeStoreName(), e);
            return null;
        }
    }

    @Override
    public void setData(ChartProperties cp) {
    }

    @Override
    public void setData(ChartEvent e, ChartUpdate update) throws SBException, SQLException, IOException {
        super.setData(e, update);
    }

    private Style createStyle(SimpleFeatureSource featureSource, ChartProperties cp) {
        StyleFactory sf = CommonFactoryFinder.getStyleFactory();
        FeatureTypeStyle fts = sf.createFeatureTypeStyle();
        if (this.categoryFillList != null) {
            List<Rule> rules = this.getCategoryFillRules();
            fts.rules().addAll(rules);
        } else {
            Rule rule = this.createRule(sf, featureSource, cp);
            fts.rules().add(rule);
        }
        Style style = sf.createStyle();
        style.featureTypeStyles().add(fts);
        return style;
    }

    private List<Rule> getCategoryFillRules() {
        StyleFactory sf = CommonFactoryFinder.getStyleFactory();
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (CategoryFillEntry entry : this.categoryFillList.getList()) {
            Rule rule = sf.createRule();
            PropertyIsEqualTo f = ff.equal((Expression)ff.property(this.categoryFillList.getPropertyName()), (Expression)ff.literal((Object)entry.getValue()), false);
            rule.setFilter((Filter)f);
            MapFill fill = entry.getFill();
            if (fill.getType().getSvgString() != null) {
                SVGFillArtist artist = new SVGFillArtist();
                artist.loadSVGFromString(fill.getType().getSvgString());
                int iconSize = (int)(fill.getMarkerSize() * 100.0f);
                int iconGap = (int)(fill.getMarkerGap() * 100.0f);
                ImageIcon iconFill = artist.buildIcon(iconSize, iconGap, fill.getFillColour(), fill.getBackgroundColour());
                if (fill.getBackgroundColour() != null) {
                    rule.symbolizers().add(GeotoolsSymbolizerHelper.buildSolidColourSymbolizer(fill.getBackgroundColour(), fill.getStrokeColour(), fill.getStrokeSize()));
                }
                rule.symbolizers().add(GeotoolsSymbolizerHelper.buildIconSymbolizer(iconFill, fill.getMarkerSize(), fill.getFillColour(), fill.getStrokeColour(), fill.getStrokeSize()));
            } else {
                rule.symbolizers().add(GeotoolsSymbolizerHelper.buildSolidColourSymbolizer(fill.getFillColour(), fill.getStrokeColour(), fill.getStrokeSize()));
            }
            rules.add(rule);
        }
        Rule defaultRule = sf.createRule();
        defaultRule.setName("default");
        Stroke st = sf.createStroke((Expression)ff.literal((Object)Color.black), (Expression)ff.literal(0.5f));
        Fill f = sf.createFill((Expression)ff.literal((Object)Color.green), (Expression)ff.literal(1));
        PolygonSymbolizer s = sf.createPolygonSymbolizer(st, f, (String)null);
        defaultRule.symbolizers().add(s);
        defaultRule.setElseFilter(true);
        rules.add(defaultRule);
        return rules;
    }

    private Rule createRule(StyleFactory sf, SimpleFeatureSource featureSource, ChartProperties cp) {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        LineSymbolizer symbolizer = null;
        Fill fill = null;
        if (this.p.getFillColour() != null) {
            fill = sf.createFill((Expression)ff.literal((Object)this.p.getFillColour()), (Expression)ff.literal(1.0f));
        }
        Stroke stroke = null;
        if (this.p.getLineColour() != null) {
            stroke = sf.createStroke((Expression)ff.literal((Object)this.p.getLineColour()), (Expression)ff.literal((Object)this.p.getLineWidth()));
        }
        GeometryDescriptor geomDesc = ((SimpleFeatureType)featureSource.getSchema()).getGeometryDescriptor();
        String geometryAttributeName = geomDesc.getLocalName();
        switch (LayerShape.findGeometryType(geomDesc).ordinal()) {
            case 0: {
                symbolizer = sf.createPolygonSymbolizer(stroke, fill, geometryAttributeName);
                break;
            }
            case 1: {
                symbolizer = sf.createLineSymbolizer(stroke, geometryAttributeName);
                break;
            }
            case 2: {
                Mark mark = sf.getCircleMark();
                mark.setFill(fill);
                mark.setStroke(stroke);
                Graphic graphic = sf.createDefaultGraphic();
                graphic.graphicalSymbols().clear();
                graphic.graphicalSymbols().add(mark);
                graphic.setSize((Expression)ff.literal((Object)this.p.getPointSize()));
                symbolizer = sf.createPointSymbolizer(graphic, geometryAttributeName);
            }
        }
        Rule rule = sf.createRule();
        rule.symbolizers().add(symbolizer);
        if (this.p.getLabelAttribute() != null) {
            int fontSize = Math.round(cp.getFontSize(this.p.getLabelAttribute().getFontSize()) / 0.3527f);
            Symbolizer labelSymbolizer = GeotoolsUtils.createTextSymbolizer(this.p.getLabelAttribute().getAttributeName(), cp.foreground, cp.font, fontSize);
            rule.symbolizers().add(labelSymbolizer);
        }
        return rule;
    }

    private static GeomType findGeometryType(GeometryDescriptor geomDesc) {
        Class clazz = geomDesc.getType().getBinding();
        if (Polygon.class.isAssignableFrom(clazz) || MultiPolygon.class.isAssignableFrom(clazz)) {
            return GeomType.POLYGON;
        }
        if (LineString.class.isAssignableFrom(clazz) || MultiLineString.class.isAssignableFrom(clazz)) {
            return GeomType.LINE;
        }
        return GeomType.POINT;
    }

    @Override
    public LayerShapeProperties getProperties() {
        return this.p;
    }

    @Override
    protected Class<? extends PanelProperties> getPropertiesClass() {
        return LayerShapeProperties.class;
    }

    @Override
    public String summaryString() {
        return this.p.getShapeStoreName() + " / " + this.p.getFeatureTypeName();
    }

    @Override
    public Optional<SimpleFeatureSource> getFeatureSource() {
        return Optional.ofNullable(this.cachedFeatureSource);
    }

    private static enum GeomType {
        POLYGON,
        LINE,
        POINT;

    }
}

