/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel.spatial;

import jsbchart.panel.BasicPanelProperties;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelPropertyItem;
import jsbchart.panel.PanelType;
import jsbchart.util.colour.ColourSpectrum;
import model3.IGDScheme;

public class LayerSuCropProperties
extends BasicPanelProperties {
    private final PanelPropertyItem<CropType> type = PanelPropertyItem.nonNullable("Type", CropType.SUB);
    private final PanelPropertyItem<IGDScheme> scheme = PanelPropertyItem.nullable("Scheme", IGDScheme.class);
    private final PanelPropertyItem<ColourOption> colourOption = PanelPropertyItem.nonNullable("Colours", ColourOption.INHERIT);
    private final PanelPropertyItem<ColourSpectrum> spectrum = PanelPropertyItem.nonNullable("Spectrum", new ColourSpectrum());

    public LayerSuCropProperties() {
        super(PanelType.S_CROP_LAYER);
        this.items.add(this.type);
        this.items.add(this.scheme);
        this.items.add(this.colourOption);
        this.items.add(this.spectrum);
    }

    public LayerSuCropProperties(String props, IGDScheme scheme) {
        this();
        this.scheme.setValue(scheme);
        this.setValuesFromPropertiesString(props);
    }

    @Override
    public boolean showRow(int row) {
        if (row == this.items.indexOf(this.spectrum)) {
            return this.getColourOption() != ColourOption.INHERIT;
        }
        return true;
    }

    @Override
    public boolean hasShowRowDependencies(int nProp) {
        return nProp == this.items.indexOf(this.colourOption);
    }

    public CropType getCropType() {
        return this.type.getValue();
    }

    public IGDScheme getScheme() {
        return this.scheme.getValue();
    }

    public ColourOption getColourOption() {
        return this.colourOption.getValue();
    }

    public ColourSpectrum getSpectrum() {
        return this.spectrum.getValue();
    }

    @Override
    public int getIGDSchemeID() {
        if (this.scheme.getValue() != null) {
            return this.scheme.getValue().getID();
        }
        return super.getIGDSchemeID();
    }

    @Override
    public LayerSuCropProperties copy() {
        LayerSuCropProperties p = new LayerSuCropProperties();
        p.copy(this);
        return p;
    }

    @Override
    public void copy(PanelProperties pp) {
        if (pp == null) {
            throw new NullPointerException("Cannot copy null panel properties");
        }
        if (!(pp instanceof LayerSuCropProperties)) {
            throw new IllegalArgumentException(this.getClass().getName() + " cannot copy " + pp.getClass().getName());
        }
        LayerSuCropProperties rhs = (LayerSuCropProperties)pp;
        for (int i = 0; i < this.getnProps(); ++i) {
            this.setProperty(i, rhs.getProperty(i));
        }
    }

    @Override
    public boolean isSimilarTo(PanelProperties comp) {
        if (comp instanceof LayerSuCropProperties) {
            LayerSuCropProperties l = (LayerSuCropProperties)comp;
            return l.type.getValue() == this.type.getValue() && l.scheme.getValue() == this.scheme.getValue();
        }
        return false;
    }

    @Override
    public Class<?> getPropertyClass(int nProp) {
        if (this.items.get(nProp) == this.scheme) {
            return IGDScheme[].class;
        }
        return super.getPropertyClass(nProp);
    }

    public static enum CropType {
        SUB("sub-crop"),
        SUPRA("supra-crop"),
        COMBINED("combined");

        final String description;

        private CropType(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }

    public static enum ColourOption {
        INHERIT("inherit from data"),
        ALTERNATIVE("always use alternative spectrum"),
        SIMILARITY("use alternative if inherited colours are similar");

        final String description;

        private ColourOption(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }
}

