/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel.spatial;

import com.stratadata.model3.Discipline;
import jsbchart.panel.BasicPanelProperties;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelPropertyItem;
import jsbchart.panel.PanelType;
import model3.TxGroupSet;

public class LayerTaxonProperties
extends BasicPanelProperties {
    private final PanelPropertyItem<Discipline> disc = PanelPropertyItem.nonNullable("Discipline", Discipline.PALY);
    private final PanelPropertyItem<Group> group = PanelPropertyItem.nonNullable("Group data by", Group.CAT);
    private final PanelPropertyItem<TxGroupSet> groupSet = PanelPropertyItem.nullable("Group Set", TxGroupSet.class);
    private final PanelPropertyItem<Boolean> excludeBarren = PanelPropertyItem.nonNullable("Exclude barren analyses", false);

    public boolean isExcludeBarren() {
        return this.excludeBarren.getValue();
    }

    public LayerTaxonProperties() {
        super(PanelType.SETLAYER);
        this.items.add(this.disc);
        this.items.add(this.group);
        this.items.add(this.groupSet);
        this.items.add(this.excludeBarren);
    }

    public LayerTaxonProperties(String props, TxGroupSet txGroupSet) {
        super(PanelType.SETLAYER);
        this.items.add(this.disc);
        this.items.add(this.group);
        this.items.add(this.groupSet);
        this.items.add(this.excludeBarren);
        this.groupSet.setValue(txGroupSet);
        this.setValuesFromPropertiesString(props);
    }

    @Override
    public boolean showRow(int row) {
        if (row == this.items.indexOf(this.groupSet)) {
            return this.group() == Group.GROUP;
        }
        return true;
    }

    @Override
    public boolean hasShowRowDependencies(int nProp) {
        return nProp == this.items.indexOf(this.group);
    }

    public Discipline disc() {
        return this.disc.getValue();
    }

    public TxGroupSet groupSet() {
        return this.groupSet.getValue();
    }

    public Group group() {
        return this.group.getValue();
    }

    @Override
    public int getGrpSetID() {
        if (this.groupSet.getValue() != null) {
            return this.groupSet.getValue().getID();
        }
        return 0;
    }

    @Override
    public boolean allowNull(int nProp) {
        return ((PanelPropertyItem)this.items.get(nProp)).isNullable();
    }

    @Override
    public PanelProperties copy() {
        LayerTaxonProperties p = new LayerTaxonProperties();
        p.copy(this);
        return p;
    }

    @Override
    public void copy(PanelProperties pp) {
        if (pp == null) {
            throw new NullPointerException("Cannot copy null panel properties");
        }
        if (!(pp instanceof LayerTaxonProperties)) {
            throw new IllegalArgumentException(this.getClass().getName() + " cannot copy " + pp.getClass().getName());
        }
        LayerTaxonProperties rhs = (LayerTaxonProperties)pp;
        for (int i = 0; i < this.getnProps(); ++i) {
            this.setProperty(i, rhs.getProperty(i));
        }
    }

    @Override
    public boolean isSimilarTo(PanelProperties comp) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static enum Group {
        CAT("categories"),
        GROUP("groups in set"),
        GENUS("genera");

        final String description;

        private Group(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }
}

