/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel.spatial;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import jsbchart.block.MapBlock;
import jsbchart.core.ChartProperties;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.spatial.LayerWellLocationProperties;
import jsbchart.panel.spatial.LayerWellLocationWithSelectionProperties;
import jsbchart.panel.spatial.SBPointDataLayer;
import model3.Well;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.style.AnchorPoint;
import org.geotools.api.style.Displacement;
import org.geotools.api.style.Fill;
import org.geotools.api.style.Font;
import org.geotools.api.style.Graphic;
import org.geotools.api.style.LabelPlacement;
import org.geotools.api.style.Mark;
import org.geotools.api.style.PointPlacement;
import org.geotools.api.style.Stroke;
import org.geotools.api.style.StyleFactory;
import org.geotools.api.style.Symbolizer;
import org.geotools.api.style.TextSymbolizer;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;

public class LayerWellLocationWithSelection
extends SBPointDataLayer {
    private LayerWellLocationWithSelectionProperties p;

    public LayerWellLocationWithSelection(PanelTemplate template, PanelOcc panelOcc, MapBlock block) {
        super(template, panelOcc == null ? new PanelOcc(template.getID()) : panelOcc, block);
        this.p = template != null ? (LayerWellLocationWithSelectionProperties)template.getProperties() : new LayerWellLocationWithSelectionProperties();
    }

    @Override
    public void addFeatureTypeAttributes(SimpleFeatureTypeBuilder builder) {
    }

    @Override
    public void setFeatureAttributes(Well well, SimpleFeatureBuilder builder) {
    }

    @Override
    public void setData(ChartProperties cp) {
    }

    @Override
    public Collection<Symbolizer> getNotSelectedWellSymbolizers(ChartProperties cp) {
        LinkedList<Symbolizer> symbolizers = new LinkedList<Symbolizer>();
        if (this.p.showLabels()) {
            symbolizers.add(this.createTextSymbolizer(cp));
        }
        if (this.p.showCorrelation()) {
            symbolizers.add(this.createLineSymbolizer(cp));
        }
        symbolizers.add(this.createPointSymbolizer(this.p.pinColour(), this.p.pinSize()));
        return symbolizers;
    }

    @Override
    public Collection<Symbolizer> getSelectedWellSymbolizers(ChartProperties cp) {
        LinkedList<Symbolizer> symbolizers = new LinkedList<Symbolizer>();
        symbolizers.add(this.createPointSymbolizer(this.p.selectedPinColour(), this.p.selectedPinSize()));
        if (this.p.showSelectedLabels().booleanValue()) {
            symbolizers.add(this.createTextSymbolizer(cp));
        }
        if (this.p.showCorrelation()) {
            symbolizers.add(this.createLineSymbolizer(cp));
        }
        return symbolizers;
    }

    @Override
    public int preferredSize() {
        return -1;
    }

    @Override
    public Optional<String> getChartParameterString(ChartProperties cp) {
        return Optional.ofNullable(null);
    }

    private Symbolizer createPointSymbolizer(Color c, int pinSize) {
        StyleFactory sf = CommonFactoryFinder.getStyleFactory();
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        Literal fillColour = c != null ? ff.literal((Object)c) : ff.property("well_c");
        Fill fill = sf.fill(null, (Expression)fillColour, (Expression)ff.literal(1.0));
        ArrayList<Mark> symbols = new ArrayList<Mark>();
        symbols.add(sf.mark((Expression)ff.literal((Object)"circle"), fill, null));
        Expression opacity = null;
        Literal size = ff.literal(pinSize);
        Expression rotation = null;
        AnchorPoint anchor = null;
        Displacement displacement = null;
        Graphic wellGraphic = sf.graphic(symbols, opacity, (Expression)size, rotation, anchor, displacement);
        return sf.pointSymbolizer("point", (Expression)ff.property("the_geom"), null, null, wellGraphic);
    }

    private Symbolizer createLineSymbolizer(ChartProperties cp) {
        StyleFactory sf = CommonFactoryFinder.getStyleFactory();
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        Stroke stroke = sf.getDefaultStroke();
        stroke.setWidth((Expression)ff.literal(0.5));
        stroke.setColor((Expression)ff.literal((Object)cp.foreground));
        return sf.createLineSymbolizer(stroke, "line_geom");
    }

    private Symbolizer createTextSymbolizer(ChartProperties cp) {
        StyleFactory sf = CommonFactoryFinder.getStyleFactory();
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        TextSymbolizer ts = sf.createTextSymbolizer();
        ts.setLabel((Expression)ff.property(switch (this.p.getLabelType()) {
            default -> "well_name";
            case LayerWellLocationProperties.WellLabel.CODE -> "well_code";
            case LayerWellLocationProperties.WellLabel.ALT -> "well_alt_name";
            case LayerWellLocationProperties.WellLabel.NAMECODE -> "well_namecode";
            case LayerWellLocationProperties.WellLabel.NAMEALT -> "well_namealt";
        }));
        ts.setFill(sf.createFill((Expression)ff.literal((Object)cp.foreground)));
        int fontSize = Math.round(cp.getFontSize() / 0.3527f);
        Literal family = ff.literal((Object)cp.font);
        Literal style = ff.literal((Object)"normal");
        Literal weight = ff.literal((Object)"normal");
        Literal size = ff.literal(fontSize);
        Font font = sf.createFont((Expression)family, (Expression)style, (Expression)weight, (Expression)size);
        ts.setFont(font);
        AnchorPoint anchorPoint = sf.createAnchorPoint((Expression)ff.literal(0.5), (Expression)ff.literal(0));
        Displacement displacement = sf.createDisplacement((Expression)ff.literal(0), (Expression)ff.literal(fontSize / 2));
        PointPlacement labelPlacement = sf.createPointPlacement(anchorPoint, displacement, null);
        ts.setLabelPlacement((LabelPlacement)labelPlacement);
        Map options = ts.getOptions();
        options.put("maxDisplacement", "1000");
        return ts;
    }

    @Override
    public LayerWellLocationWithSelectionProperties getProperties() {
        return this.p;
    }

    @Override
    protected Class<? extends PanelProperties> getPropertiesClass() {
        return LayerWellLocationProperties.class;
    }

    @Override
    public String summaryString() {
        LinkedList<String> strings = new LinkedList<String>();
        strings.add(this.p.showLabels() ? "labels" : "no labels");
        strings.add(this.p.getLabelType().toString());
        return String.join((CharSequence)", ", strings);
    }
}

