/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel.spatial;

import java.util.Objects;
import jsbchart.core.ChartProperties;

public class MapLabelAttribute {
    private final String attributeName;
    private final ChartProperties.FontSizeExtended fontSize;

    public MapLabelAttribute(String attributeName, ChartProperties.FontSizeExtended fontSize) {
        this.attributeName = attributeName;
        this.fontSize = fontSize;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public ChartProperties.FontSizeExtended getFontSize() {
        return this.fontSize;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapLabelAttribute that = (MapLabelAttribute)o;
        return Objects.equals(this.attributeName, that.attributeName) && this.fontSize == that.fontSize;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.attributeName, this.fontSize});
    }

    public static MapLabelAttribute fromString(String s) {
        int i = s.lastIndexOf(58);
        String name = s.substring(0, i);
        String fontSizeString = s.substring(i + 1);
        ChartProperties.FontSizeExtended fontSize = MapLabelAttribute.matchFontSizeOrDefault(fontSizeString, ChartProperties.FontSizeExtended.SMALL);
        return new MapLabelAttribute(name, fontSize);
    }

    private static ChartProperties.FontSizeExtended matchFontSizeOrDefault(String stringValue, ChartProperties.FontSizeExtended defaultValue) {
        ChartProperties.FontSizeExtended value = defaultValue;
        for (ChartProperties.FontSizeExtended f : ChartProperties.FontSizeExtended.values()) {
            if (!f.name().equals(stringValue)) continue;
            value = f;
            break;
        }
        return value;
    }

    public String toString() {
        return this.attributeName;
    }

    public String getStringValue() {
        return this.attributeName + ":" + this.fontSize.name();
    }
}

