/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel.spatial;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import jsbchart.SVGFillArtist;
import jsbchart.block.MapBlock;
import jsbchart.core.ChartProperties;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.graphics.FillType;
import jsbchart.graphics.map.GeotoolsSymbolizerHelper;
import jsbchart.graphics.text.MapFill;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.spatial.SBLayerFactory;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.Fill;
import org.geotools.api.style.Graphic;
import org.geotools.api.style.Mark;
import org.geotools.api.style.PolygonSymbolizer;
import org.geotools.api.style.Rule;
import org.geotools.api.style.Stroke;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyleFactory;
import org.geotools.api.style.Symbolizer;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.styling.SLD;
import org.geotools.styling.StyleBuilder;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;

public class PolygonLayer
extends SBLayerFactory {
    private Coordinate[] coordinates = null;
    private MapFill fill = new MapFill(FillType.CIRCLES, Color.BLUE, 10.0f, 1.0f, Color.black, 0.5f, Color.white, 0.5f, Color.black);
    private String svgFill = null;

    public PolygonLayer(PanelTemplate template, PanelOcc panelOcc, MapBlock block) {
        super(template, panelOcc, block);
    }

    @Override
    public PanelProperties getProperties() {
        return null;
    }

    @Override
    public void setData(ChartProperties cp) {
    }

    @Override
    public String summaryString() {
        return null;
    }

    public void setCoordinates(Coordinate[] coordinates) {
        this.coordinates = coordinates;
    }

    public MapFill getFill() {
        return this.fill;
    }

    public void setFill(MapFill fill) {
        this.fill = fill;
    }

    public String getSVGFill() {
        return this.svgFill;
    }

    public void setSVGFill(String svg) {
        this.svgFill = svg;
    }

    @Override
    public Layer createLayer(ChartProperties cp) {
        SimpleFeatureType polygonFeatureType = this.createPolygonFeatureType();
        GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory();
        SimpleFeatureBuilder polygonFeatureBuilder = new SimpleFeatureBuilder(polygonFeatureType);
        ArrayList<SimpleFeature> features = new ArrayList<SimpleFeature>();
        features.add(this.buildPolygonFeature(polygonFeatureBuilder, geometryFactory));
        SimpleFeatureCollection featureCollection = DataUtilities.collection(features);
        Style style = this.buildStyle();
        FeatureLayer l = new FeatureLayer((FeatureCollection)featureCollection, style);
        return l;
    }

    private Style buildStyle() {
        Style style;
        StyleBuilder sb = new StyleBuilder();
        StyleFactory sf = CommonFactoryFinder.getStyleFactory();
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        int iconSize = (int)(this.fill.getMarkerSize() * 2.8346457f);
        int iconGap = (int)(this.fill.getMarkerGap() * 2.8346457f);
        if (this.svgFill != null) {
            SVGFillArtist artist = new SVGFillArtist();
            artist.loadSVGFromString(this.svgFill);
            ImageIcon iconFill = artist.buildIcon(iconSize, iconGap, this.fill.getFillColour(), this.fill.getBackgroundColour());
            style = this.buildIconStyle(iconFill);
        } else if (this.fill.getType().getSvgString() != null) {
            SVGFillArtist artist = new SVGFillArtist();
            artist.loadSVGFromString(this.fill.getType().getSvgString());
            ImageIcon iconFill = artist.buildIcon(iconSize, iconGap, this.fill.getFillColour(), this.fill.getBackgroundColour());
            style = this.buildIconStyle(iconFill);
        } else {
            style = this.buildSolidFillStyle(this.fill.getStrokeColour(), this.fill.getFillColour());
        }
        return style;
    }

    private Style buildSolidFillStyle(Color strokeColor, Color fillColor) {
        return SLD.createPolygonStyle((Color)this.fill.getStrokeColour(), (Color)this.fill.getFillColour(), (float)1.0f);
    }

    private Style buildBasicFillStyle(MapFill fill) {
        StyleBuilder sb = new StyleBuilder();
        StyleFactory sf = CommonFactoryFinder.getStyleFactory();
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        Rule rule = sf.createRule();
        Stroke markerStroke = sf.createStroke((Expression)ff.literal((Object)fill.getMarkerStrokeColour()), (Expression)ff.literal(fill.getMarkerStrokeSize()));
        Stroke stroke = sf.createStroke((Expression)ff.literal((Object)fill.getStrokeColour()), (Expression)ff.literal(fill.getStrokeSize()));
        Mark m = sf.getDefaultMark();
        m.setWellKnownName((Expression)ff.literal((Object)fill.getType().getWellKnownName()));
        m.setFill(sf.createFill((Expression)ff.literal((Object)fill.getFillColour()), (Expression)ff.literal(1)));
        m.setStroke(markerStroke);
        Graphic g = sf.createDefaultGraphic();
        g.graphicalSymbols().clear();
        g.graphicalSymbols().add(m);
        g.setSize((Expression)ff.literal(fill.getMarkerSize()));
        g.setDisplacement(sf.displacement((Expression)ff.literal(fill.getMarkerGap()), (Expression)ff.literal(fill.getMarkerGap())));
        g.setRotation((Expression)ff.literal(45));
        Fill f = sf.createFill((Expression)ff.literal((Object)fill.getFillColour()), null, (Expression)ff.literal(1), g);
        PolygonSymbolizer symbolizer = sf.createPolygonSymbolizer(stroke, f, (String)null);
        if (fill.getMarkerGap() > 0.0f) {
            String marginString = fill.getMarkerGap() + " " + fill.getMarkerGap() + " " + fill.getMarkerGap() + " " + fill.getMarkerGap();
            symbolizer.getOptions().put("graphic-margin", marginString);
        }
        if (fill.getBackgroundColour() != null) {
            Fill f2 = sf.createFill((Expression)ff.literal((Object)fill.getBackgroundColour()), null, (Expression)ff.literal(1), null);
            PolygonSymbolizer sym2 = sf.createPolygonSymbolizer(stroke, f2, (String)null);
            rule.symbolizers().add(sym2);
        }
        rule.symbolizers().add(symbolizer);
        FeatureTypeStyle fts = sb.createFeatureTypeStyle("Polygon", new Rule[]{rule});
        Style style = sf.createStyle();
        style.featureTypeStyles().add(fts);
        return style;
    }

    private Style buildSBFillStyle(MapFill fill) {
        StyleFactory sf = CommonFactoryFinder.getStyleFactory();
        switch (fill.getType()) {
            default: 
        }
        ImageIcon icon = PolygonLayer.buildSquareIcon((int)(fill.getMarkerSize() * 100.0f), (int)(fill.getMarkerGap() * 100.0f), fill.getFillColour(), fill.getBackgroundColour());
        return this.buildIconStyle(icon);
    }

    private Style buildIconStyle(ImageIcon icon) {
        StyleBuilder sb = new StyleBuilder();
        StyleFactory sf = CommonFactoryFinder.getStyleFactory();
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        Rule rule = sf.createRule();
        if (this.fill.getBackgroundColour() != null) {
            rule.symbolizers().add(GeotoolsSymbolizerHelper.buildSolidColourSymbolizer(this.fill.getBackgroundColour(), this.fill.getStrokeColour(), this.fill.getStrokeSize()));
        }
        Symbolizer iconSymbolizer = GeotoolsSymbolizerHelper.buildIconSymbolizer(icon, this.fill.getMarkerSize(), this.fill.getFillColour(), this.fill.getStrokeColour(), this.fill.getStrokeSize());
        rule.symbolizers().add(iconSymbolizer);
        FeatureTypeStyle fts = sb.createFeatureTypeStyle("Polygon", new Rule[]{rule});
        Style style = sf.createStyle();
        style.featureTypeStyles().add(fts);
        return style;
    }

    private static ImageIcon buildCircleIcon(int size, int padding, Color fillColour, Color background) {
        BufferedImage img = new BufferedImage(size + padding, size + padding, 1);
        Graphics2D g2dIcon = (Graphics2D)img.getGraphics();
        g2dIcon.setColor(background);
        g2dIcon.fillRect(0, 0, img.getWidth(), img.getHeight());
        g2dIcon.setColor(fillColour);
        g2dIcon.fill(new Ellipse2D.Double(0.0, 0.0, size, size));
        ImageIcon icon = new ImageIcon(img);
        return icon;
    }

    private static ImageIcon buildSquareIcon(int size, int padding, Color fillColour, Color background) {
        BufferedImage img = new BufferedImage(size + padding, size + padding, 1);
        Graphics2D g2dIcon = (Graphics2D)img.getGraphics();
        g2dIcon.setColor(background);
        g2dIcon.fillRect(0, 0, img.getWidth(), img.getHeight());
        g2dIcon.setColor(fillColour);
        g2dIcon.fillRect(0, 0, size, size);
        ImageIcon icon = new ImageIcon(img);
        return icon;
    }

    private static ImageIcon buildCrossIcon(int size, int width, int padding, Color fillColour, Color background) {
        BufferedImage img = new BufferedImage(size + padding, size + padding, 1);
        Graphics2D g2dIcon = (Graphics2D)img.getGraphics();
        g2dIcon.setColor(background);
        g2dIcon.fillRect(0, 0, img.getWidth(), img.getHeight());
        g2dIcon.setColor(fillColour);
        int halfSize = (int)((double)size * 0.5);
        int halfWidth = (int)((double)width * 0.5);
        g2dIcon.fillRect(halfSize - halfWidth, 0, width, size);
        g2dIcon.fillRect(0, halfSize - halfWidth, size, width);
        ImageIcon icon = new ImageIcon(img);
        return icon;
    }

    private static ImageIcon buildSlashIcon(int size, int width, int padding, Color fillColour, Color background) {
        BufferedImage img = new BufferedImage(size + padding, size + padding, 1);
        Graphics2D g2dIcon = (Graphics2D)img.getGraphics();
        g2dIcon.setColor(background);
        g2dIcon.fillRect(0, 0, img.getWidth(), img.getHeight());
        g2dIcon.setColor(fillColour);
        g2dIcon.setStroke(new BasicStroke(width, 0, 2, 10.0f));
        g2dIcon.drawLine(0, 0, size, size);
        ImageIcon icon = new ImageIcon(img);
        return icon;
    }

    public SimpleFeature buildPolygonFeature(SimpleFeatureBuilder featureBuilder, GeometryFactory geometryFactory) {
        Coordinate[] coordList = this.coordinates;
        if (coordList == null) {
            coordList = new Coordinate[]{new Coordinate(-5.0, 40.0), new Coordinate(-5.0, 60.0), new Coordinate(5.0, 60.0), new Coordinate(5.0, 40.0), new Coordinate(-5.0, 40.0)};
        }
        Polygon p = geometryFactory.createPolygon(coordList);
        featureBuilder.add((Object)p);
        return featureBuilder.buildFeature(null);
    }

    public SimpleFeatureType createPolygonFeatureType() {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("Polygon");
        builder.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        builder.add("the_geom", Polygon.class);
        return builder.buildFeatureType();
    }
}

