/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel.spatial;

import com.stratadata.util.delete.RelatedRecordException;
import com.stratadata.util.delete.RelatedRecordInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import jsbchart.panel.spatial.SBShapeFileException;
import jsbchart.panel.spatial.SBShapeStore;
import jsbchart.panel.spatial.ShapeStoreNotFoundException;
import jsbchart.panel.spatial.ShapeStoreService;
import jsbchart.panel.spatial.ShapefileFileFinder;
import model3.ConnectionProvider;
import model3.exception.SuppressedSQLException;

public class ShapeStoreServiceImpl
implements ShapeStoreService {
    private static final String TABLE_NAME = "SHAPESTORE";
    private static final String TABLE_NAME_FILES = "SHAPESTORE_DATA";
    private static final Logger LOGGER = Logger.getLogger(ShapeStoreServiceImpl.class.getName());
    private final ConnectionProvider connectionProvider;
    private final Map<Integer, SBShapeStore> cache = new HashMap<Integer, SBShapeStore>();
    private boolean allLoaded = false;

    public ShapeStoreServiceImpl(ConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
    }

    @Override
    public SBShapeStore getShapeStore(int shapeStoreID) {
        SBShapeStore shapeStore = this.cache.get(shapeStoreID);
        if (shapeStore == null) {
            shapeStore = this.loadShapeStore(shapeStoreID);
            this.cache.put(shapeStoreID, shapeStore);
        }
        return shapeStore;
    }

    @Override
    public void putShapeStore(SBShapeStore shapeStore) {
        this.cache.put(shapeStore.getShapeStoreID(), shapeStore);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SBShapeStore loadShapeStore(int shapeStoreID) {
        String sql = "SELECT TYPE,NAME,URL,LONGFIRST FROM " + this.connectionProvider.DBTableName(TABLE_NAME) + " WHERE ID=" + shapeStoreID;
        try (Statement stmt = this.connectionProvider.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.connectionProvider.modQuery(sql));
            if (!rs.next()) throw new ShapeStoreNotFoundException(shapeStoreID);
            SBShapeStore.StoreType type = SBShapeStore.StoreType.valueOf(rs.getString("TYPE"));
            String name = rs.getString("NAME");
            String url = rs.getString("URL");
            boolean longitudeFirst = rs.getBoolean("LONGFIRST");
            SBShapeStore sBShapeStore = SBShapeStore.createShapeStore(shapeStoreID, type, name, url, longitudeFirst);
            return sBShapeStore;
        }
        catch (SQLException sqle) {
            throw new RuntimeException(sqle);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void initShapeStore(SBShapeStore shapeStore) {
        File shapeFileDir;
        if (shapeStore.getStoreType() != SBShapeStore.StoreType.FILE) {
            return;
        }
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        File tempShapeFileDir = new File(tempDir, "sbugs_shapefiles");
        if (!tempShapeFileDir.exists()) {
            tempShapeFileDir.mkdir();
        }
        if ((shapeFileDir = new File(tempShapeFileDir, shapeStore.getUrl())).exists()) {
            File shpFile = new File(shapeFileDir, shapeStore.getUrl() + ".shp");
            if (shpFile.exists()) {
                LOGGER.log(Level.INFO, "Temporary directory already exists for shapefile: {0}", shapeFileDir.getPath());
                return;
            }
            shapeFileDir.delete();
        }
        shapeFileDir.mkdir();
        String sql = "SELECT FILENAME,SHAPE_DATA FROM " + this.connectionProvider.DBTableName(TABLE_NAME_FILES) + " WHERE SHAPESTORE_ID=" + shapeStore.getShapeStoreID();
        try (Statement stmt = this.connectionProvider.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.connectionProvider.modQuery(sql));
            while (rs.next()) {
                String filename = rs.getString("FILENAME");
                try {
                    byte[] buffer = rs.getBytes("SHAPE_DATA");
                    File targetFile = new File(shapeFileDir, filename);
                    try (FileOutputStream outStream = new FileOutputStream(targetFile);){
                        ((OutputStream)outStream).write(buffer);
                    }
                }
                catch (IOException ioe) {
                    throw new SBShapeFileException("Error writing blob to temporary file", ioe);
                    return;
                }
            }
        }
        catch (SQLException e) {
            throw SuppressedSQLException.withoutRollback((SQLException)e);
        }
    }

    @Override
    public SBShapeStore storeShapeStore(SBShapeStore shapeStore) {
        SBShapeStore sBShapeStore;
        block28: {
            if (shapeStore.getShapeStoreID() > 0) {
                throw new IllegalArgumentException("Wrong method for storing SBShapeStore");
            }
            String shapeStoreURL = shapeStore.getUrl();
            List<File> shapeFiles = null;
            List<ZipEntry> shapeFilesZipEntries = null;
            ZipFile zipFile = null;
            if (shapeStore.getStoreType() == SBShapeStore.StoreType.FILE) {
                if (shapeStore.getZipFile() == null) {
                    shapeFiles = ShapeStoreServiceImpl.getShapeFiles(shapeStore.getUrl());
                    String firstFileName = shapeFiles.get(0).getName();
                    shapeStoreURL = firstFileName.substring(0, firstFileName.lastIndexOf("."));
                } else {
                    try {
                        zipFile = new ZipFile(shapeStore.getZipFile());
                    }
                    catch (IOException ze) {
                        throw new IllegalArgumentException("Unable to open SBShapeStore zip file: " + ze.getMessage() + "\n" + shapeStore.getZipFile().getPath());
                    }
                    shapeFilesZipEntries = new ShapefileFileFinder().findShapefileZipEntries(shapeStore.getUrl(), zipFile);
                    shapeStoreURL = shapeStore.getUrl();
                }
            }
            String sql = "INSERT INTO " + this.connectionProvider.DBTableName(TABLE_NAME) + " (ID,TYPE,NAME,URL,LONGFIRST) VALUES (?,?,?,?,?)";
            PreparedStatement pStmt = this.connectionProvider.getDatabase().prepareStatement(this.connectionProvider.modQuery(sql));
            try {
                int shapeStoreID = this.connectionProvider.nextControl(TABLE_NAME, "ID");
                pStmt.setInt(1, shapeStoreID);
                pStmt.setString(2, shapeStore.getStoreType().name());
                pStmt.setString(3, shapeStore.getName());
                pStmt.setString(4, shapeStoreURL);
                pStmt.setBoolean(5, shapeStore.isLongitudeFirst());
                pStmt.executeUpdate();
                if (shapeFiles != null || shapeFilesZipEntries != null) {
                    int nEntries = shapeFiles != null ? shapeFiles.size() : shapeFilesZipEntries.size();
                    String sql2 = "INSERT INTO " + this.connectionProvider.DBTableName(TABLE_NAME_FILES) + " (SHAPESTORE_ID,FILENAME,SHAPE_DATA) VALUES (?,?,?)";
                    try (PreparedStatement pStmt2 = this.connectionProvider.getDatabase().prepareStatement(this.connectionProvider.modQuery(sql2));){
                        for (int i = 0; i < nEntries; ++i) {
                            pStmt2.setInt(1, shapeStoreID);
                            if (shapeFiles != null) {
                                File file = shapeFiles.get(i);
                                Path path = file.toPath();
                                byte[] allBytes = Files.readAllBytes(path);
                                pStmt2.setString(2, file.getName());
                                pStmt2.setBytes(3, allBytes);
                            } else {
                                ZipEntry entry = shapeFilesZipEntries.get(i);
                                pStmt2.setString(2, entry.getName());
                                pStmt2.setBinaryStream(3, zipFile.getInputStream(entry));
                            }
                            pStmt2.executeUpdate();
                        }
                    }
                }
                this.connectionProvider.commit();
                SBShapeStore ss = SBShapeStore.createShapeStore(shapeStoreID, shapeStore.getStoreType(), shapeStore.getName(), shapeStoreURL, shapeStore.isLongitudeFirst());
                this.cache.put(shapeStoreID, ss);
                sBShapeStore = ss;
                if (pStmt == null) break block28;
            }
            catch (Throwable shapeStoreID) {
                try {
                    if (pStmt != null) {
                        try {
                            pStmt.close();
                        }
                        catch (Throwable throwable) {
                            shapeStoreID.addSuppressed(throwable);
                        }
                    }
                    throw shapeStoreID;
                }
                catch (IOException ioe) {
                    try {
                        this.connectionProvider.doRollback();
                    }
                    catch (Exception sqlExCausedByRollback) {
                        LOGGER.warning("Could not roll back database");
                        sqlExCausedByRollback.printStackTrace();
                    }
                    throw new SBShapeFileException("Error reading shapefile data", ioe);
                }
                catch (SQLException sqle) {
                    throw SuppressedSQLException.withRollback((String)"Error storing shapeStore", (SQLException)sqle, (ConnectionProvider)this.connectionProvider);
                }
            }
            pStmt.close();
        }
        return sBShapeStore;
    }

    @Override
    public SBShapeStore updateShapeStore(SBShapeStore shapeStore, SBShapeStore newValues) {
        if (shapeStore.getShapeStoreID() <= 0) {
            throw new IllegalArgumentException("Cannot update unstored shapeStore");
        }
        String sql = "UPDATE " + this.connectionProvider.DBTableName(TABLE_NAME) + " SET NAME=?, LONGFIRST=? WHERE ID=?";
        try (PreparedStatement pStmt = this.connectionProvider.getDatabase().prepareStatement(this.connectionProvider.modQuery(sql));){
            pStmt.setString(1, newValues.getName());
            pStmt.setBoolean(2, newValues.isLongitudeFirst());
            pStmt.setInt(3, shapeStore.getShapeStoreID());
            pStmt.executeUpdate();
            this.connectionProvider.commit();
        }
        catch (SQLException sqle) {
            throw SuppressedSQLException.withRollback((String)"Error updating shapeStore", (SQLException)sqle, (ConnectionProvider)this.connectionProvider);
        }
        shapeStore.setName(newValues.getName());
        shapeStore.setLongitudeFirst(newValues.isLongitudeFirst());
        return shapeStore;
    }

    private static List<File> getShapeFiles(String filePath) {
        return new ShapefileFileFinder().findShapefileFiles(filePath);
    }

    @Override
    public void deleteShapeStore(SBShapeStore shapeStore) throws RelatedRecordException {
        String checkDeleteQuery = "SELECT count(panel_id) as nPanels FROM " + this.connectionProvider.DBTableName("CHTPANL") + " WHERE SHAPE_ID=" + shapeStore.getShapeStoreID();
        String mainDeleteQuery = "DELETE FROM " + this.connectionProvider.DBTableName(TABLE_NAME) + " WHERE ID=" + shapeStore.getShapeStoreID();
        String filesDeleteQuery = "DELETE FROM " + this.connectionProvider.DBTableName(TABLE_NAME_FILES) + " WHERE SHAPESTORE_ID=" + shapeStore.getShapeStoreID();
        try (Statement stmt = this.connectionProvider.getDatabase().createStatement();){
            int count;
            ResultSet rs = stmt.executeQuery(this.connectionProvider.modQuery(checkDeleteQuery));
            if (rs.next() && (count = rs.getInt("nPanels")) > 0) {
                RelatedRecordInfo rri = new RelatedRecordInfo("layer template", count);
                throw new RelatedRecordException(rri);
            }
            stmt.execute(this.connectionProvider.modQuery(filesDeleteQuery));
            stmt.execute(this.connectionProvider.modQuery(mainDeleteQuery));
            this.connectionProvider.commit();
        }
        catch (SQLException sqle) {
            throw SuppressedSQLException.withRollback((String)"Error deleting shapeStore", (SQLException)sqle, (ConnectionProvider)this.connectionProvider);
        }
        this.cache.remove(shapeStore.getShapeStoreID());
    }

    @Override
    public List<SBShapeStore> getAllShapeStores() {
        if (!this.allLoaded) {
            String sql = "SELECT ID,TYPE,NAME,URL,LONGFIRST FROM " + this.connectionProvider.DBTableName(TABLE_NAME);
            try (Statement stmt = this.connectionProvider.getDatabase().createStatement();){
                ResultSet rs = stmt.executeQuery(this.connectionProvider.modQuery(sql));
                while (rs.next()) {
                    int shapeID = rs.getInt("ID");
                    SBShapeStore.StoreType type = SBShapeStore.StoreType.valueOf(rs.getString("TYPE"));
                    String name = rs.getString("NAME");
                    String url = rs.getString("URL");
                    boolean longitudeFirst = rs.getBoolean("LONGFIRST");
                    this.cache.put(shapeID, SBShapeStore.createShapeStore(shapeID, type, name, url, longitudeFirst));
                }
            }
            catch (SQLException sqle) {
                throw new RuntimeException(sqle);
            }
            this.allLoaded = true;
        }
        return new ArrayList<SBShapeStore>(this.cache.values());
    }
}

