/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel.spatial;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import jsbchart.panel.spatial.SBShapeFileException;

public class ShapefileFileFinder {
    private static final List<String> REQUIRED_SHAPEFILE_EXTENSIONS = List.of(".shp", ".shx", ".dbf");
    private static final List<String> OPTIONAL_SHAPEFILE_EXTENSIONS = List.of(".sbn", ".sbx", ".atx", ".fbn", ".fbx", ".ain", ".aih", ".ixs", ".mxs", ".prj", ".xml", ".cpg");

    public List<File> findShapefileFiles(String mainFilePath) {
        File shpFile = new File(mainFilePath);
        if (!shpFile.exists()) {
            throw new SBShapeFileException("No shapefile found at " + mainFilePath);
        }
        String basicPath = shpFile.getPath().substring(0, shpFile.getPath().lastIndexOf("."));
        ArrayList<File> files = new ArrayList<File>();
        for (String extension : REQUIRED_SHAPEFILE_EXTENSIONS) {
            File requiredFile = new File(basicPath + extension);
            if (!requiredFile.exists()) {
                throw new SBShapeFileException("Required shapefile not found: " + requiredFile.getPath());
            }
            files.add(requiredFile);
        }
        for (String extension : OPTIONAL_SHAPEFILE_EXTENSIONS) {
            File optionalFile = new File(basicPath + extension);
            if (!optionalFile.exists()) continue;
            files.add(optionalFile);
        }
        return files;
    }

    public List<ZipEntry> findShapefileZipEntries(String basicPath, ZipFile zipFile) {
        if (!new File(zipFile.getName()).exists()) {
            throw new SBShapeFileException("No zip for shapefile found at " + zipFile.getName());
        }
        ArrayList<ZipEntry> entries = new ArrayList<ZipEntry>();
        for (String extension : REQUIRED_SHAPEFILE_EXTENSIONS) {
            ZipEntry zipEntry = zipFile.getEntry(basicPath + extension);
            if (zipEntry == null) {
                throw new SBShapeFileException("Required zip file entry for shapefile not found: " + basicPath + extension);
            }
            entries.add(zipEntry);
        }
        for (String extension : OPTIONAL_SHAPEFILE_EXTENSIONS) {
            ZipEntry optionalZipEntry = zipFile.getEntry(basicPath + extension);
            if (optionalZipEntry == null) continue;
            entries.add(optionalZipEntry);
        }
        return entries;
    }
}

