/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel.spatial;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsbchart.block.MapBlock;
import jsbchart.core.ChartProperties;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.graphics.map.ColourWellFunction;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.spatial.LayerWellLocationProperties;
import jsbchart.panel.spatial.SBLayerFactory;
import jsbchart.panel.spatial.SidetrackLayerProperties;
import jsbchart.util.GeotoolsUtils;
import jsbchart.util.PointTransformationHelper;
import model3.TVDList;
import model3.TVDepth;
import model3.Well;
import model3.WellHeader;
import org.apache.commons.lang3.StringUtils;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.LineSymbolizer;
import org.geotools.api.style.Rule;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyleFactory;
import org.geotools.api.style.Symbolizer;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.referencing.GeodeticCalculator;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.styling.StyleBuilder;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;

public class SidetrackLayer
extends SBLayerFactory {
    private static Logger LOGGER = Logger.getLogger(SidetrackLayer.class.getName());
    private final SidetrackLayerProperties p;
    private Map<Integer, WellTrackData> trackData = new HashMap<Integer, WellTrackData>();

    public SidetrackLayer(PanelTemplate template, PanelOcc panelOcc, MapBlock block) {
        super(template, panelOcc != null ? panelOcc : new PanelOcc(template.getID()), block);
        this.p = template != null ? (SidetrackLayerProperties)template.getProperties() : new SidetrackLayerProperties();
    }

    @Override
    public PanelProperties getProperties() {
        return this.p;
    }

    @Override
    public void setData(ChartProperties cp) {
        this.trackData.clear();
        GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory();
        this.getBlock().getWellsWithLocation().forEach(well -> {
            TVDList list = null;
            try {
                list = well.getTVDlist(false);
                if (list != null) {
                    this.addTrackData((Well)well, list, geometryFactory);
                }
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, "Error extracting well list for well id " + well.getWellID(), e);
            }
        });
        this.clearCachedLayer();
    }

    @Override
    protected Class<? extends PanelProperties> getPropertiesClass() {
        return SidetrackLayerProperties.class;
    }

    private void addTrackData(Well well, TVDList list, GeometryFactory geometryFactory) {
        LinkedList<Point2D> points = this.getTrackPoints(well, list, geometryFactory);
        this.trackData.put(well.getWellID(), new WellTrackData(well, points));
    }

    private LinkedList<Point2D> getTrackPoints(Well well, TVDList list, GeometryFactory geometryFactory) {
        LinkedList<Point2D> points = null;
        if (list.getSize() > 0 && well.getHeader().hasLocation()) {
            points = new LinkedList<Point2D>();
            Point origin = this.getPoint(geometryFactory, well.getHeader());
            points.add(new Point2D.Double(origin.getX(), origin.getY()));
            GeodeticCalculator gc = new GeodeticCalculator((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            gc.setStartingGeographicPoint(origin.getX(), origin.getY());
            Iterator i = list.getIterator();
            double lastVs = 0.0;
            while (i.hasNext()) {
                TVDepth d = (TVDepth)i.next();
                if (d.getAzumith() == null || d.getVS() == null) continue;
                double hozInc = d.getVS() - lastVs;
                gc.setDirection((double)d.getAzumith().floatValue(), hozInc);
                Point2D next = gc.getDestinationGeographicPoint();
                gc.setStartingGeographicPoint(next);
                points.add(next);
                lastVs = d.getVS();
            }
            if (points.size() <= 1) {
                points = null;
            }
        }
        return points;
    }

    private Point getPoint(GeometryFactory geometryFactory, WellHeader wellHeader) {
        Point point = geometryFactory.createPoint(new Coordinate(wellHeader.getLong_dec().doubleValue(), wellHeader.getLat_dec().doubleValue()));
        String epsgCode = wellHeader.getEpsgCode(true);
        return PointTransformationHelper.transformPoint(point, epsgCode, "EPSG:4326");
    }

    @Override
    public String summaryString() {
        LinkedList<String> strings = new LinkedList<String>();
        strings.add(this.p.getShowLabels() != false ? "labels" : "no labels");
        strings.add(this.p.getLabelType().toString());
        return String.join((CharSequence)", ", strings);
    }

    @Override
    public Layer createLayer(ChartProperties cp) {
        SimpleFeatureType trackFeatureType = this.createTrackFeatureType();
        SimpleFeatureBuilder trackFeatureBuilder = new SimpleFeatureBuilder(trackFeatureType);
        GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory();
        ArrayList<SimpleFeature> trackFeatures = new ArrayList<SimpleFeature>();
        for (Integer id : this.trackData.keySet()) {
            SimpleFeature trackFeature = this.buildTrackFeature(trackFeatureBuilder, geometryFactory, id, this.trackData.get(id));
            if (trackFeature == null) continue;
            trackFeatures.add(trackFeature);
        }
        FeatureLayer l = null;
        if (trackFeatures.size() > 0) {
            SimpleFeatureCollection trackFeatureCollection = DataUtilities.collection(trackFeatures);
            Style style = this.buildSideTrackStyle(cp);
            l = new FeatureLayer((FeatureCollection)trackFeatureCollection, style);
        }
        return l;
    }

    private Style buildSideTrackStyle(ChartProperties cp) {
        StyleBuilder sb = new StyleBuilder();
        Style style = sb.createStyle();
        style.featureTypeStyles().add(this.buildTrackFeatureTypeStyle());
        if (this.p.getShowLabels().booleanValue()) {
            style.featureTypeStyles().add(this.buildTrackEndFeatureTypeStyle(cp));
        }
        return style;
    }

    private FeatureTypeStyle buildTrackFeatureTypeStyle() {
        StyleBuilder sb = new StyleBuilder();
        StyleFactory sf = CommonFactoryFinder.getStyleFactory();
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        HashMap<Integer, Color> wellColourMap = new HashMap<Integer, Color>();
        for (Integer id : this.trackData.keySet()) {
            Color c = this.trackData.get(id).well().getHeader().getColour();
            if (c == null) continue;
            wellColourMap.put(id, c);
        }
        ColourWellFunction colourFunc = new ColourWellFunction(wellColourMap);
        LineSymbolizer ls = sf.createLineSymbolizer();
        ls.setGeometryPropertyName("line_geom");
        ls.setStroke(sf.createStroke((Expression)colourFunc, (Expression)ff.literal(this.p.getLineWidth())));
        Rule primaryRule = sf.createRule();
        primaryRule.setName("primary");
        primaryRule.symbolizers().add(ls);
        FeatureTypeStyle featureTypeStyle = sb.createFeatureTypeStyle("Track", primaryRule);
        return featureTypeStyle;
    }

    private FeatureTypeStyle buildTrackEndFeatureTypeStyle(ChartProperties cp) {
        StyleBuilder sb = new StyleBuilder();
        StyleFactory sf = CommonFactoryFinder.getStyleFactory();
        Symbolizer ts = this.createTextSymbolizer(cp);
        Rule r = sf.createRule();
        r.setName("trackEndRule");
        r.symbolizers().add(ts);
        FeatureTypeStyle featureTypeStyle = sb.createFeatureTypeStyle("Track", r);
        return featureTypeStyle;
    }

    private Symbolizer createTextSymbolizer(ChartProperties cp) {
        String labelAttributeName = switch (this.p.getLabelType()) {
            default -> "well_name";
            case LayerWellLocationProperties.WellLabel.CODE -> "well_code";
            case LayerWellLocationProperties.WellLabel.ALT -> "well_alt_name";
            case LayerWellLocationProperties.WellLabel.NAMECODE -> "well_namecode";
            case LayerWellLocationProperties.WellLabel.NAMEALT -> "well_namealt";
        };
        int fontSize = Math.round(cp.getFontSize() / 0.3527f);
        return GeotoolsUtils.createTextSymbolizer(labelAttributeName, cp.foreground, cp.font, fontSize);
    }

    private SimpleFeature buildTrackFeature(SimpleFeatureBuilder fb, GeometryFactory geometryFactory, Integer id, WellTrackData data) {
        Well well = data.well();
        Coordinate[] coordinates = null;
        Point endPoint = null;
        SimpleFeature feature = null;
        if (data.path != null) {
            Point2D pathEnd = data.path().getLast();
            Coordinate endCoordinate = new Coordinate(pathEnd.getX(), pathEnd.getY());
            coordinates = new Coordinate[data.path().size()];
            int i = 0;
            for (Point2D p : data.path()) {
                coordinates[i] = new Coordinate(p.getX(), p.getY());
                ++i;
            }
            endPoint = geometryFactory.createPoint(endCoordinate);
        } else if (well.getHeader().hasLocation()) {
            endPoint = this.getPoint(geometryFactory, well.getHeader());
            coordinates = new Coordinate[]{};
        }
        if (endPoint != null && coordinates != null) {
            fb.set("the_geom", (Object)endPoint);
            LineString line = geometryFactory.createLineString(coordinates);
            fb.set("line_geom", (Object)line);
            fb.set("well_id", (Object)id);
            fb.set("well_name", (Object)well.getWellName());
            fb.set("well_code", (Object)well.getWellCode());
            fb.set("well_alt_name", (Object)(StringUtils.isNotBlank((CharSequence)well.getHeader().getWellAltName()) ? well.getHeader().getWellAltName() : well.getWellName()));
            fb.set("well_namecode", (Object)(well.getWellName() + " " + well.getWellCode()));
            fb.set("well_namealt", (Object)(well.getWellName() + (String)(StringUtils.isNotBlank((CharSequence)well.getHeader().getWellAltName()) ? " " + well.getHeader().getWellAltName() : "")));
            feature = fb.buildFeature(null);
        }
        return feature;
    }

    public SimpleFeatureType createTrackFeatureType() {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("Track");
        builder.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        builder.add("the_geom", Point.class);
        builder.add("line_geom", LineString.class);
        builder.add("well_id", Integer.class);
        builder.length(15).add("well_name", String.class);
        builder.length(15).add("well_code", String.class);
        builder.length(15).add("well_alt_name", String.class);
        builder.length(30).add("well_namecode", String.class);
        builder.length(30).add("well_namealt", String.class);
        return builder.buildFeatureType();
    }

    private record WellTrackData(Well well, LinkedList<Point2D> path) {
    }
}

