/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.tag;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import jsbchart.block.MapBlock;
import jsbchart.core.Chart;
import jsbchart.core.ChartProperties;
import jsbchart.core.IZoomManager;
import jsbchart.graphics.SBGraphics;
import jsbchart.graphics.text.HorizontalAlignment;
import jsbchart.graphics.text.SBFont;
import jsbchart.graphics.text.TextDirection;
import jsbchart.graphics.text.TextLayoutPreferences;
import jsbchart.graphics.text.VerticalAlignment;
import jsbchart.tag.ChartTag;
import jsbchart.tag.ChartTagButton;
import jsbchart.tag.ChartTagButtonType;
import org.apache.commons.lang3.ObjectUtils;
import util.RectUtils;

public class ChartTagArtist {
    private static final Logger LOGGER = Logger.getLogger(ChartTagArtist.class.getName());
    private static final float TARGET_HIGHLIGHT_DIAMETER = 5.0f;
    private BufferedImage close;
    private BufferedImage addImage;
    private BufferedImage removeImage;
    private boolean iconsLoaded = false;

    public void drawChartTagOverlay(SBGraphics g, Chart chart, IZoomManager zm) {
        chart.getTags().stream().filter(t -> t.isSelected()).forEach(tag -> {
            this.drawChartTag(g, chart, (ChartTag)((Object)tag));
            this.highlightSelectedTag(g, chart.getProperties(), (ChartTag)((Object)tag));
            g.setStroke(0.2f);
            this.drawTagButtons(g, (ChartTag)((Object)tag), zm);
            if (tag.getTarget() != null) {
                g.drawCircle(tag.getTarget().x - 2.5f, tag.getTarget().y - 2.5f, 5.0f, chart.getProperties().accent);
            }
        });
    }

    public void drawChartTags(SBGraphics g, List<ChartTag> tags, Chart chart) {
        this.getTagOrderForDrawing(tags).forEach(tag -> this.drawChartTag(g, chart, (ChartTag)((Object)tag)));
    }

    private List<ChartTag> getTagOrderForDrawing(List<ChartTag> tags) {
        Comparator<ChartTag> tagComparator = Comparator.comparing(ChartTag::isSelected).reversed().thenComparing(ChartTag::getOrder).reversed();
        List<ChartTag> sorted = tags.stream().sorted(tagComparator).toList();
        return sorted;
    }

    public List<ChartTag> getTagOrderForSelection(List<ChartTag> tags) {
        ArrayList<ChartTag> sorted = new ArrayList<ChartTag>(this.getTagOrderForDrawing(tags));
        Collections.reverse(sorted);
        return sorted;
    }

    private void drawChartTag(SBGraphics g, Chart chart, ChartTag tag) {
        Rectangle2D.Float anchorBlockBounds;
        LOGGER.log(Level.FINE, "Drawing chart tag at {0}", tag.getPosition());
        g.setStroke(tag.getProperties().getLineWeight());
        Color lineColour = (Color)ObjectUtils.defaultIfNull((Object)tag.getProperties().getLineColour(), (Object)chart.getProperties().foreground);
        Color fillColour = tag.getProperties().getFillBackground() ? (Color)ObjectUtils.defaultIfNull((Object)tag.getProperties().getFillColour(), (Object)chart.getProperties().background) : null;
        g.drawAndfillRect((Rectangle2D.Float)((Object)tag), lineColour, fillColour);
        g.setFontStyle(0);
        SBFont font = SBFont.buildFontFromGraphics(g, chart.getProperties().getFontSize(tag.getFontSize()));
        TextLayoutPreferences layout = new TextLayoutPreferences();
        layout.setHorizontalAlignment(HorizontalAlignment.Left).setVerticalAlignment(VerticalAlignment.Top).setTextDirection(TextDirection.Horizontal).setFont(font);
        layout.truncateText().wrapText();
        float padding = tag.getProperties().getLineWeight() * 0.5f + 0.5f;
        Rectangle2D.Float tagTextArea = RectUtils.makeSmallerRect((Rectangle2D.Float)tag.getArea(), (float)padding);
        g.setColor(chart.getProperties().foreground);
        g.drawStringWithinBox(tag.getText(), tagTextArea, layout);
        if (tag.getTarget() != null) {
            g.setColor((Color)ObjectUtils.defaultIfNull((Object)tag.getProperties().getLineColour(), (Object)chart.getProperties().foreground));
            Rectangle2D.Float anchorBlockBounds2 = null;
            boolean drawLineToTarget = true;
            boolean clipLine = false;
            if (tag.getAnchorBlock() != null && tag.getAnchorBlock() instanceof MapBlock) {
                anchorBlockBounds2 = chart.getBlockBounds(tag.getAnchorBlock());
                if (!anchorBlockBounds2.contains(tag.getTarget()) && !anchorBlockBounds2.intersects((Rectangle2D)((Object)tag))) {
                    g.drawArrowBetweenBoxes((Rectangle2D.Float)((Object)tag), anchorBlockBounds2);
                    drawLineToTarget = false;
                } else if (!anchorBlockBounds2.contains(tag.getTarget())) {
                    clipLine = true;
                }
            }
            if (drawLineToTarget) {
                if (anchorBlockBounds2 != null && clipLine) {
                    g.setClip(anchorBlockBounds2.x, anchorBlockBounds2.y, anchorBlockBounds2.width, anchorBlockBounds2.height);
                }
                g.drawArrowFromBox((Rectangle2D.Float)((Object)tag), tag.getTarget());
                if (anchorBlockBounds2 != null && clipLine) {
                    g.clearClip();
                }
            }
        } else if (tag.getAnchorBlock() != null && tag.getAnchorBlock() instanceof MapBlock && !(anchorBlockBounds = chart.getBlockBounds(tag.getAnchorBlock())).intersects((Rectangle2D)((Object)tag))) {
            g.drawArrowBetweenBoxes((Rectangle2D.Float)((Object)tag), anchorBlockBounds);
        }
    }

    private void highlightSelectedTag(SBGraphics g, ChartProperties cp, ChartTag t) {
        float width = 0.3f;
        Rectangle2D.Float r = RectUtils.getRectWithBorder((Rectangle2D.Float)((Object)t), (float)(t.getProperties().getLineWeight() * 0.5f + 0.5f));
        g.drawDottedRect(r, width, cp.foreground);
    }

    private void drawTagButtons(SBGraphics g, ChartTag t, IZoomManager zm) {
        for (ChartTagButton b : t.getButtons(zm)) {
            g.setColor(Color.black);
            BufferedImage image = this.getButtonImage(b.getType());
            g.drawHighQualityImage(image, b.x, b.y, b.width, b.height);
        }
    }

    private BufferedImage getButtonImage(ChartTagButtonType type) {
        if (!this.iconsLoaded) {
            this.loadIcons();
        }
        switch (type) {
            case REMOVE_POINTER: {
                return this.removeImage;
            }
            case ADD_POINTER: {
                return this.addImage;
            }
        }
        return this.close;
    }

    private void loadIcons() {
        this.iconsLoaded = true;
        try {
            this.close = ImageIO.read(this.getClass().getResource("/icon/close.png"));
            this.addImage = ImageIO.read(this.getClass().getResource("/icon/pointer_add.png"));
            this.removeImage = ImageIO.read(this.getClass().getResource("/icon/pointer_remove.png"));
        }
        catch (Exception e) {
            Logger.getLogger(ChartTagArtist.class.getName()).log(Level.WARNING, "Failed to load tag icon from '/icon/' path.", e);
        }
    }
}

