/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.tag;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import jsbchart.core.ChartTemplate;
import jsbchart.tag.ChartTagTemplate;
import model3.SBdb;

public class ChartTagManager {
    private final SBdb sbdb;

    public ChartTagManager(SBdb sbdb) {
        this.sbdb = sbdb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ChartTagTemplate> getTagsForChart(ChartTemplate chart, List<ChartTemplate.BlockOcc> blocks) throws SQLException {
        Object sql = "SELECT BLOCK_NO, TAG_ORDER, WIDTH, HEIGHT, POS_X, POS_Y, POS_DEPTH, POS_LAT, POS_LON, TARGET_X, TARGET_Y, TARGET_DEPTH, TARGET_LAT, TARGET_LON, TEXT, PROP FROM " + this.sbdb.DBTableName("CHTTAG") + " WHERE CHART_ID = ?";
        sql = this.sbdb.modQuery((String)sql);
        ArrayList<ChartTagTemplate> tags = new ArrayList<ChartTagTemplate>();
        stmt.setInt(1, chart.getID());
        try (PreparedStatement stmt = this.sbdb.getDatabase().prepareStatement((String)sql);){
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                tags.add(this.getTagFromResultSet(chart.getID(), rs, blocks));
            }
        }
        return tags;
    }

    private ChartTagTemplate getTagFromResultSet(int chartId, ResultSet rs, List<ChartTemplate.BlockOcc> blocks) throws SQLException {
        Integer blockNo = this.getNullableInt(rs, "BLOCK_NO");
        int order = rs.getInt("TAG_ORDER");
        float width = rs.getFloat("WIDTH");
        float height = rs.getFloat("HEIGHT");
        float posX = rs.getFloat("POS_X");
        float posY = rs.getFloat("POS_Y");
        Float posDepth = this.getNullableFloat(rs, "POS_DEPTH");
        Float posLat = this.getNullableFloat(rs, "POS_LAT");
        Float posLon = this.getNullableFloat(rs, "POS_LON");
        Float targetX = this.getNullableFloat(rs, "TARGET_X");
        Float targetY = this.getNullableFloat(rs, "TARGET_Y");
        Float targetDepth = this.getNullableFloat(rs, "TARGET_DEPTH");
        Float targetLat = this.getNullableFloat(rs, "TARGET_LAT");
        Float targetLon = this.getNullableFloat(rs, "TARGET_LON");
        String text = rs.getString("TEXT");
        String properties = rs.getString("PROP");
        return new ChartTagTemplate(chartId, blockNo, order, width, height, posX, posY, posDepth, posLat, posLon, targetX, targetY, targetDepth, targetLat, targetLon, text, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTagsForChart(int id) throws SQLException {
        Object sql = "DELETE FROM " + this.sbdb.DBTableName("CHTTAG") + " WHERE CHART_ID = ?";
        sql = this.sbdb.modQuery((String)sql);
        stmt.setInt(1, id);
        try (PreparedStatement stmt = this.sbdb.getDatabase().prepareStatement((String)sql);){
            stmt.execute();
        }
    }

    private int getNextTagId() throws SQLException {
        Object sql = "SELECT MAX(TAG_ID) AS max_id FROM " + this.sbdb.DBTableName("CHTTAG");
        sql = this.sbdb.modQuery((String)sql);
        int max_id = 0;
        try (PreparedStatement stmt = this.sbdb.getDatabase().prepareStatement((String)sql);){
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                max_id = rs.getInt("max_id");
            }
        }
        return ++max_id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertChartTag(int chartId, ChartTagTemplate tt) throws SQLException {
        Object sql = "INSERT INTO " + this.sbdb.DBTableName("CHTTAG") + " (TAG_ID, CHART_ID, BLOCK_NO, TAG_ORDER, WIDTH, HEIGHT, POS_X, POS_Y, POS_DEPTH, POS_LAT, POS_LON, TARGET_X, TARGET_Y, TARGET_DEPTH, TARGET_LAT, TARGET_LON, TEXT, PROP) VALUES  (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
        sql = this.sbdb.modQuery((String)sql);
        int tagId = this.getNextTagId();
        PreparedStatement stmt = this.sbdb.getDatabase().prepareStatement((String)sql);
        stmt.setInt(1, tagId);
        stmt.setInt(2, chartId);
        if (tt.getBlockNo() != null) {
            stmt.setInt(3, tt.getBlockNo());
        } else {
            stmt.setNull(3, 4);
        }
        stmt.setInt(4, tt.getOrder());
        stmt.setFloat(5, tt.getWidth());
        stmt.setFloat(6, tt.getHeight());
        stmt.setFloat(7, tt.getPosX());
        stmt.setFloat(8, tt.getPosY());
        this.setNullableFloatProperty(stmt, 9, tt.getPosDepth());
        this.setNullableFloatProperty(stmt, 10, tt.getPosLat());
        this.setNullableFloatProperty(stmt, 11, tt.getPosLon());
        this.setNullableFloatProperty(stmt, 12, tt.getTargetX());
        this.setNullableFloatProperty(stmt, 13, tt.getTargetY());
        this.setNullableFloatProperty(stmt, 14, tt.getTargetDepth());
        this.setNullableFloatProperty(stmt, 15, tt.getTargetLat());
        this.setNullableFloatProperty(stmt, 16, tt.getTargetLon());
        stmt.setString(17, tt.getText());
        stmt.setString(18, tt.getProperties());
        try {
            stmt.execute();
        }
        finally {
            stmt.close();
        }
    }

    private Integer getNullableInt(ResultSet rs, String column) throws SQLException {
        Integer value = rs.getInt(column);
        if (rs.wasNull()) {
            value = null;
        }
        return value;
    }

    private Float getNullableFloat(ResultSet rs, String column) throws SQLException {
        Float value = Float.valueOf(rs.getFloat(column));
        if (rs.wasNull()) {
            value = null;
        }
        return value;
    }

    private void setNullableFloatProperty(PreparedStatement stmt, int index, Float value) throws SQLException {
        if (value == null) {
            stmt.setNull(index, 6);
        } else {
            stmt.setFloat(index, value.floatValue());
        }
    }
}

