/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.util;

import java.awt.Color;
import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.FileDataStore;
import org.geotools.api.data.FileDataStoreFinder;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.feature.type.GeometryType;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CRSAuthorityFactory;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.api.style.AnchorPoint;
import org.geotools.api.style.Displacement;
import org.geotools.api.style.Font;
import org.geotools.api.style.LabelPlacement;
import org.geotools.api.style.PointPlacement;
import org.geotools.api.style.Stroke;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyleFactory;
import org.geotools.api.style.Symbolizer;
import org.geotools.api.style.TextSymbolizer;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.Position2D;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.styling.SLD;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class GeotoolsUtils {
    private static final Logger LOGGER = Logger.getLogger(GeotoolsUtils.class.getName());

    public static SimpleFeatureCollection buildNewFeatureCollectionWithCRS(SimpleFeatureSource source, CoordinateReferenceSystem crs) {
        SimpleFeatureType sft = (SimpleFeatureType)source.getSchema();
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(sft.getName());
        builder.setCRS(crs);
        for (int i = 0; i < sft.getAttributeCount(); ++i) {
            AttributeType attributeType = sft.getDescriptor(i).getType();
            if (attributeType instanceof GeometryType) {
                GeometryType geoType = (GeometryType)attributeType;
                builder.add(sft.getDescriptor(i).getLocalName(), geoType.getBinding(), crs);
                continue;
            }
            builder.add(sft.getDescriptor(i));
        }
        SimpleFeatureType newFeatureType = builder.buildFeatureType();
        SimpleFeatureBuilder newFeatureBuilder = new SimpleFeatureBuilder(newFeatureType);
        ArrayList<SimpleFeature> newFeatures = new ArrayList<SimpleFeature>();
        try (SimpleFeatureIterator sfi = source.getFeatures().features();){
            while (sfi.hasNext()) {
                try {
                    SimpleFeature f = (SimpleFeature)sfi.next();
                    for (int i = 0; i < f.getAttributeCount(); ++i) {
                        newFeatureBuilder.set(i, f.getAttribute(i));
                    }
                    SimpleFeature newFeature = newFeatureBuilder.buildFeature(f.getID());
                    newFeatures.add(newFeature);
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Could not create feature from featureSource: {0}", e.getMessage());
                }
            }
        }
        catch (RuntimeException e) {
            LOGGER.log(Level.SEVERE, "Could not read data from feature source: {0}", e.getCause() != null ? e.getCause().getMessage() : e.getMessage());
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Exception when reading from feature source {0}", e);
        }
        SimpleFeatureCollection featureCollection = DataUtilities.collection(newFeatures);
        return featureCollection;
    }

    public static boolean isPointFeatureType(FeatureType type) {
        GeometryDescriptor desc = type.getGeometryDescriptor();
        Class clazz = desc.getType().getBinding();
        boolean isPoint = Point.class.isAssignableFrom(clazz) || MultiPoint.class.isAssignableFrom(clazz);
        return isPoint;
    }

    public static Layer buildLayerFromShapefile(String path) throws IOException {
        File file = new File(path);
        FileDataStore store = FileDataStoreFinder.getDataStore((File)file);
        SimpleFeatureSource featureSource = store.getFeatureSource();
        Style style = SLD.createSimpleStyle((FeatureType)featureSource.getSchema());
        return new FeatureLayer((FeatureSource)featureSource, style);
    }

    public static Layer buildPointLayer() {
        SimpleFeatureType POINT = GeotoolsUtils.createPointFeatureType();
        GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory();
        Color color = Color.blue;
        SimpleFeatureBuilder pointFeatureBuilder = new SimpleFeatureBuilder(POINT);
        ArrayList<SimpleFeature> pointFeatures = new ArrayList<SimpleFeature>();
        pointFeatures.add(GeotoolsUtils.buildPointFeature(pointFeatureBuilder, geometryFactory, "A", 0.0, 51.0));
        pointFeatures.add(GeotoolsUtils.buildPointFeature(pointFeatureBuilder, geometryFactory, "B", 1.0, 51.0));
        pointFeatures.add(GeotoolsUtils.buildPointFeature(pointFeatureBuilder, geometryFactory, "C", -1.0, 52.0));
        pointFeatures.add(GeotoolsUtils.buildPointFeature(pointFeatureBuilder, geometryFactory, "C", -4.0, 56.0));
        pointFeatures.add(GeotoolsUtils.buildPointFeature(pointFeatureBuilder, geometryFactory, "D", -3.0, 52.0));
        SimpleFeatureCollection pointFeatureCollection = DataUtilities.collection(pointFeatures);
        Style style = SLD.createPointStyle((String)"Circle", (Color)color, null, (float)0.5f, (float)10.0f);
        return new FeatureLayer((FeatureCollection)pointFeatureCollection, style);
    }

    public static Layer buildLineGrid(int x1, int y1, int x2, int y2) {
        SimpleFeatureType LINE = GeotoolsUtils.createLineFeatureType();
        GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory();
        Color color = Color.red;
        SimpleFeatureBuilder lineFeatureBuilder = new SimpleFeatureBuilder(LINE);
        ArrayList<SimpleFeature> lineFeatures = new ArrayList<SimpleFeature>();
        for (int y = y1; y <= y2 + 1; ++y) {
            for (int x = x1; x <= x2; ++x) {
                lineFeatures.add(GeotoolsUtils.buildLineFeature(lineFeatureBuilder, geometryFactory, x, y, x + 1, y));
            }
        }
        for (int x = x1; x <= x2 + 1; ++x) {
            for (int y = y1; y <= y2; ++y) {
                lineFeatures.add(GeotoolsUtils.buildLineFeature(lineFeatureBuilder, geometryFactory, x, y, x, y + 1));
            }
        }
        SimpleFeatureCollection lineFeatureCollection = DataUtilities.collection(lineFeatures);
        Style lineStyle = SLD.createLineStyle((Color)color, (float)1.0f);
        return new FeatureLayer((FeatureCollection)lineFeatureCollection, lineStyle);
    }

    public static SimpleFeature buildPointFeature(SimpleFeatureBuilder featureBuilder, GeometryFactory geometryFactory, String name, double x, double y) {
        Point point = geometryFactory.createPoint(new Coordinate(x, y));
        featureBuilder.add((Object)point);
        featureBuilder.add((Object)name);
        featureBuilder.add((Object)1);
        return featureBuilder.buildFeature(null);
    }

    public static SimpleFeature buildLineFeature(SimpleFeatureBuilder featureBuilder, GeometryFactory geometryFactory, double x1, double y1, double x2, double y2) {
        LineString line = geometryFactory.createLineString(new Coordinate[]{new Coordinate(x1, y1), new Coordinate(x2, y2)});
        featureBuilder.add((Object)line);
        return featureBuilder.buildFeature(null);
    }

    public static SimpleFeatureType createPointFeatureType() {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("Location");
        builder.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        builder.add("the_geom", Point.class);
        builder.length(15).add("Name", String.class);
        builder.add("number", Integer.class);
        SimpleFeatureType POINT = builder.buildFeatureType();
        return POINT;
    }

    public static SimpleFeatureType createLineFeatureType() {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("Location");
        builder.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        builder.add("the_geom", LineString.class);
        SimpleFeatureType LINE = builder.buildFeatureType();
        return LINE;
    }

    public static Layer getEnvelopeLayer(ReferencedEnvelope env, Color c) {
        Polygon p = GeotoolsUtils.envelopeToPoly((Envelope)env, 5);
        return GeotoolsUtils.polygonToLayer(p, env.getCoordinateReferenceSystem(), c);
    }

    public static ReferencedEnvelope buildEnvelope(String crsString, double x1, double x2, double y1, double y2) throws Exception {
        CoordinateReferenceSystem crs = CRS.decode((String)crsString);
        ReferencedEnvelope e = new ReferencedEnvelope(x1, x2, y1, y2, crs);
        return e;
    }

    public static Layer polygonToLayer(Polygon p, CoordinateReferenceSystem crs, Color c) {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("Poly");
        builder.setCRS(crs);
        builder.add("the_geom", Polygon.class);
        SimpleFeatureType POLY = builder.buildFeatureType();
        GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory();
        SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(POLY);
        ArrayList<SimpleFeature> features = new ArrayList<SimpleFeature>();
        featureBuilder.add((Object)p);
        features.add(featureBuilder.buildFeature(null));
        SimpleFeatureCollection featureCollection = DataUtilities.collection(features);
        Style lineStyle = SLD.createPolygonStyle((Color)c, null, (float)0.0f);
        StyleFactory sf = CommonFactoryFinder.getStyleFactory();
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        Stroke stroke = sf.createStroke((Expression)ff.literal((Object)c), (Expression)ff.literal(50.0f));
        Style s = SLD.wrapSymbolizers((Symbolizer[])new Symbolizer[]{sf.createPolygonSymbolizer(stroke, null, (String)null)});
        return new FeatureLayer((FeatureCollection)featureCollection, s);
    }

    public static Polygon envelopeToPoly(Envelope e, int extraPointsPerSide) {
        double xSpace;
        int i;
        double ySpace;
        ArrayList<Coordinate> coords = new ArrayList<Coordinate>();
        coords.add(new Coordinate(e.getMinX(), e.getMinY()));
        if (extraPointsPerSide > 0) {
            ySpace = e.getHeight() / (double)(extraPointsPerSide + 1);
            for (i = 0; i < extraPointsPerSide; ++i) {
                coords.add(new Coordinate(e.getMinX(), e.getMinY() + ySpace * (double)i));
            }
        }
        coords.add(new Coordinate(e.getMinX(), e.getMaxY()));
        if (extraPointsPerSide > 0) {
            xSpace = e.getWidth() / (double)(extraPointsPerSide + 1);
            for (i = 0; i < extraPointsPerSide; ++i) {
                coords.add(new Coordinate(e.getMinX() + xSpace * (double)i, e.getMaxY()));
            }
        }
        coords.add(new Coordinate(e.getMaxX(), e.getMaxY()));
        if (extraPointsPerSide > 0) {
            ySpace = e.getHeight() / (double)(extraPointsPerSide + 1);
            for (i = 0; i < extraPointsPerSide; ++i) {
                coords.add(new Coordinate(e.getMaxX(), e.getMaxY() - ySpace * (double)i));
            }
        }
        coords.add(new Coordinate(e.getMaxX(), e.getMinY()));
        if (extraPointsPerSide > 0) {
            xSpace = e.getWidth() / (double)(extraPointsPerSide + 1);
            for (i = 0; i < extraPointsPerSide; ++i) {
                coords.add(new Coordinate(e.getMaxX() - xSpace * (double)i, e.getMinY()));
            }
        }
        coords.add(new Coordinate(e.getMinX(), e.getMinY()));
        GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory();
        LinearRing ring = geometryFactory.createLinearRing(coords.toArray(new Coordinate[coords.size()]));
        LinearRing[] holes = null;
        Polygon polygon = geometryFactory.createPolygon(ring, holes);
        return polygon;
    }

    public static Position2D convertPositionToCRS(Position2D positionToConvert, CoordinateReferenceSystem targetCRS) {
        Position2D result = null;
        GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory(null);
        Coordinate coord = new Coordinate(positionToConvert.x, positionToConvert.y);
        Point pointToConvert = geometryFactory.createPoint(coord);
        try {
            MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)positionToConvert.getCoordinateReferenceSystem(), (CoordinateReferenceSystem)targetCRS);
            Geometry resultGeometry = JTS.transform((Geometry)pointToConvert, (MathTransform)transform);
            if (resultGeometry instanceof Point) {
                Point p = (Point)resultGeometry;
                result = new Position2D(targetCRS, p.getX(), p.getY());
            }
        }
        catch (MismatchedDimensionException | FactoryException | TransformException ex) {
            Logger.getLogger(GeotoolsUtils.class.getName()).log(Level.SEVERE, null, ex);
        }
        return result;
    }

    public static CoordinateReferenceSystem getCRS(String code) throws FactoryException {
        Hints hints = new Hints((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)Boolean.TRUE);
        CRSAuthorityFactory factory = ReferencingFactoryFinder.getCRSAuthorityFactory((String)"EPSG", (Hints)hints);
        CoordinateReferenceSystem crs = factory.createCoordinateReferenceSystem(code);
        return crs;
    }

    public static CoordinateReferenceSystem getWGS84CRS() {
        CoordinateReferenceSystem crs = null;
        try {
            crs = GeotoolsUtils.getCRS("EPSG:4326");
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error getting CRS", e);
            crs = DefaultGeographicCRS.WGS84;
        }
        return crs;
    }

    public static Symbolizer createTextSymbolizer(String labelAttributeName, Color fillColour, String fontString, int textSize) {
        StyleFactory sf = CommonFactoryFinder.getStyleFactory();
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        TextSymbolizer ts = sf.createTextSymbolizer();
        ts.setLabel((Expression)ff.property(labelAttributeName));
        ts.setFill(sf.createFill((Expression)ff.literal((Object)fillColour)));
        float fontSize = textSize;
        Literal family = ff.literal((Object)fontString);
        Literal style = ff.literal((Object)"normal");
        Literal weight = ff.literal((Object)"normal");
        Literal size = ff.literal(fontSize);
        Font font = sf.createFont((Expression)family, (Expression)style, (Expression)weight, (Expression)size);
        ts.setFont(font);
        AnchorPoint anchorPoint = sf.createAnchorPoint((Expression)ff.literal(0.5), (Expression)ff.literal(0));
        Displacement displacement = sf.createDisplacement((Expression)ff.literal(0), (Expression)ff.literal(fontSize / 2.0f));
        PointPlacement labelPlacement = sf.createPointPlacement(anchorPoint, displacement, null);
        ts.setLabelPlacement((LabelPlacement)labelPlacement);
        Map options = ts.getOptions();
        options.put("maxDisplacement", "1000");
        return ts;
    }
}

