/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.util;

import model3.LogDef;

public class LogInfo {
    public static final int NFIELDS = 5;
    public static final String[] PROP_NAMES = new String[]{"Trace", "Width", "Offset", "Shift", "Line at scale centre"};
    LogDef logDef;
    double logShift = 0.0;
    float logColWidth = 40.0f;
    float logTraceOffset = 40.0f;
    boolean logScaleLine = true;

    public LogInfo() {
    }

    LogInfo(LogInfo rhs) {
        this.logShift = rhs.logShift;
        this.logColWidth = rhs.logColWidth;
        this.logTraceOffset = rhs.logTraceOffset;
        this.logScaleLine = rhs.logScaleLine;
        if (rhs.logDef != null) {
            this.logDef = new LogDef(rhs.logDef);
        }
    }

    public String getPropertiesString() {
        String s = this.logDef.getProperties() + "^";
        String[] prop = new String[]{"" + this.logColWidth, "" + this.logTraceOffset, "" + this.logShift, "" + (this.logScaleLine ? 1 : 0)};
        for (String strg : prop) {
            s = s + strg + "|";
        }
        return s;
    }

    public boolean isSimilarTo(LogInfo rhs) {
        if (this.logDef.getAbr().equals(rhs.logDef.getAbr())) {
            return false;
        }
        if (this.logScaleLine != rhs.logScaleLine) {
            return false;
        }
        if (Math.abs(this.logShift - rhs.logShift) > 1.0) {
            return false;
        }
        if (Math.abs(this.logTraceOffset - rhs.logTraceOffset) > 5.0f) {
            return false;
        }
        return Math.abs(this.logColWidth - rhs.logColWidth) <= 5.0f;
    }

    public boolean setColWidth(Object o) {
        float width = this.getFloat(o);
        if (width >= 10.0f && width < 1000.0f && (double)Math.abs(this.logColWidth - width) >= 0.1) {
            this.logColWidth = width;
            return true;
        }
        return false;
    }

    public boolean setTraceOffset(Object o) {
        float width = this.getFloat(o);
        if (width > -1000.0f && width < 1000.0f && (double)Math.abs(this.logTraceOffset - width) >= 0.1) {
            this.logTraceOffset = width;
            return true;
        }
        return false;
    }

    public boolean setShift(Object o) {
        float width = this.getFloat(o);
        if (Math.abs(this.logShift - (double)width) >= 0.1) {
            this.logShift = width;
            return true;
        }
        return false;
    }

    private float getFloat(Object o) {
        if (o instanceof Float) {
            return ((Float)o).floatValue();
        }
        return Float.parseFloat(o.toString());
    }

    public LogDef getLogDef() {
        return this.logDef;
    }

    public double getLogShift() {
        return this.logShift;
    }

    public float getLogColWidth() {
        return this.logColWidth;
    }

    public float getLogTraceOffset() {
        return this.logTraceOffset;
    }

    public boolean getLogScaleLine() {
        return this.logScaleLine;
    }

    public void setLogDef(LogDef logDef) {
        this.logDef = logDef;
    }

    public void setLogShift(double logShift) {
        this.logShift = logShift;
    }

    public void setLogColWidth(float logColWidth) {
        this.logColWidth = logColWidth;
    }

    public void setLogTraceOffset(float logTraceOffset) {
        this.logTraceOffset = logTraceOffset;
    }

    public void setLogScaleLine(boolean logScaleLine) {
        this.logScaleLine = logScaleLine;
    }
}

