/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.util.colour;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public record ColourSpectrum(float hueLeft, float hueRight, float saturation, float brightness) {
    public static final int STANDARD_DIVISIONS = 12;
    public static final float DEFAULT_SATURATION = 0.5f;
    public static final float DEFAULT_BRIGHTNESS = 0.95f;

    public ColourSpectrum() {
        this(0.0f, 1.0f, 0.5f, 0.95f);
    }

    public ColourSpectrum(float hueLeft, float hueRight) {
        this(hueLeft, hueRight, 0.5f, 0.95f);
        if (hueLeft < 0.0f || hueLeft > 1.0f || hueRight < 0.0f || hueRight > 1.0f) {
            throw new IllegalArgumentException("Illegal spectrum hues: " + hueLeft + "," + hueRight);
        }
    }

    public static ColourSpectrum parse(String string) {
        String[] components = string.split(",");
        if (components.length != 4) {
            return new ColourSpectrum();
        }
        List<Float> floats = Arrays.stream(components).map(s -> Float.valueOf(Float.parseFloat(s))).map(f -> {
            if (f.floatValue() > 1.0f) {
                return 1;
            }
            if (f.floatValue() < 0.0f) {
                return 0;
            }
            return f;
        }).map(o -> (Float)o).toList();
        return new ColourSpectrum(floats.get(0).floatValue(), floats.get(1).floatValue(), floats.get(2).floatValue(), floats.get(3).floatValue());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ColourSpectrum other = (ColourSpectrum)obj;
        if (Float.floatToIntBits(this.hueLeft) != Float.floatToIntBits(other.hueLeft)) {
            return false;
        }
        return Float.floatToIntBits(this.hueRight) == Float.floatToIntBits(other.hueRight);
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + Float.floatToIntBits(this.hueLeft);
        hash = 53 * hash + Float.floatToIntBits(this.hueRight);
        return hash;
    }

    public float getHuePrecise(float value) {
        float hue = this.hueLeft + value * (this.hueRight - this.hueLeft);
        if (hue > 1.0f || hue < 0.0f) {
            hue %= 1.0f;
        }
        return hue;
    }

    public float getHueClass(float value, int nClasses) {
        if ((double)value < 0.0 || (double)value > 1.0) {
            throw new IllegalArgumentException("Illegal value: " + value);
        }
        float valueIncrement = 1.0f / Float.valueOf(nClasses).floatValue();
        float hueIncrement = (this.hueRight - this.hueLeft) / (float)(nClasses - 1);
        float hue = this.hueLeft;
        float currentValue = valueIncrement;
        while (value >= currentValue && currentValue < 1.0f) {
            currentValue += valueIncrement;
            hue += hueIncrement;
        }
        return hue;
    }

    public Color getColour(float value) {
        return Color.getHSBColor(this.getHuePrecise(value), this.saturation, this.brightness);
    }

    public Color[] getColours() {
        return this.getColours(12).toArray(new Color[12]);
    }

    public List<Color> getColours(int nColours) {
        ArrayList<Color> colours = new ArrayList<Color>();
        float hueIncrement = (this.hueRight - this.hueLeft) / (float)(nColours - 1);
        float hue = this.hueLeft;
        for (int i = 0; i < nColours; ++i) {
            colours.add(Color.getHSBColor(hue, this.saturation, this.brightness));
            hue += hueIncrement;
        }
        if (this.hueRight < this.hueLeft) {
            Collections.reverse(colours);
        }
        return colours;
    }

    @Override
    public String toString() {
        return StringUtils.join(List.of(Float.valueOf(this.hueLeft), Float.valueOf(this.hueRight), Float.valueOf(this.saturation), Float.valueOf(this.brightness)), (String)",");
    }
}

