/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.util.colour;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class ColourUtils {
    static final double STANDARD_TOLERANCE = 35.0;
    private static final Logger LOGGER = Logger.getLogger(ColourUtils.class.getName());

    public static double calcDistance(Color colour1, Color colour2) {
        float[] labComponents1 = ColourUtils.rgb2lab(colour1);
        float[] labComponents2 = ColourUtils.rgb2lab(colour2);
        double distance = 0.0;
        for (int i = 0; i < 3; ++i) {
            distance += Math.pow(labComponents1[i] - labComponents2[i], 2.0);
        }
        double dist = Math.sqrt(distance);
        return dist;
    }

    public static boolean hasSimilar(Collection<Color> colours) {
        if (colours.isEmpty()) {
            return false;
        }
        ArrayList<Color> list = new ArrayList<Color>(colours);
        ArrayList<Double> distances = new ArrayList<Double>();
        for (int i = 0; i < list.size(); ++i) {
            for (int j = i + 1; j < list.size(); ++j) {
                Color c2;
                Color c1 = list.get(i);
                double dist = ColourUtils.calcDistance(c1, c2 = list.get(j));
                if (dist < 35.0) {
                    return true;
                }
                distances.add(dist);
            }
        }
        LOGGER.log(Level.CONFIG, "Min colour distance: " + String.valueOf(distances.stream().min(Double::compareTo).get()));
        return false;
    }

    static float[] rgb2lab(Color colour) {
        float eps = 0.008856452f;
        float k = 903.2963f;
        float Xr = 0.964221f;
        float Yr = 1.0f;
        float Zr = 0.825211f;
        float r = (float)colour.getRed() / 255.0f;
        float g = (float)colour.getGreen() / 255.0f;
        float b = (float)colour.getBlue() / 255.0f;
        r = (double)r <= 0.04045 ? (r /= 12.0f) : (float)Math.pow(((double)r + 0.055) / 1.055, 2.4);
        g = (double)g <= 0.04045 ? (g /= 12.0f) : (float)Math.pow(((double)g + 0.055) / 1.055, 2.4);
        b = (double)b <= 0.04045 ? (b /= 12.0f) : (float)Math.pow(((double)b + 0.055) / 1.055, 2.4);
        float X = 0.43605202f * r + 0.3850816f * g + 0.14308742f * b;
        float Y = 0.22249159f * r + 0.71688604f * g + 0.060621485f * b;
        float Z = 0.013929122f * r + 0.097097f * g + 0.7141855f * b;
        float xr = X / Xr;
        float yr = Y / Yr;
        float zr = Z / Zr;
        float fx = xr > eps ? (float)Math.pow(xr, 0.3333333333333333) : (float)(((double)(k * xr) + 16.0) / 116.0);
        float fy = yr > eps ? (float)Math.pow(yr, 0.3333333333333333) : (float)(((double)(k * yr) + 16.0) / 116.0);
        float fz = zr > eps ? (float)Math.pow(zr, 0.3333333333333333) : (float)(((double)(k * zr) + 16.0) / 116.0);
        float Ls = 116.0f * fy - 16.0f;
        float as = 500.0f * (fx - fy);
        float bs = 200.0f * (fy - fz);
        return new float[]{Ls, as, bs};
    }

    public static List<Color> createPalette(int nColours, Color seedColour) {
        float[] hsbvals = Color.RGBtoHSB(seedColour.getRed(), seedColour.getGreen(), seedColour.getBlue(), null);
        float h = hsbvals[0];
        float s = hsbvals[1];
        float b = hsbvals[2];
        float golden_ratio_conjugate = 0.618034f;
        ArrayList<Color> colours = new ArrayList<Color>();
        double tolerance = 35.0;
        int skips = 0;
        block0: do {
            Color newColour = Color.getHSBColor(h, s, b);
            h += 0.618034f;
            h %= 1.0f;
            for (Color c : colours) {
                double dist = ColourUtils.calcDistance(c, newColour);
                if (!(dist < tolerance)) continue;
                if (skips > 3) {
                    tolerance -= 5.0;
                    skips = 0;
                    continue block0;
                }
                ++skips;
                continue block0;
            }
            colours.add(newColour);
            skips = 0;
        } while (colours.size() < nColours);
        return colours;
    }

    public static List<Color> createPalette(List<Color> seedColours) {
        int n = seedColours.size();
        ArrayList<float[]> seeds = new ArrayList<float[]>();
        for (int i = 0; i < n; ++i) {
            Color seedColour = seedColours.get(i);
            seeds.add(Color.RGBtoHSB(seedColour.getRed(), seedColour.getGreen(), seedColour.getBlue(), null));
        }
        Collections.sort(seeds, (arr1, arr2) -> Float.compare(arr1[0], arr2[0]));
        float averageS = seeds.stream().collect(Collectors.averagingDouble(seed -> seed[1])).floatValue();
        float averageB = seeds.stream().collect(Collectors.averagingDouble(seed -> seed[2])).floatValue();
        float hueMin = ((float[])seeds.get(0))[0];
        float hueMax = ((float[])seeds.get(n - 1))[0];
        List<Color> palette = ColourUtils.generateEquallySpacedColours(n, hueMin, hueMax, averageS, averageB);
        while (ColourUtils.hasSimilar(palette) && (double)hueMin > 0.05 && (double)hueMax < 0.95) {
            hueMin = (float)((double)hueMin - 0.05);
            hueMax = (float)((double)hueMax + 0.05);
            palette = ColourUtils.generateEquallySpacedColours(n, hueMin, hueMax, averageS, averageB);
        }
        return palette;
    }

    private static List<Color> generateEquallySpacedColours(int n, float hueMin, float hueMax, float s, float b) {
        float incr = (hueMax - hueMin) / (float)(n - 1);
        float hue = hueMin;
        ArrayList<Color> results = new ArrayList<Color>();
        for (int i = 0; i < n; ++i) {
            results.add(Color.getHSBColor(hue, s, b));
            hue += incr;
        }
        return results;
    }

    public static String getHexString(Color colour) {
        return String.format("#%06x", colour.getRGB() & 0xFFFFFF);
    }
}

