/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs;

import java.io.IOException;
import org.geotools.api.data.FeatureReader;
import org.geotools.api.feature.FeatureFactory;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.data.Diff;
import org.geotools.data.store.ContentFeatureStore;
import org.geotools.data.store.DiffContentFeatureWriter;
import org.geotools.data.wfs.MutableIdentifierFeatureFactory;
import org.geotools.data.wfs.WFSDataStore;
import org.geotools.data.wfs.WFSFeatureStore;
import org.geotools.data.wfs.WFSLocalTransactionState;
import org.geotools.data.wfs.WFSRemoteTransactionState;
import org.geotools.feature.simple.SimpleFeatureBuilder;

public class WFSFeatureWriter
extends DiffContentFeatureWriter {
    final WFSRemoteTransactionState autoCommitState;

    public WFSFeatureWriter(WFSFeatureStore store, WFSLocalTransactionState localSate, FeatureReader<SimpleFeatureType, SimpleFeature> reader, boolean autoCommit) {
        super((ContentFeatureStore)store, (Diff)localSate.getDiff(), reader, new SimpleFeatureBuilder((SimpleFeatureType)reader.getFeatureType(), (FeatureFactory)new MutableIdentifierFeatureFactory()));
        if (autoCommit) {
            WFSDataStore dataStore = store.getDataStore();
            this.autoCommitState = new WFSRemoteTransactionState(dataStore);
            this.autoCommitState.watch(localSate.getState());
        } else {
            this.autoCommitState = null;
        }
    }

    public void write() throws IOException {
        this.checkClosed();
        super.write();
        if (this.autoCommitState != null) {
            this.autoCommitState.commit();
        }
    }

    public void remove() throws IOException {
        this.checkClosed();
        super.remove();
        if (this.autoCommitState != null) {
            this.autoCommitState.commit();
        }
    }

    public boolean hasNext() throws IOException {
        this.checkClosed();
        return super.hasNext();
    }

    public synchronized SimpleFeature next() throws IOException {
        this.checkClosed();
        return super.next();
    }

    private void checkClosed() throws IOException {
        if (this.reader == null) {
            throw new IOException("FeatureWriter is closed");
        }
    }
}

