/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3;

import java.awt.Color;
import java.util.Locale;

public enum Discipline {
    MICRO('M', "Micropalaeontology", "Microfaunal", "Micro", Color.BLACK),
    PALY('P', "Palynology", "Palynofloral", "Paly", Color.RED),
    NANNO('N', "Nannopalaeontology", "Nannofloral", "Nanno", Color.BLUE),
    MACRO('A', "Macropalaeontology", "Macrofaunal", "Macro", Color.GREEN);

    private final char charType;
    private final String noun;
    private final String adjective;
    private final String abr;
    private final Color defaultColor;

    private Discipline(char charType, String noun, String adj, String abr, Color defaultColor) {
        this.charType = charType;
        this.noun = noun;
        this.adjective = adj;
        this.abr = abr;
        this.defaultColor = defaultColor;
    }

    public char getChar() {
        return this.charType;
    }

    public String getNoun() {
        return this.noun;
    }

    public String getAdj() {
        return this.adjective;
    }

    public String getAbr(boolean withPeriod) {
        return this.abr + (withPeriod ? "." : "");
    }

    public static Discipline getDisc(char discID) {
        for (Discipline d : Discipline.values()) {
            if (d.getChar() != discID) continue;
            return d;
        }
        return null;
    }

    public static Discipline getDisc(String s) {
        if (s != null) {
            for (Discipline d : Discipline.values()) {
                if (!d.getNoun().equalsIgnoreCase(s) && !d.getAdj().equalsIgnoreCase(s) && !d.getAbr(false).equalsIgnoreCase(s) && (s.length() != 1 || d.getChar() != s.toUpperCase(Locale.UK).charAt(0))) continue;
                return d;
            }
        }
        return null;
    }

    public static Discipline parseDisc(String s) {
        try {
            return Discipline.valueOf(s.toUpperCase(Locale.UK).trim());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Discipline disc = Discipline.getDisc(s);
            if (disc != null) {
                return disc;
            }
            s = s.toUpperCase(Locale.UK);
            for (Discipline d : Discipline.values()) {
                if (!s.contains(d.getAbr(false).toUpperCase(Locale.UK))) continue;
                return d;
            }
            return null;
        }
    }

    public static char getChar(Discipline d) {
        if (d == null) {
            return '\u0000';
        }
        return d.getChar();
    }

    public static String getNoun(Discipline d) {
        if (d == null) {
            return "";
        }
        return d.getNoun();
    }

    public String toString() {
        return this.getNoun();
    }

    public static String[] getNouns() {
        String[] nouns = new String[Discipline.values().length];
        for (int i = 0; i < Discipline.values().length; ++i) {
            nouns[i] = Discipline.values()[i].getNoun();
        }
        return nouns;
    }

    public Color getColour() {
        return this.defaultColor;
    }
}

