/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3;

import com.stratadata.model3.event.EventType;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class SystemPreferences {
    private static SystemPreferences INSTANCE;
    private final Map<String, String> preferences = new HashMap<String, String>();
    public static final String SAMPLE_TOPS_KEY = "SAMPLETOPS";
    private static final boolean SAMPLE_TOPS_DEFAULT;
    public static final String HIDE_COMMON_SAMPLE_TYPES = "HIDECOMMONSAMPLETYPES";
    private static final boolean HIDE_COMMON_SAMPLE_TYPES_DEFAULT;

    private SystemPreferences() {
        this.preferences.put(SAMPLE_TOPS_KEY, Boolean.toString(SAMPLE_TOPS_DEFAULT));
        this.preferences.put(HIDE_COMMON_SAMPLE_TYPES, Boolean.toString(HIDE_COMMON_SAMPLE_TYPES_DEFAULT));
    }

    public static SystemPreferences getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SystemPreferences();
        }
        return INSTANCE;
    }

    public static void init(HashMap<String, String> prefs) {
        INSTANCE = new SystemPreferences();
        prefs.forEach((key, value) -> INSTANCE.setPreference((String)key, (String)value));
    }

    public boolean useSampleTops() {
        return this.parseBooleanPreference(this.preferences.get(SAMPLE_TOPS_KEY), SAMPLE_TOPS_DEFAULT);
    }

    public boolean hideCommonSampleTypes() {
        return this.parseBooleanPreference(this.preferences.get(HIDE_COMMON_SAMPLE_TYPES), HIDE_COMMON_SAMPLE_TYPES_DEFAULT);
    }

    private boolean parseBooleanPreference(String value, boolean defaultValue) {
        if (value != null && !value.isEmpty()) {
            return value.toUpperCase(Locale.ENGLISH).charAt(0) != 'F';
        }
        return defaultValue;
    }

    public void setPreference(String key, boolean value) {
        this.setPreference(key, Boolean.toString(value));
    }

    public void setPreference(String key, String value) {
        if (value == null || key == null) {
            return;
        }
        this.preferences.put(key.toUpperCase(Locale.ENGLISH), value);
    }

    public String getPreference(String key) {
        return this.preferences.get(key.toUpperCase());
    }

    public boolean getBooleanPreference(String key, boolean defaultValue) {
        return this.parseBooleanPreference(this.preferences.get(key.toUpperCase(Locale.ENGLISH)), defaultValue);
    }

    public void setEventPrefixes() {
        String wTop = this.preferences.get("EVENTPRXWT");
        String wBase = this.preferences.get("EVENTPRXWB");
        String sTop = this.preferences.get("EVENTPRXCT");
        String sBase = this.preferences.get("EVENTPRXCB");
        boolean singlePrefix = this.parseBooleanPreference(this.preferences.get("EVENTPRSGL"), false);
        EventType.setPrefixes(wTop, wBase, sTop, sBase, singlePrefix);
    }

    static {
        SAMPLE_TOPS_DEFAULT = Boolean.FALSE;
        HIDE_COMMON_SAMPLE_TYPES_DEFAULT = Boolean.FALSE;
    }
}

