/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.audit;

import com.stratadata.model3.user.User;
import com.stratadata.model3.user.UserService;
import java.time.Instant;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Optional;

public interface Audit {
    public static final String DATE_FORMAT = "dd-MMM-yyyy";
    public static final String UNKNOWN_LABEL = "<unknown>";

    public LocalDate getCreated();

    public int getCreatorID();

    default public Optional<User> getCreator(UserService userService) {
        return userService.findUser(this.getCreatorID());
    }

    public Optional<User> getCreator();

    public LocalDate getModified();

    public int getModifierID();

    default public Optional<User> getModifier(UserService userService) {
        return userService.findUser(this.getModifierID());
    }

    public Optional<User> getModifier();

    public Instant getUpdated();

    public int getUpdaterID();

    default public String toString(UserService userService, boolean includeCreated) {
        StringBuilder label = new StringBuilder();
        if (includeCreated && this.getCreated() != null) {
            label.append(Audit.getLabelText("Created", userService.findUser(this.getCreatorID()), this.getCreated()));
        }
        if (this.getModified() != null && !this.getModified().equals(this.getCreated())) {
            if (!label.isEmpty()) {
                label.append("; ");
            }
            label.append(Audit.getLabelText("Modified ", userService.findUser(this.getModifierID()), this.getModified()));
        }
        return label.toString();
    }

    private static String getLabelText(String label, Optional<User> user, LocalDate date) {
        String userText = user.map(u -> " by " + u.getAbr()).orElse("");
        String dateText = date != null ? date.format(DateTimeFormatter.ofPattern(DATE_FORMAT)) : UNKNOWN_LABEL;
        return label + " " + dateText + userText;
    }
}

