/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.event;

import com.stratadata.model3.event.EventContext;
import com.stratadata.model3.event.EventType;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

class DictionaryEventType {
    private final Map<EventType, TypeValue> typeValues = new EnumMap<EventType, TypeValue>(EventType.class);

    DictionaryEventType() {
        Stream.of(EventType.values()).forEach(eventType -> this.typeValues.put((EventType)((Object)eventType), new TypeValue()));
    }

    boolean isPermitted(EventType type) {
        return this.typeValues.get((Object)((Object)type)).typePermitted;
    }

    Optional<String> prefix(EventType type, EventContext context) {
        TypeValue valueForType = this.typeValues.get((Object)type);
        if (!valueForType.typePermitted) {
            return Optional.empty();
        }
        return Optional.ofNullable(valueForType.getPrefix(context));
    }

    void setUpType(EventType type, boolean permitted, String wellPrefix, String schemePrefix) {
        TypeValue valueForType = this.typeValues.get((Object)type);
        valueForType.typePermitted = permitted;
        if (wellPrefix != null) {
            wellPrefix = wellPrefix.trim();
        }
        String string = valueForType.wellPrefix = permitted ? wellPrefix : null;
        if (schemePrefix != null) {
            schemePrefix = schemePrefix.trim();
        }
        valueForType.schemePrefix = permitted ? schemePrefix : null;
    }

    public int hashCode() {
        int hash = 7;
        hash = 43 * hash + Objects.hashCode(this.typeValues);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return Objects.equals(this.typeValues, ((DictionaryEventType)obj).typeValues);
    }

    public static String trimCommonPrefixToNull(String prefix, EventType type, EventContext context) {
        CharSequence[] charSequenceArray;
        block0 : switch (type) {
            default: {
                throw new MatchException(null, null);
            }
            case TOP: {
                switch (context) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case WELL: {
                        String[] stringArray = new String[2];
                        stringArray[0] = "Top";
                        charSequenceArray = stringArray;
                        stringArray[1] = "FDO";
                        break block0;
                    }
                    case SCHEME: 
                }
                String[] stringArray = new String[2];
                stringArray[0] = "Top";
                charSequenceArray = stringArray;
                stringArray[1] = "LAD";
                break;
            }
            case BASE: {
                switch (context) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case WELL: {
                        String[] stringArray = new String[2];
                        stringArray[0] = "Base";
                        charSequenceArray = stringArray;
                        stringArray[1] = "LDO";
                        break block0;
                    }
                    case SCHEME: 
                }
                String[] stringArray = new String[2];
                stringArray[0] = "Base";
                charSequenceArray = stringArray;
                stringArray[1] = "FAD";
                break;
            }
            case SINGLE: {
                CharSequence[] charSequenceArray2 = new String[1];
                charSequenceArray = charSequenceArray2;
                charSequenceArray2[0] = "Single";
            }
        }
        CharSequence[] commonTypes = charSequenceArray;
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)prefix, (CharSequence[])commonTypes)) {
            return null;
        }
        return prefix;
    }

    private static class TypeValue {
        boolean typePermitted = true;
        String wellPrefix = null;
        String schemePrefix = null;

        private TypeValue() {
        }

        String getPrefix(EventContext context) {
            Objects.requireNonNull(context);
            switch (context) {
                default: {
                    return this.wellPrefix;
                }
                case SCHEME: 
            }
            return this.schemePrefix;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TypeValue other = (TypeValue)obj;
            if (this.typePermitted != other.typePermitted) {
                return false;
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)this.wellPrefix, (CharSequence)other.wellPrefix)) {
                return false;
            }
            return StringUtils.equalsIgnoreCase((CharSequence)this.schemePrefix, (CharSequence)other.schemePrefix);
        }

        public int hashCode() {
            int hash = 3;
            hash = 61 * hash + (this.typePermitted ? 1 : 0);
            hash = 61 * hash + Objects.hashCode(this.wellPrefix);
            hash = 61 * hash + Objects.hashCode(this.schemePrefix);
            return hash;
        }
    }
}

