/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.image;

import com.stratadata.model3.image.ImageLoader;
import com.stratadata.model3.image.ImageRecord;
import com.stratadata.model3.image.ImageRecordService;
import com.stratadata.model3.image.ImageUtils;
import java.awt.Dimension;
import java.awt.Image;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.map.AbstractReferenceMap;
import org.apache.commons.collections4.map.ReferenceMap;

public class ImageSet {
    private final int imageSetID;
    private Map<Integer, Image> fullSizeImages = new ReferenceMap(AbstractReferenceMap.ReferenceStrength.HARD, AbstractReferenceMap.ReferenceStrength.SOFT);
    private final Map<SizedImageKey, Image> sizedImages = new ReferenceMap(AbstractReferenceMap.ReferenceStrength.HARD, AbstractReferenceMap.ReferenceStrength.SOFT);
    private static final int THUMB_THRESHOLD = 85;
    private final Map<SizedImageKey, Image> thumbs = new HashMap<SizedImageKey, Image>();

    public ImageSet(int imageSetID) {
        this.imageSetID = imageSetID;
    }

    private Map<SizedImageKey, Image> getImageMap(SizedImageKey key) {
        if (key.dimension != null && key.dimension.width < 85 && key.dimension.height < 85) {
            return this.thumbs;
        }
        return this.sizedImages;
    }

    public List<ImageRecord> getImageRecords(ImageRecordService irs) {
        return irs.getImageRecords(this.imageSetID);
    }

    public ImageRecord getImageRecord(int n, ImageRecordService irs) {
        return this.getImageRecords(irs).get(n);
    }

    public int getSize(ImageRecordService irs) {
        return this.getImageRecords(irs).size();
    }

    public Iterator<Image> getImageIterator(final ImageRecordService imageRecordService, final ImageLoader imageLoader, final Dimension imageSize) {
        return new Iterator<Image>(this){
            private List<ImageRecord> imageRecords;
            int currentIndex;
            final /* synthetic */ ImageSet this$0;
            {
                ImageSet imageSet = this$0;
                Objects.requireNonNull(imageSet);
                this.this$0 = imageSet;
                this.imageRecords = this.this$0.getImageRecords(imageRecordService);
                this.currentIndex = 0;
            }

            @Override
            public boolean hasNext() {
                return this.currentIndex < this.imageRecords.size();
            }

            @Override
            public Image next() {
                Image image = this.this$0.getImage(imageRecordService, imageLoader, this.imageRecords.get(this.currentIndex).imageID(), imageSize);
                ++this.currentIndex;
                return image;
            }
        };
    }

    public Image getFirstImage(ImageRecordService imageRecordService, ImageLoader imageLoader, Dimension imageSize) {
        List<ImageRecord> imageRecords = this.getImageRecords(imageRecordService);
        if (!imageRecords.isEmpty()) {
            return this.getImage(imageRecordService, imageLoader, imageRecords.get(0).imageID(), imageSize);
        }
        return null;
    }

    public Image getImage(ImageRecordService imageRecordService, ImageLoader imageLoader, int imageID, Dimension imageSize) {
        SizedImageKey imageKey = new SizedImageKey(imageID, imageSize);
        Map<SizedImageKey, Image> cache = this.getImageMap(imageKey);
        if (cache.get(imageKey) != null) {
            return cache.get(imageKey);
        }
        List<ImageRecord> imageRecords = this.getImageRecords(imageRecordService);
        ImageRecord im = imageRecords.stream().filter(imageRecord -> imageRecord.imageID() == imageID).findFirst().orElse(null);
        if (im == null) {
            return null;
        }
        Image fullSizeImage = this.fullSizeImages.get(im.imageID());
        if (fullSizeImage == null) {
            fullSizeImage = imageLoader.getImage(im);
        }
        if (fullSizeImage == null) {
            return null;
        }
        this.fullSizeImages.put(im.imageID(), fullSizeImage);
        if (imageSize != null) {
            Image sizedImage = ImageUtils.buildResizedImage(fullSizeImage, imageSize.width, imageSize.height);
            cache.put(imageKey, sizedImage);
            return sizedImage;
        }
        return fullSizeImage;
    }

    public int getImageSetID() {
        return this.imageSetID;
    }

    public void clearCaches() {
        this.fullSizeImages.clear();
        this.sizedImages.clear();
    }

    private record SizedImageKey(Integer imageID, Dimension dimension) {
    }
}

