/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.image;

import com.stratadata.model3.image.ImageSet;
import com.stratadata.model3.image.TaxonImageService;
import com.stratadata.model3.image.TaxonImageSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class TaxonImageServiceImpl
implements TaxonImageService {
    private final HashMap<Integer, List<TaxonImageSet>> map = new HashMap();

    @Override
    public boolean hasTypeImage(int specID) {
        return this.map.getOrDefault(specID, Collections.emptyList()).stream().anyMatch(TaxonImageSet::isType);
    }

    @Override
    public int getTypeImageSetID(int specID) {
        return this.map.getOrDefault(specID, Collections.emptyList()).stream().filter(TaxonImageSet::isType).findFirst().map(ImageSet::getImageSetID).orElse(-1);
    }

    @Override
    public void addTaxonImageSet(int specID, TaxonImageSet taxonImageSet) {
        List<TaxonImageSet> taxonImageSets = this.map.get(specID);
        if (taxonImageSets == null) {
            ArrayList<TaxonImageSet> imageSetsForSpecies = new ArrayList<TaxonImageSet>();
            imageSetsForSpecies.add(taxonImageSet);
            this.map.put(specID, imageSetsForSpecies);
        } else {
            TaxonImageSet existing = taxonImageSets.stream().filter(tis -> tis.getImageSetID() == taxonImageSet.getImageSetID()).findFirst().orElse(null);
            if (existing != null) {
                taxonImageSets.set(taxonImageSets.indexOf(existing), taxonImageSet);
            } else {
                taxonImageSets.add(taxonImageSet);
            }
        }
    }

    @Override
    public void deleteTaxonImageSet(int specID, TaxonImageSet imageSet) {
        List<TaxonImageSet> imageSetsForSpecies = this.map.get(specID);
        if (imageSetsForSpecies != null) {
            imageSetsForSpecies.remove(imageSet);
            this.notifyListeners(specID);
        }
    }

    @Override
    public void setTaxonImageSetType(int specID, TaxonImageSet imageSet, boolean isType) {
        imageSet.setType(isType);
        this.addTaxonImageSet(specID, imageSet);
    }

    @Override
    public List<TaxonImageSet> getImages(int specID) {
        List<TaxonImageSet> images = this.map.get(specID);
        if (images != null) {
            return new ArrayList<TaxonImageSet>(images);
        }
        return Collections.emptyList();
    }

    @Override
    public TaxonImageSet getTaxonImageSet(int imageSetID) {
        return this.map.values().stream().flatMap(Collection::stream).filter(taxonImageSet -> taxonImageSet.getImageSetID() == imageSetID).findFirst().orElse(null);
    }
}

