/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.image;

import com.stratadata.model3.image.ImageRecord;
import com.stratadata.model3.image.ImageRecordService;
import com.stratadata.model3.image.ImageSet;
import com.stratadata.model3.well.analysis.AnalysisID;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class TaxonImageSet
extends ImageSet {
    private final int specID;
    private boolean isType;

    public TaxonImageSet(int imageSetID, int specID, boolean isType) {
        super(imageSetID);
        this.specID = specID;
        this.isType = isType;
    }

    void setType(boolean isType) {
        this.isType = isType;
    }

    public boolean isType() {
        return this.isType;
    }

    public int getSpecID() {
        return this.specID;
    }

    public Optional<AnalysisID> getAnalysisID() {
        return Optional.empty();
    }

    static class SlideStoreImageSet
    extends TaxonImageSet {
        private List<SlideStoreImageRecord> imageRecords = new ArrayList<SlideStoreImageRecord>();

        public SlideStoreImageSet(int specID) {
            super(0, specID, true);
        }

        void addSlideStoreImageRecord(SlideStoreImageRecord record) {
            this.imageRecords.add(record);
        }

        @Override
        public List<ImageRecord> getImageRecords(ImageRecordService irs) {
            return this.imageRecords.stream().map(ir -> ImageRecord.SpecimenImageRecord(ir.specimen_image_id, ir.caption)).toList();
        }

        record SlideStoreImageRecord(int specimen_image_id, String caption, int specimen_id, int slidecell_id) {
        }
    }

    static class Unreferenced
    extends TaxonImageSet {
        private List<ImageRecord> imageRecords;

        public Unreferenced(int specID, List<ImageRecord> imageRecords) {
            super(0, specID, true);
            this.imageRecords = imageRecords;
        }

        @Override
        public List<ImageRecord> getImageRecords(ImageRecordService irs) {
            return this.imageRecords;
        }
    }
}

