/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.project;

import com.stratadata.model3.audit.Audit;
import com.stratadata.model3.audit.AuditImpl;
import com.stratadata.model3.audit.Audited;
import com.stratadata.model3.validation.Ident;
import com.stratadata.model3.validation.LimitedLengthString;
import com.stratadata.model3.validation.NotEmptyString;
import com.stratadata.model3.validation.Validatable;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

@Validatable
public class WellList
implements Comparable<WellList>,
Audited {
    private final int wellListID;
    private final int projID;
    @NotEmptyString
    @LimitedLengthString
    private String name = "";
    @LimitedLengthString
    private String description;
    private Audit audit = new AuditImpl();

    public WellList(int wellListID, int projID, String name, String description) {
        this.wellListID = wellListID;
        this.projID = projID;
        this.name = name;
        this.description = description;
    }

    public WellList(int wellListID, int projID) {
        this.wellListID = wellListID;
        this.projID = projID;
    }

    @Ident
    public int getID() {
        return this.wellListID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = Objects.requireNonNullElse(StringUtils.trimToNull((String)name), "<none>");
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = StringUtils.trimToNull((String)description);
    }

    public int getProjID() {
        return this.projID;
    }

    @Override
    public Audit getAudit() {
        return this.audit;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(WellList o) {
        int comp = this.name.compareToIgnoreCase(o.name);
        if (comp == 0) {
            return o.wellListID - this.wellListID;
        }
        return comp;
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + this.wellListID;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WellList other = (WellList)obj;
        return this.wellListID == other.wellListID;
    }
}

