/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.scheme;

import java.util.Arrays;

public enum IgdType {
    IGD_LITHOSTRAT(2, "Lithostratigraphy", true),
    IGD_CHRONOSTRAT(3, "Chronostratigraphy", true),
    IGD_BIOZONE(4, "Biozone", true),
    IGD_SEQUENCE(10, "Sequence", true),
    IGD_INTLITHOLOGY(12, "Interpreted Lithology"),
    IGD_QUALLITHOLOGY(13, "Lithology qualifiers"),
    IGD_ENVIRONMENT(5, "Palaeoenvironment"),
    IGD_ALLBSCOMMENTS(19, "Biostratigraphic Comments"),
    IGD_EVENT(20, "Events"),
    IGD_SQPICK(21, ""),
    IGD_INTCOMMENTS(22, "Interval Comments"),
    IGD_LOC(23, "LOC"),
    IGD_FAULTS(24, "Faults"),
    IGD_AGECURVE(25, ""),
    IGD_CHRON(26, "");

    private final int intType;
    private final String name;
    private final boolean intervalType;

    private IgdType(int intType, String name, boolean intervalType) {
        this.intType = intType;
        this.name = name;
        this.intervalType = intervalType;
    }

    private IgdType(int intType, String name) {
        this(intType, name, false);
    }

    public static IgdType getIgdType(int igdType) {
        for (IgdType type : Arrays.asList(IgdType.values())) {
            if (type.intType != igdType) continue;
            return type;
        }
        throw new IllegalArgumentException("Unrecognised IGDType: " + igdType);
    }

    public String getName() {
        return this.name;
    }

    public boolean isIntervalType() {
        return this.intervalType;
    }

    public int getIntType() {
        return this.intType;
    }
}

