/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.taxon;

import com.stratadata.model3.audit.Audit;
import com.stratadata.model3.audit.AuditImpl;
import com.stratadata.model3.taxon.Category;
import com.stratadata.model3.taxon.Qualifier;
import com.stratadata.model3.taxon.TaxonQual;
import com.stratadata.model3.user.UserService;
import com.stratadata.model3.validation.Ident;
import com.stratadata.model3.validation.LimitedLengthString;
import com.stratadata.model3.validation.NotEmptyString;
import com.stratadata.model3.validation.Validatable;
import com.stratadata.model3.validation.Validation;
import java.awt.Color;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.text.WordUtils;

@Validatable
public class Genus
implements Comparable<Genus> {
    private final int genID;
    private final AuditImpl audit;
    private Category category;
    @NotEmptyString
    @LimitedLengthString(fieldName="genus")
    private String genusName = "";
    @LimitedLengthString(fieldName="sub-genus")
    private String subGenus = "";
    private final Qualifier[] qualifiers = new Qualifier[4];
    private Color colour = Color.BLACK;

    public Genus() {
        this(0, new AuditImpl());
    }

    public Genus(int genID) {
        this(genID, new AuditImpl());
    }

    public Genus(int genID, AuditImpl audit) {
        for (int i = 0; i < this.qualifiers.length; ++i) {
            this.qualifiers[i] = new Qualifier(i);
        }
        this.genID = genID;
        this.audit = audit;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean includeCategory) {
        return this.toString(includeCategory, null);
    }

    public String toString(boolean includeCategory, List<Integer> italics) {
        StringBuilder b = new StringBuilder();
        if (includeCategory && this.category != null) {
            b.append(this.category.getMnemonic());
            while (b.length() < 6) {
                b.append(' ');
            }
        }
        if (this.qualifiers[0].hasQuals()) {
            b.append(this.qualifiers[0].toString(true));
        }
        if (italics != null) {
            italics.add(b.length());
        }
        b.append(this.genusName);
        if (italics != null) {
            italics.add(b.length());
        }
        if (this.qualifiers[1].hasQuals()) {
            b.append(this.qualifiers[1].toString(true));
        }
        if (!this.subGenus.isEmpty()) {
            b.append(" (");
            if (this.qualifiers[2].hasQuals()) {
                b.append(this.qualifiers[2].toString(true));
            }
            if (italics != null) {
                italics.add(b.length());
            }
            b.append(this.getSubGenus());
            if (italics != null) {
                italics.add(b.length());
            }
            if (this.qualifiers[3].hasQuals()) {
                b.append(this.qualifiers[3].toString(true));
            }
            b.append(")");
        }
        return b.toString();
    }

    public AttributedString toAttributedString(boolean useItalics, boolean includeCat) {
        LinkedList<Integer> italicsPos = new LinkedList<Integer>();
        String string = this.toString(includeCat, useItalics ? italicsPos : null);
        AttributedString ats = new AttributedString(string);
        Iterator it = italicsPos.iterator();
        while (it.hasNext()) {
            ats.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE, (Integer)it.next(), (Integer)it.next());
        }
        return ats;
    }

    public static String toGenusCase(String string) {
        return WordUtils.capitalize((String)string.toLowerCase());
    }

    public static Genus copy(Genus source) {
        Genus target = new Genus(source.getGenID());
        Genus.copyFields(target, source);
        return target;
    }

    public static void copyFields(Genus target, Genus source) {
        Genus.copyFields(target, source, true);
    }

    public static void copyFields(Genus target, Genus source, boolean copyAudit) {
        target.setCategory(source.getCategory());
        target.setGenusName(source.getGenusName());
        target.setSubGenus(source.getSubGenus());
        target.setColour(source.getColour());
        for (int i = 0; i < 4; ++i) {
            target.setQualifier(i, new Qualifier(i, source.getQualifier(i).toString(false)));
        }
        if (copyAudit) {
            target.audit.copyFields(source.audit);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Genus genus = (Genus)o;
        return this.genID == genus.genID;
    }

    public boolean equivalent(Genus genus, boolean ignoreCase) {
        if (!Objects.equals(this.category, genus.category)) {
            return false;
        }
        if (ignoreCase) {
            if (!this.genusName.equalsIgnoreCase(genus.genusName)) {
                return false;
            }
            if (!this.subGenus.equalsIgnoreCase(genus.subGenus)) {
                return false;
            }
        } else {
            if (!this.genusName.equals(genus.genusName)) {
                return false;
            }
            if (!this.subGenus.equals(genus.subGenus)) {
                return false;
            }
        }
        for (int i = 0; i < this.qualifiers.length; ++i) {
            if (this.qualifiers[i].equals(genus.qualifiers[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.genID);
    }

    @Override
    public int compareTo(Genus genus) {
        return Genus.compare(this, genus);
    }

    public static int compare(Genus o1, Genus o2) {
        if (o1 != null && o2 != null) {
            if (o1.genID == o2.genID) {
                return 0;
            }
            if (!Objects.equals(o1.getCategory(), o2.getCategory())) {
                return Category.compare(o1.getCategory(), o2.getCategory());
            }
            if (!o1.genusName.equals(o2.genusName)) {
                return o1.genusName.compareTo(o2.genusName);
            }
            if (!o1.subGenus.equals(o2.subGenus)) {
                return o1.subGenus.compareTo(o2.subGenus);
            }
            for (int i = 0; i < 4; ++i) {
                if (o1.qualifiers[i].equals(o2.qualifiers[i])) continue;
                return o1.qualifiers[i].toString().compareTo(o2.qualifiers[i].toString());
            }
            return 0;
        }
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return 1;
        }
        return -1;
    }

    public void updateAudit(UserService userService, Instant databaseServerDate) {
        this.updateAudit(this.audit, userService, databaseServerDate);
    }

    public void updateAudit(Audit originalAudit, UserService userService, Instant databaseServerDate) {
        AuditImpl auditUpdate = AuditImpl.getAuditUpdate(originalAudit, userService, databaseServerDate, false);
        this.audit.copyFields(auditUpdate);
    }

    @Ident
    public int getGenID() {
        return this.genID;
    }

    public Category getCategory() {
        return this.category;
    }

    public void setCategory(Category category) {
        this.category = category;
    }

    public String getGenusName() {
        return this.genusName;
    }

    public void setGenusName(String genusName) {
        this.genusName = Objects.requireNonNullElse(genusName, "").trim();
    }

    public String getSubGenus() {
        return this.subGenus;
    }

    public void setSubGenus(String subGenus) {
        this.subGenus = Objects.requireNonNullElse(subGenus, "").trim();
    }

    public Color getColour() {
        return this.colour;
    }

    public void setColour(Color colour) {
        this.colour = Objects.requireNonNullElse(colour, this.colour);
    }

    public Qualifier getQ1() {
        return this.qualifiers[0];
    }

    public Qualifier getQ2() {
        return this.qualifiers[1];
    }

    public Qualifier getQ3() {
        return this.qualifiers[2];
    }

    public Qualifier getQ4() {
        return this.qualifiers[3];
    }

    public Qualifier getQualifier(int pos) {
        if (pos < 0 || pos > this.qualifiers.length - 1) {
            return null;
        }
        return this.qualifiers[pos];
    }

    public void setQ1(Qualifier q) {
        this.setQualifier(0, q);
    }

    public void setQ2(Qualifier q) {
        this.setQualifier(1, q);
    }

    public void setQ3(Qualifier q) {
        this.setQualifier(2, q);
    }

    public void setQ4(Qualifier q) {
        this.setQualifier(3, q);
    }

    public void setQualifier(int pos, Qualifier q) {
        if (q.position() != pos) {
            throw new IllegalArgumentException("Illegal qualifier for position " + pos);
        }
        this.qualifiers[pos] = q;
    }

    public Audit getAudit() {
        return this.audit;
    }

    @Validation
    public List<String> validateQualifiers() {
        if (this.getQ1().hasQual(TaxonQual.QUOTE) || this.getQ2().hasQual(TaxonQual.QUOTE)) {
            this.getQ1().addQual(TaxonQual.QUOTE);
            this.getQ2().addQual(TaxonQual.QUOTE);
        }
        if (this.getQ3().hasQual(TaxonQual.QUOTE) || this.getQ4().hasQual(TaxonQual.QUOTE)) {
            this.getQ3().addQual(TaxonQual.QUOTE);
            this.getQ4().addQual(TaxonQual.QUOTE);
        }
        ArrayList<String> validationMessages = new ArrayList<String>();
        for (String name : new String[]{this.genusName, this.subGenus}) {
            if (TaxonQual.allowName(name)) continue;
            validationMessages.add("qualifiers must not be part of the genus name: '" + name + "'");
        }
        return validationMessages;
    }
}

