/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.taxon;

import com.stratadata.model3.taxon.TaxonQual;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Qualifier {
    private final int position;
    private final List<TaxonQual> quals = new ArrayList<TaxonQual>();

    public Qualifier(int position) {
        if (position < 0 || position > 7) {
            throw new IllegalArgumentException("Illegal qualifier position: " + position);
        }
        this.position = position;
    }

    public Qualifier(int position, TaxonQual tq) {
        this(position);
        this.quals.add(tq);
    }

    public Qualifier(int position, String s) {
        this(position);
        this.quals.addAll(TaxonQual.parse(s, position));
    }

    public String toString(boolean whitespace) {
        Object s = StringUtils.join(this.quals, (String)" ");
        if (whitespace) {
            boolean start;
            boolean bl = start = this.position % 2 == 0;
            s = start ? (String)s + (this.quals.get((int)(this.quals.size() - 1)).whitespace ? " " : "") : (this.quals.get((int)0).whitespace ? " " : "") + (String)s;
        }
        return s;
    }

    public String toString() {
        return this.toString(false);
    }

    public boolean hasQuals() {
        return !this.quals.isEmpty();
    }

    public boolean hasQual(TaxonQual qual) {
        return this.quals.stream().anyMatch(q -> q == qual);
    }

    public boolean equals(Object q) {
        if (!(q instanceof Qualifier)) {
            return false;
        }
        return this.toString().equals(q.toString());
    }

    public Qualifier copy() {
        Qualifier newQual = new Qualifier(this.position);
        newQual.quals.addAll(this.quals);
        return newQual;
    }

    public TaxonQual getSingle() {
        if (this.quals.size() == 1) {
            return this.quals.get(0);
        }
        return null;
    }

    public boolean addQual(TaxonQual toAdd) {
        if (this.hasQual(toAdd) || !toAdd.useAt(this.position)) {
            return false;
        }
        for (int i = 0; i < this.quals.size(); ++i) {
            if (!this.quals.get(i).isMutuallyExclusive(toAdd, this.position)) continue;
            this.quals.set(i, toAdd);
            return false;
        }
        this.quals.add(toAdd);
        Collections.sort(this.quals, new TaxonQual.QualComparator(this.position));
        return true;
    }

    int position() {
        return this.position;
    }
}

