/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.taxon;

import com.stratadata.model3.taxon.SynonymService;
import com.stratadata.model3.taxon.Taxon;
import com.stratadata.model3.taxon.TaxonService;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;

public class TaxonNameService {
    private final SynonymService synonymService;
    private final TaxonService taxonService;
    private int synSchID;

    public static String toSynonymString(SynonymService synonymService, TaxonService taxonService, int synSchID, int specID, boolean includeJuniorSynonym, boolean includeAuthor, boolean includeCategory) {
        TaxonWithSynonym taxonAndJunior = TaxonNameService.getTaxonAndJunior(synonymService, taxonService, specID, synSchID, includeJuniorSynonym);
        return TaxonNameService.generateTaxonString(taxonAndJunior, includeAuthor, includeCategory, null);
    }

    public static AttributedString toSynonymAttributedString(SynonymService synonymService, TaxonService taxonService, int synSchID, int specID, boolean italics, boolean includeJuniorSynonym, boolean includeAuthor, boolean includeCategory) {
        TaxonWithSynonym taxonAndJunior = TaxonNameService.getTaxonAndJunior(synonymService, taxonService, specID, synSchID, includeJuniorSynonym);
        LinkedList<Integer> italicsPos = italics ? new LinkedList<Integer>() : null;
        String taxonString = TaxonNameService.generateTaxonString(taxonAndJunior, includeAuthor, includeCategory, italicsPos);
        return TaxonNameService.generateAttributedString(taxonString, italicsPos);
    }

    private static TaxonWithSynonym getTaxonAndJunior(SynonymService synonymService, TaxonService taxonService, int specID, int synSchID, boolean includeJuniorSynonym) {
        Optional<Taxon> preferredTerm;
        Taxon taxon = taxonService.findTaxon(specID).orElseThrow(() -> new IllegalArgumentException("No taxon for ID " + specID));
        Taxon juniorSynonym = null;
        if (synSchID > 0 && (preferredTerm = synonymService.getPreferredTerm(synSchID, specID, taxonService)).isPresent()) {
            if (includeJuniorSynonym) {
                juniorSynonym = taxon;
            }
            taxon = preferredTerm.get();
        }
        return new TaxonWithSynonym(taxon, juniorSynonym);
    }

    private static String generateTaxonString(TaxonWithSynonym taxonWithSynonym, boolean includeAuthor, boolean includeCategory, List<Integer> italicsPos) {
        Object taxonString = taxonWithSynonym.taxon.toString(includeAuthor, includeCategory, italicsPos, false);
        if (taxonWithSynonym.juniorSynonym != null) {
            boolean category = includeCategory || !taxonWithSynonym.juniorSynonym.getGenus().getCategory().equals(taxonWithSynonym.taxon.getGenus().getCategory());
            int italicsOffset = ((String)taxonString).length() + 2;
            LinkedList<Integer> synItalicsPos = italicsPos != null ? new LinkedList<Integer>() : null;
            taxonString = (String)taxonString + " (" + taxonWithSynonym.juniorSynonym.toString(includeAuthor, category, synItalicsPos, false) + ")";
            if (italicsPos != null) {
                italicsPos.addAll(synItalicsPos.stream().map(pos -> pos + italicsOffset).toList());
            }
        }
        return taxonString;
    }

    static AttributedString generateAttributedString(String string, List<Integer> italicsPos) {
        AttributedString ats = new AttributedString(string);
        if (italicsPos != null) {
            Iterator<Integer> it = italicsPos.iterator();
            try {
                while (it.hasNext()) {
                    ats.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE, it.next(), it.next());
                }
            }
            catch (RuntimeException ex) {
                Logger.getLogger(TaxonNameService.class.getName()).warning("Error getting attributed String for '" + string + "': " + ex.getMessage());
            }
        }
        return ats;
    }

    public TaxonNameService(SynonymService synonymService, TaxonService taxonService, int synSchID) {
        this.synonymService = synonymService;
        this.taxonService = taxonService;
        this.synSchID = synSchID;
    }

    public void setSynSchID(int synSchID) {
        this.synSchID = synSchID;
    }

    public String getSynonymString(int specID, boolean includeJuniorSynonym, boolean includeAuthor, boolean includeCategory) {
        return TaxonNameService.toSynonymString(this.synonymService, this.taxonService, this.synSchID, specID, includeJuniorSynonym, includeAuthor, includeCategory);
    }

    public AttributedString getAttributedString(int specID, boolean useItalics, boolean includeJuniorSynonym, boolean includeAuthor, boolean includeCategory) {
        return TaxonNameService.toSynonymAttributedString(this.synonymService, this.taxonService, this.synSchID, specID, useItalics, includeJuniorSynonym, includeAuthor, includeCategory);
    }

    private record TaxonWithSynonym(Taxon taxon, Taxon juniorSynonym) {
    }
}

